(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     41368,        966]
NotebookOptionsPosition[     38128,        914]
NotebookOutlinePosition[     38548,        931]
CellTagsIndexPosition[     38505,        928]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Last checked 20 April, 2023",
 CellFrame->True,
 Background->GrayLevel[0.849989]]], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.851321730299733*^9, 3.851321747924562*^9}, 
   3.8513218075505953`*^9, {3.890897811719871*^9, 3.890897826726935*^9}, {
   3.890973965108789*^9, 3.8909739653874283`*^9}},
 TextAlignment->Left,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"1c1dff06-69e6-46a2-9b2c-0707da8332fe"],

Cell["Chapter 8, Section 8.12.2, Figures 8.27\[Dash]28", "Section",
 CellChangeTimes->{{3.882006605439645*^9, 3.8820066110954123`*^9}, {
  3.8820069390394917`*^9, 3.8820069425985413`*^9}, {3.882007113034523*^9, 
  3.882007113929899*^9}},ExpressionUUID->"82f499f7-7566-4202-8352-\
b2938cf7819e"],

Cell[TextData[{
 "The definitions of the following functions are taken from the PhD thesis of \
Malhotra (1988).\n\nWe consider second-order resonances and define the \
functions ",
 StyleBox["\[Psi]", "Input"],
 ", ",
 StyleBox["\[CapitalPhi]1", "Input"],
 ", ",
 StyleBox["\[CapitalPhi]2", "Input"],
 ", ",
 StyleBox["\[CapitalPhi]3", "Input"],
 ", ",
 StyleBox["\[CapitalPhi]min", "Input"],
 ", ",
 StyleBox["\[CapitalPhi]max", "Input"],
 " and ",
 StyleBox["\[Gamma]", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.88200713915382*^9, 3.88200714601864*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"8934e077-7d45-47ea-b3df-ccb2b93927ad"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPhi]1", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Delta]"}], ")"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.882005666705064*^9, 3.882005666711138*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"71f5bbc0-7679-48f4-add3-679a6beb7337"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPhi]2", "[", "\[Delta]_", "]"}], " ", ":=", " ", "0"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.882005674177622*^9, 3.882005674183778*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"e87f792a-95ff-4053-82c2-2e7037cf219b"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPhi]3", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "2"}], ")"}], "*", "\[Delta]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8820056825192347`*^9, 3.882005682525753*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"68c939ca-969e-45ce-8251-e8be524acbd6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPhi]min", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Delta]"}], ")"}]}], " ", "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"2", "*", "\[Delta]"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.882005692944954*^9, 3.882005692951223*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"cf98bc41-55cf-4024-a5a6-f980a9ee816d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalPhi]max", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", "\[Delta]"}], ")"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "*", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"2", "*", "\[Delta]"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8820057015534487`*^9, 3.8820057015607347`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"b791241e-dfa8-442d-b960-3f36db86959e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Gamma]", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{"ArcSin", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], "+", 
       RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}], "-", 
       RowBox[{"2", "*", 
        RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], "-", 
       RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}]}], ")"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.88200570998111*^9, 3.8820057099871063`*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"a4f563ca-f9d0-4039-824a-c40af085a0e0"],

Cell["\<\
Now define the functions to calculate the area enclosed by the outer and \
inner branches of the separatrix (see Eqs.(8.227) and (8.228)).\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.882005729484353*^9, 3.8820057361013412`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"95146a49-b4a8-4d70-b148-425340ec896f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Areaext", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{"Abs", "[", "\n", 
    RowBox[{
     RowBox[{"-", "2"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], " ", "+", " ", 
          RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}], " ", "+", " ", 
          RowBox[{"2", "*", 
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}]}]}], ")"}], "*", 
        "\n", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Pi", "/", "2"}], "+", 
          RowBox[{"\[Gamma]", "[", "\[Delta]", "]"}]}], ")"}]}], " ", "+", 
       " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], "-", 
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}], "-", 
           RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}]}], ")"}]}], 
        "]"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.882005750321032*^9, 3.882005750327136*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"19d95019-14d8-4000-bbd6-38a9f7c47867"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Areaint", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{"Abs", "[", "\n", " ", 
    RowBox[{"2", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", "2"}], ")"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], " ", "+", " ", 
          RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}], " ", "+", " ", 
          RowBox[{"2", "*", 
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}]}]}], ")"}], "*", 
        "\n", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Pi", "/", "2"}], "-", 
          RowBox[{"\[Gamma]", "[", "\[Delta]", "]"}]}], ")"}]}], " ", "-", 
       " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalPhi]max", "[", "\[Delta]", "]"}], "-", 
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalPhi]3", "[", "\[Delta]", "]"}], "-", 
           RowBox[{"\[CapitalPhi]min", "[", "\[Delta]", "]"}]}], ")"}]}], 
        "]"}]}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.882005761016163*^9, 3.8820057610276403`*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"34755105-56a4-4723-8c7a-5048fdfc7c68"],

Cell["\<\
Define the function that gives the probability of capture (see Eq.(8.220)).\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"1a922e9b-f522-4292-89bb-a74f5086721a"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ProbCap", "[", "\[Delta]_", "]"}], " ", ":=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"4", "*", 
     RowBox[{
      RowBox[{"\[Gamma]", "[", "\[Delta]", "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"Pi", "+", 
        RowBox[{"2", "*", 
         RowBox[{"\[Gamma]", "[", "\[Delta]", "]"}]}]}], ")"}]}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.882005787023031*^9, 3.88200578702907*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"dbddf5fe-8f2f-4fbc-9879-98c693454583"],

Cell["Define the axis labels.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.869373084037505*^9, 3.869373204667523*^9}, {
  3.869552502127846*^9, 3.869552527987165*^9}, {3.8695525676926813`*^9, 
  3.869552627902935*^9}, {3.869552688038094*^9, 3.8695527321988773`*^9}, {
  3.86955276584477*^9, 3.8695527789835157`*^9}, {3.869552853609722*^9, 
  3.8695529191526623`*^9}, {3.869553047085703*^9, 3.869553087120385*^9}, {
  3.870607952402626*^9, 3.870607986048612*^9}, {3.870608112694354*^9, 
  3.870608186135066*^9}, {3.870608226185451*^9, 3.8706082321707907`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"e55e2b36-f248-4fb7-85ad-5905fd40e0da"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xlabel", "=", "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
SubscriptBox[\"\[Delta]\", \"t\"], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"\\\\delta_{\\\\rm{t}}\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ylabel1", "=", "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
FractionBox[
StyleBox[\"A\", \"TI\"], 
RowBox[{\"2\", \"\[Pi]\"}]], TraditionalForm], \"errors\" -> {}, \"input\" -> \
\"{{A}\\\\over{2\\\\pi}}\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ylabel2", "=", "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
SubscriptBox[
StyleBox[\"P\", \"TI\"], \"cap\"], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"P_{\\\\rm{cap}}\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\""}], ";"}]}], "Input",
 CellChangeTimes->{{3.880100664379323*^9, 3.880100667376337*^9}, {
   3.881480907052763*^9, 3.881480910113048*^9}, 3.882005997664741*^9, {
   3.8820060337864847`*^9, 3.8820060757749453`*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"4725a0c6-f0a8-4acb-bf9a-fdeddd9865ed"],

Cell["\<\
Plot the area enclosed by the outer branch of the separatrix.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"eefa9cd7-14bb-4fcd-87cc-49b039569ae0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"outer2", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Areaext", "[", "\[Delta]", "]"}], "/", "2"}], "/", "Pi"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882005803374855*^9, 3.8820058033809566`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"d0112d06-1fa5-4e7a-9b2b-b495c98b55f7"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVxX081HcAB/CTh+SOnGc/T3d+XqnLQ2y9XqvJ91NmEfUiyUKaK1RI5Jqh
koeiqGuZxHRJlBlSl0alPCcPTUYKJUfq1KLr8li2/fF+vbn8iM1BCxgMxsb/
/H/eYb6K3a6Tjqqf0sMZjEHS0MVx9+HsIe0NdsKbBoNkvqkmicP5mWi51om0
7AZJ3v0MM2VOGom327bQOnCQhK0RhE+anSc2ol7u5XuDpGt2d+a4WTFpvlEp
aPrpJVnYN2T5zqyKXP1hh8yib4jkPxRFjpm1ENd0+buChBFSVp7WF2bzjFS/
KD52UCIlIaTz/NsoCeHp/L5XWvSe7BtZJhGXvSHdy33sA3Q+EDVusuWLb8aJ
VbNP1zLBR3JKs5WX/6OM+NfG2c1d/ET4fVvuKbZ9IgkT5klZ41MksjGZH2E5
Q4K2qi+OsJolFftZXgaun8nRzuQUg28/k/y4UOkKHwa4a75XH4iYJ4miOc+P
bxWg57G5Vn6HAUbXIO7EKqJiq2RSXK2AJdHBMVt4yrj+9OtFL1sXYFh+bivz
rgrk/ZOj8geK2DCy99AvkapgdNoqJT5VwqZh4XJTUzWEjjXIwiXKkNbzEx6U
MnFBK/G53jMV2LB7TJx2qMN5wr3SeXgh1Ig8sF+mgV9XBodm9Kli/TvfSXNv
TZSffn/E89Ui9NbtUvC1YmPmdEWbyZgabqY2BHDkbKyPZPgfGmAiWFkw2NGh
hb5dc1e9JCzsjIq7ycrRBm/WsVDeow7bkOUd7oE6yOWvlbEbNfBIy4opWKWL
LB7/Rk7TYtwuS8y1UtSD8Qy70dRPE3EKPI+2AT3YP4/2F/VrQq0/1mWfWB8a
w6pX9vqxMVLEzRTFG6BypHzbzk42MpcaKlV5G2L1/qkBJU8tCHOCmwM5FDKT
sg5KmrXgm7m9gzVK4Y/OLA8rB21MfVc4Laoxwnvb8BP61dqQjKyLqTtujBjm
YgcfWx1cWmNn1B5oAvei3nH7Mh2UpgjYIdam4NuUqEZY6OK49043RbkpXHwe
pyzJ1sXK/vzi4+1m2M589uSArh6yl+WWtrtxUCSp6f3qhB6O3M/IdqviwOlt
/T9JqvrYaORd+NCCi/rR3HCvZH2s3dfsx07j4laM4nDhpD5ExnyLNjkX3e2C
M4nRBrCov5K1yc8cQqd8P+lrAwit63iPa8zRm/rq9UtfQwTLlDpbeDSs2x8t
DegxBL/iAyftNI21z9fGRrlSCEv0mttwhsbTrC8Lot0oCLzET1hnadi7TqYK
NlJIlQtOCbNoGLIupMd4UihbNT17Lo/GOePWqMPbKEzXzvcUldA4XCmrTttD
QfiYldHQTMNhxWeHC2kUcgrCdx9rocHylYaLTlIoiO5wcmmlYfLC9LeLGRQq
9YQzrR009Pk7xi+dodDvq727q5uG2MAl5sp5CpYSQ6chCY2hAyoq14oprBDH
ml4eoWHneJZZUUJhdUrfdNAoDf/JMI3rpRTcLfOuvZHSSM9WZYkrKESFckwn
Jmh4rJO+ulVFId7h6PR1GY0x29c9f96mkKI+9He0nAbz0cqGqrsUsssLTk5N
0eg+Wpt1u5bCpQSlkOoZGs7OjPg79RRKPIPWxc/R+MtQGHC3kYLYvMnE8QsN
nk+kY00zhRrZkun5eRpTWy4b3Wuh8C99yC5u
       "]]},
     Annotation[#, "Charting`Private`Tag$3873#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {0., 6.697018081574463}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.882005804968419*^9, 3.882007310616929*^9, 
  3.8820078595275517`*^9, 3.882035541197193*^9, 3.890981072514213*^9, 
  3.890981229895805*^9, 3.8909812631820583`*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"97848a6f-85f7-42c4-be8f-5c635681ba42"]
}, Open  ]],

Cell["\<\
Plot the area enclosed by the inner branch of the separatrix.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"c0671b21-6158-4cc4-8c93-d5560e1d020e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"inner2", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Areaint", "[", "\[Delta]", "]"}], "/", "2"}], "/", "Pi"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882005823437809*^9, 3.8820058234452477`*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"8dc071ca-4be9-4a0a-834b-52c36e795cf5"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVkGk81IkfgMcRMfxqJEeu4WfJRKGSLL7fzO6yyH8L2WyFEaMoslhdWzmy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       "]]},
     Annotation[#, "Charting`Private`Tag$4066#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {0., 3.8029817143439035`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.882005824859771*^9, 3.882007310655958*^9, 
  3.882007859616006*^9, 3.882035541259296*^9, 3.890981072830777*^9, 
  3.890981229947929*^9, 3.890981263257184*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"ba25e6a5-2d78-45ff-866f-968c9d4746f5"]
}, Open  ]],

Cell["Define the inner and outer labels.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.869373084037505*^9, 3.869373204667523*^9}, {
  3.869552502127846*^9, 3.869552527987165*^9}, {3.8695525676926813`*^9, 
  3.869552627902935*^9}, {3.869552688038094*^9, 3.8695527321988773`*^9}, {
  3.86955276584477*^9, 3.8695527789835157`*^9}, {3.869552853609722*^9, 
  3.8695529191526623`*^9}, {3.869553047085703*^9, 3.869553087120385*^9}, {
  3.870607952402626*^9, 3.870607986048612*^9}, {3.870608112694354*^9, 
  3.870608186135066*^9}, {3.870608226185451*^9, 3.8706082321707907`*^9}, {
  3.882035428931944*^9, 3.882035434667725*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"11813e6e-55e0-4eb4-9bce-fa3f664b87b8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"innerlabel", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<inner\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"6.5", ",", "1.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outerlabel", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
      RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<outer\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"3.8", ",", "4.2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.882035058818726*^9, 3.882035208024719*^9}, {
  3.882035273944602*^9, 3.882035324430416*^9}, {3.8820353688314533`*^9, 
  3.8820353720935287`*^9}, {3.88203550097155*^9, 3.8820355237149973`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"b1ed4bd6-d8e0-4812-8188-9cf61e623a42"],

Cell["Show both plots together.  This is Fig.8.27.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8820072230479813`*^9, 3.882007232959848*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"6f7a8621-19fd-403f-8d47-e6818ebef282"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"areas2", " ", "=", " ", 
  RowBox[{"Show", "[", 
   RowBox[{"outer2", ",", "inner2", ",", "innerlabel", ",", "outerlabel", ",", 
    RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", "\n", "     ", 
    RowBox[{"Frame", "->", "True"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "7"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "->", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"xlabel", ",", 
       RowBox[{"Rotate", "[", 
        RowBox[{"ylabel1", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "->", 
     RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882005843232294*^9, 3.882005843238111*^9}, {
  3.88200726329718*^9, 3.882007281814846*^9}, {3.882035530299452*^9, 
  3.882035536298799*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"e1358948-7b30-4cb9-8a6d-ba4488fb35ca"],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVxX081HcAB/CTh+SOnGc/T3d+XqnLQ2y9XqvJ91NmEfUiyUKaK1RI5Jqh
koeiqGuZxHRJlBlSl0alPCcPTUYKJUfq1KLr8li2/fF+vbn8iM1BCxgMxsb/
/H/eYb6K3a6Tjqqf0sMZjEHS0MVx9+HsIe0NdsKbBoNkvqkmicP5mWi51om0
7AZJ3v0MM2VOGom327bQOnCQhK0RhE+anSc2ol7u5XuDpGt2d+a4WTFpvlEp
aPrpJVnYN2T5zqyKXP1hh8yib4jkPxRFjpm1ENd0+buChBFSVp7WF2bzjFS/
KD52UCIlIaTz/NsoCeHp/L5XWvSe7BtZJhGXvSHdy33sA3Q+EDVusuWLb8aJ
VbNP1zLBR3JKs5WX/6OM+NfG2c1d/ET4fVvuKbZ9IgkT5klZ41MksjGZH2E5
Q4K2qi+OsJolFftZXgaun8nRzuQUg28/k/y4UOkKHwa4a75XH4iYJ4miOc+P
bxWg57G5Vn6HAUbXIO7EKqJiq2RSXK2AJdHBMVt4yrj+9OtFL1sXYFh+bivz
rgrk/ZOj8geK2DCy99AvkapgdNoqJT5VwqZh4XJTUzWEjjXIwiXKkNbzEx6U
MnFBK/G53jMV2LB7TJx2qMN5wr3SeXgh1Ig8sF+mgV9XBodm9Kli/TvfSXNv
TZSffn/E89Ui9NbtUvC1YmPmdEWbyZgabqY2BHDkbKyPZPgfGmAiWFkw2NGh
hb5dc1e9JCzsjIq7ycrRBm/WsVDeow7bkOUd7oE6yOWvlbEbNfBIy4opWKWL
LB7/Rk7TYtwuS8y1UtSD8Qy70dRPE3EKPI+2AT3YP4/2F/VrQq0/1mWfWB8a
w6pX9vqxMVLEzRTFG6BypHzbzk42MpcaKlV5G2L1/qkBJU8tCHOCmwM5FDKT
sg5KmrXgm7m9gzVK4Y/OLA8rB21MfVc4Laoxwnvb8BP61dqQjKyLqTtujBjm
YgcfWx1cWmNn1B5oAvei3nH7Mh2UpgjYIdam4NuUqEZY6OK49043RbkpXHwe
pyzJ1sXK/vzi4+1m2M589uSArh6yl+WWtrtxUCSp6f3qhB6O3M/IdqviwOlt
/T9JqvrYaORd+NCCi/rR3HCvZH2s3dfsx07j4laM4nDhpD5ExnyLNjkX3e2C
M4nRBrCov5K1yc8cQqd8P+lrAwit63iPa8zRm/rq9UtfQwTLlDpbeDSs2x8t
DegxBL/iAyftNI21z9fGRrlSCEv0mttwhsbTrC8Lot0oCLzET1hnadi7TqYK
NlJIlQtOCbNoGLIupMd4UihbNT17Lo/GOePWqMPbKEzXzvcUldA4XCmrTttD
QfiYldHQTMNhxWeHC2kUcgrCdx9rocHylYaLTlIoiO5wcmmlYfLC9LeLGRQq
9YQzrR009Pk7xi+dodDvq727q5uG2MAl5sp5CpYSQ6chCY2hAyoq14oprBDH
ml4eoWHneJZZUUJhdUrfdNAoDf/JMI3rpRTcLfOuvZHSSM9WZYkrKESFckwn
Jmh4rJO+ulVFId7h6PR1GY0x29c9f96mkKI+9He0nAbz0cqGqrsUsssLTk5N
0eg+Wpt1u5bCpQSlkOoZGs7OjPg79RRKPIPWxc/R+MtQGHC3kYLYvMnE8QsN
nk+kY00zhRrZkun5eRpTWy4b3Wuh8C99yC5u
        "]]},
      Annotation[#, "Charting`Private`Tag$3873#1"]& ]}, {}}, {{{}, {}, 
     TagBox[
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJwVkGk81IkfgMcRMfxqJEeu4WfJRKGSLL7fzO6yyH8L2WyFEaMoslhdWzmy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        "]]},
      Annotation[#, "Charting`Private`Tag$4066#1"]& ]}, {}}, 
   StyleBox[
    InsetBox["\<\"inner\"\>", {6.5, 1.5}, NCache[
     ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]],
    FontFamily->"Times",
    FontSize->16], 
   StyleBox[
    InsetBox["\<\"outer\"\>", {3.8, 4.2}, NCache[
     ImageScaled[{0, Rational[1, 2]}], ImageScaled[{0, 0.5}]]],
    FontFamily->"Times",
    FontSize->16]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> FormBox[SubscriptBox[\\\"\
\[Delta]\\\", \\\"t\\\"], TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\
\" -> \\\"\\\\\\\\delta_{\\\\\\\\rm{t}}\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"", TraditionalForm], 
    FormBox[
     RotationBox[
     "\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> FormBox[FractionBox[StyleBox[\
\\\"A\\\", \\\"TI\\\"], RowBox[{\\\"2\\\", \\\"\[Pi]\\\"}]], \
TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\" -> \
\\\"{{A}\\\\\\\\over{2\\\\\\\\pi}}\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"", 
      BoxRotation -> -1.5707963267948966`], TraditionalForm]},
  FrameStyle->Thickness[0.004],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[FontFamily -> "Times", FontSize -> 16],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 10}, {0, 7}},
  PlotRangeClipping->True,
  PlotRangePadding->None,
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.88200584398011*^9, 3.882007310671977*^9, 
  3.882007859641491*^9, 3.882035541306572*^9, 3.8909810728825006`*^9, 
  3.890981230263627*^9, 3.890981263583088*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"2927d9f3-c28c-4e1d-be63-737520705056"]
}, Open  ]],

Cell["\<\
Now do the plot of probability of capture as a function of the value of \
\[Delta] at transition.  This is Fig.8.28.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8820073305577*^9, 3.8820073448849087`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f87c0cbc-d909-43ba-85f0-e24e10b142fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"prob2", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"ProbCap", "[", "\[Delta]", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Delta]", ",", "0", ",", "10"}], "}"}], ",", "\n", "  ", 
    RowBox[{"Frame", "->", "True"}], ",", "\n", "  ", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"PlotRangePadding", "\[Rule]", "None"}], ",", "\n", "     ", 
    RowBox[{"Frame", "->", "True"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AxesOrigin", "->", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"xlabel", ",", 
       RowBox[{"Rotate", "[", 
        RowBox[{"ylabel2", ",", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "2"}]}], "]"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"FrameStyle", "->", 
     RowBox[{"Thickness", "[", "0.004", "]"}]}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "16"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.882005867645522*^9, 3.882005867651518*^9}, 
   3.882007368207918*^9},
 CellLabel->"In[18]:=",ExpressionUUID->"f57b94bb-8713-4a51-9310-6c051b61bd05"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwV0Hk81PkDx3Fnu6FCl1TM+KpxdT3a3coD7w/VrxxJSbVqa00ySlF+kaQS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       "]]},
     Annotation[#, "Charting`Private`Tag$4126#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox[
       RotationBox[
       "\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[SubscriptBox[StyleBox[\\\"P\\\", \\\"TI\\\"], \\\"cap\\\"], \
TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\" -> \
\\\"P_{\\\\\\\\rm{cap}}\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"", 
        BoxRotation -> -1.5707963267948966`], HoldForm], TraditionalForm], 
     None}, {
     FormBox[
      TagBox[
      "\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> FormBox[SubscriptBox[\\\"\
\[Delta]\\\", \\\"t\\\"], TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\
\" -> \\\"\\\\\\\\delta_{\\\\\\\\rm{t}}\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"", HoldForm], 
      TraditionalForm], None}},
  FrameStyle->Thickness[0.004],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  LabelStyle->Directive[FontFamily -> "Times", FontSize -> 16],
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 10.}, {0., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{None, None}, {None, None}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.882005875010345*^9, {3.8820073724891577`*^9, 3.88200739384734*^9}, 
   3.882007859759362*^9, 3.882035541366678*^9, 3.890981072997979*^9, 
   3.890981230380515*^9, 3.8909812637064342`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"a0be51fa-2376-428e-ab38-52c01f384c7c"]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{1049, 661},
WindowMargins->{{85, Automatic}, {Automatic, 26}},
FrontEndVersion->"13.2 for Mac OS X x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a44f014b-5947-4915-b1e6-4140f483b1a8"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 439, 9, 53, "Text",ExpressionUUID->"1c1dff06-69e6-46a2-9b2c-0707da8332fe"],
Cell[1000, 31, 294, 4, 67, "Section",ExpressionUUID->"82f499f7-7566-4202-8352-b2938cf7819e"],
Cell[1297, 37, 673, 22, 95, "Text",ExpressionUUID->"8934e077-7d45-47ea-b3df-ccb2b93927ad"],
Cell[1973, 61, 405, 10, 30, "Input",ExpressionUUID->"71f5bbc0-7679-48f4-add3-679a6beb7337"],
Cell[2381, 73, 275, 6, 30, "Input",ExpressionUUID->"e87f792a-95ff-4053-82c2-2e7037cf219b"],
Cell[2659, 81, 356, 8, 30, "Input",ExpressionUUID->"68c939ca-969e-45ce-8251-e8be524acbd6"],
Cell[3018, 91, 620, 17, 30, "Input",ExpressionUUID->"cf98bc41-55cf-4024-a5a6-f980a9ee816d"],
Cell[3641, 110, 624, 17, 30, "Input",ExpressionUUID->"b791241e-dfa8-442d-b960-3f36db86959e"],
Cell[4268, 129, 747, 18, 30, "Input",ExpressionUUID->"a4f563ca-f9d0-4039-824a-c40af085a0e0"],
Cell[5018, 149, 340, 7, 53, "Text",ExpressionUUID->"95146a49-b4a8-4d70-b148-425340ec896f"],
Cell[5361, 158, 1393, 36, 73, "Input",ExpressionUUID->"19d95019-14d8-4000-bbd6-38a9f7c47867"],
Cell[6757, 196, 1374, 35, 73, "Input",ExpressionUUID->"34755105-56a4-4723-8c7a-5048fdfc7c68"],
Cell[8134, 233, 209, 5, 53, "Text",ExpressionUUID->"1a922e9b-f522-4292-89bb-a74f5086721a"],
Cell[8346, 240, 527, 14, 30, "Input",ExpressionUUID->"dbddf5fe-8f2f-4fbc-9879-98c693454583"],
Cell[8876, 256, 656, 10, 53, "Text",ExpressionUUID->"e55e2b36-f248-4fb7-85ad-5905fd40e0da"],
Cell[9535, 268, 1189, 24, 97, "Input",ExpressionUUID->"4725a0c6-f0a8-4acb-bf9a-fdeddd9865ed"],
Cell[10727, 294, 195, 5, 53, "Text",ExpressionUUID->"eefa9cd7-14bb-4fcd-87cc-49b039569ae0"],
Cell[CellGroupData[{
Cell[10947, 303, 432, 10, 30, "Input",ExpressionUUID->"d0112d06-1fa5-4e7a-9b2b-b495c98b55f7"],
Cell[11382, 315, 3565, 77, 248, "Output",ExpressionUUID->"97848a6f-85f7-42c4-be8f-5c635681ba42"]
}, Open  ]],
Cell[14962, 395, 195, 5, 53, "Text",ExpressionUUID->"c0671b21-6158-4cc4-8c93-d5560e1d020e"],
Cell[CellGroupData[{
Cell[15182, 404, 432, 10, 30, "Input",ExpressionUUID->"8dc071ca-4be9-4a0a-834b-52c36e795cf5"],
Cell[15617, 416, 4132, 86, 249, "Output",ExpressionUUID->"ba25e6a5-2d78-45ff-866f-968c9d4746f5"]
}, Open  ]],
Cell[19764, 505, 716, 11, 53, "Text",ExpressionUUID->"11813e6e-55e0-4eb4-9bce-fa3f664b87b8"],
Cell[20483, 518, 1305, 34, 52, "Input",ExpressionUUID->"b1ed4bd6-d8e0-4812-8188-9cf61e623a42"],
Cell[21791, 554, 238, 4, 53, "Text",ExpressionUUID->"6f7a8621-19fd-403f-8d47-e6818ebef282"],
Cell[CellGroupData[{
Cell[22054, 562, 1406, 34, 73, "Input",ExpressionUUID->"e1358948-7b30-4cb9-8a6d-ba4488fb35ca"],
Cell[23463, 598, 7037, 140, 257, "Output",ExpressionUUID->"2927d9f3-c28c-4e1d-be63-737520705056"]
}, Open  ]],
Cell[30515, 741, 316, 7, 53, "Text",ExpressionUUID->"f87c0cbc-d909-43ba-85f0-e24e10b142fd"],
Cell[CellGroupData[{
Cell[30856, 752, 1677, 44, 115, "Input",ExpressionUUID->"f57b94bb-8713-4a51-9310-6c051b61bd05"],
Cell[32536, 798, 5576, 113, 271, "Output",ExpressionUUID->"a0be51fa-2376-428e-ab38-52c01f384c7c"]
}, Open  ]]
}
]
*)

