(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    476261,       9227]
NotebookOptionsPosition[    462794,       9031]
NotebookOutlinePosition[    463369,       9052]
CellTagsIndexPosition[    463326,       9049]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Last checked 20 April, 2023",
 CellFrame->True,
 Background->GrayLevel[0.849989]]], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.851321730299733*^9, 3.851321747924562*^9}, 
   3.8513218075505953`*^9, {3.890897811719871*^9, 3.890897826726935*^9}, {
   3.890973965108789*^9, 3.8909739653874283`*^9}},
 TextAlignment->Left,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f0b8aa06-db16-42de-b829-6141169ce309"],

Cell["Chapter 8, Section 8.2, Figure 8.4", "Section",
 CellChangeTimes->{{3.878892716539859*^9, 
  3.878892717498271*^9}},ExpressionUUID->"46a2d40f-f18c-413a-a1dd-\
78688d8cb6ca"],

Cell["Define a graphics object to represent the Sun.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4d13be8d-b27f-4159-be03-29125211000f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sun", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.878888163925295*^9, 3.8788881639370327`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0af57122-6bad-4bd6-a32b-206941c664c6"],

Cell[TextData[{
 "Now we define a function ",
 StyleBox["ksolve", "Input"],
 " that solves Kepler's equation to find the eccentric anomaly for a given \
value of the mean anomaly and eccentricity."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115817576166267`*^9, 3.811581780124024*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"65207154-b191-43be-938a-e55009d8aeb0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ksolve", "[", 
    RowBox[{"ma_", ",", " ", "e_"}], "]"}], " ", ":=", " ", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ea", " ", "-", " ", 
       RowBox[{"e", " ", 
        RowBox[{"Sin", "[", "ea", "]"}]}]}], " ", "==", " ", "ma"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"ea", ",", "ma"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.878888184913851*^9, 3.878888184925157*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"c1aa4f93-5249-4cf2-b3da-53146511bdcf"],

Cell[TextData[{
 "The function ",
 StyleBox["position", "Input"],
 " calculates the ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " coordinates of an object for a particular value of the mean anomaly."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"832d9400-db90-4e52-b277-c765597e9a62"],

Cell[BoxData[
 RowBox[{
  RowBox[{"position", "[", 
   RowBox[{"ma_", ",", "a_", ",", "e_"}], "]"}], ":=", "\n", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"eca", "=", 
     RowBox[{"ea", " ", "/.", " ", 
      RowBox[{"ksolve", "[", 
       RowBox[{"ma", ",", "e"}], "]"}]}]}], ";", "\n", 
    RowBox[{"x", "=", 
     RowBox[{"N", "[", 
      RowBox[{"a", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "eca", "]"}], "-", "e"}], ")"}]}], "]"}]}], ";", 
    " ", 
    RowBox[{"y", "=", 
     RowBox[{"N", "[", 
      RowBox[{"a", " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], "]"}], " ", 
       RowBox[{"Sin", "[", "eca", "]"}]}], "]"}]}], ";", "\n", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.878888195406641*^9, 3.8788881954202223`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"c1b3cd0e-b61d-4565-9251-5401bfb74f2c"],

Cell[TextData[{
 "Define a function ",
 StyleBox["PlotPath", "Input"],
 " to show points along the orbital path in the rotating frame of the \
resonant orbit defined by the list of two numbers in ",
 StyleBox["pl", "Input"],
 ".  The points are plotted at time intervals of ",
 StyleBox["dt", "Input"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"47e14c7e-3a9b-4927-9428-8eeb2fbfbaa6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PlotPath", "[", 
   RowBox[{"pl_List", ",", " ", "a_", ",", " ", "e_", ",", " ", "dt_"}], 
   "]"}], " ", ":=", "\n", 
  RowBox[{"Module", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"time", ",", " ", "p1", ",", " ", "p2", ",", " ", 
      RowBox[{"p", " ", "=", " ", 
       RowBox[{"Apply", "[", 
        RowBox[{"Rational", ",", "pl"}], "]"}]}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"pt", " ", "=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"pl", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", ">", " ", 
          RowBox[{"pl", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
         RowBox[{"pl", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"pl", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"sun", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.05", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"box", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.5"}], ",", 
             RowBox[{"-", "1.5"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", 
             RowBox[{"-", "1.5"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"1.5", ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.5"}], ",", 
             RowBox[{"-", "1.5"}]}], "}"}]}], "}"}], "]"}], "]"}]}]}], 
     "\[IndentingNewLine]", "}"}], ",", " ", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"time", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"N", "[", "t", "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"pt", "*", "2", "*", "Pi"}], ",", "dt"}], "}"}]}], "]"}]}], 
     ";", 
     RowBox[{"posvec", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"position", "[", 
          RowBox[{"#", ",", "a", ",", "e"}], "]"}], "&"}], ",", "time"}], 
       "]"}]}], ";", 
     RowBox[{"f", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"ArcTan", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], "&"}], ",", 
        "posvec"}], "]"}]}], ";", " ", 
     RowBox[{"rad", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}], 
         "&"}], ",", "posvec"}], "]"}]}], ";", 
     RowBox[{"points", " ", "=", " ", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "*", 
          RowBox[{"Cos", "[", 
           RowBox[{
            RowBox[{"p", "*", "time"}], "-", "f"}], "]"}]}], ",", 
         RowBox[{"rad", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{
            RowBox[{"p", "*", "time"}], "-", "f"}], "]"}]}]}], "}"}], "]"}]}],
      ";", 
     RowBox[{"p1", " ", "=", " ", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"points", ",", 
        RowBox[{"AspectRatio", "->", "Automatic"}], ",", " ", 
        RowBox[{"Axes", "->", "None"}], ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"AbsolutePointSize", "[", "2", "]"}]}], ",", " ", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "}"}]}]}], "]"}]}], 
     ";", 
     RowBox[{"Show", "[", 
      RowBox[{"box", ",", "sun", ",", "p1", ",", 
       RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
       RowBox[{"PlotRange", "->", "All"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.878888212855723*^9, 3.878888422993389*^9}, 
   3.878890571863344*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"fcb7fd42-0694-4ee8-a452-cf8daf14f5c8"],

Cell["\<\
Plot points along the paths of orbits at the 2:1internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"7fc55d62-a35a-426f-a5a1-3b9bfb5afac4"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint11a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint12a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint13a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint14a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8788894492177887`*^9, 3.878889449222577*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"0571a41d-07f8-4100-80be-b06dccabf09b"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811580903696122*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"59ddf638-53f2-4440-b5dd-66f0d3532882"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint11a", ",", "pint12a", ",", "pint13a", ",", "pint14a"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889461384099*^9, 3.8788894613892*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"9a06f594-38e1-4cc3-a699-35b904c683ae"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlFtIlFEUhUehhyAoEkFQyy5YmaSVkeLUFqEiGiutcLKUtEarSU0tbSSM
ScTy0iSa1phIWpomaagPibp9KM3UzDuaoJkOOU02E0z14KXsrP9hDvz8D4dz
zl5rfXtviIoPUdnLZLLgf9/yv6d7eZlIhlWRoJ13qzJRmbv7SYWiiXPHqlNV
ZKKY7MyMCpf3LMuta1Lkf6PElEpz7JkBdl5135pdbaTTA1cDB6JH2f/VNcPB
nFlquyhPuuc2wV4pvtbLAV9pb5a1PXj/FHu1DBc49BpoLKAzPO31NM+dMHat
DJih4ryjxdolA09vzz8eo/9C6rKZjemrZ7lL430rfPoz7dG5D3bMGjlI8d3P
edMkRfWXqyN0Js7L3z1T0DhOygPlL4fs5ljd7mL1dx2lwXVrw5YCf7CTg2NW
v3aIepMrNp/zMPPWF2tKUg19FKcqCEl+bOaGOwqNq76b2tYPORT9MbNuYdf1
1itvSXvYdZuGLFwY+ru8/m4z3Xi2GFSbYOFDc3YhKzJqaP6JOeWpzsLxDzv7
fl3Kl+sfLS8Ll4p9lvaV4jyn4Hy6uJ9v4/7n4n2W3vcQ9bFUn4Oonz+i/gih
j0eg74HQz2HQf0T4wxfgD/xjH/g3LvzlJPgL/1kP/71FPjyKfDxFfuyP/PxE
vvwO+SJ/lvJfzPnPB98EH+CHE8FPpeCLdeAL/PGCvMS+7FNDs7QfLfYpG+c1
4jzZCf5YLe4n6f2z4n2So74WUR/5oH5PUT/thL4RoY9+Qn+h0E+T8CdB+EPd
tv7RMfgbKfylUvh/SvhPUchnWORDW5DfB5Ef7bDNl2pt86cs8AH+qA78gD9i
W77IqactrVHZ2gz+qN6WT6qy5ZdU4Bv8UY0t/+SC/ohHfY7oH/BHkegvSV8R
+i8U+sEfnYc/7ehfX/g3hf6Og79G9H8p/PfEfJhAPh6YH/uQnzRfOpCvK+aP
EvmDD1KBjxzMr1jwA74oE3xJ80/w90b+F401wtQ=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlGtI01EYxsfS7EMQUqTY5lq6LoKBaZAgvGIlEQ1zQmphZbUMtDIRSysL
MwrTCEnTilREzATDS1BpvDNt5iVT3JaTafN+6aazEuli2Xn2YR348/9wOOe8
z/P83ld55LRGK5VIJOF/v8X/3cLFNUkSLGNLaHnp0UmqvxqoH8vQcdLKDcnB
+gnaGtfkbVJ3cUrj6n2WN+NkuhUdeHDuHedVrQ1TZI+RsfhLj1b2nn8Uyl/U
rhqlpP3GzfGGIZaGZPZmpQ2TIlsaEdU2yk7Gm/HyzkGqKQ6bv5Y4wQN98xvL
ZFZK79VsSmmbYuV3z6+uVgs1VLp+8u3/yAPB6o4DD8zkciXUfXfVZ9a6e6mG
LphoSheS8VA5zQHaO53qyz1UW3c9vbJrmktb7x9e86iLlsT4VJ84PsMx68zd
T2zttC1AsaV5ZIYN8rMzuSY9ecvueajVNn7m3F2UO9dIhj5K3V5i42Otcref
+c9JXyHvLxq0ceIut5G4nGpa71LR4bFilnfE1mYlJJVQ+ILVz99nlo2G9MQW
37wg/39rlpeLfdZgP0KcZxXOnxT3czPuHxbvcw/efy3qYxXq04j6ORD15wl9
7Ax9vkI/2/UfEv7wB/hjFv7xMvjnJfxlu79m4T9nwv+lIh9+jHyQHyuR35zI
l1OQL/JnM/JPFnywGXyAH/YHPybBFz8FX+CPf5c3e0Zm1TTY9wvEPtnP+4nz
dA73d4v7KRfvD4r3aQH1JYj6yAn1y0T95AJ9VUIfWaD/ktBPCkd/yAL/wB+d
gb/jwl/yc/SfipGPVORD0cgP/NFb5Av+SO+YP5U58kE3wA/4ozTwtVfwRQVR
XjvTcnQN4I+U4BP8USX4BX+UCr5f4f4mR/6pw7E/KBL9A/4oH/3lBH3QT3XQ
H+vYn3b/CPyRCv1dD3+t6P+L8P+XQcyHeuTz3/ygb5gv55HvbcyffuQPPqgd
fJzC/NoDfgyYbzrwZZ9/gr+XQX8AP9W7cg==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlGtIk2EUx0cp9iE3l4mR5gokCAwCI5vNToqlFHaxrCwsCGualKXdDC0S
w8xL5iUvFYiiQkVU1pa5cdQMzfJDiVCkU6db8zIv2zLEzPI95/2wB17eD4fn
POf8/79z1p1Kjj69RCKRHPj/Lf7PCMcMEj6VTxIunJCb4eKCSZGwpQ2bPTMV
xQoTFFyrU+/52I0q1abKsIYh8FPfPP7hbS/6/ZANb/g9CIaemCD9SSOmSpcN
JHoOwN0SvVUzasJ4RUNh9b5esKfnVHm5jGCIZldceek3sOjiMVs7hgV97VFx
Xj3Q6D1+r0M+gaaa828i+7+ALeWI/17ZFLodDg37/qsL+pS5WoljCq1LZzX1
3R3wsyJ0vWvTNLpnTTZNRLdBbLolMFNtw7wr17cFJDZDSaT9oGHOhk8lk5+S
Pd7B6quNY0NpdvSWBmZat78Gj69lKUajHas04UFVKc8hNjU/uzPIgdqInY1N
L2shdCa5LjzNgb4eGVFZPQ+hRvqqs7Xegco/s0nqjblwqF16I/+9A0Pkm2Xl
0w9UXZ8XjwMH54U4ivEFqXAfxftrI4X8KOZ30wrvo/h+t7tQH8q5Pi3Vjz5c
fyH1h8Xc30rqH8X+XVwEfdDM+szHCPqhgfWzkL4o6nuL9Ecd668kf3CU/Ukk
/9DG/rG/mMf+riH/cYD9DyY+0J/5QOIHy5kf5gsvMV/MH/5dMR68XPlC94jj
sRQHPd8vovsQwvl9KT/48vtGeh8uc313qD44x/VbqX7Yyv2NUH+Qx/0zf9DH
+jhIH7A76wcW4g+ZP/Bh/Y+S/vCM/blP/kAH+8f8gdnZX8jROPkPduIPw4gP
iJARP9XED/TPEV8xxBfU7jZ3Vky06Jg/qKU4iPEAmRO/UMx8i/kzmP9j/L6B
6gOxvhbn+YFSnq8i7m+V8/yBK/EHw6zPUp5fUb8unu8Z1vc2z7+e9Rf3wzj7
c5b3B/MHSbxfythf5g/62f8dvJ+kzEcr768s5ucx77f9zJe4/4i/ZtU/WPvE
3w==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlGtIk2EUx5d2EYQQdazANDM1L5SmaObghBfCxExNA7GywqG5FYYpYgwx
sUwQm9VKShhaIWKuK03njhpYQqEfJC/ZUiPLBEmnIy9o9p7zfngfeHk/PDzn
8v//zvE+fzk1x0Emk6VsfP//YcL5DjI+loWTyVHNk6BtK9JXZn1Aue5L5HLI
BNSPqpYOlQ1hYKm8fvKIFYzFnqe15nHsVlcOXH00Ah2K1jpPhx9YEtBmemMf
hOXYwuX4pl94sKC3qvrBABxv8coZs8ygLKMofzGrD5pq2iNX8mfReZPbVG1N
D8QFpI0lZv/BbHhYX2QwgWuZ9n2gag5dg5z7th42wvArfU9I0jym4I2Y1NsG
6HpZvCt6pw1jKuQWTVAVpEcV4vhHG4aqdxhvPs7HYd3X3E95C+h7YFo9qq1G
WeLZM9vmFtBlplM/5V6HGp9ug8+FRbyrs4Z7xN3B9i2OJnXXIq51J2TOeurQ
N+Cnct3JjkHeg9/C5m/h4Pa0e1alHRMK9BdjGq7h9aoBg2OWHRuTpltzX99X
qoRjx7ca4R7E++A9wnsQ3/dTfPDn+CrKDx2cf+K3UB9c4voUIUL9INbfd1Ho
D0a4v93lQv8o9p9D+iCyPh6kH4r6JZC+6Mb6upD+KOr/N13wB5+yP+HkH4r+
XSF/cZX9RfIfzez/PuJjIz3x4U78YBPzYya+sJb5Yv5wdcXvWXl/i5n5w0y6
BwW/19F78Of4Lyg+dHJ+C+UH5g+XqD5Qcv1HqX5Y4/6eUH+g4P5jqX+IkOoD
TlL9IFqqLxhZ/wzSH/Qa8meI/IHQ/eTf+jHBP9Cxv2ryF3ql/kOZlA+wMT+f
iR8oURNfFcQXPFc2nzAlvzMzf2BTS/iEzV4SfqGB+fbj+BHMv5jfSPWhWJ9Z
Oj9wLo/mi/mDEuofTnH/pdL5BGsgze8I65fO8y1nfeU8//Gs/yT5A63sTzDv
jzT2r5j3yzr728P7h/mDvdL9BOL+amR+Onm/FTBf4v4j/jqU/wAM/KUK
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.8788898475479937`*^9, 3.8788905942859507`*^9, 
  3.8788922836440496`*^9, 3.878892580639792*^9, 3.890981463733055*^9, 
  3.890981579196989*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"1925b80e-dfcc-413f-b079-38ed1b4f38fb"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 3:2 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"0d4db431-8709-475d-987c-c0aae366cc09"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint21a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint22a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint23a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint24a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8788894754402323`*^9, 3.878889475445148*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"08edaaf6-9468-4e33-8dba-8b4feffc8828"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811580899795662*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"256935ff-7d9c-419c-ab4d-b97ae59982ca"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint21a", ",", "pint22a", ",", "pint23a", ",", "pint24a"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.87888949265976*^9, 3.878889492664632*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"b65d6748-3325-4cc8-a753-8753fb86e67f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlWlQU2cUhiNIjR2LWqdYtI7VlsUqboACFU4QlGKtCzCuIIiCgK0wiqjV
ioiVxaU4RSEwLghiKTOAGBAh5QADVBHCFmQRI0uAAEluglqKgrRyvvzwzmTy
48699/vO977Ps8A32M1Pj8fjnfj/9/6/pvr9pQQeu0x+MSpKEyshcfE8/5Ou
Irw23vTn0EUlDKT6m6YtKsdnO/QnaUAJ7g/yY5o1NWhvF6HSbx2E2o3DOTNy
GvFxafZBH89BEBm2xExZ0YLy3qPZ8ZIBCBW/+MzmSDtmqk8FmFoNgMHyLWVx
Nh04jCC3v9IPfuKFYTWzujCvcjQuqF8Bw/yp+wurutG3qEQWDgqoP9c8HuXV
g5anX/17/mof6NeGiEare9Ep8d7mEmUvJEXwBa5zFOje6N6ava4XzMtNg3vW
96Pn9hjRsls9MCoNXHzUYwDX7p0k+/WtHHzaEh6JnAdRL2jk3s/b5DBalWpw
0FiJ2gsRTw5ld8OT3A1feUuVGMAvOBY8uRtk/Ljftx5TYcJPsQdc3bsgMSPr
3Wt9NQonrk7QqCyEqpNqVBkKMtulHXDE+W+90g412pqF9ZzS64Do6tK5rZYc
LpfZaopBBgZ5zsFhYRwO1VV2dXm0g1HIMt7dDA619RVWQdAGvMtOx+0kHCaE
yN7eetMMknCj1yI5hx/LcrlvzzZB0rqTbwQqDi83GYSGNzTAYfg8LKWPQ0vJ
npz2ulrgdjs4mjRymBlVt03/3GO4P/M7ixtZHI6Vh34qFZdBmch2557jHH7Z
oKncN5IPHk/5q2Eph4MOqZdlzjfgZVILP79Gjf/4Bjh+tDMFC7v3eY24q9HJ
sNDMNu0hjif/VmBbrMISl/n5exMr8ElLbIFyqgoNG3Z5qq5I0F0znGBircTn
dY4u8vpGVDVXXtE4DGL7Dru/bHa0oP+z8dEUswGUTuSvHfdnnl3N1yqwYMsJ
z+i4DhyxXhN3+EYfms+2juKldaFyqUV0lFUveqQpM0KT5Ri+NjaPK5DjloCR
8MHDvei7crqPfEU38s4UrG81U+Dt+NSXeXc68b6P9/eTH/ZjhEGom9ecDszg
D3n+YDqILU0zLm345jk6tM3zCgpRosKyOqLbqg1fDwuv3kxUYdz2vQMuu5tx
8/NQ0Zlbaiw27ty15LYUccU0k+IYDp8aJxtvndaAFxzbJvMWa3D7sEOLj3Ut
Lkm5pvCP1OB9AzeLQ8IqrHdZY1wi0eChzFzTcUElLjRZeer6J1rcJ8kqNjIt
Q/vArJlhAi2mm3tJX0SIMca+dsHdA1qMmlnnXTgjD2tnJywNi9Qi2n0RefxR
Jjo5+E2dFa/FuZ6zIn2EyZg0kT8tjvlvqlp9+qFYd38R3Qfd8xX0POjeX0fv
hzXs+5aLJr4PC9j6ztP6QLf+EFo/WLD9xdP+IJbtP5D2D0VsPmqaD7ix+eXQ
/EA332iaLziz+TfR/OEPdj6ddD7wgJ1fOJ0fvAun802n84WN7PwD6PxhE8tH
JOUD5rP8vKT8QCHL1zDlC0pY/oIof9DE8hlA+QQNy6+C8gvj9ZRvD8o31HyY
fxCyfoxRP8CO9aeI+gOBAurXEPULSj7sH0yvoH6WUj9BzPqbS/2Fdazfauo3
3GH9P0j9h68ZHxKJD3CT8aOK+AFvGF/GL03wBZSMP7OJP2DL+KRPfIJVjF+x
xC8YYXz7kfgG6Yx/CuIfCBkfrxEfwY/xs5P4CbyLxNcS4isYMf6qib+g47M3
8Rm8Gb9HiN/gwvi+ivgOroz/QuI/2DA/jEkm/ADBzB/l5A8oZH55RX6Bt8w/
3uQf0PlpCvkJ+pi/fMlfUMH8JiW/gR3z3wD5D54yP+aRH0HI/JlO/gRT5tfr
5FfQ+VcAxeaZ5Sj+D7QAMLI=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlX8w1Gkcx7fizlxpjDORJrqspl+urIor9UE/hpq0dlMJkS7hmgx11WbJ
yelSyVXbLwmlNEpRiFQfWWen0A9srN92sRa7vtaPKy6u9nn8cffMfOc733nm
+T7P8/m836/3DwGhvL2TWSyW4Mvz9X3t6tehAhYd26SflcaRKlDXbnohySnC
d3dC5ZKFKih6kxf7u385ckscdojvdUFl3pUr9vNrkL9AxX05rQtKCi1kRivr
sd/AYHmhtxLmvjYLPCVtQXevqMTy253gGmgVdFUgx6ojNREDQx3Qen3qltmv
2jE0/RbvyNYO+K314NVvGjrRfaneNHlZO8R1+Z22fdSF7JuKZFduO3iqy37R
enSjyiFCmdWvgLq9DWfuP+/B8yOCoeBMBeQa1cQlf+xFn1VJESePKuAnjtSq
XF+DYkXCsLGXApxSgtv0uzToa/fXNm9XBbjcODBlOK0PHczqGWsXBYyql2yd
MYvB4GKZutZZAdOXYdA1PoPv9QUel7/MO24Tjb2LYHCmJGHzXlBA/w2PKEMR
gxy7r0MB1ySTrLNTGbRRcD5pzRTwyvjh03lfvlXrMgzTe+TAqZFmd19k0G6s
guV7Rw62BUvjhNEMRu4yPMNbJ4dZF5PW+vzMYPODprONxW1gkcyWjjkz6HPB
673AtA1unffUoDmD0QFNPdVrWyE7665Naksfro3eEhJ/ohl8pZlqx9g+fMQz
6ZaYN0JMqMECIbsPO4YvVPy4QQaThNmzzxZrMLHbzOHYuBTsmhPDA7Zr8FCx
V+Ub5ypwtmG5h3Sqsc7xz/QRkwpwCxhy2xKsxrB7YbUOuSXwbf7GoA+yXhyN
XN+nrs0GFVszeWRJL74T7W9z3iPCOeGuq/cH9GBeON/iVMMzdGFEuzP3deOi
4hdjrNTXyDrE42XZq/D5actA06hqLDr3fc7nSiWm6vQnwznfZcWJFnViu0Vj
8HRhC5aYbCws3d6O4mG8KYmRI59l3X/aT47j/APLeEYd6CNyEyXwWzGttMk5
Y7cSwxaGp0niGzGzgNHmH1bhk+PilJD4OlxYurNMxuvByBR31rHiGjSQfGRz
RnuxOr56aI/Te7wbyy3c9asGBzi2VQk2FXjpttH8lLI+zPsgvi6+WIblb2ZM
zhYwmLTyjiTk6Uucm+Oi+WOcQdfNQW3CFUW4s4krMj3cj5bW+StGfXKx1/3Z
Y5vmfrR9Yp/MTc7Cs6sG92xw0OI+f7PclNp0nBXmoU2K1SI/it8w6HQddxUd
XOMo1qLlSVV9hMd55Pvxj5gPanHcqKRgelgc+lonPpxtOoDpw5FOj2YK0Erq
b7V48QCa5CifHuUEok5+dgP4z+i8BzFvi56x6fwg6uZhYv36T7r1sJX+n2us
+z/40f29/9DtDxPnexytOx8k0PNP2q07P6jp/bT5uvuBN71/CLk/WNH6bCb1
gYn6JZP6gYjWt4zUFzJo/fXsdPUHQ9qft6Q/sJj27yjpHzyg/c0j/YVU2n8B
6T8MUn0EEX1AJdXPJqIfGKP6KiD6gnNUf/OI/iCT6vMF0Sfso/odOajTLyyh
+t5A9A2cS0T/lkT/YB5F/NFF/AHHqX/0iH9AbzXx13riLxBS/zkR/8Fl6k9b
4k9oof6dQvwLT6i/hcTfsIP6n0/8DycoH+4TPoA/5Uca4QfI/ssXiKH8MSf8
ATfKp0WET6Ck/FpO+AVLKd8khG/gRPknIvwDNuWjhvAR/sdP2E/5Oo3wFVZS
/o4Q/oI/5fMawmcopPzeSPgNnpTvLoTvcJPy/x7hPzTQfGgn+QD2ND9cSX6A
N80XIckXCKf5E0vyB+poPtWTfAIeza81JL/gb5pvU0m+gQfNv3KSf+BG81E/
X5ePUEXz8xTJT/Ck+dpK8hUm8ncso9Rie3yV47+8Ex/I
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlWlQU1cYhkFLU5FqLVIUFyotBXQqalGB0X6aDopLJaKggKYjFbAUpHUQ
BRQUtQ6LgGIAbVywjiKLioIIYj4iUhYhDY4xEoITEhINJJAbMlAHi7U5Jz/o
ncnkx5177znne9/nmRceFxgxwcrKKvH977//SPOlASt69X3kcmPDYg3k3tY1
zFQLMYz1NPQeXw1zZgsVW7M6MCXvzBP3x71Q5T38oCajE+19/OuvtqhgRfXk
Xb4RCoyp3PvBqTYlbN1ufSizSIU3bbvybdQ9sDu2+khIigbL7sTGeXzRA5L6
7++unqjFpxvTFi/IVcBY00LHZO9+1NhxB4Y9FfCMwSW7XPXIb3cLKJ+gAN0i
DnvkrwEMbKqTN9soIFu7Spww14C+xxPjGS8FFEYfbBqsNmClaDg/N0MB9cw+
vXgpg3OZvm99rHqga7iyae05Btv3pzYz2T3Acso8EKli8LLEwSHaUwnbpZc8
wMGIyvXuRV/KlNA5GJD0xtOIO7vZzfknVcBkJa1Rehmx1Lisgb2oF/bFBB9O
cDVim/nqhRWFMYd/mmjEE/1KJ7tgNWSeWxBzXczgraoAuWOjGubLFZItOQxe
2pw1k2OvgSI57+Hj1QymNjW6hPtq4OLaZsekPgNau9bN9vfSQEyLe/y0LAPu
5XHZ342qIUIbtGWphwFPDbCuiNPV8IN/TuaU9EGc6OD2e6GsF4KOZLz8UDiA
3DJddOhrFaTlbXhwb0yP93aucpaWv5+H14yzGX56nJ7L+6zBtQdiFZz+AwU6
3D/rvmMh7yUMHRvIDTL1o4STefG8pwymcjsu2IT04+ZNRxMefCIB2YWjj+IF
fejYffmgOkoE3c3OnNwZfbhH8E9osLcQ3rF87AqCtJisLQ67XcyD0EnRfnzu
a4w7/rHYVFyDnVNCdp9yeoU28ZOkK1VtyA4qKGmOV2OMOX/PUb5HKnGJVGHr
Noz829CN8zz4PmmjCmwLFtcXRCkx3Zp51VgsR5EsbtPeX9U43NktSlkixfJi
1rZax9d4pCg0uEbRgXf788N/i+xDl0eJHHt5C76omBX4Y6wOO4XurFgrIdqH
3RUM+w7gFe3src4372BWKHfliGwQc1JGlgckF2CKKHFCd4kBy75W6t0fnoYy
B6/l7O0McltTVa3XikFa8+yPaSMMvnlb4VHNVMDljWJW40kjWl9fcqwxoQou
clP5i2yHUPCiMun89GpY03B1leDwEG6QGvzcrKshqv2Ckd8zhPNtXZdx9lfB
GZF+lsbLhO9GD87ZXHYH/DaF7qxNMGFCFLug4M9yOLZuXeC2ayaMnbnMXlRx
FZwG7eLcGkzoWVu5/vE3PGg358+Eb3PfnW7/XFBnuf/0vvk+HqfPC2eYn8c1
9P0HIs3vx7P0+6Xk+2hZ31dkfWhZP4+sHy37yyP7wyK6/8pr5v2jhJ7PbnI+
WE7PL73FfH6YSs/3xkLz+WI2PX9ncv7gQOfTSOYDcjq/bjI/eEjn+0poni/c
pPNPJvMHIc2Hk8ycD3hC85ND8gN1NF9uJF+wg+avh+QPptJ8rib5BBnNbwfJ
L2hovkNIvmEHzf8YyT+waT+6SD8gmPZHSvoDrbRfk0m/IJv2b5D0D5xpP/eQ
fkIt7W8g6S+E036nkn7DZNp/f9J/yBvPB/iF8iOc8AOmUL5EEb5AGuUPn/AH
Siif+IRPUEr5tYDwCzIo3zII36CL8s+b8A9ujecj/Ez5qSf8BB3l63PCV7g0
nr/wPz6DO+V3J+E31I3nO8B4/oM/9cNp4gcopf7QEH+Alvqlk/gFuqh/Rol/
oIT6SU78BOXUXxHEX2DxWxjxG9hS/3GI/+AQ9WMr8SNwqT/tiD/B4lcB8StY
/Dv2qc7Xzke84l/Hpx3q
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXs01GkYx1EMm0qKKWGLSOzo3uj6ZNpFDrVadFTKfSu11q2SWpVtbTlx
wtlY6mjbSCOZanRq2x5aq4QRYjKumTCGMldNVLad9/VH7zm/8zu/8zvv7Xm+
3893fkjUtnA9HR2dhE/P/+/l2iEGHTpOPFwVFfGsB5Jy42eyIqrwtUlQV9CT
l3AmP+6iD7cZextGLxeFdYOwgO8p/diJnrVfKDo7OkBQrycaPifGdYOaJRfY
bTCF5X5umkk/jqo02cdntoKh+47DBnOluFRo6ZGXJgTp3EMejyqGcNw/yUzM
a4HNPxk/jzYdxnj7hkbO0RYYblKvDkyVYVh4qs1vHS2gyUm/ErBfjtnzu1wT
64Rw5K1v4buFChSvNBaMurQCqyi3ce2/ChRlHvNLntoGR0ty7Ys5SrSrCzuV
wu4AoVfZhWv5SsyosRwb+KMLUj3DVJldSjy7yJtVaPUSYveJLMbGlejQHljH
OtQD8dW7027qqTDydMj0sWdisDny9HarRIllze2Gaxb0wtVKp8DJd5QYHvH/
6IPOvcJmmwglGp9eHB6c1g+vdjttztBVYmUZNy45UwIMRoEl84wCOxOyLhYd
HIAi56D8lnE5WrO/Pr/eTAp+e/LcvPfJMYb/wYidLIXU0PQdrtUynJe6XDyL
J4WsqnExz1aGgwdNDGqzpbBQd57s5Ls3WCIVaYpWfPpeqbBYwnuNP8Y4X3dI
GoAcJt5OOTSEG7nNG3gxEvC6ctyA4TOIDY/jNF5G/WDueGGTobsUeY6dP7uv
64XX83c4ju4awBlBOVsbJolhCje2fWWWBCW7Gxi1/t2QJTpft3agH62xutLX
XwRmCxj7zXz60Zi5X//34UZg4zGP+/w+/PX05I6AvkpoNpE52yl6UW3VPvn2
4XQIrW1jbml4hSvs4m+0rXmEuyo/5vQyxeii1V8TZj/WtSvN78ZvpbcYe5Lb
cfw+5/qd9yLcdTKWC2496KrhZHi+bUI35do5Gy/1Yo7a1778aTXeiL6f+CBC
gpzE+tjvNtxDB7+Xo+oqKRY/+rD4rusJDGn1fn62ewhLQzdt8UvjwdWawtgv
a95g2j9GpUvLysFyUJCS5ynDuOjqgs7mKki58WYJ21aO7m99Kp5sqIGRkqkO
D2VyzOX8osebJoBLuul2ylsKPBbIjSwJr4fGU7KbmXuVqBc/a5H1p2/pzu9f
VE1XoWtUYFzAYgEINcu2HShQoWzpnYv8/hrIm1o1yd9RjRYuhYKsW0/Ar9Rj
T0yOGq18ZJd/4FeCgVMCf1CuxuMtqqjH5uUwx5rBgWUjaGDqHrPoPR9CWQZ3
vQNG8MFd4xOcLQWglV/ECH40HVpjvLr8QQj971Wm/Y+z6fzEGdr5qE/XTyTr
48T++mR/nDgfk5wPW+n5ReT8OETv50/uh8/p/UVx2vtjPq3PJlIfnKhfMakf
nqX1XUXqi1a0/rGk/lhM+xNM+oORtH9DpH/oTPs7p0LbXyim/f+K9B82Un0I
iD4gnOqHRfQDPlRfOn9p9QVOVH95RH8QTPW5negTGs2JfncS/QKX6ruJ6Bv0
qf5XEf3DbOoPJvEHyKl/0oh/wJT6S5/4C/6m/pMQ/0EP9ach8Sesp/7dSvwL
R6m/zxF/w0Pq/1nE/yCjfLAlfABbyo8Mwg+I/JwvYEP540v4AxN8ukr4BBWU
X0aEX2BI+dZH+AbxlH+thH9wj/LxT8JHOPA5P8GF8jWa8BW4lL8HCH/hGuXz
GcJnWEb5/YLwG6SU7wmE79BG+e9M+A95n+cDRNH8GCP5AZk0X2QkX2DedpI/
35D8ga00n7pJPoG5muTXqJs2v4BN882C5Btsp/lXR/IPemg+akg+gormZzDJ
T0ii+ZpO8hUm8vf9mH3Jqfqadf8BS/gIJw==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.8788898484444036`*^9, 3.878890595575305*^9, 
  3.8788922852357616`*^9, 3.878892581489139*^9, 3.890981464704986*^9, 
  3.890981579809429*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"d29db040-c9ca-496c-af5b-3873d4ed381e"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 4:3 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"96cd15f8-78e6-4890-a330-b11582f1f29a"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint31a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint32a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint33a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint34a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.87888950675734*^9, 3.878889506764619*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"70172b73-8559-457d-953e-ec6dc47544fb"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.8115808959481173`*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"47ee9a23-47db-4786-8edb-fbfdb2568c69"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint31a", ",", "pint32a", ",", "pint33a", ",", "pint34a"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889519749506*^9, 3.8788895197544527`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"0d654af3-0a6d-450e-a95a-16e2f81a6a2c"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVln1M1WUYhpmAzlZkcwWpIWITEw5yOKUIyAOxSIrGMClnG58hY2uBqWi1
JbFo2gxQUHOxZpvklmCpbTRCHkiLD8HMlL4cQeABzjmtglqCf1T2Xm8bZ2O/
7ffxvs9z39d7PywrKN1YNMfPz+/9f/9uX/v7bv984scvMsZxvvKCTxYcGMpu
SjuteaM1nrgmn2hfysEDqzr1647x6iNVPtl7/MN5ia/26KET/q7wp33yUNPR
tKn2yzp3m7vLHeyT+/Ylnny75qpuP7yx8cFvvfLi6+FZYxHfadHRnaem67zi
e/aNzc2VP6ozY17d0iyvbB25NX6wYVB7y/I/PrfAKyHPzAwGtg5py2lfReZV
j7iawzftCfhZMxalvtfQ4JHJC8vd66NHtDyyNKS9xCO93Y2NSXGjGvN70UBU
gkeS3UHFPyy/ofELj2Veu9sjQRVbPj8zeUNjr/d0OdwTUtv864bjH7g1dk/x
/KfaJqS/cNc7bSlj+vz1RzL8aidE9qd7Y78c0+l1Jbt/ypmQRRFVnvw143qu
MSE7d8WErB4ob+2sH9fVK7VseGRcos1Vo819aTfv6TLznfxm1tEks64UmX30
K7OvxJg69C1Tl6w1depCU7esMX1oqulLok2fet70La8ZHfQvo4ukG5002ugm
rUZHDTO6SpfRWQuN7hJrfNBfjC+CT1pufJOXjI8abHyVQOOzrjS+CxxoveFC
LhtOdMBwI3Ck3tr/uBI407KPqnMqvjnRBoc6B+7s82G4y+X7Yri7wvoOuKtn
/1C4C6C+HLjbQf2jcFdMf8/B3cP0vwTu4FCdcPcp+k3B3ZPo+wXcvYL+ljsn
/twBd0n49z93+HsJ7pz4vx7uLB+L4e4m/DjgTuHLAXcxXFu57+K9Sb4LY508
1k1lH7uvrSOKug5T56PUPZc+VtHXBvq03HWgwxPo8ic6nUG3eHTsRtdQdI5B
91J8sL548clytx0f78TX6b3G5zp8T4ED8km3wUk+3JyFI8tVCJxZ7gyHLYkO
nl+DU8tdLxzb9ffBueUuhnMwn/oCOSfl1F/IOSqhv+85Z5a7XM5hH/rcyzk9
hX7JnOM09L3FOa9E/xZyIAJ/MsmJRPyDQ3HhbzU548D/K+RQMXwkkFMz8EP+
ySfwFUfOrYC7teRgLNx9Rk4uhbspcjQZ7uBQFO6SyOFDcBdNTt8Dd3HkeDrc
Ocj5frizc2AM7jYxJxxw184ceWD2+ZYX4M7OIf/Nhrs85lQp3MGhZJAvf5eZ
OSdwB4cyBHf9zMkdcFfIHL0L7qKYs/X+3rRjg52Jdg4Pw519ngN3BXzfA3eX
WH/mpOHuXfZPhjtbX+Hs/JabcFdAf3mz81+C4e4i+kTAXQf6DcNdNvp2wd1u
9LfzifyT++HOiX81cGfn8DDcheE/+Sdb4SMI7gLiDT/r4O4sfEXBnZNrG/ed
vPcH3IWyTinrutjHxb4XqSOeut6kzseoO4A+mLvyOH3uou8+dLD/nzAnpBvd
QtHR6roYnSPRvQoftuDLEsOhvIxvWfjIXBMHPu/H953kTzdcZDQaTsgvYY4K
+SbVcGa5M/nX1fYP8U2Aeg==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlX1M1WUYho+0ZhiyimhsCI1JOUtMiMIx7CkLlpIEHkD7mBaSuUCi2cZg
TghRxEAq/xC0OWsRsJkQgljQHhIZX1FAkJTkQlvnHM6WfVCJIwl7r/cPznb2
234f7/s893299xOW8frGV3wcDscHc/+b16PVN38ecfA7XbMwP+SAR7LeHMi4
cutnWvz3X2ty0z2ybuXu08VtPXr82EjcKj+PdG1L/tYZPayzntARn2a3dKcn
DmefvKDOvtsSs59zy6nl44GulnF92ZVX71jolutBUdFhH/2kt1dEjD3R5ZLN
zqaxrY2XNaXv7Uv3H3VJQptzOqroZ927+JFfg8tcEtMf6xcd+It2Tcy64g+7
pGPbH0dK33DpeFRB5kSrS84+9sLliiNuLQ0PzqqZckl/fFWtlnn07O6AdaEJ
brkz9vfQ2vWTOnYuJGem1i31QQ397vFJzZ86fMumQI8Mlq5OdT7p1WgtL74y
169jPKP1tyKv5u0IuLr037l+mxLyA6u9GuVd8GhF9qQEB3dNZFV6NSz786GP
hyYlbVfz5uuverXy7tmC8GVeOWSummruy1Lznoaa7+RBs46uNetKgdlHr138
f1+JM3XoqKlL8kyd2mjqlhHTh95j+pIW06cOmL5ln9FBW40ucsnopOeNbtJh
dNRYo6sUGZ31GaO7JBkfNNn4IncYn/Sa8U0yjY/aZHyVjcZnHTS+yw3DgfYa
LuSY4URTDDcCR7rTcCVwpqMje3K7I2ra4VCT4K6J52vhzn7fCXdwqD1wB4da
D3e2vj/hztbvhDt/+nsa7pLp33IHh1Y//RL9muEODvUruNuP/v5w14o/dXB3
Ef+G4c76O2P8txyqwN0e+FgCd6vgx3J3L3xVwN27XMO57+S9lXwHh1rCunHs
s4Z9/6EOW9cQdX5H3Q30cYa+7qLPQ/TdjQ5D6NKBTla3TnQsRdeH0TkV3Z/C
h0X4sgWfXsK3GXxMxdcGfLbcfQ0HJ+DiFJwUwk0hHDXCVQ+cWe4Mhy1xn/K8
HE7f4vsVcPw+6w/D+Qz7X+AcpFPfCc6J5W6Kc+RHf3Aolrv1nEN7LuFQvkC/
Hs7xGPqSf1IyX39pxJ8gcuJH/KshRwrxt4+cicF/OJQc+NhATsXATxA5tgS+
0sm5/XBXRQ5uhbsgcjIE7h4iR51wt4Oc9SF3I8lhm8s2p9vgrp8cD4A7m/Nd
cFfBHDgHd6N2TsDdIHMkCu4OMGdS4G4Dc+h5uPNlTk3D3Rbm2Em4s3Ouf37+
yDTcVTMnA+CuhDm6aX6+SZ/va9/k1A3Z/JNIuGvm+Y0Iw539/ircVbF+B9w5
Js3+H8JdGvVZ7jKoPw3u7BxOhLtn6X8F3B1En0a4G0K/drj7Hn174W4v+i+G
uzb8aYa7Qfwbg7tc/PU1/ssy/E+Cu53wsQjuHoef7XDnD1/lcPce1/u4n8R7
kXxHjso+1l3NPsK+U/B/kLo6qfMH6v6EPo7T1wP0+Q59n0eHfnQZQCer2xl0
LEPXSHSOR/cX8WEBvmzHp1x8m8BHy10dPlvfe+GgEi6WZxpOiuBGyK8WuCra
ZTiz3Jn862r/D2tte74=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVln1MlWUYxhEUkJPIR9DCFmCu9YeFQgkS62bYan5UwIJcJWMQSqxslqzM
DGbEnFErCuVDDn5BVqBpiRTYDWq1MrFNkSmIBefwoXCOaUJRVtbze9vO2c7e
7X3P+zz3fV2/57pPdM4L6XneXl5eO258/72u/O8zKF58ttlST/wgg9J768sN
D7S2a/Vn3om1XU5Z8fM7IbOf/VFj5zdmFCQ7JcB399UUR7cebGiZkmV3SHpk
YF1LY59+tSXC4QpwSFCpI8/v6X4NiHON7K8ekDeeH/9j7jSn5nWErf74yQG5
NvT2svHMIe2d6MlenjYgcvLDXeFPjGhfxeFH7i8ekKvPDE/fGnBJK25f912s
c0A+SK60FxWOambTJwvK1zuksK0q5kr1mD4cU+w/muSU6aXdvi9tcOldx+4r
qY8elM99561JinRrUPWZ5tzoIfE/3ZZdttGtp0ou5GbFDcvX56eUOj9y66cv
+jbseHRE6nLGglMq3WqPj+5cVHBRikPsrySkuTVlpON4+YZLck/D4pzQsy7t
nlXiTCwelZkFqbF997r0Fy95c1XBmFw2Vw009+Ws+Z3Gm/ckwayjrCvbzT5a
Y/aVg6YO/cbUJV2mTrWZuoU+tNn0JbNNnxpg+palRgdda3SR5UYnfd/oJluM
jvqb0VV6jc76oNFduo0POml8kVzjkxYZ3yTI+KhhxldpNT5rhvFd4ED9DBcS
ZzjRlYYbgSPtN1wJnGni5OqNgZt2tsGhdsFdLc/z4W4r79vgbj7rp8JdM/sH
w91h6lsPdzOofxzu4FCT4a6H/tHH4lCr4K4M/dbBXRr6+sPdYvRvhLu78ccH
7m7Bv+NwdwJ/t8NdE/6/Bne74WMB3Fn8hMPdafhyw90Vrtb9MH63kPesdXay
bhH7HGJfONRO6rLqjKLu66dMH7H0tYc+H6fvqejwGLpY53MzutWi4zl0/Qud
z6E7HP7vCxyqDd+s/GjH13B8PoDvWXAQDxeuaYaTKrjJgSM7XO2HM4s7w+GB
JOv5UTi1uEuH43msfxOcW9zDoRylvkDOyUzqh0NZRX9uzlk//ZN/8hP6THBO
y9GvgnO8FH1f5Zxb3PmQA5H400pOWNz9bfyTb/H3JDlD/in5J9XwUUJOkX9K
/kkPfNnIuSG4myQHQ+HuDDl5J9wtIUc3w105OVsPd3vI4Ta4u0BO+3F+gslx
63wlkPMz4O4h5oB1PjOYE+VwV8McuQ53PcyZRZ7nX3yGDXdPMafK4M6bORYF
d4eYc9me+SO3eeaTLIG7bcxRvwiPfJOo936/2DHYaeWfXIO7Gp4nw531fgjc
WXM4H+72sn8E3LVQ33NwdzP1/wl3K+gvCe766N/i7jz6lMFdHfqt8ZwvN+a8
4S4R/ffB3Vz8CWV+2fDvCNxZc7gJ7uz4/y7cbYKPO+AuHX5mwd338DUGd79y
dXDfm9/F8F4K69SzLjkrrexbRR2XqWsvdc6hbvJPIuirnT4z6dsbHRaiSxk6
fYFur6PjiOf/GzmG7hn4kI8vE/g0Fd/ewscv8RUOZR++r4WDSLgohJNKz/9v
Qr6Jj+FQLO5M/h1p+wcPr1K4
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlQ1M1VUYxonSShZZw7TZVWPWtBIZqDklXhJH1nIK4lpD00BcbvgRczob
s2WKgiAMVDJZCqhjFRciCwTyFblMFEwJB33w4SBhoCjX1mQUkHl+x+3e7e6/
3f8957zv8/zO874Yuzkq3tvLyyvv/vf/Z/CDT5d48VnXMPD5uc5OeaI4eddn
G2o1PacvP+HpTvmwPmDJhMpreqWgZGXg8HWZ6D08FFHcpnPfbDm6pqNDlv57
sm30bKcOpe5z/f1au0zrSMvInNqtCwbP1MRNapOKGefG5YzrVZ0TlpFS3irZ
GxITBw/c1OyIsD+Gx7dJwapp780v69dXmo+9kfd8uyxf1XOmJeWOTr5a3b+w
pkM2bu36IGjPgF4/7U594f75h3zD1yxxuPWAY/3Gl6M7ZfZIXWVaultzb3vN
rP69S551OkdCm91auz3RJ2n3Dal4e177+XtubZiSe6N8cY+cHDzh23jXrUVl
gYt6fXslLrlw4ZE6t0aUXhx1NfdJop/M+vUTt+oPFxOSMm/J3h131/7p49bR
opKt3YG35bFIxy+lOwc0qn9nxtdFd2S5eeqj5nd5xPngf5pq1km52UfZV5aZ
c5Rz5TtTh1KXUKdWmbrlJ9OH+pm+5IjpU+lbMowOmmV0kW6jk6KbTDQ6apTR
VV41Omu+0V0OGx80x/gilcYnLTO+SbjxUf2NrzJofFZ8FzhQh+FCLhtOdLPh
RvYbjnSK4UpiDWcqcnbGN65jVXCoN52GOzjU1XCXxnrLHRzqu3AXyvmWu3vU
9z3chVH/Qbg7T3/0r1/QfzTcvYQ+m+BuPPpZ7n5D3yC424f+z8AdHOqPcHcJ
/07AXT3+roM7ONSP4c7ykQ53ZfBjufOGr2Vwt4LnkOFTx/K/CtalsI/ddwvn
lHJuLHVcpq4C6mykbtvHl/QFh5pN34Ho0IIuOejkg25b0DEIXVei81F0t/f/
Kr7AoQbhWzU+Prnf+Gp9no3vkXDQBBdj4SQFbrbBkeXqLziz3BkOi0Pied9q
3ksG6wWO69nfH87ncf473IPhVI/6JIT6yb+H9yqLe5ZF/4XcQ39PfcSBfvYe
/+ypr6SgfwA5kI0/z5ETdZ7+SQ3+2pz5Fv/jySHyz3IotfCTTI6NgTtvci4C
7mLIwTFw9w85abmrIke3wV0oORsDdy5y2HJ3hZwm/7SGHH8K7orI+WC428Uc
IP+0jzmRCHd+zBF7v+cyZyx3XzGH0uCujjlVDHeLmGMhcNfInMN3fYs5OAfu
yD+ZD3cHmaMTmKtxzFmn79TXTyVdsvknj5OP9n0A3Nn1Mz3zVcLh7uH5cNdE
fYVwF0H9u+Gugf5y4e4U/a+w3KEP+Wc5lGy4a0dfO3/2ov8kuINDKYe7C/h3
HO6a8DcB7nLwfwfcBcPHp3B3DX68PeerLIW7aJ4jnvNZnKzLZJ9I9t3EOac5
dy11WO7yqdNF3ZX0UUJfvvR5iL5noUMrutj7uQDdrI6T0XU1On+E7qX40IMv
e/BpO77l4WMvvlqfp+P7+3BwAS4WwwlzV2LgaD1c3SLfLHcm/7TqP0IEvcc=

          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878889849118505*^9, 3.878890596115203*^9, 
  3.87889228579838*^9, 3.878892582216755*^9, 3.890981465002602*^9, 
  3.890981580241544*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"6d7672e3-d6d0-4e23-b3d0-d1bcb3b15d96"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 5:4 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a2081c17-770e-4c20-b598-7281ccca6e66"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint41a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint42a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint43a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint44a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889540567335*^9, 3.878889540576172*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"6b04603b-cb0c-4dac-a519-926848374df5"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811580891692903*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"300e6048-e3fe-416c-8274-96b459045660"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint41a", ",", "pint42a", ",", "pint43a", ",", "pint44a"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889554021603*^9, 3.878889554028634*^9}},
 CellLabel->"In[24]:=",ExpressionUUID->"b3d21b17-356f-4c9a-a1bf-014eb12dc1bc"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVl3k8lWkbx5Uwb02WFqXmFeW1tBCyli5vWoxGhCitEtJmiShkS6dpSKmG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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3k41Wkbx4UahillRiqSarK0qDC06D5RluqlEVEqZSnJUlmaSouyvCGl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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVl3s01GsXxylJRRdSpItQCSXqUKl2ORWloqJO6SJCeeW80uWUSjcUctxe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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVl3k41Wkbx0UpWUYhhUjbNC1STArNHb3TvnmlZQpZKoXUSA5pGhXZSr0y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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878889849637947*^9, 3.8788905966053143`*^9, 
  3.878892286464501*^9, 3.878892582772038*^9, 3.890981465385931*^9, 
  3.8909815806075172`*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"c5181e14-3649-4700-abdc-124dd7df49f1"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 6:5 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"9ddce1d6-ff9d-46ad-be0e-92f8406ec25c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint51a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint52a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint53a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint54a", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889567073687*^9, 3.8788895670785522`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"ec7a7997-ea9a-4424-b6d7-8c699c372393"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.8115808878414783`*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"8f4e30d5-92a8-4d82-ab8d-28ca2f803bf7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint51a", ",", "pint52a", ",", "pint53a", ",", "pint54a"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8788895789085617`*^9, 3.878889578913404*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"ce477813-ab78-4db9-8c38-eac8bf79211e"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVln1UzXccx8vDRvIwNCaPI1sZ2jEayofZ2c6QFSV6oOTilphns3lqOTfm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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlnlQlWUUxgEdtwzMwBKQgsRUIL0gAoIdcQdNKJBQcAkzJVwGVAocHchR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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlnlUzWkYxwsZW+EQB9HJWBoSky1pPHMzNPYjSyWGkhiMDKOhxhaiKRkj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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlnlMlFcUxREqIopWxKU1LoOaWrVWRSUocAOjpqC4FVQ00jpslmbQgq24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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878889850097238*^9, 3.878890597189191*^9, 
  3.87889228705935*^9, 3.8788925832261753`*^9, 3.890981465808713*^9, 
  3.8909815810403347`*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"d061462f-95c6-405f-82e4-f7515112a407"]
}, Open  ]],

Cell[TextData[{
 "Gather several plots using ",
 StyleBox["GraphicsGrid", "Input"],
 ".  This is Fig.8.3a."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115808498154507`*^9, 3.811580852596011*^9}, {
  3.878890343454084*^9, 3.8788903885741987`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a75a0581-eff9-469e-a6cf-642bbe1d4f59"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pint11a", ",", "pint12a", ",", "pint13a"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pint21a", ",", "pint22a", ",", "pint23a"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pint31a", ",", "pint32a", ",", "pint33a"}], "}"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8788902515034657`*^9, 3.878890319574437*^9}, {
  3.878890398565146*^9, 3.878890430694849*^9}, {3.878890466919552*^9, 
  3.8788905066873417`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"ed370e2c-5c55-4864-a4b9-f5f30e5245ee"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlFtIlFEUhUehhyAoEkFQyy5YmaSVkeLUFqEiGiutcLKUtEarSU0tbSSM
ScTy0iSa1phIWpomaagPibp9KM3UzDuaoJkOOU02E0z14KXsrP9hDvz8D4dz
zl5rfXtviIoPUdnLZLLgf9/yv6d7eZlIhlWRoJ13qzJRmbv7SYWiiXPHqlNV
ZKKY7MyMCpf3LMuta1Lkf6PElEpz7JkBdl5135pdbaTTA1cDB6JH2f/VNcPB
nFlquyhPuuc2wV4pvtbLAV9pb5a1PXj/FHu1DBc49BpoLKAzPO31NM+dMHat
DJih4ryjxdolA09vzz8eo/9C6rKZjemrZ7lL430rfPoz7dG5D3bMGjlI8d3P
edMkRfWXqyN0Js7L3z1T0DhOygPlL4fs5ljd7mL1dx2lwXVrw5YCf7CTg2NW
v3aIepMrNp/zMPPWF2tKUg19FKcqCEl+bOaGOwqNq76b2tYPORT9MbNuYdf1
1itvSXvYdZuGLFwY+ru8/m4z3Xi2GFSbYOFDc3YhKzJqaP6JOeWpzsLxDzv7
fl3Kl+sfLS8Ll4p9lvaV4jyn4Hy6uJ9v4/7n4n2W3vcQ9bFUn4Oonz+i/gih
j0eg74HQz2HQf0T4wxfgD/xjH/g3LvzlJPgL/1kP/71FPjyKfDxFfuyP/PxE
vvwO+SJ/lvJfzPnPB98EH+CHE8FPpeCLdeAL/PGCvMS+7FNDs7QfLfYpG+c1
4jzZCf5YLe4n6f2z4n2So74WUR/5oH5PUT/thL4RoY9+Qn+h0E+T8CdB+EPd
tv7RMfgbKfylUvh/SvhPUchnWORDW5DfB5Ef7bDNl2pt86cs8AH+qA78gD9i
W77IqactrVHZ2gz+qN6WT6qy5ZdU4Bv8UY0t/+SC/ohHfY7oH/BHkegvSV8R
+i8U+sEfnYc/7ehfX/g3hf6Og79G9H8p/PfEfJhAPh6YH/uQnzRfOpCvK+aP
EvmDD1KBjxzMr1jwA74oE3xJ80/w90b+F401wtQ=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlGtI01EYxsfS7EMQUqTY5lq6LoKBaZAgvGIlEQ1zQmphZbUMtDIRSysL
MwrTCEnTilREzATDS1BpvDNt5iVT3JaTafN+6aazEuli2Xn2YR348/9wOOe8
z/P83ld55LRGK5VIJOF/v8X/3cLFNUkSLGNLaHnp0UmqvxqoH8vQcdLKDcnB
+gnaGtfkbVJ3cUrj6n2WN+NkuhUdeHDuHedVrQ1TZI+RsfhLj1b2nn8Uyl/U
rhqlpP3GzfGGIZaGZPZmpQ2TIlsaEdU2yk7Gm/HyzkGqKQ6bv5Y4wQN98xvL
ZFZK79VsSmmbYuV3z6+uVgs1VLp+8u3/yAPB6o4DD8zkciXUfXfVZ9a6e6mG
LphoSheS8VA5zQHaO53qyz1UW3c9vbJrmktb7x9e86iLlsT4VJ84PsMx68zd
T2zttC1AsaV5ZIYN8rMzuSY9ecvueajVNn7m3F2UO9dIhj5K3V5i42Otcref
+c9JXyHvLxq0ceIut5G4nGpa71LR4bFilnfE1mYlJJVQ+ILVz99nlo2G9MQW
37wg/39rlpeLfdZgP0KcZxXOnxT3czPuHxbvcw/efy3qYxXq04j6ORD15wl9
7Ax9vkI/2/UfEv7wB/hjFv7xMvjnJfxlu79m4T9nwv+lIh9+jHyQHyuR35zI
l1OQL/JnM/JPFnywGXyAH/YHPybBFz8FX+CPf5c3e0Zm1TTY9wvEPtnP+4nz
dA73d4v7KRfvD4r3aQH1JYj6yAn1y0T95AJ9VUIfWaD/ktBPCkd/yAL/wB+d
gb/jwl/yc/SfipGPVORD0cgP/NFb5Av+SO+YP5U58kE3wA/4ozTwtVfwRQVR
XjvTcnQN4I+U4BP8USX4BX+UCr5f4f4mR/6pw7E/KBL9A/4oH/3lBH3QT3XQ
H+vYn3b/CPyRCv1dD3+t6P+L8P+XQcyHeuTz3/ygb5gv55HvbcyffuQPPqgd
fJzC/NoDfgyYbzrwZZ9/gr+XQX8AP9W7cg==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlGtIk2EUx0cp9iE3l4mR5gokCAwCI5vNToqlFHaxrCwsCGualKXdDC0S
w8xL5iUvFYiiQkVU1pa5cdQMzfJDiVCkU6db8zIv2zLEzPI95/2wB17eD4fn
POf8/79z1p1Kjj69RCKRHPj/Lf7PCMcMEj6VTxIunJCb4eKCSZGwpQ2bPTMV
xQoTFFyrU+/52I0q1abKsIYh8FPfPP7hbS/6/ZANb/g9CIaemCD9SSOmSpcN
JHoOwN0SvVUzasJ4RUNh9b5esKfnVHm5jGCIZldceek3sOjiMVs7hgV97VFx
Xj3Q6D1+r0M+gaaa828i+7+ALeWI/17ZFLodDg37/qsL+pS5WoljCq1LZzX1
3R3wsyJ0vWvTNLpnTTZNRLdBbLolMFNtw7wr17cFJDZDSaT9oGHOhk8lk5+S
Pd7B6quNY0NpdvSWBmZat78Gj69lKUajHas04UFVKc8hNjU/uzPIgdqInY1N
L2shdCa5LjzNgb4eGVFZPQ+hRvqqs7Xegco/s0nqjblwqF16I/+9A0Pkm2Xl
0w9UXZ8XjwMH54U4ivEFqXAfxftrI4X8KOZ30wrvo/h+t7tQH8q5Pi3Vjz5c
fyH1h8Xc30rqH8X+XVwEfdDM+szHCPqhgfWzkL4o6nuL9Ecd668kf3CU/Ukk
/9DG/rG/mMf+riH/cYD9DyY+0J/5QOIHy5kf5gsvMV/MH/5dMR68XPlC94jj
sRQHPd8vovsQwvl9KT/48vtGeh8uc313qD44x/VbqX7Yyv2NUH+Qx/0zf9DH
+jhIH7A76wcW4g+ZP/Bh/Y+S/vCM/blP/kAH+8f8gdnZX8jROPkPduIPw4gP
iJARP9XED/TPEV8xxBfU7jZ3Vky06Jg/qKU4iPEAmRO/UMx8i/kzmP9j/L6B
6gOxvhbn+YFSnq8i7m+V8/yBK/EHw6zPUp5fUb8unu8Z1vc2z7+e9Rf3wzj7
c5b3B/MHSbxfythf5g/62f8dvJ+kzEcr768s5ucx77f9zJe4/4i/ZtU/WPvE
3w==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlWlQU2cUhiNIjR2LWqdYtI7VlsUqboACFU4QlGKtCzCuIIiCgK0wiqjV
ioiVxaU4RSEwLghiKTOAGBAh5QADVBHCFmQRI0uAAEluglqKgrRyvvzwzmTy
48699/vO977Ps8A32M1Pj8fjnfj/9/6/pvr9pQQeu0x+MSpKEyshcfE8/5Ou
Irw23vTn0EUlDKT6m6YtKsdnO/QnaUAJ7g/yY5o1NWhvF6HSbx2E2o3DOTNy
GvFxafZBH89BEBm2xExZ0YLy3qPZ8ZIBCBW/+MzmSDtmqk8FmFoNgMHyLWVx
Nh04jCC3v9IPfuKFYTWzujCvcjQuqF8Bw/yp+wurutG3qEQWDgqoP9c8HuXV
g5anX/17/mof6NeGiEare9Ep8d7mEmUvJEXwBa5zFOje6N6ava4XzMtNg3vW
96Pn9hjRsls9MCoNXHzUYwDX7p0k+/WtHHzaEh6JnAdRL2jk3s/b5DBalWpw
0FiJ2gsRTw5ld8OT3A1feUuVGMAvOBY8uRtk/Ljftx5TYcJPsQdc3bsgMSPr
3Wt9NQonrk7QqCyEqpNqVBkKMtulHXDE+W+90g412pqF9ZzS64Do6tK5rZYc
LpfZaopBBgZ5zsFhYRwO1VV2dXm0g1HIMt7dDA619RVWQdAGvMtOx+0kHCaE
yN7eetMMknCj1yI5hx/LcrlvzzZB0rqTbwQqDi83GYSGNzTAYfg8LKWPQ0vJ
npz2ulrgdjs4mjRymBlVt03/3GO4P/M7ixtZHI6Vh34qFZdBmch2557jHH7Z
oKncN5IPHk/5q2Eph4MOqZdlzjfgZVILP79Gjf/4Bjh+tDMFC7v3eY24q9HJ
sNDMNu0hjif/VmBbrMISl/n5exMr8ElLbIFyqgoNG3Z5qq5I0F0znGBircTn
dY4u8vpGVDVXXtE4DGL7Dru/bHa0oP+z8dEUswGUTuSvHfdnnl3N1yqwYMsJ
z+i4DhyxXhN3+EYfms+2juKldaFyqUV0lFUveqQpM0KT5Ri+NjaPK5DjloCR
8MHDvei7crqPfEU38s4UrG81U+Dt+NSXeXc68b6P9/eTH/ZjhEGom9ecDszg
D3n+YDqILU0zLm345jk6tM3zCgpRosKyOqLbqg1fDwuv3kxUYdz2vQMuu5tx
8/NQ0Zlbaiw27ty15LYUccU0k+IYDp8aJxtvndaAFxzbJvMWa3D7sEOLj3Ut
Lkm5pvCP1OB9AzeLQ8IqrHdZY1wi0eChzFzTcUElLjRZeer6J1rcJ8kqNjIt
Q/vArJlhAi2mm3tJX0SIMca+dsHdA1qMmlnnXTgjD2tnJywNi9Qi2n0RefxR
Jjo5+E2dFa/FuZ6zIn2EyZg0kT8tjvlvqlp9+qFYd38R3Qfd8xX0POjeX0fv
hzXs+5aLJr4PC9j6ztP6QLf+EFo/WLD9xdP+IJbtP5D2D0VsPmqaD7ix+eXQ
/EA332iaLziz+TfR/OEPdj6ddD7wgJ1fOJ0fvAun802n84WN7PwD6PxhE8tH
JOUD5rP8vKT8QCHL1zDlC0pY/oIof9DE8hlA+QQNy6+C8gvj9ZRvD8o31HyY
fxCyfoxRP8CO9aeI+gOBAurXEPULSj7sH0yvoH6WUj9BzPqbS/2Fdazfauo3
3GH9P0j9h68ZHxKJD3CT8aOK+AFvGF/GL03wBZSMP7OJP2DL+KRPfIJVjF+x
xC8YYXz7kfgG6Yx/CuIfCBkfrxEfwY/xs5P4CbyLxNcS4isYMf6qib+g47M3
8Rm8Gb9HiN/gwvi+ivgOroz/QuI/2DA/jEkm/ADBzB/l5A8oZH55RX6Bt8w/
3uQf0PlpCvkJ+pi/fMlfUMH8JiW/gR3z3wD5D54yP+aRH0HI/JlO/gRT5tfr
5FfQ+VcAxeaZ5Sj+D7QAMLI=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlX8w1Gkcx7fizlxpjDORJrqspl+urIor9UE/hpq0dlMJkS7hmgx11WbJ
yelSyVXbLwmlNEpRiFQfWWen0A9srN92sRa7vtaPKy6u9nn8cffMfOc733nm
+T7P8/m836/3DwGhvL2TWSyW4Mvz9X3t6tehAhYd26SflcaRKlDXbnohySnC
d3dC5ZKFKih6kxf7u385ckscdojvdUFl3pUr9vNrkL9AxX05rQtKCi1kRivr
sd/AYHmhtxLmvjYLPCVtQXevqMTy253gGmgVdFUgx6ojNREDQx3Qen3qltmv
2jE0/RbvyNYO+K314NVvGjrRfaneNHlZO8R1+Z22fdSF7JuKZFduO3iqy37R
enSjyiFCmdWvgLq9DWfuP+/B8yOCoeBMBeQa1cQlf+xFn1VJESePKuAnjtSq
XF+DYkXCsLGXApxSgtv0uzToa/fXNm9XBbjcODBlOK0PHczqGWsXBYyql2yd
MYvB4GKZutZZAdOXYdA1PoPv9QUel7/MO24Tjb2LYHCmJGHzXlBA/w2PKEMR
gxy7r0MB1ySTrLNTGbRRcD5pzRTwyvjh03lfvlXrMgzTe+TAqZFmd19k0G6s
guV7Rw62BUvjhNEMRu4yPMNbJ4dZF5PW+vzMYPODprONxW1gkcyWjjkz6HPB
673AtA1unffUoDmD0QFNPdVrWyE7665Naksfro3eEhJ/ohl8pZlqx9g+fMQz
6ZaYN0JMqMECIbsPO4YvVPy4QQaThNmzzxZrMLHbzOHYuBTsmhPDA7Zr8FCx
V+Ub5ypwtmG5h3Sqsc7xz/QRkwpwCxhy2xKsxrB7YbUOuSXwbf7GoA+yXhyN
XN+nrs0GFVszeWRJL74T7W9z3iPCOeGuq/cH9GBeON/iVMMzdGFEuzP3deOi
4hdjrNTXyDrE42XZq/D5actA06hqLDr3fc7nSiWm6vQnwznfZcWJFnViu0Vj
8HRhC5aYbCws3d6O4mG8KYmRI59l3X/aT47j/APLeEYd6CNyEyXwWzGttMk5
Y7cSwxaGp0niGzGzgNHmH1bhk+PilJD4OlxYurNMxuvByBR31rHiGjSQfGRz
RnuxOr56aI/Te7wbyy3c9asGBzi2VQk2FXjpttH8lLI+zPsgvi6+WIblb2ZM
zhYwmLTyjiTk6Uucm+Oi+WOcQdfNQW3CFUW4s4krMj3cj5bW+StGfXKx1/3Z
Y5vmfrR9Yp/MTc7Cs6sG92xw0OI+f7PclNp0nBXmoU2K1SI/it8w6HQddxUd
XOMo1qLlSVV9hMd55Pvxj5gPanHcqKRgelgc+lonPpxtOoDpw5FOj2YK0Erq
b7V48QCa5CifHuUEok5+dgP4z+i8BzFvi56x6fwg6uZhYv36T7r1sJX+n2us
+z/40f29/9DtDxPnexytOx8k0PNP2q07P6jp/bT5uvuBN71/CLk/WNH6bCb1
gYn6JZP6gYjWt4zUFzJo/fXsdPUHQ9qft6Q/sJj27yjpHzyg/c0j/YVU2n8B
6T8MUn0EEX1AJdXPJqIfGKP6KiD6gnNUf/OI/iCT6vMF0Sfso/odOajTLyyh
+t5A9A2cS0T/lkT/YB5F/NFF/AHHqX/0iH9AbzXx13riLxBS/zkR/8Fl6k9b
4k9oof6dQvwLT6i/hcTfsIP6n0/8DycoH+4TPoA/5Uca4QfI/ssXiKH8MSf8
ATfKp0WET6Ck/FpO+AVLKd8khG/gRPknIvwDNuWjhvAR/sdP2E/5Oo3wFVZS
/o4Q/oI/5fMawmcopPzeSPgNnpTvLoTvcJPy/x7hPzTQfGgn+QD2ND9cSX6A
N80XIckXCKf5E0vyB+poPtWTfAIeza81JL/gb5pvU0m+gQfNv3KSf+BG81E/
X5ePUEXz8xTJT/Ck+dpK8hUm8ncso9Rie3yV47+8Ex/I
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlWlQU1cYhkFLU5FqLVIUFyotBXQqalGB0X6aDopLJaKggKYjFbAUpHUQ
BRQUtQ6LgGIAbVywjiKLioIIYj4iUhYhDY4xEoITEhINJJAbMlAHi7U5Jz/o
ncnkx5177znne9/nmRceFxgxwcrKKvH977//SPOlASt69X3kcmPDYg3k3tY1
zFQLMYz1NPQeXw1zZgsVW7M6MCXvzBP3x71Q5T38oCajE+19/OuvtqhgRfXk
Xb4RCoyp3PvBqTYlbN1ufSizSIU3bbvybdQ9sDu2+khIigbL7sTGeXzRA5L6
7++unqjFpxvTFi/IVcBY00LHZO9+1NhxB4Y9FfCMwSW7XPXIb3cLKJ+gAN0i
DnvkrwEMbKqTN9soIFu7Spww14C+xxPjGS8FFEYfbBqsNmClaDg/N0MB9cw+
vXgpg3OZvm99rHqga7iyae05Btv3pzYz2T3Acso8EKli8LLEwSHaUwnbpZc8
wMGIyvXuRV/KlNA5GJD0xtOIO7vZzfknVcBkJa1Rehmx1Lisgb2oF/bFBB9O
cDVim/nqhRWFMYd/mmjEE/1KJ7tgNWSeWxBzXczgraoAuWOjGubLFZItOQxe
2pw1k2OvgSI57+Hj1QymNjW6hPtq4OLaZsekPgNau9bN9vfSQEyLe/y0LAPu
5XHZ342qIUIbtGWphwFPDbCuiNPV8IN/TuaU9EGc6OD2e6GsF4KOZLz8UDiA
3DJddOhrFaTlbXhwb0yP93aucpaWv5+H14yzGX56nJ7L+6zBtQdiFZz+AwU6
3D/rvmMh7yUMHRvIDTL1o4STefG8pwymcjsu2IT04+ZNRxMefCIB2YWjj+IF
fejYffmgOkoE3c3OnNwZfbhH8E9osLcQ3rF87AqCtJisLQ67XcyD0EnRfnzu
a4w7/rHYVFyDnVNCdp9yeoU28ZOkK1VtyA4qKGmOV2OMOX/PUb5HKnGJVGHr
Noz829CN8zz4PmmjCmwLFtcXRCkx3Zp51VgsR5EsbtPeX9U43NktSlkixfJi
1rZax9d4pCg0uEbRgXf788N/i+xDl0eJHHt5C76omBX4Y6wOO4XurFgrIdqH
3RUM+w7gFe3src4372BWKHfliGwQc1JGlgckF2CKKHFCd4kBy75W6t0fnoYy
B6/l7O0McltTVa3XikFa8+yPaSMMvnlb4VHNVMDljWJW40kjWl9fcqwxoQou
clP5i2yHUPCiMun89GpY03B1leDwEG6QGvzcrKshqv2Ckd8zhPNtXZdx9lfB
GZF+lsbLhO9GD87ZXHYH/DaF7qxNMGFCFLug4M9yOLZuXeC2ayaMnbnMXlRx
FZwG7eLcGkzoWVu5/vE3PGg358+Eb3PfnW7/XFBnuf/0vvk+HqfPC2eYn8c1
9P0HIs3vx7P0+6Xk+2hZ31dkfWhZP4+sHy37yyP7wyK6/8pr5v2jhJ7PbnI+
WE7PL73FfH6YSs/3xkLz+WI2PX9ncv7gQOfTSOYDcjq/bjI/eEjn+0poni/c
pPNPJvMHIc2Hk8ycD3hC85ND8gN1NF9uJF+wg+avh+QPptJ8rib5BBnNbwfJ
L2hovkNIvmEHzf8YyT+waT+6SD8gmPZHSvoDrbRfk0m/IJv2b5D0D5xpP/eQ
fkIt7W8g6S+E036nkn7DZNp/f9J/yBvPB/iF8iOc8AOmUL5EEb5AGuUPn/AH
Siif+IRPUEr5tYDwCzIo3zII36CL8s+b8A9ujecj/Ez5qSf8BB3l63PCV7g0
nr/wPz6DO+V3J+E31I3nO8B4/oM/9cNp4gcopf7QEH+Alvqlk/gFuqh/Rol/
oIT6SU78BOXUXxHEX2DxWxjxG9hS/3GI/+AQ9WMr8SNwqT/tiD/B4lcB8StY
/Dv2qc7Xzke84l/Hpx3q
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVln1M1WUYhpmAzlZkcwWpIWITEw5yOKUIyAOxSIrGMClnG58hY2uBqWi1
JbFo2gxQUHOxZpvklmCpbTRCHkiLD8HMlL4cQeABzjmtglqCf1T2Xm8bZ2O/
7ffxvs9z39d7PywrKN1YNMfPz+/9f/9uX/v7bv984scvMsZxvvKCTxYcGMpu
SjuteaM1nrgmn2hfysEDqzr1647x6iNVPtl7/MN5ia/26KET/q7wp33yUNPR
tKn2yzp3m7vLHeyT+/Ylnny75qpuP7yx8cFvvfLi6+FZYxHfadHRnaem67zi
e/aNzc2VP6ozY17d0iyvbB25NX6wYVB7y/I/PrfAKyHPzAwGtg5py2lfReZV
j7iawzftCfhZMxalvtfQ4JHJC8vd66NHtDyyNKS9xCO93Y2NSXGjGvN70UBU
gkeS3UHFPyy/ofELj2Veu9sjQRVbPj8zeUNjr/d0OdwTUtv864bjH7g1dk/x
/KfaJqS/cNc7bSlj+vz1RzL8aidE9qd7Y78c0+l1Jbt/ypmQRRFVnvw143qu
MSE7d8WErB4ob+2sH9fVK7VseGRcos1Vo819aTfv6TLznfxm1tEks64UmX30
K7OvxJg69C1Tl6w1depCU7esMX1oqulLok2fet70La8ZHfQvo4ukG5002ugm
rUZHDTO6SpfRWQuN7hJrfNBfjC+CT1pufJOXjI8abHyVQOOzrjS+CxxoveFC
LhtOdMBwI3Ck3tr/uBI407KPqnMqvjnRBoc6B+7s82G4y+X7Yri7wvoOuKtn
/1C4C6C+HLjbQf2jcFdMf8/B3cP0vwTu4FCdcPcp+k3B3ZPo+wXcvYL+ljsn
/twBd0n49z93+HsJ7pz4vx7uLB+L4e4m/DjgTuHLAXcxXFu57+K9Sb4LY508
1k1lH7uvrSOKug5T56PUPZc+VtHXBvq03HWgwxPo8ic6nUG3eHTsRtdQdI5B
91J8sL548clytx0f78TX6b3G5zp8T4ED8km3wUk+3JyFI8tVCJxZ7gyHLYkO
nl+DU8tdLxzb9ffBueUuhnMwn/oCOSfl1F/IOSqhv+85Z5a7XM5hH/rcyzk9
hX7JnOM09L3FOa9E/xZyIAJ/MsmJRPyDQ3HhbzU548D/K+RQMXwkkFMz8EP+
ySfwFUfOrYC7teRgLNx9Rk4uhbspcjQZ7uBQFO6SyOFDcBdNTt8Dd3HkeDrc
Ocj5frizc2AM7jYxJxxw184ceWD2+ZYX4M7OIf/Nhrs85lQp3MGhZJAvf5eZ
OSdwB4cyBHf9zMkdcFfIHL0L7qKYs/X+3rRjg52Jdg4Pw519ngN3BXzfA3eX
WH/mpOHuXfZPhjtbX+Hs/JabcFdAf3mz81+C4e4i+kTAXQf6DcNdNvp2wd1u
9LfzifyT++HOiX81cGfn8DDcheE/+Sdb4SMI7gLiDT/r4O4sfEXBnZNrG/ed
vPcH3IWyTinrutjHxb4XqSOeut6kzseoO4A+mLvyOH3uou8+dLD/nzAnpBvd
QtHR6roYnSPRvQoftuDLEsOhvIxvWfjIXBMHPu/H953kTzdcZDQaTsgvYY4K
+SbVcGa5M/nX1fYP8U2Aeg==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlX1M1WUYho+0ZhiyimhsCI1JOUtMiMIx7CkLlpIEHkD7mBaSuUCi2cZg
TghRxEAq/xC0OWsRsJkQgljQHhIZX1FAkJTkQlvnHM6WfVCJIwl7r/cPznb2
234f7/s893299xOW8frGV3wcDscHc/+b16PVN38ecfA7XbMwP+SAR7LeHMi4
cutnWvz3X2ty0z2ybuXu08VtPXr82EjcKj+PdG1L/tYZPayzntARn2a3dKcn
DmefvKDOvtsSs59zy6nl44GulnF92ZVX71jolutBUdFhH/2kt1dEjD3R5ZLN
zqaxrY2XNaXv7Uv3H3VJQptzOqroZ927+JFfg8tcEtMf6xcd+It2Tcy64g+7
pGPbH0dK33DpeFRB5kSrS84+9sLliiNuLQ0PzqqZckl/fFWtlnn07O6AdaEJ
brkz9vfQ2vWTOnYuJGem1i31QQ397vFJzZ86fMumQI8Mlq5OdT7p1WgtL74y
169jPKP1tyKv5u0IuLr037l+mxLyA6u9GuVd8GhF9qQEB3dNZFV6NSz786GP
hyYlbVfz5uuverXy7tmC8GVeOWSummruy1Lznoaa7+RBs46uNetKgdlHr138
f1+JM3XoqKlL8kyd2mjqlhHTh95j+pIW06cOmL5ln9FBW40ucsnopOeNbtJh
dNRYo6sUGZ31GaO7JBkfNNn4IncYn/Sa8U0yjY/aZHyVjcZnHTS+yw3DgfYa
LuSY4URTDDcCR7rTcCVwpqMje3K7I2ra4VCT4K6J52vhzn7fCXdwqD1wB4da
D3e2vj/hztbvhDt/+nsa7pLp33IHh1Y//RL9muEODvUruNuP/v5w14o/dXB3
Ef+G4c76O2P8txyqwN0e+FgCd6vgx3J3L3xVwN27XMO57+S9lXwHh1rCunHs
s4Z9/6EOW9cQdX5H3Q30cYa+7qLPQ/TdjQ5D6NKBTla3TnQsRdeH0TkV3Z/C
h0X4sgWfXsK3GXxMxdcGfLbcfQ0HJ+DiFJwUwk0hHDXCVQ+cWe4Mhy1xn/K8
HE7f4vsVcPw+6w/D+Qz7X+AcpFPfCc6J5W6Kc+RHf3Aolrv1nEN7LuFQvkC/
Hs7xGPqSf1IyX39pxJ8gcuJH/KshRwrxt4+cicF/OJQc+NhATsXATxA5tgS+
0sm5/XBXRQ5uhbsgcjIE7h4iR51wt4Oc9SF3I8lhm8s2p9vgrp8cD4A7m/Nd
cFfBHDgHd6N2TsDdIHMkCu4OMGdS4G4Dc+h5uPNlTk3D3Rbm2Em4s3Ouf37+
yDTcVTMnA+CuhDm6aX6+SZ/va9/k1A3Z/JNIuGvm+Y0Iw539/ircVbF+B9w5
Js3+H8JdGvVZ7jKoPw3u7BxOhLtn6X8F3B1En0a4G0K/drj7Hn174W4v+i+G
uzb8aYa7Qfwbg7tc/PU1/ssy/E+Cu53wsQjuHoef7XDnD1/lcPce1/u4n8R7
kXxHjso+1l3NPsK+U/B/kLo6qfMH6v6EPo7T1wP0+Q59n0eHfnQZQCer2xl0
LEPXSHSOR/cX8WEBvmzHp1x8m8BHy10dPlvfe+GgEi6WZxpOiuBGyK8WuCra
ZTiz3Jn862r/D2tte74=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVln1MlWUYxhEUkJPIR9DCFmCu9YeFQgkS62bYan5UwIJcJWMQSqxslqzM
DGbEnFErCuVDDn5BVqBpiRTYDWq1MrFNkSmIBefwoXCOaUJRVtbze9vO2c7e
7X3P+zz3fV2/57pPdM4L6XneXl5eO258/72u/O8zKF58ttlST/wgg9J768sN
D7S2a/Vn3om1XU5Z8fM7IbOf/VFj5zdmFCQ7JcB399UUR7cebGiZkmV3SHpk
YF1LY59+tSXC4QpwSFCpI8/v6X4NiHON7K8ekDeeH/9j7jSn5nWErf74yQG5
NvT2svHMIe2d6MlenjYgcvLDXeFPjGhfxeFH7i8ekKvPDE/fGnBJK25f912s
c0A+SK60FxWOambTJwvK1zuksK0q5kr1mD4cU+w/muSU6aXdvi9tcOldx+4r
qY8elM99561JinRrUPWZ5tzoIfE/3ZZdttGtp0ou5GbFDcvX56eUOj9y66cv
+jbseHRE6nLGglMq3WqPj+5cVHBRikPsrySkuTVlpON4+YZLck/D4pzQsy7t
nlXiTCwelZkFqbF997r0Fy95c1XBmFw2Vw009+Ws+Z3Gm/ckwayjrCvbzT5a
Y/aVg6YO/cbUJV2mTrWZuoU+tNn0JbNNnxpg+palRgdda3SR5UYnfd/oJluM
jvqb0VV6jc76oNFduo0POml8kVzjkxYZ3yTI+KhhxldpNT5rhvFd4ED9DBcS
ZzjRlYYbgSPtN1wJnGni5OqNgZt2tsGhdsFdLc/z4W4r79vgbj7rp8JdM/sH
w91h6lsPdzOofxzu4FCT4a6H/tHH4lCr4K4M/dbBXRr6+sPdYvRvhLu78ccH
7m7Bv+NwdwJ/t8NdE/6/Bne74WMB3Fn8hMPdafhyw90Vrtb9MH63kPesdXay
bhH7HGJfONRO6rLqjKLu66dMH7H0tYc+H6fvqejwGLpY53MzutWi4zl0/Qud
z6E7HP7vCxyqDd+s/GjH13B8PoDvWXAQDxeuaYaTKrjJgSM7XO2HM4s7w+GB
JOv5UTi1uEuH43msfxOcW9zDoRylvkDOyUzqh0NZRX9uzlk//ZN/8hP6THBO
y9GvgnO8FH1f5Zxb3PmQA5H400pOWNz9bfyTb/H3JDlD/in5J9XwUUJOkX9K
/kkPfNnIuSG4myQHQ+HuDDl5J9wtIUc3w105OVsPd3vI4Ta4u0BO+3F+gslx
63wlkPMz4O4h5oB1PjOYE+VwV8McuQ53PcyZRZ7nX3yGDXdPMafK4M6bORYF
d4eYc9me+SO3eeaTLIG7bcxRvwiPfJOo936/2DHYaeWfXIO7Gp4nw531fgjc
WXM4H+72sn8E3LVQ33NwdzP1/wl3K+gvCe766N/i7jz6lMFdHfqt8ZwvN+a8
4S4R/ffB3Vz8CWV+2fDvCNxZc7gJ7uz4/y7cbYKPO+AuHX5mwd338DUGd79y
dXDfm9/F8F4K69SzLjkrrexbRR2XqWsvdc6hbvJPIuirnT4z6dsbHRaiSxk6
fYFur6PjiOf/GzmG7hn4kI8vE/g0Fd/ewscv8RUOZR++r4WDSLgohJNKz/9v
Qr6Jj+FQLO5M/h1p+wcPr1K4
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[700]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.87889043240206*^9, 3.878890508541912*^9, 
  3.8788905980356693`*^9, 3.878892287735721*^9, 3.878892583872707*^9, 
  3.8909814660710993`*^9, 3.8909815812222223`*^9},
 CellLabel->"Out[30]=",ExpressionUUID->"3b3722d9-4529-4a94-9511-b6b7753dee70"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 3:1 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{3.878890738090901*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"cc888054-f7e5-41b7-97c8-2d1c1be626e8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint11b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint12b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint13b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint14b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878890663927032*^9, 3.87889070005171*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"5b0d420e-1577-4e6b-b206-b03328920e29"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811581947954173*^9, 3.8115819505564413`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4cfaf97a-ef86-4f2f-9973-25f1ac1d86fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint11b", ",", "pint12b", ",", "pint13b", ",", "pint14b"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878890761383698*^9, 3.8788907902198267`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"81467876-6135-43d2-8635-22c074df4440"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXlQk1cUxUNBWeqCSl07UlCmGkBQFLRSbhhHpQoo4lAUqSOLIssoTequ
CHUUrChCKUER3ArWhaoEkELmgg0NWJAlpBDBQCJLAtmjgrVgK++lM76Zb74/
3rzt3nN+xyFi35bojxgMxuH/vvf/xob3QwUMOlq5NobsDBUsK2XasJyqkcNN
dp0oHYIHooS4kNEmVA9fzl5QOQizPaeL5QXteM/48LXfUiWMBRypDflLimEx
NZy1/gPQ8ty7QPq7HE+47bCOmNMHtV8bRJbNfejEu5rMLpTD/UPuUfxUBWoD
zVfZmfXAyJYlTX3KQZwzuiLeKf4ZrOt85/6HXoU1c2TbXa63wabnHN7Jqxr8
pdd3Ul1iIwiFwunZw1p0goxpB0/VwL4v69eUH9Nhg0xyNja+ENgSY1RKmw75
GR6tmupbWDC7oqTOQo85ntucvhPW4AtW1ecuU/WofQgsnNWInR5p6axXOuT1
uXBjrdrwk81bHZIe6VDI/5S5aIsEb6avaYTtOrR9udcmJUKKZmb20oRyLebl
vh8y1Khdc9VHNTiyeuMas+4X2FUeul5hrsYRKy+R71gfXq6uM5sXNIQLJwy8
0RgHsCI0IZkZrUT3pD3WAVVKbIo8yK3yHcCjodNOrg4eQkPehbM5il5U/bZ5
50KeCn0dFS3CMDmWLS436CVqPO6TVJq7uhvF7Nx9k1GDj7dxXuVGSnDFAniw
N1yL5SWajKteIiyZ5ueaX6zFe2eaQ8xP1WNUdGr7zLtaTO1oWBYDj/AGK/le
+CYtWmzyeb3/aRpwlo4cT87U4H2+5EHMDIR1a09nXdqvRseEAXHPgUZYGdj/
c0z/ENaV8Rek/yQG92yjeNSgxHybxbIgry5Y7Oyfuos7gAIHRcgOHxnEBrfC
lK5efHZesfxHx16I4lgZmUIZnjTsPv/Fo35oGddfF0bfSfGy0itA5WcxJs4U
Y12BPuNszSC42fHLui0bsN5c0KR0UIHf7hOxtjMrUOSdWBMwRQ1adzvFZU8u
BNwNCm47rYZvc7IE52Ieg1fFvKVOF9Rw2HmrXWJxM9h6xFtXu6rhyt/FI/M6
2iHqftwRZpwKwl+8VWTmSWG5v2WWfdAQdO9OcLA4IIeVrEKmRKmE5lPt786E
90FkZbU0CRQw6faS4mGGAowJm58IwvrBPGrFHW34IIwGdJy7tr4X8n6w3uDM
VkHRjEVar4/l8NLI9vdgacB6vp1zVlg3zC/cUz+7VgtF9S1pyXHPYLi0Mn5+
sg6eWnpOSAsSA6NqzHH6PzroOH8gpWhWM2hLHF/eDtZDZeybiMz0Whiby1ro
kKqHwK+WlbnklcKlcf3p6b/G2zS/i8yjaX0tWY+m/dvI/viant9Jzkd7er+b
5H5ouv9Ecn+8Rt9XQN6HFvT9b8n7cTKtj4HUB9tp/XaQ+mEXre8qUl9MpPV3
I/XHW7Q/kaQ/mEP7N5X0D9m0vytJf/FX2v9A0n+8SPXRSvSBG6l+hEQ/2E31
9YToC4VUfzFEf/gN1edpok8MpfpVEv3iIqrvWqJvXEL1X0T0j57UH63EH2jy
z1ziH2RTf/GJv/Am9V/GhnH//e/Pw8Sf8JD6t5T4F7yov+8Qf4OI+p9H/A8l
lA+ZhA8wRPnhQ/gBxyhfdIQvsJzy50/CH2BSPvEIn8DEr3zCL9BQvskJ34BL
+acj/IMZlI8MwkcQUX7eIPyEi5SvMwlfQUD5+5zwF/Ipn+WEzzD2Ib9hZw/h
O4fwHdwo//cT/oOM5oOA5AM0fZgfYEvzZQPJF9DR/HlD8gc+o/nEI/kE39P8
QpJfEEzzrYfkG9yg+WcfOJ5/IKP5GEryEQ7R/Ewj+QmmfF1H8hVM+TvqfeWj
650C738B2e8j6w==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXtUk2Ucx7nIBGTpKi9NMdCNBAWCSVzrZ4IKx8oJHG6mx1CJS4ZQinRA
NLxkgaIIAoYheRBEDTETL4efOJlsCiq3AmKObYyNsbGLqFyy0ufhD95zdvbH
e973fZ7f8/1+Po6xyaHbLMzMzNL//736Lyl+danBjF4MPGV7e5UaDuUXsaa5
CHCks7A5gq8CL/d9nS+etGIOyzpgi1gJzrVvwuWyHpzY+/sf8EAB3nUHlt1q
60Oh9UhaZIoMok4cXHgyqR9PrvzSx6LqCdhFbm+4eUyFu5mMjhXzu6H88fLo
xNUarN25L87+i3ZwM7isdzqixQdWE2uFvGZgXE063Jk8jFf8Ku4l3mgAccsc
i5p0PcqiWTyurAraOPktG2YZcN28dIcPBs5gnCjBryrLgLskrltH5tVj8H7m
1SGxARMCTS6feomwJJDPnTZiwDMJCybc0h7jntY4YZiZEWGsrHozuxM/y8hJ
F+sMeG7OjQv12d3olMrqUjcYkPd+03DMFQkWPpve/vA7AzYLVkowvA/DjnsX
rmAb0Iv36pJj0T1zbk2ZHjefyWOOP1XgItmLg2vf0KP9MtcAQbES+S4cD0uh
DieURe8+dlChvzCvZ+6HWvTBnO/lP6hxvCf2mn6vBs3Zp8tmPhrE49+MzorP
U6Nm6G50iUmDgZ6ViZ6JA+iuzmA2Dw/hOwdCmiyY/VjKY6YKUYuDaQWsW2ky
FFkzIGSjDkNymZmJYU/QPKPGPve2DpXP8h+4re5C/28Dy9hSHVqHY95NcSs6
7jpxoaFGh/tPZYj/eXgPBeel7gKuDk9tts/0OF+LQZtceKEeWsxqsK9cc78C
XJ7pvy5u1GCLz8MOhl0jpI53RCZ3qvF8jCl5kWcrKEUhSXc2DOAa97pZC6q6
YPXyrTnp4QoU4edRKRFSmB1ebjVTJMWKj+M/uZYph9LX+etCR9uLBwuWKsHY
YbSJHX2E2XEtfJ9gFRTMLrAZlCBuiSwVbBeqwW+Gt6p/6XG4vqP/nPLsIOjU
B/bXL7kLuduytjYPDcK17ufa7MpWOBY71lZ0aRCU6VrX8uvdwOUN++94qYbp
Zzc2LprXB7ncY84cgwqCb4aNeu5VAF/8k8SpZADupwYxnfMH4KWtXcNuWyVE
aIVJxvWD4FguLw3mK2CxqV3jhENgmf3LJos0GXAa3273leigj/3RlsJDUsgK
Ne/dGa2HccavgRdZvSCTrGjd5WAAeZUeq//9CxLeizja1miAztjK53uk7bDk
tNuQzVoj+Pt+lRZ8/RFwRsf8oi4bwXt3cMwwWwTzy61j6kaNkDTjt56U+ttQ
VKve2csxgb+lxsTHGngdP56J/gsCiun9peQ+sunzh8nzyKXvtyfvR2f6fR/y
fYyn65OT9aGcrl9K1o/76P4MZH/oTPf/N9k/cuh8GGQ+GEnn50Dmh010vuYz
Xs8XV9H5h5L541v0fA6T80Ht1PPDNnq+R8n5Yhs9/yPk/PGpDclHHckHLqb5
iSP5wV6ar0MkX3iC5o9D8odzaD7PknyiF81vN8kvami+fUm+MYXmv5rkHyf7
IST9wJW0P0WkP3iH9ktM+gUOtH+5pH/gQ/tpR/oJlrS/PaS/0ET77Uv6DT/T
/itI/8GV8oFN+AAqyo8gwg+wonzJIXwBP8qfMcIfMFE+BRE+AZvyK4rwC+Ip
3xYSvoEH5V8J4R/8SfnIJ3wEb8rPAsJPKJ3KV/Cg/F1H+AuXKJ8zCZ+hkfK7
mPAbTJTvawjfIXLuFP6DP/VDO/ED9FJ/3Cf+AAX1ixXxC1RQ//CIfyBjqp+g
mvrLnPgLRNRv4cRvMOk/P+I/yKB+3E78CBPUnyziT7Cifs0jfoVJ/748d3dh
5I93Av4DrtcPkw==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlX00lFkcx8WOslGnPaeO3ZWWpToqvayzRNNvmvRCnRG9sbNSKdJhFYmm
kNJWejlWFLKJXqiIOlto6ScRqamM15ga88KEZzDTRHRiy73zx+w95znPec49
97n3/n7f7+drtT3Ua6ehgYHBgS/P13fA2OgEAzomsu6bJKk64CRXkm0X/wQt
0tKP/n1OAWsTL5b4fWzE6PGeca5HZXB6QNJ9sESCH0XehecVEsivZk0qmqnA
Q2X/JBTPagXD6gJbWb0Sx8mkw4+tG6BHUDTbiulG130RafNtnkNQ/Ez+3BgV
8rwq/A3Y5RD92a0vJ70Pp17pv7d/0hXwXigrfJDbj0VPY+W113Mxb6qDI9db
jXfOOp5YfbAcP+3furdMqkb3Ue5Hhzm1aGMmyZK5abBNGWDSm1GHsmJb16Bk
DT757FRQ19iIUwK3V8+r1GCmcyun8PFrvK8aZda3afD4+1MHr+5+gyvWDvfs
+PIdf/hhzpnAdgy1mJO8q0qDzwzLbtUMS1HJ9s0YStOgx/GfBAv2ytHqfFT2
Rh8Nvnr+dSjQJTU4OshIg/O6GgJCJneihXjgUOsFNfImH2ZfcFbiC7vM2WbT
1GjgneQb6vEOoz5nT7CL7sd7YcbXs3hdeHG7ago3tQ/9wlJclzl1Y7ynLcfb
qBebjKuOXZ7YgwduRjhddWLQnxszfnp1D44TWtY0OnQjc431SBzI4PIJ7C08
rRLfdds+iexicKTuhpgd3oFeDubJCStU+MCXM6M5X4bv1i7/xj5chVGBIyE+
yyQo8k8t3RSgQreJYovMpBY0a0lYbjdZhW0NyvW3eHXIifP3DfdhMDeYF6ke
rECT3tgzKXN7MK/m5o9x9UkYzvpwvyS4C/nXYv/9ob0MstzlzKaRTpyWVc3q
+uUVCBSnrrkI5Xjb0s/qQk4LPKz7bfrxfAnWJ25dMzS3HYLG9NeE4l3NjdYB
cqjfY80s5tfgvm3mWqMXHcBLbnrk8jwVozdHh3zyUEKyqdttN+YRNDxbH3V3
QAkDjn+VibUi4JdG7HwgU8JZyzWJYQvFUL5HZLGSrQSnRI3flNUyqJDIa23s
O2FUMM/X0viL3tMX3WlqUgC8zLkybXMXiAfbtnp7yqGUq0hdyWXgg33VzZpC
KfQtWMcdfNkLKcJZHvmG7eCu/F5rE98PSkd7U8FlMbxZdGp0wwE1mNkYPlMt
fQ22bebGte4aOOfmc3hI2QitFYW3XT9pwGfVpbw/MkXwelXcXdMz7yFh1u7A
pcIXsPjXTvXQOC1kNFuYzxDUACc490gMXwsFg5zftcsqwOzkJW1BuhY2LJS6
VC8tBnaxoJ9XroVQjmPhjvm5IBzTn5a+K5fo5jPIPE6i64PJetT9v4T8H53p
/ilkf2yh58sl50Pd+TeS8+NMer8/yf1QQu9vSO6PK2l9hkh9sJ/WL43UDytp
fRlSX1xB699C6o+6/rBIf9CF9q+S9A9v0f4+JP3FD/r9x436+sAjVD8xRD/4
P33hNqq/t0R/eIPq8y3RJwZR/QqJfjGT6tuc6BvDqP5jif7xW+qPx0/H/AFs
6p8k4h8wpf5C4i+oo/7bQvwHCurP08Sf4En9W0r8C3LqbyPRmL9B539n4n/Q
8YFF+AAiyo9Iwg/gU74cI3yBu5Q/GYQ/oONTJOETrKP8EhJ+gZ0+36CW8m8J
4R946fMRRJSfHYSfIKB83Uv4CnH6/IVEyuciwmeo0uc3NFO+ywnfgUv5b0v4
D2/08wHO0fzIJ/kBEdkkX/gkX8CT5k8syR/4meZTKMknGJaS/GJIfkEIzTcz
km8gpflXSvIP9tF8zCP5CNY0PxeQ/AQTmq9VJF9Bl78j3zHOpovLl/wHoPUq
qw==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXs01GkYxzXtqClUWzrddNGKs9WxtYkyeaSGxTanISnZXSVDKpfStkNR
1KSt2C7akd1SUS0dNeGM1vI0coRcE2UthpkwM6Ux4xIlW97XH/Oe8zu/P97z
3p7n+/18F+0K9QhgGBgYCD59n//fjg45GNBxyauPWRLdDm4Grspkbjl+8SQ0
Ou6cDASXLrTd2NiI/LnVw+L4JrDy6Ftv1tqGkglr/VeZ1kPnJONqP/sOZKUc
TWXmVEDCEVnuuQolFqS/zH7ZVAgx86doK7JfY7ooqnZg9mWw37L+485pb3FN
5ojg1LIHWMIUJlsc02B8Y4iDz8RixK0WjHq3HjzuJGSITapwIMvYqlDTg1Zx
8WcP/l6HSwUfk6oOa7GoOKp48OEL7B3K2LpNocUdvKg06aEm1CbNvBa+Rofd
ymEZ+1kL4pYtIgeBDjfsEGlPqmX4HStk2Cpdhyua9/wo47RjFC/yLKtQh3Kz
j+4tUXJMnbo/w7lYhyVPh6qMzytQaj3zuUqiw9Mr0yrr4l9hZMPGshyRDvfw
P48O/C/oRb05X4eJO+0KS5Z1om1P7qrIBTp0lbh15LV0YsH4Kvunj7Vodmxa
Ul50F76OcS3V8rR4X/KNk9JEibuFd+yTS3twyMSxcuQ3JZ5K/WGj9ZIenLVz
jtViQxX+OhSX0RWkQTtu/75HISrkrNusDjZ7i74uEcs3lavQsP/IVxFfv8Hu
mpQAzUw1Lh+fk56oUyH35lHDCTw1rsusdxAf6MJtEG0XcUCN0w/3Wlpef4UQ
KAu8Ha5Gx669nIrD7WgU9aGQ7ajGWlu+3Ly1GcfNH/FYUKbCvwLCGaHMBtzF
yCpa3a3EQH/RufiCcpzD6mpbLuxCv/xU+1nl9zDQW1G21bcDPd19hBqFBEx9
LZYV2cox+Gi+J4dVA2cs+SOa9ma8XiCotj3UCDaj+qtD0ZNxFvdTZfDc5MuV
+4L/Qfn8KbucuHJwunN3fx8vF/on3p7Te0sBey4OJr23roVLKY888psUIJx0
2c9yoAlWjHi4o4MC/kxJ8LGRtkO2f+SFpWaf1rNOsNPedEDG3oYwU3EbuF4N
M9ifqILtdglnaxbJ4LrvQm87yRu44uzYNDy1GVqHjHZz1mrg2b67eUxlI7xL
Try5PbgHfgo4Y365ueHTfhpTr3AtuLecN5r7rg7aZjROSPfUQd6IeJqAXQsH
3idfq5nRCwl/H3Rv86oEw8zvK1IlvfCoNjbkXmwpzLN53erk0AemznGllQOP
IcxtU83ujD7wE88zZnojMKpPhbkP98G2yWvMHSwkEC+94SO37YfuGCZLF5cF
Rm7dnEqffkjkPVyczr0Ko/Lj99N/CXsyne8h8yik6y2Pj67HcXT/DWR/HDv/
F3I+zqX3syX3w7H7V5L7YwR9XwR5H8rp+zPJ+3EDrY8LqQ8O0vrxSf1QRuv7
L6kvptH6i0j9kUf74036g1zavzukf3ib9vcB6S+e1O8/+lF9XCT6wFyqnwGi
H7xF9fWK6Autqf6uEP3hIarPbKJPZFD9/kH0i0FU37OJvnE21b8p0T+M+SOU
+ANGzIh/coh/YBL1l5T4C9jUf+7Ef+BJ/TmL+BM2U//aE/+CWt/f4K3vf7Ch
fHAmfIDplB+nCT9gmPIllvAFHlD++BP+wELKp07CJ3Ch/ELCL7iozzfwp/xr
IfyDM/p8hDLKzyLCT1BRvl4lfIWFlL8xhL/AoXx2IXyGIcpvKeE3eOnzHaop
/7WE/2Cunw+QQ/NjkOQHxNJ8KSL5AgMZJH9KSf6AVwrJp9Ukn8DuFsmvn0l+
gfQKybdrJN9ATPNPTfIPuDQf2SQfwZjmpyfJTzhP8zWI5CuM5e+H90uyYqvz
2f8DhbwPZA==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892288225878*^9, 3.878892584299583*^9, 
  3.890981466380118*^9, 3.890981581509617*^9},
 CellLabel->"Out[35]=",ExpressionUUID->"aad24e3a-522d-4a3c-bc5c-ad4765f5da43"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 5:3 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{
  3.878890738090901*^9, {3.878890872987176*^9, 3.878890874172051*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"08344d86-f6b4-4938-a7ce-fc1089c2fce2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint21b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint22b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint23b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint24b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878890663927032*^9, 3.87889070005171*^9}, {
  3.8788908287376347`*^9, 3.878890840017591*^9}, {3.878890878913526*^9, 
  3.8788909114941597`*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"09607696-4097-4c7b-847b-32a4cb1c2fd6"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811581947954173*^9, 3.8115819505564413`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"2a127684-36ac-4470-87ae-7e2aa4b2f180"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint21b", ",", "pint22b", ",", "pint23b", ",", "pint24b"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878890761383698*^9, 3.8788907902198267`*^9}, {
  3.878890843662445*^9, 3.8788908527671537`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"f27ddb17-7a8c-4348-824e-cff75ccd212f"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3s8lGkbx8ditSWHlhzafUsRHTdbKZKLDpSQ7Ep6WzkuahViSYc3RRLl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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3k41Wkbx70jbZKQFtHYRsqbadHG1I2JYUiShqKFtzQKZYkSUbYZxqBy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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3k41Gsbx6VyKkm06c2SUlE6XsRJ4ZYluSq0HNvRRFkKIW1aRLY6looU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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3s4lOkbx6kkKR0s1qkJ2QpFV4qovSlKTpUih2TlfCoV17WVqJFSW9ks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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892288704772*^9, 3.878892584783886*^9, 
  3.890981466791285*^9, 3.890981581874652*^9},
 CellLabel->"Out[40]=",ExpressionUUID->"e68e092c-81c8-4de3-94e7-f6bab8aa3f72"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 7:5 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{
  3.878890738090901*^9, {3.878890872987176*^9, 3.878890874172051*^9}, {
   3.878890992837061*^9, 3.878890995687373*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f505b51f-2069-471b-983b-692bfd0d7033"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint31b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint32b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint33b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint34b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878890663927032*^9, 3.87889070005171*^9}, {
  3.8788908287376347`*^9, 3.878890840017591*^9}, {3.878890878913526*^9, 
  3.8788909114941597`*^9}, {3.8788909624770603`*^9, 3.878890987662685*^9}},
 CellLabel->"In[41]:=",ExpressionUUID->"0ed723ed-a5b6-4b7a-900c-638928286d10"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811581947954173*^9, 3.8115819505564413`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"e9760832-b4d4-4852-898f-1dae1a36b331"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint31b", ",", "pint32b", ",", "pint33b", ",", "pint34b"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878890761383698*^9, 3.8788907902198267`*^9}, {
  3.878890843662445*^9, 3.8788908527671537`*^9}, {3.878891001627733*^9, 
  3.878891010477059*^9}},
 CellLabel->"In[45]:=",ExpressionUUID->"50f27d6d-1be9-4efe-bea1-943178c902a7"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk81OsXxyVSSrJE1iypFPVrU4mOokXUvVeyRKFSyS2SpVRSVxJaKYUk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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHkglOsXx8nWplyJSJSSyta+1ylELhWl20JlTUqlTckPSdxcl0hRSZKE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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmGkglGsbx211HEs4nFCylPQqqVRK0qVCK1FJnbIdkixRlBNKtGiVmKSF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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmGk81esWx1GmKCkloihKKUMZ0sFCJU2oqKQSRUUJUSd1KVO51amD0KSB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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892289274279*^9, 3.8788925853255367`*^9, 
  3.890981467214551*^9, 3.8909815823719683`*^9},
 CellLabel->"Out[45]=",ExpressionUUID->"540e98b6-2f31-43a9-b37c-2971c0e5ebd5"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 9:7 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{
  3.878890738090901*^9, {3.878890872987176*^9, 3.878890874172051*^9}, {
   3.878890992837061*^9, 3.878890995687373*^9}, {3.878891118432665*^9, 
   3.878891120217503*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"b8aa12d3-479b-465d-91e7-bd354be2ea1e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint41b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint42b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint43b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint44b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878890663927032*^9, 3.87889070005171*^9}, {
  3.8788908287376347`*^9, 3.878890840017591*^9}, {3.878890878913526*^9, 
  3.8788909114941597`*^9}, {3.8788909624770603`*^9, 3.878890987662685*^9}, {
  3.878891045188156*^9, 3.87889107302664*^9}},
 CellLabel->"In[46]:=",ExpressionUUID->"15b34f33-1641-453c-9ecc-fd44bab3923d"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811581947954173*^9, 3.8115819505564413`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"9b8ec011-f393-497a-90cd-6d1a3ec8f4a2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint41b", ",", "pint42b", ",", "pint43b", ",", "pint44b"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878890761383698*^9, 3.8788907902198267`*^9}, {
  3.878890843662445*^9, 3.8788908527671537`*^9}, {3.878891001627733*^9, 
  3.878891010477059*^9}, {3.8788910790280437`*^9, 3.878891092377975*^9}},
 CellLabel->"In[50]:=",ExpressionUUID->"9825b2bd-65cb-4684-b55e-fa9a61f8c46c"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHdcze0bx5GU0iAakpnGY0VEw3OVkYasQrJCJZKozCISDSKS9kDrh0e0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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk81Pkfxx1dWldqSadOtoMc3dl3KlLoUCqpVO5CheiXKFm1lSK0Hbo3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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHlczPkfx0ttOpSESMiVUKgctbX1Jlfs6kJUbFKrRYgKOda2YqWLaGVF
1pGS0uVW7xBFl+5rumea6ZhpZkrlym9/8/74Y+efHj3mMTPf7/fzfr+O59Rt
e51+GSYnJ7dDXk7u/3+3y17tIMdeZ/knlXYtb4dNPg2LCzbmoJzxOq+nfB6o
9HgW7Rz+Ds+G1l756M2DfSr6VfYbqnGx8EGAdisXxCauPNveBjzFaZlu7csF
/wNPiz52tuCBL2ODq/S54BORrP/+OBf9Uh4sKdPgwoLzKvKNz9qxPMbq3BNj
Llh9r9oTGi/AhLTF0bPDuLDzptjGZmknrl8yKX/6ZB7M2npbuv1sFx638x8y
aOFBk3m64c2/uvGNrnjoQ1E7jB59N3GhsxBfGw/qmHP4cD3w5hnzUiGmHvZ4
XjCsA9IbY5KGqYpwy/7o5UvNO+GEo/6STQoi/M5Knqfh1wVaHkKlf3KE+Gf0
5m3vErvhzRa1KOWVQlwdPFMaWC6EkFsKwnMx3agmmjglmC+CE59mzNLL7sI1
Ar8poxp7IGeineOerE700zuU/d0mMdQe2rZG/WoH9oNV8dUkMagHuBSt+FWA
NueTk435YniSUpw3TJ+Pg7d4m84rS2DvX2HKqQ08nJ83Z8J4DQncONcwMCaW
i9ffxyv80S+GiLm6aXN2tuGofcWVAzli0B2ssxA6tmJSv52vyEcM3LTixJlb
WtB/5M7ysX09EJp357hJdDN2GjvYDJSI4FqRgX3ysGb8OVUt56yPELbd9oiy
cG3C64e3zjfL74KlDlt+ylvYhIYZZt7azR2gfCEpVyO2CfcorOc13+NDgJG5
2TzbZhTE3CrjmPBAuWbkaUvFFmyu3GCW5d4Kk+pHcmcPtGB5m3Z01o5G8Bpq
MdHRaEOlgG3mcV7V0KV/yXTZPC7GjRRHZkSWgMPBCBdjcx42V3C09Scj3Dkf
PtZ2ZDs+L+4L8x3vjyFBK3/Zd6MdnV7/cljTLQcty6It3/W340dV9QWvtUvQ
NtnQ21WXj52Xx3TpWVchZ4lPfdQcPkZN/vHsfhMOom/ZxJVWfAwMOnjqQmoz
3jJIE73ezsdELYFXvqAVf5rotSImg49TN747Pe0VFyuk7m2KcwQ4cmai8Mnq
doy2O6S1rUCAy6Yu4+85zMe5a94NOkd34CvVGR/KXAWoOXzQVvRHJ9aaVFa6
igRYMHhbeVd4Fwbt9OyJMu9Ar82BVzrvdqOHd76Oi1UHXvTOmtRSI0Rbrck9
avId+J3z5heHlXtwft0rcfJpAeab108L0BHj8DE2A59q+WjySny74rYYhX9p
pR/81I7rp99T3mgoQT1T64PefTz8O1uf++M1CeYX/v/FRasYn2M7FKSoosiZ
sC68DdXTF+XXOUpxXu0uvhm0Yv2SWzarQ6S4K8yOO7e7GT+UiJxab0sx+ceT
vIM/NCE/0QY33pXib3URmqbIwUVFRo/qoqV456ilplpAHc5YubxQ00uKnClf
5y7fX4NPFK68lx8nxUOHMjRPva1C+djIvKEUCU5aWqZ39GwlRj6ou3bMSIIu
njOmuFVWYMWdV2+EkWJ0ui08YZNQgZ0rqzO+pvfgnw15a7eMrcSscd2R+aNE
aD+v8eSlGVVYfs2tUMWiGz2rUpRyqquxJkM0P9ygEz2zMs88MqhDzbx7+q3l
fDxvs2L8kFwDZmhWrOxczMPLz7hlX/WaMb7EzrrIthUdLRUulla3oFHHiMgG
tUb0W+38in+qDbfqNC3V6KjCfCel/KgRPEzSjFDRu1WM5mWVDlud2jE7INd5
7eJs7GxrnrpiHR8T3qQr2Kqsh4X9L5SGJgiw2eWwYMG0LOi6MiGDky3Aspvv
jfgPC+DvuO1aZzZ0YFgA6N5IK4di3omgVEkHen6Vb3qZXQN1n991y1/rxFmm
OvMtFBogRCMy1cW7C4f03xrOsWmGoLWzW7NWd+M4ztLBypst4LRw/IUzK4T4
ZMsSverkVvjqaiA46izC08HL/jnr0QZFRWlhoQd6UCnx09oLuW1wfb/KbFt7
MUYYGTpifRsIY0sWb28T45By4LbNd9tAIPpnQ4KfBI2dTp5c+kMb3CuIc531
WYJWDhFKvHOtkHzhyqIFgVI0bZzr+WtmC9SP+Ae8+FKc+cXP6VJSMzzOSZ/2
dFkvzngxI7P8ayM8VrBvvBvai2Ej13o99+dAR13GROOsXnSbpJmh9KYWdBsN
qnKrejEoYWvwAc1q0K1z0T5Y3Yu/z/Tg7XGvgDRfu2hOdi9uVW3Kufi2FKpX
BaWPCO/FBwY7va2LiqEl8aB5lE0vVmv1mHRGvoUWtdqJzs1S7H/+uXTEd3ng
clSw4A9vKeoH9zwVOeXCD0N1oa61Egyr36CdduUFSDKO9amZSfCmx6gvsUov
QPd2qsueIDHyIgZMzJNeQL5Eb3nAvh78rUgxSnAjF2yyhr/f/UiIESYG4mL5
fPh8+W1MfnkXTtOtH7G5oBCsfUW9kc86MHHQvuzPI6Wg1u29cfQOPtb/HHdV
3bQSPsvf8P6jmItuHTkm0l9rYdJuzrV0bgtuDbRSMxQ2wLlgKFbf1IBpHU3h
T61aYLfMf//Vr1+rK6dtb4NF0THHznoUY+nyi24p63gQr1avPn1EDppmOnSv
+dgO5qalr5Xmn8edH6QKU90FsKP/T3W+WSbszv+8NCmqA8rsTJesMnkF1fvb
HmQndEJKYJlT/sNiWLaBO6swvQviJl3/1WxdOcS7j85yzOqGirTcXwKCqiDO
J3T0qRIhaH+/4YftwhpYeHqPvWa3CIbsni0VxNXBGs778cNVxCB1O2E64UY9
8KtvmCvH/fv/4+elY4ZxYPjHdUaHFkmAX+QHgvx6UKk812T1RgKz03Xd0xTr
IdNRNXbIWQpHLeqWpL6shUfCr93r6qWQbmsWun5sDRj4pfj1O/WCo1XKBUvV
KggZ3DKs+UkvPNzr5K+XWQ7tny9d3K7ZB39HRps+0i+F8Serljg69sGmowm+
03iFsNzpSRD/SB9oqFZOTdqSBx98LKI+RfTBNe/JoYaNz0H3cXtkT0gfvB4r
d3zWlMdwZOVv0fd9+iDw4XKza/tTwNUv/M+3Zn0Q1vumQcPrErTtS7M27O6F
hJRN1YW6frhG923IstBeGLoMJl27YtFBS2FllXYvtA4+tx67KB4D5/KONJyV
wuLVhpkRtYmoOvOgpscnCfgVHG97G5+AyWMXmtlsksCeuTMb5869jh0bH1/7
kCCG0Spume5mp3FG8WBpOKcHFBfOzvD9chFmebYG3rQXQe+o4y1HNdLB2Ojx
zLO3uyF1guLXzIgcqI26N1a9oRO+6I3uOXb0DaxfvvbedJ4A3JT3HrIuLIWc
1ZIU9/R2EDm5q3UtrQaHr39XrTLnQkhsRm07hwPpgvsp2/e1wLxHc/SLZ7UA
b/L6eLlCDoxY4Bs//l4bxHQkn67YUgV1d2PvR4t40HjA6t3JlyWw6ett9zQe
HxwO+N1YuOYlGPbclY+M64BUxROrQyzugZroeHi0URccf3NHN6g8CnO7i0P8
Y7sh0qNbxVTpAb6cXW0w9pMQlmk16r7WeYHcFZnzS+174Ol543SNuDys+Vwy
TmQnhoktR04euFqAvyfesYyQiiF2bvdOrTnFmBR9Kvj0OQkkxbxvXbCpBFUO
juspni0F6WeOzhqbEvz9mMmJukdSgLvDzH5RLMZGrV6HHsteiI0y6pLPKsBX
mH7EKbUXdo96/7AzLB+/QK7Ef3QfWIdYto25mIvmDvnCMZ598NBZvHG3XA6O
MsfCjVf+nasaj7jpTfdxnK766oacPojbPRTEMYnHIpn/9oFwhLea6aLSZ9/e
3+ojex+02Ocf0+fBgn3/Dvp+kFtCv997Wvb7kM+ubzpdH3y7fjFdP3y7v7N0
f6DO7j+F7h9S2fPxoecD355fOz0/qGXP15OeL/DZ85e7IHv+kMfO5ySdD7xi
59ezTXZ+MJKd74oC2fmCKTv/VgXZ+eMONh+vA2TzgS1sfu7T/KAemy93mi80
YPPXT/OHf7H5TKD5RLl1NL+raH7xEpvvOzTfGDKF5t+a5h9X6dJ+ZNN+oNPo
/+wP9i+i/ZpK+4U9irR/erR/uHse7Wc77Sc6v6X9TaX9xTcraL+Vab8xYYD2
35/2H0MukT44kj7gmEekH6tIP3CGhPSllfQFnz8i/XEm/cG92qRPh0mf0IHp
10TSL9zG9G2Q9A0fMf2zIf3DXKaP2qSPaOJL+tlE+om/MX09Q/qKoUx/Z5P+
4k2mz/dJn/Enpt8ppN9oXkz6Ppz0Hcc8If0fRvqP1cwfhOQPeMae/GMZ+Qda
MH8xJX/Bgf/6DzYwf7pO/oRyh8m/1pN/4Vbmb+/I37CU+d9O8j80Yv64m/wR
jzD/tCT/xCcXyF9byF/RhflvC/kvmjF/Lid/Rm3m337k3/iV+fty8nf81EX+
30H+jxNYPlD4IMsH+C0/bKX8gD+wfBFG+QKR5Y8nlD9Qm+WTmZGyfIL9LL/o
UX7BxSzfeHBk+QbXs/xTc0KWf5DL8tE9ykfYzPJTDeUnFLJ8dVNflq8wgeWv
SspfqMPy2R3KZziJ5Tc3ym8o+G++w/ss/2VS/sMHLB/+RPkQq1l+tKD8iPEs
X7pSvsSHLH/qUP7ERpZPgyifYj3Lr8tUZPkV41m+PU/5FqtY/h1IkOVfVHSj
fBxO+RjNWX7+QvkZ/2L5eqhelq8xiuVvCeVvfMXyeSzlc6xk+T2M8jvGsXz/
PeV7FLD8r3RLlv/RjPWDZFdZP0AJ6w/6H2T9AVeyfiHvL+sXUMj6x3HqH3CI
9ZMfqZ+AB+svytRf4BbrN3HUb2AN6z8vqP/ARdaPOl7L+hHcZ/0pn/oTGP+3
X8EJ1r/uU/+CvayfNVE/gy2sv1VRf4Ng1u9OUb+Dfaz/fbos63+Qzfrhc+qH
EMz6oz71RyirpX5pR/0SKlj/bKP+CQtYP1V8J+unoMv6azP1VwDWb7+kyfot
iFn/NaX+C6asH1+gfgzDLlJ/dqD+DBasX0+hfg0arH+XU/+Gm6yfV2+Q9XNI
Zv3dhfo7eLN+H079HipY/y+k/g/ljA+oEh+AdYwfGBM/AAXGF24RXwB9xh9q
iD/AXcYnHIlPgA/jF7nEL2Az4xuviW9AHuMfXOIfEM/4yAbiI3CZ8RMr4ieg
IyK+Ek58BSIqib/EE38BJcZnNhOfgXf+xG8GiN+ALeM7YcR3oJvxn++I/0AO
40OTiQ9BIONHu4gfwQLGl2YSX4Jgxp9WEH+CnxifiiU+BVLGry4Tv4L1jG+9
IL4FCYx/DRD/gm98TIn4GMQxfhZG/AzsGF/bQHwNFOOJv9kTf4PvGZ9rJj4H
Hxm/++gv43ewlfE91UAZ34OfGf9LIP4HUiHxwTjig/Az44f7iB/CRcYXXxJf
hJGMPyoTfwR1xicFxCfhKuOXr4lfQgLjmw+Jb0IB45/TiH/CLsZH3xMfBVvG
T1cQP4U0xld9ia/+e17EXy2Jv8Jhxmcdic/CBcZvPYnfQijju17Ed8GS8d92
4r9wjvHhjcSH4cN84seriR/DOcaX04kvwzf+LJpuFPP0auWz/wEad0MC
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk4FegXx2kPGZq0LxLRQprW0UynkAr9kmihQllKDRMiJSole0jG2piQ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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892289884009*^9, 3.8788925872393503`*^9, 
  3.890981467880095*^9, 3.890981582875319*^9},
 CellLabel->"Out[50]=",ExpressionUUID->"229b7e06-7f9a-4fa8-9ccf-9022fe760d67"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 11:9 internal resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{
  3.878890738090901*^9, {3.878890872987176*^9, 3.878890874172051*^9}, {
   3.878890992837061*^9, 3.878890995687373*^9}, {3.878891118432665*^9, 
   3.878891120217503*^9}, {3.878891156232623*^9, 3.878891158692527*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4ee123fa-6479-4836-b9e5-8cc25208182c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pint51b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "11"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint52b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "11"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint53b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "11"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pint54b", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "11"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878890663927032*^9, 3.87889070005171*^9}, {
  3.8788908287376347`*^9, 3.878890840017591*^9}, {3.878890878913526*^9, 
  3.8788909114941597`*^9}, {3.8788909624770603`*^9, 3.878890987662685*^9}, {
  3.878891045188156*^9, 3.87889107302664*^9}, {3.878891168307728*^9, 
  3.878891209377736*^9}},
 CellLabel->"In[51]:=",ExpressionUUID->"523ccf1e-9b12-4203-87d8-fd1fc56b99fc"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 53, 1, 25811544838480288869, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.878892290169552*^9, 3.8788925875177717`*^9, 
  3.890981468202222*^9, 3.890981583193006*^9},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"818da656-b621-475e-a857-e845de635115"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 54, 2, 25811544838480288869, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.878892290169552*^9, 3.8788925875177717`*^9, 
  3.890981468202222*^9, 3.890981583305951*^9},
 CellLabel->
  "During evaluation of \
In[51]:=",ExpressionUUID->"aaebd0b3-b95e-426b-a6b2-d12661d8ef3f"]
}, Open  ]],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811581947954173*^9, 3.8115819505564413`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"ea2c84eb-09fe-434c-b93c-53e7b22a1bab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pint51b", ",", "pint52b", ",", "pint53b", ",", "pint54b"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878890761383698*^9, 3.8788907902198267`*^9}, {
  3.878890843662445*^9, 3.8788908527671537`*^9}, {3.878891001627733*^9, 
  3.878891010477059*^9}, {3.8788910790280437`*^9, 3.878891092377975*^9}, {
  3.87889121351777*^9, 3.878891224137197*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"e6760bbf-f5e8-4591-ac0d-882e594d6835"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk81GsbhyUVkaXiFGXJVlJSzjlxyh3V0U5KhTYtSquSctokJKljKVu0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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk4lOsbx1FatFhSlpI2OonUKVrQbSnxixYnUUepkKOEVEKbpMWSSkoL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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, ImageScaled[{0.5, 0.5}], 
     {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHlczOsXx1tELgpRriVL4qrsRJZOkRZdIkLZqZAWEsmWrStkiRJlK2tp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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJw1mHk81HsXx0niFqGFErkq1ZUSbdZOJFkqLXJLi2yRpFuKFm33poVokaJL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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.8788922906202173`*^9, 3.878892587974462*^9, 
  3.89098146845183*^9, 3.890981583554323*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"828a23f5-b777-46ee-affa-56887faa26cd"]
}, Open  ]],

Cell[TextData[{
 "Gather several plots using ",
 StyleBox["GraphicsGrid", "Input"],
 ".  This is Fig.8.3b."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115808498154507`*^9, 3.811580852596011*^9}, {
  3.878890343454084*^9, 3.8788903604186697`*^9}, {3.878892096930172*^9, 
  3.878892098009574*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4bd0aa88-ab60-4cf0-bc7d-6b2d3ebaef32"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pint11b", ",", "pint12b", ",", "pint13b"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pint21b", ",", "pint22b", ",", "pint23b"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pint31b", ",", "pint32b", ",", "pint33b"}], "}"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8788902515034657`*^9, 3.878890319574437*^9}, {
  3.878892103185522*^9, 3.878892165044849*^9}},
 CellLabel->"In[56]:=",ExpressionUUID->"5fdbce17-b012-49b1-8a54-8ceedbbb56ec"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXlQk1cUxUNBWeqCSl07UlCmGkBQFLRSbhhHpQoo4lAUqSOLIssoTequ
CHUUrChCKUER3ArWhaoEkELmgg0NWJAlpBDBQCJLAtmjgrVgK++lM76Zb74/
3rzt3nN+xyFi35bojxgMxuH/vvf/xob3QwUMOlq5NobsDBUsK2XasJyqkcNN
dp0oHYIHooS4kNEmVA9fzl5QOQizPaeL5QXteM/48LXfUiWMBRypDflLimEx
NZy1/gPQ8ty7QPq7HE+47bCOmNMHtV8bRJbNfejEu5rMLpTD/UPuUfxUBWoD
zVfZmfXAyJYlTX3KQZwzuiLeKf4ZrOt85/6HXoU1c2TbXa63wabnHN7Jqxr8
pdd3Ul1iIwiFwunZw1p0goxpB0/VwL4v69eUH9Nhg0xyNja+ENgSY1RKmw75
GR6tmupbWDC7oqTOQo85ntucvhPW4AtW1ecuU/WofQgsnNWInR5p6axXOuT1
uXBjrdrwk81bHZIe6VDI/5S5aIsEb6avaYTtOrR9udcmJUKKZmb20oRyLebl
vh8y1Khdc9VHNTiyeuMas+4X2FUeul5hrsYRKy+R71gfXq6uM5sXNIQLJwy8
0RgHsCI0IZkZrUT3pD3WAVVKbIo8yK3yHcCjodNOrg4eQkPehbM5il5U/bZ5
50KeCn0dFS3CMDmWLS436CVqPO6TVJq7uhvF7Nx9k1GDj7dxXuVGSnDFAniw
N1yL5SWajKteIiyZ5ueaX6zFe2eaQ8xP1WNUdGr7zLtaTO1oWBYDj/AGK/le
+CYtWmzyeb3/aRpwlo4cT87U4H2+5EHMDIR1a09nXdqvRseEAXHPgUZYGdj/
c0z/ENaV8Rek/yQG92yjeNSgxHybxbIgry5Y7Oyfuos7gAIHRcgOHxnEBrfC
lK5efHZesfxHx16I4lgZmUIZnjTsPv/Fo35oGddfF0bfSfGy0itA5WcxJs4U
Y12BPuNszSC42fHLui0bsN5c0KR0UIHf7hOxtjMrUOSdWBMwRQ1adzvFZU8u
BNwNCm47rYZvc7IE52Ieg1fFvKVOF9Rw2HmrXWJxM9h6xFtXu6rhyt/FI/M6
2iHqftwRZpwKwl+8VWTmSWG5v2WWfdAQdO9OcLA4IIeVrEKmRKmE5lPt786E
90FkZbU0CRQw6faS4mGGAowJm58IwvrBPGrFHW34IIwGdJy7tr4X8n6w3uDM
VkHRjEVar4/l8NLI9vdgacB6vp1zVlg3zC/cUz+7VgtF9S1pyXHPYLi0Mn5+
sg6eWnpOSAsSA6NqzHH6PzroOH8gpWhWM2hLHF/eDtZDZeybiMz0Whiby1ro
kKqHwK+WlbnklcKlcf3p6b/G2zS/i8yjaX0tWY+m/dvI/viant9Jzkd7er+b
5H5ouv9Ecn+8Rt9XQN6HFvT9b8n7cTKtj4HUB9tp/XaQ+mEXre8qUl9MpPV3
I/XHW7Q/kaQ/mEP7N5X0D9m0vytJf/FX2v9A0n+8SPXRSvSBG6l+hEQ/2E31
9YToC4VUfzFEf/gN1edpok8MpfpVEv3iIqrvWqJvXEL1X0T0j57UH63EH2jy
z1ziH2RTf/GJv/Am9V/GhnH//e/Pw8Sf8JD6t5T4F7yov+8Qf4OI+p9H/A8l
lA+ZhA8wRPnhQ/gBxyhfdIQvsJzy50/CH2BSPvEIn8DEr3zCL9BQvskJ34BL
+acj/IMZlI8MwkcQUX7eIPyEi5SvMwlfQUD5+5zwF/Ipn+WEzzD2Ib9hZw/h
O4fwHdwo//cT/oOM5oOA5AM0fZgfYEvzZQPJF9DR/HlD8gc+o/nEI/kE39P8
QpJfEEzzrYfkG9yg+WcfOJ5/IKP5GEryEQ7R/Ewj+QmmfF1H8hVM+TvqfeWj
650C738B2e8j6w==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlXtUk2Ucx7nIBGTpKi9NMdCNBAWCSVzrZ4IKx8oJHG6mx1CJS4ZQinRA
NLxkgaIIAoYheRBEDTETL4efOJlsCiq3AmKObYyNsbGLqFyy0ufhD95zdvbH
e973fZ7f8/1+Po6xyaHbLMzMzNL//736Lyl+danBjF4MPGV7e5UaDuUXsaa5
CHCks7A5gq8CL/d9nS+etGIOyzpgi1gJzrVvwuWyHpzY+/sf8EAB3nUHlt1q
60Oh9UhaZIoMok4cXHgyqR9PrvzSx6LqCdhFbm+4eUyFu5mMjhXzu6H88fLo
xNUarN25L87+i3ZwM7isdzqixQdWE2uFvGZgXE063Jk8jFf8Ku4l3mgAccsc
i5p0PcqiWTyurAraOPktG2YZcN28dIcPBs5gnCjBryrLgLskrltH5tVj8H7m
1SGxARMCTS6feomwJJDPnTZiwDMJCybc0h7jntY4YZiZEWGsrHozuxM/y8hJ
F+sMeG7OjQv12d3olMrqUjcYkPd+03DMFQkWPpve/vA7AzYLVkowvA/DjnsX
rmAb0Iv36pJj0T1zbk2ZHjefyWOOP1XgItmLg2vf0KP9MtcAQbES+S4cD0uh
DieURe8+dlChvzCvZ+6HWvTBnO/lP6hxvCf2mn6vBs3Zp8tmPhrE49+MzorP
U6Nm6G50iUmDgZ6ViZ6JA+iuzmA2Dw/hOwdCmiyY/VjKY6YKUYuDaQWsW2ky
FFkzIGSjDkNymZmJYU/QPKPGPve2DpXP8h+4re5C/28Dy9hSHVqHY95NcSs6
7jpxoaFGh/tPZYj/eXgPBeel7gKuDk9tts/0OF+LQZtceKEeWsxqsK9cc78C
XJ7pvy5u1GCLz8MOhl0jpI53RCZ3qvF8jCl5kWcrKEUhSXc2DOAa97pZC6q6
YPXyrTnp4QoU4edRKRFSmB1ebjVTJMWKj+M/uZYph9LX+etCR9uLBwuWKsHY
YbSJHX2E2XEtfJ9gFRTMLrAZlCBuiSwVbBeqwW+Gt6p/6XG4vqP/nPLsIOjU
B/bXL7kLuduytjYPDcK17ufa7MpWOBY71lZ0aRCU6VrX8uvdwOUN++94qYbp
Zzc2LprXB7ncY84cgwqCb4aNeu5VAF/8k8SpZADupwYxnfMH4KWtXcNuWyVE
aIVJxvWD4FguLw3mK2CxqV3jhENgmf3LJos0GXAa3273leigj/3RlsJDUsgK
Ne/dGa2HccavgRdZvSCTrGjd5WAAeZUeq//9CxLeizja1miAztjK53uk7bDk
tNuQzVoj+Pt+lRZ8/RFwRsf8oi4bwXt3cMwwWwTzy61j6kaNkDTjt56U+ttQ
VKve2csxgb+lxsTHGngdP56J/gsCiun9peQ+sunzh8nzyKXvtyfvR2f6fR/y
fYyn65OT9aGcrl9K1o/76P4MZH/oTPf/N9k/cuh8GGQ+GEnn50Dmh010vuYz
Xs8XV9H5h5L541v0fA6T80Ht1PPDNnq+R8n5Yhs9/yPk/PGpDclHHckHLqb5
iSP5wV6ar0MkX3iC5o9D8odzaD7PknyiF81vN8kvami+fUm+MYXmv5rkHyf7
IST9wJW0P0WkP3iH9ktM+gUOtH+5pH/gQ/tpR/oJlrS/PaS/0ET77Uv6DT/T
/itI/8GV8oFN+AAqyo8gwg+wonzJIXwBP8qfMcIfMFE+BRE+AZvyK4rwC+Ip
3xYSvoEH5V8J4R/8SfnIJ3wEb8rPAsJPKJ3KV/Cg/F1H+AuXKJ8zCZ+hkfK7
mPAbTJTvawjfIXLuFP6DP/VDO/ED9FJ/3Cf+AAX1ixXxC1RQ//CIfyBjqp+g
mvrLnPgLRNRv4cRvMOk/P+I/yKB+3E78CBPUnyziT7Cifs0jfoVJ/748d3dh
5I93Av4DrtcPkw==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlX00lFkcx8WOslGnPaeO3ZWWpToqvayzRNNvmvRCnRG9sbNSKdJhFYmm
kNJWejlWFLKJXqiIOlto6ScRqamM15ga88KEZzDTRHRiy73zx+w95znPec49
97n3/n7f7+drtT3Ua6ehgYHBgS/P13fA2OgEAzomsu6bJKk64CRXkm0X/wQt
0tKP/n1OAWsTL5b4fWzE6PGeca5HZXB6QNJ9sESCH0XehecVEsivZk0qmqnA
Q2X/JBTPagXD6gJbWb0Sx8mkw4+tG6BHUDTbiulG130RafNtnkNQ/Ez+3BgV
8rwq/A3Y5RD92a0vJ70Pp17pv7d/0hXwXigrfJDbj0VPY+W113Mxb6qDI9db
jXfOOp5YfbAcP+3furdMqkb3Ue5Hhzm1aGMmyZK5abBNGWDSm1GHsmJb16Bk
DT757FRQ19iIUwK3V8+r1GCmcyun8PFrvK8aZda3afD4+1MHr+5+gyvWDvfs
+PIdf/hhzpnAdgy1mJO8q0qDzwzLbtUMS1HJ9s0YStOgx/GfBAv2ytHqfFT2
Rh8Nvnr+dSjQJTU4OshIg/O6GgJCJneihXjgUOsFNfImH2ZfcFbiC7vM2WbT
1GjgneQb6vEOoz5nT7CL7sd7YcbXs3hdeHG7ago3tQ/9wlJclzl1Y7ynLcfb
qBebjKuOXZ7YgwduRjhddWLQnxszfnp1D44TWtY0OnQjc431SBzI4PIJ7C08
rRLfdds+iexicKTuhpgd3oFeDubJCStU+MCXM6M5X4bv1i7/xj5chVGBIyE+
yyQo8k8t3RSgQreJYovMpBY0a0lYbjdZhW0NyvW3eHXIifP3DfdhMDeYF6ke
rECT3tgzKXN7MK/m5o9x9UkYzvpwvyS4C/nXYv/9ob0MstzlzKaRTpyWVc3q
+uUVCBSnrrkI5Xjb0s/qQk4LPKz7bfrxfAnWJ25dMzS3HYLG9NeE4l3NjdYB
cqjfY80s5tfgvm3mWqMXHcBLbnrk8jwVozdHh3zyUEKyqdttN+YRNDxbH3V3
QAkDjn+VibUi4JdG7HwgU8JZyzWJYQvFUL5HZLGSrQSnRI3flNUyqJDIa23s
O2FUMM/X0viL3tMX3WlqUgC8zLkybXMXiAfbtnp7yqGUq0hdyWXgg33VzZpC
KfQtWMcdfNkLKcJZHvmG7eCu/F5rE98PSkd7U8FlMbxZdGp0wwE1mNkYPlMt
fQ22bebGte4aOOfmc3hI2QitFYW3XT9pwGfVpbw/MkXwelXcXdMz7yFh1u7A
pcIXsPjXTvXQOC1kNFuYzxDUACc490gMXwsFg5zftcsqwOzkJW1BuhY2LJS6
VC8tBnaxoJ9XroVQjmPhjvm5IBzTn5a+K5fo5jPIPE6i64PJetT9v4T8H53p
/ilkf2yh58sl50Pd+TeS8+NMer8/yf1QQu9vSO6PK2l9hkh9sJ/WL43UDytp
fRlSX1xB699C6o+6/rBIf9CF9q+S9A9v0f4+JP3FD/r9x436+sAjVD8xRD/4
P33hNqq/t0R/eIPq8y3RJwZR/QqJfjGT6tuc6BvDqP5jif7xW+qPx0/H/AFs
6p8k4h8wpf5C4i+oo/7bQvwHCurP08Sf4En9W0r8C3LqbyPRmL9B539n4n/Q
8YFF+AAiyo9Iwg/gU74cI3yBu5Q/GYQ/oONTJOETrKP8EhJ+gZ0+36CW8m8J
4R946fMRRJSfHYSfIKB83Uv4CnH6/IVEyuciwmeo0uc3NFO+ywnfgUv5b0v4
D2/08wHO0fzIJ/kBEdkkX/gkX8CT5k8syR/4meZTKMknGJaS/GJIfkEIzTcz
km8gpflXSvIP9tF8zCP5CNY0PxeQ/AQTmq9VJF9Bl78j3zHOpovLl/wHoPUq
qw==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3s8lGkbx8ditSWHlhzafUsRHTdbKZKLDpSQ7Ep6WzkuahViSYc3RRLl
0DmVU6FUaFLK4XIKIzRyKixmGDPGjBl6t8OGfTf37Q/v8/nMZ/54Ps/z3Pd1
Xb/f73vruB908PqKwWCw/vl9+a+v+3KJgEGvqKgKvYB8EWSsNso4nvcErTXE
ag7+Iuhy7JStjq3CaXqdwmUMESSMfS94W8TG5hkpvHW+g3Dg5B7PfEYrSr0O
9D3NFcKmsW/nPZbvQJulRr5unQOwVOuKVVZ5N44v9zL9akQAraJ1HY81udjQ
kc+a/oEP8kqNCRv1+7DBTfuJtbQfTGQOdPso9uNYq0XpCw4PpPses/1q+DjP
s5yb0tAHF6vM/7N+zwA6hHwt0HnWCyfuC/cuZwnRbJtBbGEaF7KqeDEtKiJM
rk7R14nlwAuN+bp9q8SouIit7hLcA9Aw/8HMNUO4OS0orLOwC4K5erl/akpw
rHGl+f3oTlBoD2DP75RgvaP/+kM72uHVJeemv8yl+PfGVWZc5TeQIWT9xY6U
YqCt3U6TshZwrrl6Vq1Yih+9H2cFuDXBp8GFLov5UhzlZtzbKWJDmJUVa5fc
MKoWqGv9WlgH9gxBUqXaMJb6XVjb7V4NbkHBrX6awxhu5KwXXF0GveZF+kuV
hzE9LmVJdeVTML7QG5T9UYqvku2yEwsyIGF0oMOnWYqyLwPX7tY9guuP5bTn
pkpR+OcPHunNDzGq7FJU8l4pWjwP3yxiFaPq6R9UdGdKsV4rab6jZxW2el7u
VXWQIONRW6rFkgasjJk2Luc5hJ3ZShWPZzfhyAjT7KytGHn7GhMHl7bhqftS
wy2KInSUnN8QaNuBW3ZVcP1vCTG6QJdts78bo4fFAm3ZAYypCI/pK+RgnG1q
Z5IJH1OsB11v5vWi0eiZkBZLHmbxnlh+Ps/D64cPzfVc0oujBgcDC2z4WLxG
NiJZ3IMnbUx23usTYAkj4VWtwR9oWGguZ+ggRGMPnSjP7W9wZkiMSkjiIPYG
PHi53LUJTVklWodvi3BE+WbBlTd1uHL6KeGbM2K0P+dcf12hAqvuJnictRjC
mMDn26ObHqFNsrqGX+MQotRHaV+mJT6daXiyb90/dYi761Fekgd2bhqzjkZI
UEshyH/O/jJgqm5ZduuhBDOi2DtlI1hgV9do4VoswaCWm9GtiWw4p9Bl5c6U
IPO07/Gz+s1gxlSzLkmU4OegJcs+nWiDTIsb72V/keDHO/cSFFPbQUXT5Ijp
txI0OFHKCD37B+wK7El4lz+E3U3KdWbzeuCypYrbxs1DeNmKd9rFgwPJ6tmR
nFIxbvuRpRoZz4XRFpHhUgMxrnNT87p9txccS0srjcJEOH6UH5GR2wddEVXX
WvIHUT1sSZhLJg+Uohjf3X0rxOl/myQcjusHttVP7gZ9A1ju+nCD/z4+eCeV
N2U3CVDT5rzD78YCOJE4HhmawUduzX6O75gAipatXF+/ux+/i9vkXfZkAK5b
xy4cGerDEtcUTqiXEL7xY8XbuPWim93OofFpg3Cr/MankFwOduq+W7AgZRC8
vUKcXj7pRr51U5HCIhEEGVocUajowKCAdxe1UkUwc0t7TmtkG37W2BswS14M
Hl4jKxbJNCGEl9pO3yGG2TfyXVYE1uG/nJIu3zghhh1XLlTG+pSj8bM5hnpx
YhjV33RHjZOD3aMct9mhYrjI3Oqfs+IyTGstL/ZYIwallSW3QnwLob9Wu+4D
SwQh8jqFzXk1oC0dj1ywXAR6kaqat+sawU7LSfWdxyAcfl0bf3xBG8QXa6f/
7CeEjfYNBddtOqH1kpbz13YDIFfzcHXWjR740Vxhnc0MAazaE9n/3yEuxMZv
1Tqa3Q/lMuG7xjR5MFReoBq8mgcfrgV0LNbkw/FIv0daub3Q/jG32XlQAF7q
dZVdOlzw3tAVeilRCHY+jwpC43sg22WTe62SCEw19/j+JNMF2bqBqUfcxBCv
PLDcWdQOKxd3nw+PHQLrz4G3fuO3QRVX9U5LggRWh+1mKr5vBvs+Tme+sRTO
8deaMbRfA9/6lwsx16SQmW/goZPZAMNa3zSaDkhB27Htr9iNLLgq1XlwdNEw
vK3mLbSUr4S8OSeVunYPw+hFp/Td9cWgz2C3vj42DAPWzBuVZUzwOzlXlJ04
DIfcG3lBuelw/dqXaxgOXmU1vvdlFk3eF5D7OPn8FfI8Tr7/Lnk/XqHf16yZ
+D6O0PWN/DyxPpxcfyVZPzrQ/YWR/SGL7t+I7B8NaX2cSH0wk9bvPqkfPqL1
XUbqi3tp/f9N6o/9tD+7SH9wsn9HSf+wg/a3nfQXrWj/j5P+oyadj4VkPtBy
6vxgNJ2vc2S+UH/q/KErnc85ZD7Rns5vH5lf1Mgl8z2DzDcepPPfReYfb1N9
GBF9oDSJ6Od7oh/cQfVlQfSFn62I/kaJ/tCd6jOE6BOdqH4HiX7xEtV3D9E3
ylD9/0r0j2nUHwqJP2A+9Y/5xD8wgvpLJ/EX/I36zyziP8ii/lRL/AlnUf+S
I/6FXOpvysTf8P/8D2VbiT8aEn/EK9Q/nYh/Yjz11zTir+hN/fcF8V9Up/6s
RvwZb1P/VsuY8G80pf6uETzh7xhL/b+a+D9up/ngTfIBn9L8OEbyAyfzZS7J
F3xG80eR5A/a0nxKqpvIJ6ih+VVC8guMab7NIvkG5jT/OCT/QJPmYx7JR9Cn
+elC8hNO0XwtJvkKsotI/jJJ/kIazec0ks+QQ/Nbl+Q3BNN8TyX5Ds9p/v9O
8h/MKB/YEz6AdsoPkYQfgEn54hPhC+jPI/xRRfgDJJRP2IRPoJ7yiwrhF5B5
P4VvgPuK8I8p4R9oTp3CR+BA+Wkt4SfgUr7iEL6Cq5S/3Al/wWLKZ3aEz+DT
VH4DeR/Cdx8I38HRqfwHfMqHWYQPoYTyI5vwI+i+Jnw5+naCL2E15c9jhD9B
g/KpKeFTyKf8+pTwK2yjfJtO+BbsKf9GEP4FA8rHcYSPYXob4WcB4WfgUL7W
I3wNtZS/ZxD+hs+UzzsIn4Ml5fethN9hhPL9NsL3wKH8r0v4H+To+eA5OR/A
Nnp+6CDnBzhDzxcB5HwBk+cP/5zzLieaqov+BzCk0lM=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3k41Wkbx70jbZKQFtHYRsqbadHG1I2JYUiShqKFtzQKZYkSUbYZxqBy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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3k41Gsbx6VyKkm06c2SUlE6XsRJ4ZYluSq0HNvRRFkKIW1aRLY6looU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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk81OsXxyVSSrJE1iypFPVrU4mOokXUvVeyRKFSyS2SpVRSVxJaKYUk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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHkglOsXx8nWplyJSJSSyta+1ylELhWl20JlTUqlTckPSdxcl0hRSZKE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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmGkglGsbx211HEs4nFCylPQqqVRK0qVCK1FJnbIdkixRlBNKtGiVmKSF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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[700]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892291270059*^9, 3.878892588584238*^9, 
  3.890981468646652*^9, 3.8909815837926817`*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"dbe6e934-0cc0-4b5f-b35b-9fecc7eaf9fd"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 1:2 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"d27380d9-46df-44e7-915f-e0aa8b79ba92"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext11c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext12c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext13c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext14c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889719384623*^9, 3.878889719389323*^9}},
 CellLabel->"In[57]:=",ExpressionUUID->"f062202e-b5ae-4d74-8808-baa37e2627b6"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.8115808838904343`*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"dbb5cb9e-4a4e-483d-ab13-c30626c2aa8a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext11c", ",", "pext12c", ",", "pext13c", ",", "pext14c"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889730816481*^9, 3.878889730821397*^9}},
 CellLabel->"In[61]:=",ExpressionUUID->"6507c61c-f1d4-4dee-a680-4c1adf55086e"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx10mtIk1EYB/A1PwwtAm2FglazD82GzVspWT0zzfxgHybRovtM04KaUGAX
TQPNDAzNLJWU3FwXhBDNjJodlAmbeYs0sMzhjZRpTWeliFZ6/gs26sDL++Fw
znme5/+TJGoSkoUCgUD551v6d7QvrQkSYNWsVER+0k5Qv1z1M3rmNZncjF3j
kgmKEDe9sIjaSXwlVieOspK/t4dO6tNLQSX23oXpcarwCBhUhvfTr6yXsX2b
x6j6rs7eoB+kVtX0e1H3KF2TH3VP9Bml3FcRN4WWIRKtzt6tOjZGqcPzY3ce
DFBQvKh4g9JKhXV+t0WKD5RYJBMtdE5SfV73QbccM9V5xgVWPvtGAVKTIKFC
S4HythORSTaSUKFnek4z0+wyRzdm2Kjou1BdJulhl1u9MvausdGcn1hWfMTC
Zu0X4kMVXylKvWIgd36EqT/eNz2PsVJwVor7fsM46zyVXmqI+kL96ftUlQ2T
rGNrPZUcGCJdQXQHHbaxtibfLdKEPtp4aLGgNm6KeWvTkr0+m6m8bGlNMU2p
+d2PM7qd/tgfrlreZ1qc7+LnmQX3m/j9zOV95qjvJK+PWVH/PK+fadHfJd4f
C0P/abx/pneeD2txnh/Lx3yT+HyZEvMP5/NnmchnFc+HmZHfVZ4fW0C+j3i+
LAT53+P5My/4kHEf7C38rOd+2FP48g9a9sUc/hT0RlpjZAaHvxH4M+P8dvhb
i/t94U+O96vgT5jN63sIf82oP/M//tToPxT+yl386TG/evjbFuDsT4n5n4c/
DfLJgL9ZF387kG8K/MmQfw/8DcNHC/zp4acF/jbBl7HK2d+txcgbF2NMf/11
w99jnH8Cf0O43wh/YXi/Df4iUF8q/M2g/jn4O+vcH8tD/+fg77iLv1oXf9cx
39Pwl4L5h8BfGvLxhj8D8suHPzv8NcJfMPKvhD+Hj3Xw1wo/SS7+9vzTX5fh
Nyo6nNo=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt1Hss1WEYB/ATf5Q1hXRh2XSZrejmVsKenLmtmUKyOWWFUJtL/tCUsDZb
k7PVTC0T08oSWWqpDXs0UeQSO0SXg0M4bBzHOmoaxfs9f5zferffzh/v3vd9
nuf72dkRmxp+wUwmk4X9+1Z+i++vLC3JsFryKtoaK7TkrfScziupofioB83J
rVrK3lxkMaVm6nbIMt+u0ZJ/0xR/jmujy4t9Uan9WqqOnk/d6dpLNW90+roM
LdXmNJddyh8gy6jkt/V3JqlInnjErHKIxp2tkkoXxsnuStVG/dNRCqqP+O2a
O0Zh7bfUTsUTZK9UKXZZj1C7PMjHK36aNIbCjv2Bg2SW9dxB2TRDHjGT8722
nbQYvDvdvlZHcdsyHT0nyimh7eLRypw5snIZPCALbWWFhfyQonqONJU6rloe
YI36WG+G4xwp3FpOK4JHWV6aYm4onyU3LrgxelPLa77FvtblTlPJ7awX5UMz
POweoz+7/IPuGtaquq/O8eGDH2ajX6ppT9fWHK9mPQc4B27QFHST2+qa5z5V
dtr7fY99jPuuYp+LcN5dnOcy3D8g7mdfvL/wdfV9Pof6/ER9/BP1j4j62Qb9
nRH9scK0f3Y3nQ+PmM6P7TDfj2K+7I/5R4r58xjysRf5sDXyU4r8+BnyfSXy
5TTkXyfy5y748BY+OA5+SoQffgdfX4QvNvpLb42YtvBtaDDuJ0n8nYe/Ttwf
Dn/peL8C/p6gPoY/G9R/Hf606M8W/o6j/1D424T5dMGfHvNbvib8RWK+v+DP
IPH30NkkHxqW+AtCvifgzwP5/xH50yP46IG/e/DjJPFnKfG3Pr80xCuz3ccF
+z17hb9inLeAP+P9Kvjzw/vz8HcK9QXC3xLqH4a/76b9sRX6T4S/HRJ/Bsxv
ScyP12G+/fAXgvmHSPw5wp/x/6MQ/qqRbyP8pSD/Rvj7BB9b4C8Bfk5K/AX8
119Hw1+Dd8lV
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx11GtIk1EcBvApdCEoE8nKCDOv4Kdg0Addf5mVBKWuUCOQQnEVLTUrNGEu
ApW0GyS6QlMbWrRmZV4SJ8cUStNhiRjOmW3idC7LLaOcpaXneT9M8oWxD4fz
nvN/nh9vQErG0TRPkUgk+/db+pcvP1YS4XlfFL4o1ViJrm0uGcjNo7wk5fn5
uAl6WDL4OqJXTemJO63FsZO0NVM/p/mto6w1P5paFDZS1Kha/T630Ut7aUqB
fIr8O67E+5i6yZ7bHBbwZYpEFrOrc/cAPf5q2NX5ZIqU6yNqyodNRH2PNL5J
NjL9HD51XDZG1u1GuabZSvkLkRmD8knSJ0f5f9RZSCbeVlJ0YJpOu4Kvz+cY
KbSvwhzVNkPxi9Jf4vB3FLRxtNpyyEmqMsUF6dtqNnpsyOnr+53iYh48Ta/s
Z8aO53X7553Uc1nV5bhlZuv8irPlYw7SZa2trY61saqUaW+p+hvta/bQiz1n
WE93Qpr9to2skuTyuXtOZvBs03a5zKT0a088KZlljg3GsNA7/WToXXpmmcRb
7KV21EYK6y6+zsax/wPfz6Lx/nb+ftaE8+/z85nB/X4sBvc38fuzAsz3ic/H
JJg/mM/PspFPMM+HNSC/BJ4fm0C+hTxfFo38h3j+7Bn6UfB+mNDfH/Nyf6wB
/e7g/bKL6D+T988EH2Lug12FnzfcDxN8Tecv+2KCP80Rm+5M4yu9sN4Hf0rs
n73r7q87g/sTzq+Av3rcb88Kf3Z+f9Jivhz4k2D+UfizIJ+bq/grQr6B8JeK
/APhb6SU9zMCf0kr/L1Av5tW8XcQPlrgzwI/w/Cngi/bCn83tnj4LOh6I/Ow
PgN/E+5+2WG8Xwt/rThfDX91uJ8X/Mnc78+MZW7zsTDMHwJ/55BPEPzVI78T
8GdEvmr424v87fBXhX608DeO/vz594M1ot9U+LuE/kPgTwEfZ+FP+H5Vlrr7
Uxb+z1+X/i9vetx/
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt02tIk1EcBvARpAYtgyDKrkKJFbZiEIOV/+pDkKQ5bwldTDNtYlrSN02X
HwwszEsEIolmunlDSuQllY7plpYXGG1pSSzbqr3OhZdNU5EuO4/BRi+87MPh
Ped/nue34JTsmKtrJBKJ6s/791fueawkwfMjU50uL7OS01H9PkrayOYDtEGu
BhupdS3X3aoOFmeJUMiSvhGL7aoPUAgsaJ19IqzITvFdNcotb9vYvviJJffr
ScrrXZEJJzSk2Rk4O9Q+RZ31Y+1j4y/JFvuo6rHJSQdK3oTczzBS3YXd5xSC
kypOHR9f2fiJfn5u3BP4y0HGPqtOFG2kbDaHP8uxU3TdbT9/lYMyE6xi2Vor
3QxOnpGVT5Nen6tffDFKrqWmhETbLIUGzRta8zrpGBN7qhJd1GQszGorHGD+
zWeGagQXlQ5uXxafWNi9iFRXhWWOWoRDJ8UNIkst0ikrB2Yob7hBm1Q+zeRP
KTtS6qRXss2mSWGO9Q8ujUjLbJSoHm0NE9yspnjvwOloM6V5nnlWFym2XuvQ
HT2P9QK+zny+Z/nY/wjfnz3H+Sn8fKbFfMV8PmbG/H58fhaC+4Xz+7Fh3H+O
35+leefDCPlF8fzYCvId4fmyWuRfxfNndvQTwvthBejvI++P7Ue/TXpPv2wb
+lfw/ikePt5xH7QAP1ruh5zwpZ7y+KJVf2ZT/o3+sI5uB9Z38XXmwvcF8Le6
fzP87cD5E53cXyjmM8JfLuZ/CH9fcT85/NXj/sXwt4B8zPCnQH4x8KdBvhnw
Z0X+s/CXj36U8Nfg3R+lod8S+GtE/+nwdwc+ZPDXAz8m+LsIX5k+/tbXXvnQ
+2Xkn78c+OvD973wp8H+h+FPwPnJ8HcZ8z2AP4ePv8Wt3v5W/39u+LuFfLLg
T4b8Lvn4Q75Mh/zvwt939HMW/grR3zL8HUS/lQZvfwb4U8HHpjhvf6U+/qod
//Nn6P4NgmXfZw==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878889850531046*^9, 3.878890598535617*^9, 
  3.878892291713456*^9, 3.878892588976503*^9, 3.890981468961589*^9, 
  3.890981584061739*^9},
 CellLabel->"Out[61]=",ExpressionUUID->"cca45d22-2fb9-4834-bcf6-e8e3bfa44bff"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 2:3 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"7a8973e6-112a-41c3-8201-d099f4510826"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext21c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext22c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext23c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext24c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889743235078*^9, 3.8788897432400303`*^9}},
 CellLabel->"In[62]:=",ExpressionUUID->"6f942f8e-0504-4fa3-b582-e0c8b2baf5f2"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811580879906456*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f20b1f44-7186-483a-b045-d1c629ca69bb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext21c", ",", "pext22c", ",", "pext23c", ",", "pext24c"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889757319641*^9, 3.8788897573249407`*^9}},
 CellLabel->"In[66]:=",ExpressionUUID->"3a9e4ce6-4384-4a60-b856-4d623c70a969"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdVXlI02EYXplhZrcaGRVFVIpdmBk1eT0oi4pOQgk1LSklUDvISll2GYKt
Q2tGpBi1ikIijw7trcDEnOU8KMxW20ycm6SmVrgO5X0W6A+Gf3x87/e8z+Xs
2MStcSMVCsXRgd/g3xrd4GcjBT5T0GGf5DobndX4j9ZW3STTl4ZYk9FGZ17e
rnDxKaKo7Lbi8j4bzemduU/tzaT7kPnYNqaDnofNKonRVJApJ+J3/6QOyut9
VHEoUEfLa7TqHKcOUuXtWDC3Wk+rn1XtnDEwv3HhA4tzQyMFN82ITEiy0Sc/
Xbp5WROFdU/5fllvpW0FqZ+dTQbyV89rqLS005ujS1SRLUbqPftqxfRCCz1Z
bzH92dtC19NdgtZ5tVGo5uGmF7ZW2rGsQLllfitdLXC6khFjoYye6DhLo5nG
NmnvexVZ6dC7CTPLvY30sy4xwbWug77VvjaZtjfT1KTFCu3db+Q+ZndQ8+tG
cq8taD6S00kjUtQRJVk1pPLVlgfM7aKTHlWtbw3ldPHgjRX2412UqKnS98Vf
Vl7LHfy6aI+cs+PcX+5zGu67yXx2zO+U99kT7x8QfPwL+M4JfnYF/mjZj7Ow
3zXZn8Ow/0/hh4vBj5/wxzrwt1b45a3gN1D4507wHyz6sAX6+It+fBL6mUVf
zoW+NaI/34X+8AdHwR8t4h8eB//AX1wNf8F/nFR4PupEfanScb5fzhn+481y
nx3zF8l8rsb71fI+twBfuuDjJcB/SfBzKPb7JPsxYf+vsj9vBD9rhR8OAH+V
wh/bwW+h8Ms3wH+w8M/h0Cdb9GEV9Jso+nEK9O0Tffk39HcX/fmXi/jDU/zB
E+Ef+I/Dh/qLY+Iu/Ci1vyiD//j8UH/y1yPi3xO47wx/e2B+O/w/De+nIR/d
wHca+XED/kjkS+3YD/nbhf3/Ip/3wM9K5PcV+HPkOxz8hiL/H8G/Ev3gtkj0
WYr+uAX9PqJfvPpE31r0Tyr0j0Q/HYY/HP2lgX+M6Ld++MvRf+K/yjIzzgOH
9V/AsP7zgL/1eH89/G8Avnbkww/4s5CfddjvKfK1Cvvbkb9A8JOCfIaAvxLk
1yVD+M1HvuG/AbyS/3jocw79cBD6eaI/MqGvFf0ySi/6T0b/zIY/pqCfsuGf
U+ivkZ7irwvotwxVveFWquV//yUP67/3cp/hPwpC/03AfDP874X3jyEfvcCX
jvyMB/4Q5Ose9ruC/G3A/u3IZyX4WYD8fgF/a5DvaPCL/z9sBP9b0A950CcA
/ZEM/azoF4K+b9A/dugfi3660yP+MKK/Cof1n2/u0P7LdrKuyTfolf8AxkFH
kA==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlHtMzWEcxsNxclmFROQWtlPIXIZQ+7LKXJaIyaWi455cQuMchYWKHeZS
SOuMrYxuk9Vo0tfKXcacTLlWLqlToZg0Npzv82s757ednT/eve/7fZ/n8zzu
2q3Bazvb2dnp/v3+/59L/f/Vkx2+gJ4qt6br9RQ9uTrG2BLJe43js2/0baD+
hzXttfUbONHTVxd+sYHCrqxaMj19Gw3dPts3Smsm7emompmrU8hzcv6ms96N
lFkd7Fy36zKF7TnY8se5ifwizF/Pn7tGnp06R7e+aqIgTcAIo3MZXTq4oCg8
ppnaJox/dsyrnLrP21S25nYzdc11jZ8SZyL7A7Nc5+Y105sZgeUrjFVUkhHw
PMStmUaui0zqqammgl4VCeltjXSyXfdjY9Z72jJqzMPNU83Ua3+fBS5T6+jq
ikhvfeVnqqxyT3O50kDz82v26Cs/0oPthu9HzU2UFO5gCPavJdfkNL/QNV8p
eGX8wo1hr8kp+nHEl1PfaHNRxMMkrYlC2vIO9dvVQj+zgzLdc8vo2aMjiRe6
tNLzir3b7nml+Ey0fK1UJ+usrO+X/bwY+2fK+aycHyv3sxvunyPz8VPMVyDz
80vMv0Pex454X6G8n0/g/TdFH9ZAH5Xox43Qr4foy79zRN/Loj+rJ4r+HuIP
a+FPuPjH8xX/xF/eB3+Hif9cBf8ThA+OAx/ghxsMwg/44hPjhC/wx6JjoY8/
1msmWdY79gedtOwn8MfrCiznM/jj4XI/azBfpxrLfByK+d1kflbeN1fex+CP
zcIf20MfR+GPHaDfLdGPFX2Hir5cBP0Noj/HwB+1+MPZ8O+d+Meh8LdE/OV4
+D9A/Gcv8NFb+OAo8AP+WJ0jfD0Vvnha+5Z4x6TSYvDHL6z55MXgdyn2+4Bv
5fzd4H8Q7l+EfNzBfBnIz2fMvxX5clLeh/xl4P2lyOdA6OOE/BZCPxXy7Q59
s5B/E/QfjX6Ihj9Kf6yFf0q/HIe/4I/iUsR/8Edv84WPfegvvzPCD/ii0mnC
l9J/wt+dYj+srw8QPmOx/0eidf+F5lj3X59k6/6rsOk/FfID/sjXpv8GI39q
6GOP/usG/aqQ37vQ1wH5zoP+yci/Dv6o0A+58O8N+mMV/C1GvyTY9J8RfKjR
Tztt+s9F+CPwR1lFn7zLH5s7+u8e+s+E9UDwuwz7deC7B86PAf+DcX8Q8nEf
85UgPybMH4J8jcX7biB/h/H+Mut8dvRfO/Trgnx7QN9c5P/DBOv+i4U/y9Ef
epv++/VO/FX6xz9V/Degn75kCh9x6C+9XvhR+i1iiHX/zaASj+zbT3z+Ahsb
46E=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXlI03EYxkdmp2azzCCQDrIDCkKxnFsvazbN1MywQzpUUrLCSMQyTbPU
ysx1eYSiBl120IUIUb6dTNi045+hslIpTTs2c2EHdvk+C/IHwz++fN/v+z7P
532ckbArOnGEQqHI+PP7+zdp6OsiBT5brenXgtIu8iwtSa2ruszxfi/CCmd3
k625zjXYvZ7VadoF1Z7vaFHIUsvd5w38c3SgW1lMD8U1DMauXfKQN5tt2mRr
Lw3Oazq5If8BL912fc44wwcqDFU+/Opyl/ULe64a9Z9ourp5udH7ChfFbtYM
tNroTvbA4lWZZRQQ6utWbbBTeM1I647kBrIGHqtXOOzkula7rOVLE4WvvLKu
bVQfTYvsP2ePtVD59r1GW72dAvMy0vr82ynqxsuaggEbHc1Oysl684Ymd6RH
Tz37kfaZcmtHH+mhHW/XvciK6aXD1uzYup6PlG98OjNB1UUVIY3e+3rtNJho
9b8d30FdKXEmU9FnmuX73JrZbqGJ55W0ydhPx0/ddGuKbKRXreOeVhY6SKP0
9yjvK1U3mf9+DoqWc36N82Vynyfgfp/U517U3y/vcxXeT5b++Bj6U0r/nIP+
o2U+PoT5MD9rMP8K0Yf9oA/0Yxfot1j05bnQ97jozz7QP1T84QvwB/7xVvgH
f9lrvvj7S/znBPgPPlgJPhKEH/Z5JvyAL7aUCF/gj1XfUw5OOHJb7TyfLvzR
FtzXyn0KQv1AqU+KMfJ+sLxPW9CfQ/gjFfo/If1TCOabIvMR+OPQnKH5eQn0
2Sv68Cvo1x0zpB9HQF8X0ZfPQv8A0Z/D4E+R+MNj4V+B+MfZ8DdD/OU8+F8p
/nM3+PggfPBq8OMm/HAj+AJ/7GWIcE+c9OQe+GMd+OzAuQr8euB+G/i2oX4m
+K/B+0nYj2L05479OYD+ddivEsx3Gvu3GvNDH+qPEH2gH00S/pz6khn6FmP/
8w+I/uHIh5Mq8YeQH20h4t825Ms5+PsD+XMf/muQTxV64QP80TXJL3Lm2y3h
j5z5J/w9uuc81yP/NuH+l2H5917q8yDezwX/W9GfGfkXhP4DsD/BmG9NkOzX
Cczfif1z6rMR++nUr0X4oyjo2yL60hnor8X+r4I/hcgHb/iXivzYDX9zkS+H
h+WfR5Lw0Yl8Gg9+PJFfBcPyr7n/26nPPp/+5Z8FfFpx3jlb+PXC/RlSn62o
nw7+wR/FYz8M6G889icP/euxX5WYrwL75zcs/3TIv1bsby3yz7nf3dDXgP13
ZIn+YcgHHfJPg/y4BP/ikC87kX8uyJ8o+K9DPhWDD/z/5HLwY0e+DZT+n3/r
91x87GU2qX8DnDUdkg==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlX9MzHEYx29Z/RHmRytRs1WbzIWSFN15toal1mxJC5OJwyEVZiS7KJc/
yJjV+TmxSYySjigev5KMNCGFRvmRWld3dWWUX/e8r819t9Yf332+n+d5v1/v
9/kkpcRqnBQKxc6/f//+B9ueVlLgyTlYqF2U1EqG+nBt28Ny7pvx5K7vz1bS
eJXVnNlazemjfEt3u32mLwWFsR0edRzKGZG3jF9o+LgNzse7XnBJuabL9XUb
5b8qMK9zecnGkuj7cxd3UPQ6ZZF1ej1vTj7Q5DbQSePjE5LLYuvYu6M252RU
N+nSas43v3rEnj4+c3almGljop9nS3gpvynLvx8YY6GRyuE1LnNKKP5Os/PI
agup3wxrVauf0tSiEy/CqyzUEjKi9kdYI/2e4t+um2Uh7an8B9GpLaSqCdVl
jDGT39zts6Pmt9Hgx6Io60UTvVXVWcbWd9LE0HmH1e7tFLfy5IIYrZnW6vcf
dc/6REH9Jv+IPT1kXNp/7cnCd6Rxnr4gz91KOcUVO/LfP6WsVaOvjh7TR+di
vl1ebzSo1tqePiqQ92x//0zO82qc18r3eQa+7y33czzu75H5+CvmU8v87Iv5
nZS2/ViD/abJ/tyA/eNEH06EPtCPA6DfeNGXb0Bf6M9p0D9N/GFv+HNT/OMw
+HdF/OUL8Bf+syv8Bx/cBj56hR8+AX72CV/cCb7AHxPdmXzpYbEqG+8r5T31
4HymnKcd+H63fJ9UuP+Xh+1+KsZ8BpmPSjE/yfy0Bfu5yn7khf0PyP5D+mhE
nyH9uqbY9GPwx70NNn05CPo/Fv15UPjjZPGHw+CfUvxjlxbx97n4y37wf7H4
z4ngI0T44A/gZ43wwyngK1v4YpNfgKHidFUl+OND//PJVeDXfn4N+AZ/7An+
E3C/CfkAfxyC/IRi/gHkKx37BSB/LrNk/wTksxH6NCG/k6CfF/J9Cvra818I
/dPRDz+WiD+30R8z4V8l+mUb/A1E/wQLf7QT/fQRfFjRX0fAjx79lgu+7P0n
/HEl+KNn4NOM88vAL/gjK/gOxv0e4N+I+fTIx3XMH4n8aLBfFPI1EfsvR/4m
QJ/+Ff/3X53oR3Z9DaIvKR36TyH9QJvQD+CPJqE/vsPfJvSLP/yPRf9sAR8B
6Kej4EeL/moEX3vRb9/z9NtHhHUP9d9uh/7Tgt9knNeD78n4vhv4B3/kinzU
Yr4I5McL85uRr7PYLxD5u+fQfzr03zvkdyP6D/yxzqH/jkH/VPSDSfjjMvSH
P/zD7xs3wF97/zjB/yz00yfwgd9Pngl+9qPfdA79l1qcm5hZX636A2M09wM=

          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.8788898510379066`*^9, 3.8788905991528883`*^9, 
  3.8788922921506147`*^9, 3.8788925894799643`*^9, 3.8909814692706137`*^9, 
  3.890981584357111*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"1d87e96f-9df2-4992-80f1-dc059e1454d9"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 3:4 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"001350ac-4a7a-4af2-a2de-f0f3c6e2e5a6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext31c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext32c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext33c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext34c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8788897812901154`*^9, 3.8788897812980347`*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"ebdb5eec-eac3-4130-be45-ef4995d1ab45"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811580875671486*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"84275ba2-c9dd-4831-b793-a8b4af8d5394"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext31c", ",", "pext32c", ",", "pext33c", ",", "pext34c"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889793709149*^9, 3.878889793714292*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"ef48cc20-81cb-4629-953b-c7b299af6b7e"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXtUjHkYx0tLuUUkl6yUU4RYrEuJJytspCi1tsVqU4fclk2hQpQhy6Kr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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXk01WkYx283EqdJi7GUJiMNbVpMk9NoHioxmbJNhtEizdUJLSQmY2+x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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXlUjXkYx1vQOiYSKk2Ui5np4FAaomdyRJaUDAphmnGLLB0qSpjRHQa3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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXlUzXkYh9tIUpQlSySTUrYxRXWld0qjObIVokuHVJaOFFli0kSJhKQO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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878889851523182*^9, 3.8788905997632504`*^9, 
  3.87889229263072*^9, 3.878892589949156*^9, 3.890981469643383*^9, 
  3.890981584771454*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"7e5fd7f1-e85e-457b-8a93-f1fb6cf867b3"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 4:5 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"5e94720a-2345-42ed-bcf7-7c64c2f16629"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext41c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext42c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext43c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext44c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889804285678*^9, 3.878889804290448*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"e71a04e5-b85e-462d-9a4a-2e0c61b6f99f"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.811580862548997*^9, 3.811580865182575*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"6d835273-85a8-46f1-b372-90e26ef511ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext41c", ",", "pext42c", ",", "pext43c", ",", "pext44c"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889817425817*^9, 3.87888981743064*^9}},
 CellLabel->"In[76]:=",ExpressionUUID->"ebfdc0e6-6252-4cfd-9b14-276a6214d04a"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlgtM1WUYxpmlKz1ZMi+wUFHxLhe3FBHzUxOd5ExdWSpeQhkTNFSsXCV4
BMVCFJlhCs4bamMORUpXWO+CYngvDZZaRwQBJThHTcUyWsn7+1p0NvbfzuH/
fe/7PL/veb8+0QkzY9p5eXmd+ufv8fPc2cefRuPFJ2ffQXfQ5UbjaA549VJB
nJnXv6TgREujafZOra3PSjbjBi7JzRjVZLZcK77tLMwwW79NOJyzoclcG7jH
dIzYYaa1BK/LrmkyN5K+i3jLkWd8e60Md0S6TcaDsg5TOxWYoWfuRKYUuc2n
lUHR/RI/N3Pjz3yR7+Mxfs0/nP9t0Vfm6JQnknNWeExh4puT/BNKzf41ZaMH
HfeYDzZVhcY2lpv5O+rcI10ec6O5LHpXzwtm13ZHVO9qj2m36t7Uo80XTfrg
pIVPFXtMueOlj6v3VxpnwuybYxd5zO5DYYt3p1wxpuzqh85Kt4mrSnVWp7rM
6O2LC8Z4u43fqbz4jpHXTd2yO90/69ZkNpU3+MVMqzHxV0uzelT/as5uONU+
IqLWhDsCKpzvNZjCycXPnQuoN8GDZPn1mpsmiGcR34fxf6d5z66TxroN7PM8
+9o63qWucOrMpu4U+iijL9unL33nooOgy0J0yka3veh4AF0L0Xk4us/Bhy34
Yn2qua++WR/9ktVX67P3IPXdctDXpVxYTkK7Kjfz4ehlr/6tXFnONta/83vD
laIxlsOZj1q5E/v78S6t74vlMK2qdX2x6y9X7sTuf1q5E1vfQ+VOulF/lfYn
Q+hvovYvtv9M1UeK0GeP6idWv3zVV6LRN1D1l+3on6/+SCb+7FT/ZB3+LVV/
xXLYXf2XF/E/U/mQGvj4UfmRGPgpUb5kGHwNUO4kFP6G6/dyEg7j9D05B4e3
dF35CA5H6b7SCw4naF0yDw6TtW7Jh8Ms7Uty4XC39i0ticphlOoiHR8qh/tU
N1kHh3AnR+EwSnWXp+FwmPoiB+AQ7sRBfryivsokOMxS3yUGDo1yIbd/Vg7h
Rrr7KodwJVnKmYE7UQ5Lx+Ty+zPKqUTZ95Vjset/eV05hDt5oPtb7mQvHNr6
34DDwfR3Gg7JPwmGwyPoUwKHeeg3Cw7JP3HBYQ76d4DDDPwhJ+Rt/LsIh+Pw
NxYOx+J/VzishY/NcLgSfkrhkFwTck4C4S+EJ7ko5KS4eG8+66Szrt3Hm30N
dSyirvHUeYG6V9NHCX1tps+J9J2NDpXosgCdzrc9v/IHulqde6O75TCyQn0J
wacR+OaDj058nYnPrgHqu+UwHC7Gw0llpzb5JZ3/0nyznIW13E1J+qn2pOWw
nyfgv/koFcxdy+GKX5Rru34e3Geyfyznwp6TMPK7B/Ufb5vvkvtAz53l8ATn
kjks6Zxbe467cK5no28f5s8n6L+XXNiGP0fIjST8c5IrYfjrT+6E4v8acuk2
fFwgt5bAz9d27sJXX3IvHP4mkosH4TCW3LwIh25ydS0cjiB3+8HhZHJ5ChyS
f+YEHKaR6/VwmEfu39L8kznMBX/VSez9ZQcc2rlbBod27hyDwyDm0hU4tHN3
mfpouTPFa5TDbcy91/srhxOYiy/oHP53bs4iv+DO9LqrHNq5q/l36aT9Pdyl
HMKdqfBRDuHOrNY5bDaz/5Ahbe9/gWvb3v/ak9/B9BdS0fb+9yT5z7k0S+Hw
IPqNg8Pp6FsOh8wf8yfzZyf+vA+H6/FvIxzOwN/ecBiC/4Fw+Ag+4uFwAfxc
hsMB8FUOhz7wF8Hze7735//yeW896ySy7n32Gcm+gdRx2NZFnTnUbe8PZ/93
/3uW82fvwY3oYnWqS1fdDqNj51Wqaz46z+D8L8CHOPJhmL2n31PfeuLjMXyd
js/BQ9V3y0HQVeXCcvhaZ+XGchhUp1xZznznfnNo1OUjNv/M3+gczl0=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlgtMlmUUx7+YSk6ZCmgqBWJyUSbJJ206qeOloaJ5IdvUENMsc+RcWmpe
ELCJeAEvy5Rm6mzK0pySOdrIA/NSXqZgmvrZxVRM+ABhStNKKzu/p+2Tjb3b
+37v85zz///O/3mjp89JfzPI4/Gc+Pf/0bV4y6O/WvHwdyyk97aTpbVSM3zM
Pe/FHTpkiS/F+7BW2oQfyV0Wc0Dn1ef0/WtRnWy+cWhm5+AyXflSUPtfY/3S
EDpwwawH5Vo/Zdz01Ad+8aRtvZpaqDr6u87jPvu9XipKjrfMm6yq6dpuypON
0vv1qd7syHLt2uXz7FYxtyUn4rWg+C+/0nUzJlRnRzZJutffVyNK9J3i6612
b2uSrJi0Hc//OFM6leZHp4Y0i69u+aw9y/fL2SEdw+sym+WTxXP3Ll1UKVWe
lH2X1jRLWciUNsU/nJJlNcUtH6xrljt9+g1uWv29rFw6v7x0RrNklvzpnbj4
sjxT5qtMaNMs0QOvZWRs+EUSKnYW5M1rkpvxqTs9569J2IrgAUcn35ZuW6uP
FJ6okStNYy+2nt0gVQszw1tvuiVF4X8v6hXnl0Ku57jv43cRvNeBdW6wrttn
IPtGUMcE6lpFnbeoO5c+DtJXNX1ucn2jw1l0cTqNjDfdnI6p6Op03oPu3fCh
Zar54ny6jG8v42P9SPPV+dwuzHx3HFTCxVw48YUZN46jErg6DmfBGeH9Y3cd
SHEc5ttzcRyesPdlKO8fsPXFcXjfuJN89vdZfVJHfQVWv4yi/mvWn7j+Nln/
8hT9R5o+4vQp7Pmffv9z+Knpqx3Rd4fpr47DLeaPOg4bzD/Nwb/h5q8W4G+C
+a/O/0bjQ+PgI8740bbw4zO+tAq+Vhh3uhn+Ttl9vQGHcKdRcBhr6+o9OOxu
+6rAIfOhk+Awz+rWn+DwnPWlCx2H1rfmwCG66E04RDeNTTAO15uuujnJOGT+
9VU4rDRfNIN8ID/0IRzCnY4iX1aZ77qG/IE73QeHcKdJ5NdR40rTRxiHcKfG
YWWKe97Jnstg3t8Fh3CnRXAI93oBDv3UF2f1Oe6UOZJv6M9r/Qlzp1/AYRH6
jIRDp9/+KOOwA/p28BuHZ9B/IxzCnV6Aw2z8a5tgHObj7xtwSP5pHBx64eMU
HHaFny5weA6+LsHhWvhbz9Xdv8DvkngviHVqWbc3+zzLvq4Oclkdh8EJAfOj
p+mL/NOqwPnTxlrTJQydWieabrPRMauf6eo4rED3CHxInma+lOPT3MD80Jsj
zNcmfK7B9wI42A4XC+Ak0rgTgaONqQH5puPm3I2KyLpe7jh8OzAftYz8dByG
1BjXjsMJ5O+H7D+RfG6gPj9zk0b9Z8j3w/QnT9vcuTlc0N/m0nHY6UWb2yz0
e5e5DkXf0CU296fRPy/wfNJ480+W4t8gcmU1/g4ld7ri/yVyKRE+osmtdvDz
Lbl2Fb5yyb2t8PczuXgSDtuTm73gsC+5egUOu5G7aXBIXTIMDsk/8ZPj5J9s
gEOX+x/DIdxJIecE3MmwHsYh3IlY/kkk504iHOKLlJAP+Cbn4ZB8kZ7ky2rO
vbfgcL47F+EQbmQn+eXO1Rc4Z925a/lXXe6eTxoR+P03HQ7fY/2D5Gsu+999
7Pvvvs2JjqX+Ijj8mv5GTwv8/rtI/q9Cn23JxiHcycY+xiHcSYvln+NOlPPn
PP48B4fL8e8Q51cR/obCYQ/8j4LDZPg4Boet4CcRDhW+7sDhfPjbzfUw92/x
uwG852Gdfaw7iH0aB9i+MdRRSl251Hmaul0f0+jrMn1mPvb9l4QundEpN9R0
cxyG8v1X6L5vmP/u+BDBuVuBT+Px7RV83B6YL/IR+ZMHB+PJp/fh5I/Hvv9+
I98cZyuTnzgzZuxel3/yD27SbrA=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx1lntM1mUUx1+ZaZuWWillTitvkU6nFVZeDpSir5egl7SaTg1E0QrTWU37
owTxCl5nZDlXZt4IGVrilSOoJSleXlCSFA0QECUBMx15qTyfpw232Nhv+/3e
5znnfL+f55znyaipvpgAj8eT+8//v8+Jd//KxcNfZfvcraHx5bLh2qQdf03Y
pucHf+GPOV0uKwvTKntm56j3cFKGZ0aFRBSdKxu/5mc96vdNH/VWpfSK/LSo
W9xxHTw+IfvmwouS33rVwpkr/RpZvDw8I+CSDCnxBk7fmK8P74s9OGPrZblV
s/6HcSvyNee6r11J4u9SUTjmlV1D/bp0ddv2t3vVyPaW78c9lXJMk1/uqPMe
rZWMhLeLcl44pLu8W8aEVNbKwC6L5rfrs1eHVn9b1X9FnaR1ae3flpqiwQHV
nfY2vyqfld4X8/i57+VW71lN87xX5aWyTo2n9cmVOaP9vuLQq7LsxaSYpR8X
yHdr+lX1vlIneTPK3hy0+oykjpk4OSi8TsJahN5fOK5EpiTeiIqKqpX4wrbV
yZHlcuab+m5Z3WtkdfT+AU2aVUmtRxInTamWGp5reP8rv5vNOrePl303E+cs
cTeTxxLySiTPYPK+TR0LqOt56vRS9zB0CEcXp1MCujkdT6Kr07kO3bPxoVmt
+eJ8Golvr+HjKXx1PnfF9xNwEAkXQ+BkEdyUwNHncOU4a/519Omcki39HIcL
7bu476tsvRSzPtr2l8Hs39PiyzHi+y0/cfmFWP4SQf7XjTtpTX2XrX5x9aeZ
PrICffaYfpKEfodMX9mJvpc739VfHIevmz/6HP6EmH/qOIwzf3Ue/p4w/9Vx
ONL40I3wMdP40XfhZ63xpY6vCuNO6+Gv0N5rKhzCnSbAIdzpcDhMtbh6AQ7h
TuPh8KblrbFwSF26Fg7hTpt3NQ53mC56qbNxCHeKjoquehQO95vuig/axnzR
pnA4ynzTYDgcYb7qSTjMM9+1r+s/xoV64ZD+pfFweNG40h5wCHdqHGb1c9/f
g8OzrJ8Gh/Q/7QuHfuK3hcMw8rsAh3CnYXDYkvrq4fAn6i+Dw+XokwmHTr/1
cAh3GgGHQ9A/3PqA6wtaAIf1+PcJHNL/NBkO4U5zHYfwIXAYCz8L4LAAvtLh
8Ar81fFM5n0pv9vEurHs059904hzgLhp5JFOXrPJM4e8XR1PU1cf6ozsZHU7
Dieiy250CkK3ZegYiq4p6Nz0F9N9Hz50MO6kFT4NxzcfPlbhqxefffjOHNTH
4CICTjbAjeOo558N+pvG/HZtd+at83sch6fgsoLvM+GW/qdhcD2c/WPh/iDx
j3MuhpHfM+7ckH8jztVD1FfRsP9rQCs7l0vQJ45zuxj9bjBfMtE3k/njRf+d
DeeTfkjfuIN/c+krjsOLDeefBtGXMuDjA/rWVPhxc5c5rCX0vTvw5/riV3AY
R990fZR9pQccurlbB4fufrAYDul/MgcO3f2iCA7d3B3A+XNzoRgOlzI3ouFw
JXPlIzj8kblTyvkPZC7dpj8MYm6tgkP6i3jaGIcFzL1gOBzBXFwHh+eYm65/
ubk6Cw7d3LX+d3QP3EmIfVe3PhIOX2X/J+DwCPGrfMZhOPntgkP693/3iADq
Gw2HB6g/Dw7no89AOHRzNwsOs9B3MvMF7mRqkHHo7kVN7rn/BcLhXPx9Aw7T
8V/hcDt8PPI/9z/mq2yCw1Pw16yRPbfyPp/fvcO66exT/6Dtu5c4SS4ueewm
L/qftCi1vBs/a3UklzW8/x3rbnW7+0cHdMlGpy/RbQk6rrvn/rcP3Y/gQyC+
uPvRUHwbi4/pzld8DqX/5MDBYbgYBicpcOM4aglXzFm5/kDoHxMObnT9T/4G
993D+Q==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlgtsjWcYxztWl7YImxE2VLQx6jKXUD36qGG0bFKdbMTUxCUSOlRHurlt
gmGtqNuImktLqY6NGNJnF9FtmaF1X4uqtdjaoxdsC92lz++VHCc5+ZLvnO99
n+f//73/5wt+NyF2Sj0/P78f//v+f+1d9ykRPz7xZSsuT5ASqec91GDdxVxN
7bhx7ZZ5JbI14uHJhIzT2t7/haENH5XI8My8uUcqzmtWu5CwR1W3JODknqNX
f7miSZ1CU89NK5WXpueO+SKuSNfnnXq8Pe62BFw89F3UjOu689z4IN11V6JP
J7av//i6no8c2WV8eLn83SSgVeN/rmmn+rn7I8u9cqbH/UuTZxTql9OKGt+O
qZRBqZfvxw65rJ+dTl56dnmVTDjzW3hyer42LWuf89aGaokv2DMiPzxP6y0K
ez5iSo2cktDAqIn7tDJvatdzt2pkkX/zjT8XHpGYt2esL2h0X270H9UxJuCM
5Nb2K/D+UCMDIrM3pR64Itf+nHmyW3CN9Igv+DTLWyyzF+443KFFtezyrFwW
XFwqkpdTVby9Uhb7r76QuPR3iS1fmJKV7ZXRXD/m/kD+l8FzCazTk3VvsM9g
9lXquEpdI6lzOHW7Porpqz59xtK302EsumxGp8Ho5nTMQ9fO6FyD7hfxIQZf
MvEpCN/S8LEZvn6Az7Xfm+8H4CAWLtrByWG4SYGjVnA1Ec4CP9k2MnxBlsdx
eKKi7ndxHC6z52Utz79u64tbv5FxJ9ns39Lqk/nU9+BCXf3iOBxm/Ynrr9b6
lwL6zzd9JBR9PKafOP2Wm76yAX0TTH9phv5Vg+r8kWfwZ5L5p/fw75j5q9H4
29f812/wv7fxodfhY4fxo3PhZ7Pxpf3ga5hxp+PhL9zuawocwp3uhcNCW1cH
wiH8azQcjrC6tBQO4U6PwiHcqdf6VPrW9XDI+dTRcHjUdNO2cBhiuuotOLxi
umslHO4yX3Q6HG4y3zQQDheYrxoKh3vNd21B/rQyLjQeDtcZN7oCDicZV3rc
OFO4U+PwmAfudAccwp1Gw2EH1if/JIf9q+0cyGzq6wWHKdTf2uqXbfQXB4cX
6L9hU+PQ6XMJDr9Cv15wuBF9p8NhEPrPh0Pnz6uWE+LFvztwOBR/Y8ONQ7jT
7nBYBB/d4HAW/ByEw0j4Iuf0Dfgbw3UJ98lJPc9zk1mnqy/fGurLv37O+SD/
9BJ1V9NH50jry/XZz/f8aQK6bEInd34dh4qu3dG5Mbrn44MHX5hTepP82IyP
Ub75oiHkz244IP8kFE62w80qOHrkm2/6IKMiZ0+HohOOw4Nw6ThNgtvVPO+B
686sHwj3mewfwrlIpj7yT9dQf1vO1W76u+Ob//or5zIYfSb4zg9N41ynoe+d
fJ/5o4GDLReexZ+kBpYb5J96yZXh+Dua3HE51JJcKoGPLeTWPPhZS66RfxpF
7k2CvyHk4hw4TCQ30+HwJrnaBg6Pk7tj4dDN3XFwCHcyCg7pS/Z5jEM3d9+H
w63MhaFweIS5MQ4OuzBX0FmKmDv4INnMpRfhcB1z6y84nMtci4NDN/eC4DCM
uTgADt37WyIcvsNc9dgcFjd3Lf9+OvFkLjOn3dx+Ew67sP7LcLiT/ct5D1hC
fc/B4Vbqr4DDVfSXAIeF9H8WDpuiz0M4PIB+H8FhOvr2gMNA9B/C/HH+rHzV
OPwD//Yzv9zcXQOHzv85cHgbPmonGofvwU8WHL4CX+lw2Af+ZnHdx/2e/C+V
5xawTgB8l7FPf/b9ljqmWS7La9TZhPNDjktYhPXlT59f0zdzQJgLT3RKeur9
bya69kXnPHQvxYc++JKBT3fxLRMfB+Drh/jcnPzZBgeJT73/pcHNGjhqfc+4
GgdnU8sWt0mO2O3yT/4FCSzbRQ==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.87888985206362*^9, 3.878890600427339*^9, 
  3.878892293192197*^9, 3.8788925904306803`*^9, 3.8909814700399647`*^9, 
  3.8909815851444674`*^9},
 CellLabel->"Out[76]=",ExpressionUUID->"a97e5e34-2a31-42d3-8057-02e3ef5848f3"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 5:6 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"e85d8ac9-d0f1-4e24-9871-ffd0b645fa34"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext51c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext52c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext53c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext54c", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878889828885686*^9, 3.878889828890527*^9}},
 CellLabel->"In[77]:=",ExpressionUUID->"6699b8cc-62af-43fe-9936-2e78c94b18e9"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115808498154507`*^9, 3.811580852596011*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"5ef6384f-0d6d-4073-af87-9cee8840d018"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext51c", ",", "pext52c", ",", "pext53c", ",", "pext54c"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878889839221075*^9, 3.8788898392262287`*^9}},
 CellLabel->"In[81]:=",ExpressionUUID->"a36c35e5-add5-4cc2-8b8f-a426b0377e87"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlntUjfkax3dES0VCiUSiRqU4ilSOZ+QamdBEo9RGF6qjq1SYoi1EDJ1U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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlns4lfkWx/foRg2aSagmSmqU6XR3Gc0sRciYlBmVJ6X7INJFoTG5pGNC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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlglQVFcWhluUEAREUBYXFNHoKFFhBMVWPMoQUBJXIm4gQcFB4oKKInED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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVlndQVPcWxyEGnwbNA0GKKE0kBlGRaj9BQIIKhKbiYjR0HcAEzEsggIOB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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.8788898525316277`*^9, 3.878890601080689*^9, 
  3.878892293664974*^9, 3.878892590924129*^9, 3.890981470424264*^9, 
  3.890981585507835*^9},
 CellLabel->"Out[81]=",ExpressionUUID->"4ae9e3de-19f7-495f-b170-397a87752a3c"]
}, Open  ]],

Cell[TextData[{
 "Gather several plots using ",
 StyleBox["GraphicsGrid", "Input"],
 ".  This is Fig.8.3c."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115808498154507`*^9, 3.811580852596011*^9}, {
  3.878890343454084*^9, 3.8788903604186697`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"67f7e0f5-c547-4a1f-a949-62ddd9253521"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pext11c", ",", "pext12c", ",", "pext13c"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pext21c", ",", "pext22c", ",", "pext23c"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pext31c", ",", "pext32c", ",", "pext33c"}], "}"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8788902515034657`*^9, 3.878890319574437*^9}},
 CellLabel->"In[82]:=",ExpressionUUID->"2d3186cf-70d9-4faf-8a01-5df87caff17e"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx10mtIk1EYB/A1PwwtAm2FglazD82GzVspWT0zzfxgHybRovtM04KaUGAX
TQPNDAzNLJWU3FwXhBDNjJodlAmbeYs0sMzhjZRpTWeliFZ6/gs26sDL++Fw
znme5/+TJGoSkoUCgUD551v6d7QvrQkSYNWsVER+0k5Qv1z1M3rmNZncjF3j
kgmKEDe9sIjaSXwlVieOspK/t4dO6tNLQSX23oXpcarwCBhUhvfTr6yXsX2b
x6j6rs7eoB+kVtX0e1H3KF2TH3VP9Bml3FcRN4WWIRKtzt6tOjZGqcPzY3ce
DFBQvKh4g9JKhXV+t0WKD5RYJBMtdE5SfV73QbccM9V5xgVWPvtGAVKTIKFC
S4HythORSTaSUKFnek4z0+wyRzdm2Kjou1BdJulhl1u9MvausdGcn1hWfMTC
Zu0X4kMVXylKvWIgd36EqT/eNz2PsVJwVor7fsM46zyVXmqI+kL96ftUlQ2T
rGNrPZUcGCJdQXQHHbaxtibfLdKEPtp4aLGgNm6KeWvTkr0+m6m8bGlNMU2p
+d2PM7qd/tgfrlreZ1qc7+LnmQX3m/j9zOV95qjvJK+PWVH/PK+fadHfJd4f
C0P/abx/pneeD2txnh/Lx3yT+HyZEvMP5/NnmchnFc+HmZHfVZ4fW0C+j3i+
LAT53+P5My/4kHEf7C38rOd+2FP48g9a9sUc/hT0RlpjZAaHvxH4M+P8dvhb
i/t94U+O96vgT5jN63sIf82oP/M//tToPxT+yl386TG/evjbFuDsT4n5n4c/
DfLJgL9ZF387kG8K/MmQfw/8DcNHC/zp4acF/jbBl7HK2d+txcgbF2NMf/11
w99jnH8Cf0O43wh/YXi/Df4iUF8q/M2g/jn4O+vcH8tD/+fg77iLv1oXf9cx
39Pwl4L5h8BfGvLxhj8D8suHPzv8NcJfMPKvhD+Hj3Xw1wo/SS7+9vzTX5fh
Nyo6nNo=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt1Hss1WEYB/ATf5Q1hXRh2XSZrejmVsKenLmtmUKyOWWFUJtL/tCUsDZb
k7PVTC0T08oSWWqpDXs0UeQSO0SXg0M4bBzHOmoaxfs9f5zferffzh/v3vd9
nuf72dkRmxp+wUwmk4X9+1Z+i++vLC3JsFryKtoaK7TkrfScziupofioB83J
rVrK3lxkMaVm6nbIMt+u0ZJ/0xR/jmujy4t9Uan9WqqOnk/d6dpLNW90+roM
LdXmNJddyh8gy6jkt/V3JqlInnjErHKIxp2tkkoXxsnuStVG/dNRCqqP+O2a
O0Zh7bfUTsUTZK9UKXZZj1C7PMjHK36aNIbCjv2Bg2SW9dxB2TRDHjGT8722
nbQYvDvdvlZHcdsyHT0nyimh7eLRypw5snIZPCALbWWFhfyQonqONJU6rloe
YI36WG+G4xwp3FpOK4JHWV6aYm4onyU3LrgxelPLa77FvtblTlPJ7awX5UMz
POweoz+7/IPuGtaquq/O8eGDH2ajX6ppT9fWHK9mPQc4B27QFHST2+qa5z5V
dtr7fY99jPuuYp+LcN5dnOcy3D8g7mdfvL/wdfV9Pof6/ER9/BP1j4j62Qb9
nRH9scK0f3Y3nQ+PmM6P7TDfj2K+7I/5R4r58xjysRf5sDXyU4r8+BnyfSXy
5TTkXyfy5y748BY+OA5+SoQffgdfX4QvNvpLb42YtvBtaDDuJ0n8nYe/Ttwf
Dn/peL8C/p6gPoY/G9R/Hf606M8W/o6j/1D424T5dMGfHvNbvib8RWK+v+DP
IPH30NkkHxqW+AtCvifgzwP5/xH50yP46IG/e/DjJPFnKfG3Pr80xCuz3ccF
+z17hb9inLeAP+P9Kvjzw/vz8HcK9QXC3xLqH4a/76b9sRX6T4S/HRJ/Bsxv
ScyP12G+/fAXgvmHSPw5wp/x/6MQ/qqRbyP8pSD/Rvj7BB9b4C8Bfk5K/AX8
119Hw1+Dd8lV
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJx11GtIk1EcBvApdCEoE8nKCDOv4Kdg0Addf5mVBKWuUCOQQnEVLTUrNGEu
ApW0GyS6QlMbWrRmZV4SJ8cUStNhiRjOmW3idC7LLaOcpaXneT9M8oWxD4fz
nvN/nh9vQErG0TRPkUgk+/db+pcvP1YS4XlfFL4o1ViJrm0uGcjNo7wk5fn5
uAl6WDL4OqJXTemJO63FsZO0NVM/p/mto6w1P5paFDZS1Kha/T630Ut7aUqB
fIr8O67E+5i6yZ7bHBbwZYpEFrOrc/cAPf5q2NX5ZIqU6yNqyodNRH2PNL5J
NjL9HD51XDZG1u1GuabZSvkLkRmD8knSJ0f5f9RZSCbeVlJ0YJpOu4Kvz+cY
KbSvwhzVNkPxi9Jf4vB3FLRxtNpyyEmqMsUF6dtqNnpsyOnr+53iYh48Ta/s
Z8aO53X7553Uc1nV5bhlZuv8irPlYw7SZa2trY61saqUaW+p+hvta/bQiz1n
WE93Qpr9to2skuTyuXtOZvBs03a5zKT0a088KZlljg3GsNA7/WToXXpmmcRb
7KV21EYK6y6+zsax/wPfz6Lx/nb+ftaE8+/z85nB/X4sBvc38fuzAsz3ic/H
JJg/mM/PspFPMM+HNSC/BJ4fm0C+hTxfFo38h3j+7Bn6UfB+mNDfH/Nyf6wB
/e7g/bKL6D+T988EH2Lug12FnzfcDxN8Tecv+2KCP80Rm+5M4yu9sN4Hf0rs
n73r7q87g/sTzq+Av3rcb88Kf3Z+f9Jivhz4k2D+UfizIJ+bq/grQr6B8JeK
/APhb6SU9zMCf0kr/L1Av5tW8XcQPlrgzwI/w/Cngi/bCn83tnj4LOh6I/Ow
PgN/E+5+2WG8Xwt/rThfDX91uJ8X/Mnc78+MZW7zsTDMHwJ/55BPEPzVI78T
8GdEvmr424v87fBXhX608DeO/vz594M1ot9U+LuE/kPgTwEfZ+FP+H5Vlrr7
Uxb+z1+X/i9vetx/
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdVXlI02EYXplhZrcaGRVFVIpdmBk1eT0oi4pOQgk1LSklUDvISll2GYKt
Q2tGpBi1ikIijw7trcDEnOU8KMxW20ycm6SmVrgO5X0W6A+Gf3x87/e8z+Xs
2MStcSMVCsXRgd/g3xrd4GcjBT5T0GGf5DobndX4j9ZW3STTl4ZYk9FGZ17e
rnDxKaKo7Lbi8j4bzemduU/tzaT7kPnYNqaDnofNKonRVJApJ+J3/6QOyut9
VHEoUEfLa7TqHKcOUuXtWDC3Wk+rn1XtnDEwv3HhA4tzQyMFN82ITEiy0Sc/
Xbp5WROFdU/5fllvpW0FqZ+dTQbyV89rqLS005ujS1SRLUbqPftqxfRCCz1Z
bzH92dtC19NdgtZ5tVGo5uGmF7ZW2rGsQLllfitdLXC6khFjoYye6DhLo5nG
NmnvexVZ6dC7CTPLvY30sy4xwbWug77VvjaZtjfT1KTFCu3db+Q+ZndQ8+tG
cq8taD6S00kjUtQRJVk1pPLVlgfM7aKTHlWtbw3ldPHgjRX2412UqKnS98Vf
Vl7LHfy6aI+cs+PcX+5zGu67yXx2zO+U99kT7x8QfPwL+M4JfnYF/mjZj7Ow
3zXZn8Ow/0/hh4vBj5/wxzrwt1b45a3gN1D4507wHyz6sAX6+It+fBL6mUVf
zoW+NaI/34X+8AdHwR8t4h8eB//AX1wNf8F/nFR4PupEfanScb5fzhn+481y
nx3zF8l8rsb71fI+twBfuuDjJcB/SfBzKPb7JPsxYf+vsj9vBD9rhR8OAH+V
wh/bwW+h8Ms3wH+w8M/h0Cdb9GEV9Jso+nEK9O0Tffk39HcX/fmXi/jDU/zB
E+Ef+I/Dh/qLY+Iu/Ci1vyiD//j8UH/y1yPi3xO47wx/e2B+O/w/De+nIR/d
wHca+XED/kjkS+3YD/nbhf3/Ip/3wM9K5PcV+HPkOxz8hiL/H8G/Ev3gtkj0
WYr+uAX9PqJfvPpE31r0Tyr0j0Q/HYY/HP2lgX+M6Ld++MvRf+K/yjIzzgOH
9V/AsP7zgL/1eH89/G8Avnbkww/4s5CfddjvKfK1Cvvbkb9A8JOCfIaAvxLk
1yVD+M1HvuG/AbyS/3jocw79cBD6eaI/MqGvFf0ySi/6T0b/zIY/pqCfsuGf
U+ivkZ7irwvotwxVveFWquV//yUP67/3cp/hPwpC/03AfDP874X3jyEfvcCX
jvyMB/4Q5Ose9ruC/G3A/u3IZyX4WYD8fgF/a5DvaPCL/z9sBP9b0A950CcA
/ZEM/azoF4K+b9A/dugfi3660yP+MKK/Cof1n2/u0P7LdrKuyTfolf8AxkFH
kA==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlHtMzWEcxsNxclmFROQWtlPIXIZQ+7LKXJaIyaWi455cQuMchYWKHeZS
SOuMrYxuk9Vo0tfKXcacTLlWLqlToZg0Npzv82s757ednT/eve/7fZ/n8zzu
2q3Bazvb2dnp/v3+/59L/f/Vkx2+gJ4qt6br9RQ9uTrG2BLJe43js2/0baD+
hzXttfUbONHTVxd+sYHCrqxaMj19Gw3dPts3Smsm7emompmrU8hzcv6ms96N
lFkd7Fy36zKF7TnY8se5ifwizF/Pn7tGnp06R7e+aqIgTcAIo3MZXTq4oCg8
ppnaJox/dsyrnLrP21S25nYzdc11jZ8SZyL7A7Nc5+Y105sZgeUrjFVUkhHw
PMStmUaui0zqqammgl4VCeltjXSyXfdjY9Z72jJqzMPNU83Ua3+fBS5T6+jq
ikhvfeVnqqxyT3O50kDz82v26Cs/0oPthu9HzU2UFO5gCPavJdfkNL/QNV8p
eGX8wo1hr8kp+nHEl1PfaHNRxMMkrYlC2vIO9dvVQj+zgzLdc8vo2aMjiRe6
tNLzir3b7nml+Ey0fK1UJ+usrO+X/bwY+2fK+aycHyv3sxvunyPz8VPMVyDz
80vMv0Pex454X6G8n0/g/TdFH9ZAH5Xox43Qr4foy79zRN/Loj+rJ4r+HuIP
a+FPuPjH8xX/xF/eB3+Hif9cBf8ThA+OAx/ghxsMwg/44hPjhC/wx6JjoY8/
1msmWdY79gedtOwn8MfrCiznM/jj4XI/azBfpxrLfByK+d1kflbeN1fex+CP
zcIf20MfR+GPHaDfLdGPFX2Hir5cBP0Noj/HwB+1+MPZ8O+d+Meh8LdE/OV4
+D9A/Gcv8NFb+OAo8AP+WJ0jfD0Vvnha+5Z4x6TSYvDHL6z55MXgdyn2+4Bv
5fzd4H8Q7l+EfNzBfBnIz2fMvxX5clLeh/xl4P2lyOdA6OOE/BZCPxXy7Q59
s5B/E/QfjX6Ihj9Kf6yFf0q/HIe/4I/iUsR/8Edv84WPfegvvzPCD/ii0mnC
l9J/wt+dYj+srw8QPmOx/0eidf+F5lj3X59k6/6rsOk/FfID/sjXpv8GI39q
6GOP/usG/aqQ37vQ1wH5zoP+yci/Dv6o0A+58O8N+mMV/C1GvyTY9J8RfKjR
Tztt+s9F+CPwR1lFn7zLH5s7+u8e+s+E9UDwuwz7deC7B86PAf+DcX8Q8nEf
85UgPybMH4J8jcX7biB/h/H+Mut8dvRfO/Trgnx7QN9c5P/DBOv+i4U/y9Ef
epv++/VO/FX6xz9V/Degn75kCh9x6C+9XvhR+i1iiHX/zaASj+zbT3z+Ahsb
46E=
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXlI03EYxkdmp2azzCCQDrIDCkKxnFsvazbN1MywQzpUUrLCSMQyTbPU
ysx1eYSiBl120IUIUb6dTNi045+hslIpTTs2c2EHdvk+C/IHwz++fN/v+z7P
532ckbArOnGEQqHI+PP7+zdp6OsiBT5brenXgtIu8iwtSa2ruszxfi/CCmd3
k625zjXYvZ7VadoF1Z7vaFHIUsvd5w38c3SgW1lMD8U1DMauXfKQN5tt2mRr
Lw3Oazq5If8BL912fc44wwcqDFU+/Opyl/ULe64a9Z9ourp5udH7ChfFbtYM
tNroTvbA4lWZZRQQ6utWbbBTeM1I647kBrIGHqtXOOzkula7rOVLE4WvvLKu
bVQfTYvsP2ePtVD59r1GW72dAvMy0vr82ynqxsuaggEbHc1Oysl684Ymd6RH
Tz37kfaZcmtHH+mhHW/XvciK6aXD1uzYup6PlG98OjNB1UUVIY3e+3rtNJho
9b8d30FdKXEmU9FnmuX73JrZbqGJ55W0ydhPx0/ddGuKbKRXreOeVhY6SKP0
9yjvK1U3mf9+DoqWc36N82Vynyfgfp/U517U3y/vcxXeT5b++Bj6U0r/nIP+
o2U+PoT5MD9rMP8K0Yf9oA/0Yxfot1j05bnQ97jozz7QP1T84QvwB/7xVvgH
f9lrvvj7S/znBPgPPlgJPhKEH/Z5JvyAL7aUCF/gj1XfUw5OOHJb7TyfLvzR
FtzXyn0KQv1AqU+KMfJ+sLxPW9CfQ/gjFfo/If1TCOabIvMR+OPQnKH5eQn0
2Sv68Cvo1x0zpB9HQF8X0ZfPQv8A0Z/D4E+R+MNj4V+B+MfZ8DdD/OU8+F8p
/nM3+PggfPBq8OMm/HAj+AJ/7GWIcE+c9OQe+GMd+OzAuQr8euB+G/i2oX4m
+K/B+0nYj2L05479OYD+ddivEsx3Gvu3GvNDH+qPEH2gH00S/pz6khn6FmP/
8w+I/uHIh5Mq8YeQH20h4t825Ms5+PsD+XMf/muQTxV64QP80TXJL3Lm2y3h
j5z5J/w9uuc81yP/NuH+l2H5917q8yDezwX/W9GfGfkXhP4DsD/BmG9NkOzX
Cczfif1z6rMR++nUr0X4oyjo2yL60hnor8X+r4I/hcgHb/iXivzYDX9zkS+H
h+WfR5Lw0Yl8Gg9+PJFfBcPyr7n/26nPPp/+5Z8FfFpx3jlb+PXC/RlSn62o
nw7+wR/FYz8M6G889icP/euxX5WYrwL75zcs/3TIv1bsby3yz7nf3dDXgP13
ZIn+YcgHHfJPg/y4BP/ikC87kX8uyJ8o+K9DPhWDD/z/5HLwY0e+DZT+n3/r
91x87GU2qX8DnDUdkg==
           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXtUjHkYx0tLuUUkl6yUU4RYrEuJJytspCi1tsVqU4fclk2hQpQhy6Kr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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXk01WkYx283EqdJi7GUJiMNbVpMk9NoHioxmbJNhtEizdUJLSQmY2+x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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdlXlUjXkYx1vQOiYSKk2Ui5np4FAaomdyRJaUDAphmnGLLB0qSpjRHQa3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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[700]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878890321593855*^9, 3.878890601960557*^9, 
  3.878892294331737*^9, 3.878892591497311*^9, 3.890981470620462*^9, 
  3.890981585684585*^9},
 CellLabel->"Out[82]=",ExpressionUUID->"710f9cdd-9634-4eb7-ae5e-910dcfe770eb"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 1:3 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"bc8be5a0-9182-49fa-a1e2-7e7163494184"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext11d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "40"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext12d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "40"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext13d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "40"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext14d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "40"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878891313150784*^9, 3.8788913131565933`*^9}, {
  3.87889152970435*^9, 3.878891555669133*^9}, {3.8788915918501167`*^9, 
  3.87889159673857*^9}},
 CellLabel->"In[83]:=",ExpressionUUID->"0d496c42-458f-4c79-959c-1f5d8459b929"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811582008273028*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a5b420e9-e9ed-4407-866d-fa1f85806296"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext11d", ",", "pext12d", ",", "pext13d", ",", "pext14d"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878891581661181*^9, 3.8788916141407623`*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"4f89bbb6-78dd-48af-9dd0-309fcfea55bc"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13lQ1GUcx/ElyQsS1JoUMsoQSYOy8ArsMcSDpENNEi0QE9OUkEkTiEOO
UYpGQRk2dhUstRIUTTKlVh88CFe7ENHRFBc2zoUVNPAqKXveNLNMzDj+8Zvf
8Tzfz+fFw+OLomZH3KfRaNr/+Xfv/59+vPfTIjT8JMZGeOvSW4TO2feJzFtS
fN7+THiBwSKOffrupGklv4j0vHUPd73bLCyNT+pXx50XOUbdbCdto7CPKP5y
wcFq0XmyIvra1Hphf17z2WsltSIqoHxKTqJZLN8Y+cjxsjphjp0453agSQx6
IrTr5MpG8WblSv/KJReEq2NmR0ZBszDmuJwIzqoQ7kZreOfbLSJOu/nEJ0uP
iXElrmNGbGwV04u9T5xckSBm2CW4trpZxdCGyV5L7pbKR+e1nop0tArD4d1+
G+IqZFm2487Cl1uFPDDp0IYZF+Wl4PJtI00WEXT95rUXQmqkp1PSF8tPNInW
Oc2n+02uk1uyXtEnd9WL3Y2FkesNjTJo7OComXqzuOy57NuUYossWOi5d8nL
V8Rw3fxlux2s8uOw0fqQ5efE/oEzvPKKrsoD638N7pVmFAnpHUNaA9rkO3HF
6zxDd4h+vpVRl6e3yQ+3btdvr5LyoaJep6ceuirzLrftKYk9I0Ombi+qsrPK
DZufq8s+cEle7Vi9PDPaIgPszo3/08ss5388qzN/cKOs3lewKT2zQca7BWhH
3jHLAT7m2zGhFrnUb3SBObVa2ofnenissUp/f9dFe5zOyk2vxxz2D2uTG8eF
jFhdflSaJxtGPuXULn1S53/T772d4o+sxV7aKe1Slx4UO0z3ozjqVjVYe7NN
+jtrZv+ef0HYpfUPCfJukwb9jpQAj1rxfPllT82ZVtnkZlyRdrdebLY/6em1
qFl6z10lR4+xiNX310V+PaJeLpzgk5qvt4qcwpulo/xqpMk0MfpIZpvo/3qp
X2zOeVk2LSH+XHC7yM190n1UR7nU5d77aRdRnxorOpcVG37geoK6Lrrvd1T3
izCer1XPF4/z/lT1fmHl+zaq7xMVfL+3+n4xi/Vp1PrEt6y/VK1fbEqx2R/x
vu3+CXf2N1vtr3iT/e+r9l/EMJ8H1XzEYuZ3Vs1P1DHfuWq+Yh7z36rmLx4k
H4UqH//lJ0rl5798fR/7b77kAfIXr/Inu/P5icqnPEt+jSq/8jvy7avyLVts
8y8F/XhW9UOa6E+V6o/cTb+Mql8yjf65qv5JX6n6Gaj6KZNs+yu/pN+jVL9l
KP13Uf2XV/DhIeWDjMCPVcoP+Tu+uCpfZC7+3F38rz8yDZ/+Uj7JnfiVq/yS
yfjWW/kmu/1buXdD6NrKckMS1zPw7yvuX4F/H/H8BvzL5/0N6v3CwvcNxL9I
vj8S/5pY3wD8e4H1D8c/yf544N8+9s8H/z4os/XvQr3a/2H4l818fsI/I/O7
iH8+zHcC/tUy/x34l0c+QvGvmvzswr9h5Gsn/hWSv6fTlX/x5DML/xzIb/IW
5d/95NupWvk3l/xvwz8z/XgD/yLpzyn8y6RfGvybQP+c8U/Qz8345zNe9deE
f0XJtv4l9vAv2NYHWYYfY/HvKr5k4J87/qTg3yv4tB//qvHLE/+O4tuLuv/z
r9JwnOsW/Kvh/q45yr8Qnp+Pf2N4fzT+2T2mvi8J/zr4/iH4l8j67qQq/86w
fol/9ra/H4QJ/2rwbx77m4V/g9h/F/zTMZ9bzyn/pjO/dvxrZr5B+DeJ+d+X
rfxzIB+38M+R/LhtsfXvVfzbRf7CVP6kO/lci383yO+r+HeYfI/Fv4vkvwj/
1tAPB/xroT+V+HeIfpXj31b8c8E/79M2/ZQf5qj+voh/VfR7OP59RP8H4t81
fOiLf2H4EYN/Jnxxw7/u81dvdf6SKfjUp0n5V4hf/vgXj29DB/6ff+cNMVz3
GKT828/9DVrlXwbP/w3/Snl/LP5Z+T5H/Ivm+5fiX584tb7bw5V/37D+3vjX
S6v2xwX/LrF/fviXVmLz+0VMbLD1bz3z+Rn/DD3Of4uY7xD862D+2fi3h3y8
hH9N5Cce/4aSr334t4/8neL8l0g+Wz5Q/j1AfqfrlX/O5Ps457/F5H8u/t2m
H2PxL4P+7MW/r+lXo+qXnEL/HPDPgX5q8W8W/l3BP98e/oXT/2P4F9jj/PcZ
fszEv2b8y8S/IPyZhX8L8EmHf7X4dV35Jbt9q+xx/guPyLxx8E+ToZzrU/Cv
ifv34t9Mnn8Q/97m/ePwzxf/ZuJfCt+/AP/6s74+nP+srP8I/q3Bv+v4dxz/
avHvpR7+rWX/7y5U/mUzn7/wL4D53cC/BuY7B/+6z/9azn9Dycc6/OtLft7K
U/4lka/KVcq/78hfIOe/AeSzGf/ukN8A/Gsi310+yr8r5H8X/gXSj9H4l05/
LPjne0T16yD+lXH+eAz/2nbZnv9e4/zii3/df9+NwL/B9N8b/6z49wD+vYUf
ifinMSpfOs8p/zbhjzP+LcWnePzT49f4XOVfGr4lO9n6l93LMm1bdY3hb6iG
GuA=
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13tQ1WUex3ECRXISE01ZgvSsmrQiumtLG4kP6CTtxA6mlkBBBB5EMUC0
khQXJN2TV+TibZCErGRzvCVmdeLZdgtdNOXiFXIRBeRwPYBCi667m983zZwz
nRnHP35zfr/n93w/n9d5MMQkzTM6Ojg4dP3/30//79n908eiHPj8Piphw+m3
LMolvKJz3L7PVWaFj3HOwxZV3FBQOiL/lDK6N88e/FKzijb3ZIceqlSmdfl/
n/fCLTXJ1zukJ+OyGvR++oollkY12Vqx972Aa8pQ+fn+ab4NKify+Zyh8fVq
xRHvJ8eOuKEWvnky+ZURDeryvs5qo2edyjs0LnTs5ib10umqVTXBV1Wi2Tho
5KlmVVbT1555oEptj+mv3nWoRVnHOJ0pyCtTl7J+mLF7SptKWbEja/Wkv6rg
wjFN6b7tKj6qOWyLoUQXur1WmJLfrsytzuGZsWd11H/D83ctalc3kp325AVd
1p5VnTrjnTZ1rebf3h95Xtd/vjLvqbfLW1T2I0MDc5c06N7JhecOhjUrj/Ht
kfExzfrtK8m1IRMaldGSlu9V36oTXp//m0nP1CvHNUe8tvytQ9/szTnrO+eq
GrLS7O+VZNV+w/s+c3Q5p2aeHJfv5tqlL2WXxbW9fFg1LVi0ZdZvu/Swnqjv
D1wo1Z8dN639tMKqpxp3nvtTerUe2et+oKiyU3eMOnp+88g6nfpDYUtsb5te
3J/i1OXUqIdfu90/2MuirXWOt+betWjD3cBXjZENOirt5vd9Mzv0P5OPvvLR
sWva6UTAJyGVVv3xEs97vu9U6rVVcWXzHbp1ec7xXO/jR3XLsP5Wj4JufXhw
5QfZfd+oCzUqdXZhtz41Jf7enJBLqvMfGYHuzt3aM8+nePf6erVz7323+nNW
PdIn6f6IN26poHZDa8OQDj0nKE3PymhT7d9WLumIs+ix+5Ou7IywqoTZ20Nb
6m9q/9rsg0+2dKmdxeW3g+fV6sXpRx6deL1b3Rp/Jsyx8oye/uDToy5eWJt8
akqJeSnX18h1NYPvm+T7yov7r5T7qwCef1uerzxY30xZn5rO+rNk/eoi79cu
76d6eP9qeX9lyJX9aZb9URvYvwzZP7Wb/XWR/VU+7H+E7L96lPnckfmotcwv
RuanhjPfwY89mK8amL+fzP/nfDwk+fg5P0bJj3YhXz6SL+1E/v4l+dPLyGek
5FOPJr/vSn51AfnulHzrS+R/g+Rft9APD+mHHt8m/Vko/dGR9KtI+qW/SpH+
vSD906Hu0s8K6adupL+bpL86iH6vkH7rs/R/j/RfR+NDnPigPfFjh/ihu03i
S6z4orPxx1H80a/jU6b4pDPwq1T80n74Vhj2wDc94J/k7zvzs1wPlevKxPen
4d8y7q/wbyPPfwL/+ljfXPybwPq34d8a3i8E/47y/kX497Kdf9+xf1vxL439
PYt/qfj3PP7djbSZj+rBv3D8q2K+T+BfOfPfhH+rycdQH/Hv1+QnAf/iyNdS
/Lu/WvLXh3/O5DMG/54jvwtyxb8G8n3ytvhXQv5/hX+P0A8X6YfOpD8L8O93
9Os8/rnTPyP+/Ug/75eIf630913820u/Lfh33Lb/+gt8sOLfRPzIwT8vfPHH
vyD86cE/d3xah39/wK/9+BeLb3sn/JJ/F83xXC/GvwC+n4p/j3H/bfg3l+fX
49801ueLf/6sfxv+TfWV92vGPzdnef8q/HPNs/WvlP1Lw78K298XNYT9X4l/
BuZTh3+rmF88/g38vnXL75s6xPxNdv7NlXyoGeRnYp749zD5csO/H8mfa5/4
l0w+w/BvKvl9Df/2ke8m/Osl/8vx7w79GIN/gW02/dFZ+Pch/kWk2Jw/9LP0
sxr/ltPfQvwbRL/X4Z+V/m/FvxR8CMc/d/zYg38d+JKAf+/hz3P4F49Pkfi3
Hr8S8W86vu0K/yX/Lpqncn19hPi3ke8/jn+J3P9p/PuQ55dMEf/usr5g/JvE
+jfiXwbv90f8G1Uo75+Of1vZnwj8y2f/duHfCc5/NfhXa+ffGfzbj3+dLTK/
ePzzWy7zdcG/0bUy/2j822R3/vMkP0n4F02+EvGvg/wF9dn6l45//uS3aYft
+W8Z578vyH/ZIvHPQD9KOf+9T39C8e8Z+lWOf2Pp3xv457xc+nkP//rp7yr8
O8b5rxX/dtid/7rwrxX/anPFj0/wbxS+BOBfEv58g3+j8cmEfwN+JeBfDL59
beeff3/iOlfTDXMc1w1yXQ34eQz/DNx/Mf6ZeH4R/vmxvqfw70vWfxj/DvJ+
Xfg3zc6/Ndk252N12M6/YPb3juyveoj9T8U/D+ZzA/9eZH7F+OfKfP+DfyeY
/zD8s5CP2G7xL5D8rMwS/0aRr95h4t9ozn8mzn8h5PMv+Pc0+V2If1fJtxn/
TuPfdvzbhn8++LeU80Ms/hVE257/8t+S/s3CvyD6eR3/ztueX3S07flGb8a/
I/j3Jj5E2vlXhH9D+PvycfxLx5/Z+Dcfn07j3yr8erFR/Bs43022O/8FqlLv
T7+tM/8PvsU5FA==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13tQlFUcxnGCiszITJGoLEBJ0coQYonbES9UOmCAIGhMZRE6jqXkJQwt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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt1nlQlHUYB/DlCBAsPFDMG9cDL9QhNUB5QnBD0RRQUDDNkpJSaSSjsQzM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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892294877804*^9, 3.87889259201799*^9, 
  3.890981471069972*^9, 3.8909815861091413`*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"3ce6f414-d4ff-4801-86b2-c8848ce3aa18"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 3:5 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878891692634336*^9, 3.878891693759428*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"5c315b46-5b33-403b-b96b-656b364b1562"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext21d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext22d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext23d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext24d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878891313150784*^9, 3.8788913131565933`*^9}, {
  3.87889152970435*^9, 3.878891555669133*^9}, {3.8788915918501167`*^9, 
  3.87889159673857*^9}, {3.8788916470191727`*^9, 3.878891670613721*^9}, {
  3.878891730374497*^9, 3.878891739510613*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"92469101-fc59-49bc-b764-8f30eae58316"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811582008273028*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"fc03fbae-da6b-4e1f-bc2e-3ca18d7236c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext21d", ",", "pext22d", ",", "pext23d", ",", "pext24d"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878891581661181*^9, 3.8788916141407623`*^9}, {
  3.8788916753396063`*^9, 3.878891684053443*^9}},
 CellLabel->"In[92]:=",ExpressionUUID->"c8a22c6e-b33f-4142-8634-173275000cbf"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1XtQlWUeB3B0WUSdldQ2JWWScYEJsUILNoT9qVxUNsvDKnC4JIkoJzLa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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1nlQ1OcZB/AFrWgCwYlEZYW0LFkwRTRyGI7Uh9KWqjWKSC7B6BAVQZqQ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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1X881fceB3DlR90mlmp1m2XpUveu272p25pfb05UKv1mtkuPVqbW3OVG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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1ntUlHUaB/CJXS+J0tFIYRVRSiIp0B0BEZzHZgEFYS2UDNFzShSRo6CU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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892295406063*^9, 3.87889259248553*^9, 
  3.890981471452566*^9, 3.8909815865299807`*^9},
 CellLabel->"Out[92]=",ExpressionUUID->"ac7cae0a-d154-459a-8bfe-fec357c4ba10"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 5:7 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878891692634336*^9, 3.878891693759428*^9}, {
  3.8788917923425694`*^9, 3.878891793568647*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"5c4ff47c-c546-4e3a-8803-f1b63f667fe8"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext31d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext32d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext33d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext34d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "5"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878891313150784*^9, 3.8788913131565933`*^9}, {
  3.87889152970435*^9, 3.878891555669133*^9}, {3.8788915918501167`*^9, 
  3.87889159673857*^9}, {3.8788916470191727`*^9, 3.878891670613721*^9}, {
  3.878891730374497*^9, 3.878891739510613*^9}, {3.8788917994046373`*^9, 
  3.878891832285042*^9}},
 CellLabel->"In[93]:=",ExpressionUUID->"5cc3a98d-5114-46c0-bd0d-3e3a8dd1cc00"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811582008273028*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"20ab887b-c428-4df5-a208-7d9124a72af9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext31d", ",", "pext32d", ",", "pext33d", ",", "pext34d"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878891581661181*^9, 3.8788916141407623`*^9}, {
  3.8788916753396063`*^9, 3.878891684053443*^9}, {3.878891836709979*^9, 
  3.8788918455142183`*^9}},
 CellLabel->"In[97]:=",ExpressionUUID->"680786b7-a668-4c0e-8870-17bf4d6cc386"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxtl3k81XkXxy1JmhEqk6ZVqER7KNSJFm1MUYPyEGVKRiLJpE1RMo1p1Cgt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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3lczXkXxxvEY2wpRalETE1oRtqmxZlJNe2WGcIYTGMpS3aKGJoJjyKi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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVl3k41Wkbx6neIiZmSTQpjKSYGpKydVMxZK3E2HrbJJKinRGTZaaIUdZm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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3tczfcfx0uUrsqo9cNcEpIVK6LkPZOKUq6ty6y7Fgm5pMbIYpIVRnLr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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.87889229598944*^9, 3.878892593021269*^9, 
  3.890981471897539*^9, 3.8909815870312843`*^9},
 CellLabel->"Out[97]=",ExpressionUUID->"04c640c6-a92a-43bc-8512-d86a86a354e4"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 7:9 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878891692634336*^9, 3.878891693759428*^9}, {
  3.8788917923425694`*^9, 3.878891793568647*^9}, {3.878891866139823*^9, 
  3.878891867639566*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"c18d6a53-b68c-464b-9efa-517c3df9ff58"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext41d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext42d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext43d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext44d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9", ",", "7"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "20"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878891313150784*^9, 3.8788913131565933`*^9}, {
  3.87889152970435*^9, 3.878891555669133*^9}, {3.8788915918501167`*^9, 
  3.87889159673857*^9}, {3.8788916470191727`*^9, 3.878891670613721*^9}, {
  3.878891730374497*^9, 3.878891739510613*^9}, {3.8788917994046373`*^9, 
  3.878891832285042*^9}, {3.8788918775850897`*^9, 3.878891901599208*^9}},
 CellLabel->"In[98]:=",ExpressionUUID->"ae762f78-e6e9-429e-aff0-cd0c35513ed5"],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811582008273028*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"749579a0-9988-40dc-b386-5f5be116c6b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext41d", ",", "pext42d", ",", "pext43d", ",", "pext44d"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878891581661181*^9, 3.8788916141407623`*^9}, {
  3.8788916753396063`*^9, 3.878891684053443*^9}, {3.878891836709979*^9, 
  3.8788918455142183`*^9}, {3.878891905004848*^9, 3.878891912849112*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"a9357fba-7ee0-416d-a55a-331b8e9683fd"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdmHtczPn3x4dQYd0vXUS0EULoQqkToZXYlGssCpGlDblFdrckFaJSUmuT
+yWELqROUWzpKkmqqekyNZpqGmwX4mfnnO8f/eaf/pjHNPN5v895XZ5jnX+z
39JTIBC49hAI/vubm/PfSwoCfpXt313+/q0UfmzdtGyO8p8wR80nMeCLFNxv
3VY2WxIM911X3j9i1AQTzC21UkMvgPKVAYsm/9EEaR1Ou+zMrkFQYvib0JIm
WDV6/uyvj+5B4A2HzZ5GzVD167InwyYngsf0dq8/g5vhRkpp3LahCMYRBYke
4mY4XL2lKHdeBiSLHopD9Fpge99Kh+z0LBhS3R4t/7kFTi9+WTz6Wz6Yhzyq
rXRogWfzJ+ce2FsEdumybDv9Fvgl/iXkGZdA37DbEutXzZC6S8/O0rAM2j7s
sZ1p2QydWsMmh6ythPZI/xCz3U1wWNylo5cjgsxG2ye/u0hB/2pbyKL3NXDJ
efMsU61GeHd9ofPHL3XwNV3ZPPecBNapRH3S7KiHsIu1fvEV9RDRZvuvw2sJ
5CW56G+W14H2AO2t5r6N0GG22KpHZQ2UJ662blBqglvDJv2hESsCHRPHnro2
zXBlyPxffPKEsKD+6L3078/xpnPVE5j+Dq7GzhiyeqAM9u0b1693RDHMy0lz
918hg6j8ILMCzUKYcurr5HNeMjB6orJzYVQW6Kqo+V71l8E0OD14/9F0cDfP
sko8LIMZKD96VushbIvTn+rrKAPP0Uoq6uHn4cP2f0LtJ8ggofhmVEFnKN7c
YdZza34LmAVpTywW3MXGyLJ3Ny1bwGRvgEeAdhLqqH6bF3SrGUS1l728DRDz
Nsy/e0qtGQLDQzJObHuKxo80p+sGNcGB6TO1fc5loJrIdd/x4U0w932v3gEL
nmN8lqfR3ntSsApvljWfeYELWiF3yCYpOL8weht86R8MSPc2aJwqhdFvl+Zs
i8nCoa+iCuVDpaAaHiUrSMhGJcnY3pGDpGA2LCWhUjkH/1HKyJeMlYLNNan7
tUe5WGRlZxVqJYUKk8OD/mrMR7/ChghNdymUt22ODF9biBsMYytboqXgL8rM
tRtZhKt11XWj8qTQX9JpMWpqMSYkOIV+k0nhvnG4YUV0CeID2xeh36Sg02W0
Q3fHO1xY9s3geasUOqpLW5Yer8Cbyl4atigFR8/Cp1UeVZhukNQnaKMUjnkl
v7tnWY2unecOqOQ3goXvhM7g0bWYfO9VW2TvRjB9fmanSy8x+md7X68WvIcn
FsOzV9bX442F425uxgaY8vtW1SVPJPhq0/5zT+bWg+mnsfGbDzRi4YL4tzEB
dbDKrb5+w+Am7IyIwcoLNRChpp0/7EgzlqYJBbq+IkioC/bLT2jB4jkGK6ID
heB2X/C60FGGC1RbFs0oLoX9azUzlifL8MtOJxenL69B8OTruCFfZFh2ap/3
tZEFELR8iYO1Vit6zdS32XToOSy5FDPcWrsVp2r2GycZ/Bhy50cecFFuxa7f
zoK7UjTU3OqjLiyWoX7iJ/u31Rex+sUAg4tBMjyUPWmQRmAS9nru8Jv+bBle
mr3S48DSZ3hn8E9TLtxpwc9+BSuVjmahqa6DoLqiGW1My7e8FubhF3+1CXGq
zWhpOeda+d1CNBx/eGG9aRMOVtvuGedXhEv/illoe1CKXiHJ9s1fX6NwiEP2
vJeNqFrjoVqn/QYrthzqecKoESfuNshN/vwGxW2RZ3WS36Oh8ZDi6r9LUHv2
em3DX97jMJ9wDc8xb3FzibPVOM33aNfS+e7aybdoWKSUc0MuwUCNBwuqut5i
QbnJD8pVEgwXx+/Q9inFZYFpEeOFElwWPbnHuGnv0GAmri0RS/Bz0OxVZwaX
ocnZD8Vd3z9/rO9E0TKTcsQeI5WyOyV4e8/aWxU3KtCvf+gD+ScJ+toUbcl2
q8QZ5VHKHWUSzO5pEZ7yrApH7RQK9l6W4ArH2k1/totw1eMT1a7WEty7/t+D
mvY1ODC2SX4hpQEXTr+b3JFdiyo3p95pEzRg+0677Iy1YsxcPiAzs389rpK6
xN76XI+5t88vGSisQ4/9SavToiWojjenZeypReep6sucLBtR8JNyjTCvGttG
Lu17O1+KfXZNFu2UV2Ggqd/QD1bNGHDt5FTVFxX4aPWWNzNCWtA5ZdQkPftS
vHPSKhe+z9WFt9WTHMNfI4x6WjqzQIZt9+M7kpbn48Y/AqJi9FpR2WWWRsDc
TLwalhaX4tSKv6Yc07s8PwF/SEpdnOf5fY4Sfq0UWHtj3K6wS2YerSiSLjl9
WS0OlHSt/zz6cys2G6/R3fsiHUSWTyboD2zFj+6S9bau2eBihIGRCTKcYezQ
a/ykQujV+pNt+yIZTu8YfrPXo9cwQFeaIo5swcJRjfny0hL4csLrlE5QM/a8
fuXgXf938OOEs001+5tQs8xom1JWOcQPdLAYu1GKW2s+NwRHCWGGrXLImGWN
eG67unBBnyqIDXCS9XZ4j7PWj7bSDK4CbcsxBb47JHjCRt7xqL0Kim7ddwuL
acAz+40CR8wTgVGX+n7r9no8ntFhIdwngv712kaxbvU4W/RyzcRoEdRG1/uL
e9Wjm4fKh0kvROApdzllmiTG+nFx5yo+isD1TqP3oqNiPL1h+Z7b06th2FS3
fos3ifFL/GN7Dd9qMOy7YZfDUjEucvL7ZfunatBPyJGfNxdjR9LKQXZ+NfAx
7X54hp4YD3gkfr5tXgvHnA+G/KgsRvdp61Sd1esgf5W8SLmgDmMnjtg4S10M
lgf/9frqWYf+g4411MyuB6eYfrUTBXUYsWWQz5h9DSCXBV08sboWZ4pG7BY9
l8CKUR2xa47UoLKJo/0VnUYI1zKRm++sxkOhfpr/eEthjHTfpr/HiTB5YqK8
tbQJ9lj8Hh9hVomCksP9/Ue3wMAFbXZGaWVovrzddJiODERGAzVflZag+cEV
9wMuycDMud+i8SFF2JruVrKyfysUTPqhQe1TLp556ju+bk0r9NO5Lu9nlYE5
we2Xjvu3wnS/Z2/WuD/E8xH/vVqhy2VptskRyZyX/H4kvQ8n+fPZ9HmQ8f9X
mqz4/2DC3x9O3w+m/Ps66fdB1xv6/Xr0+yGeny+Qng+W8/NvpueHFmM6H6Tz
gSl8fhvp/CCYz7eLzhfc+Py96fzhKt/PIrofcOX7K6X7g7V8v5fpfiGT7398
uuL+YR7PhyHNB3zg+ZlD8wPHeb40ab5AyPO3i+YPlvJ8htB8ggHPr4TmF1x4
vn+k+QY3nv9FNP+wjfdDQvsBI3h/TGh/4BTv1wPaL7Dj/TOh/YMe3fcT7l6j
/TWi/YXDvN8/nFTsN5S20/5r0P5DiRHpQ1/SB0DWj62kH/CI9aWa9AU2NZL+
9CL9gSWPu+kTNKWSfvUl/YIXrG8xpG+Q+oD0z5H0DzxYH61IHwFSST8jSD+h
ivU1hvQVPrmT/oaR/sJE1mch6TMA67c16Tf0iyV9tyR9h1es/8tI/2Ew+4OM
/AGmsH+MJ/8Ad/aXZeQvYMT+M4P8B9axPwWRP8EF9i8g/4IS9ret5G9gyv7n
Tv4H9uyP3uSPsIr905z8E16zv/qQv8IU9t/b5L+wl/1ZhfwZRrJ/zyT/hjb2
9yYjhb+DkP1/KPk/fOR84F2tyAfgwPnBlfIDmHO+SB2pyBcgCKD8oUr5A6w5
nzjNVuQTSOX8kntMkV9AhfONbJYi30Al5x+tl4r8A3Wcj3rcVeQjyOH8VL5L
kZ9wIeerRC1FvsJTnL92UP7CtmTKZ45BinyGBzi/faD8hu6c7zQp32Ei579X
lP/QnfPh2HRFPsSZnB+nn1fkRxzK+bLPQkW+RDPOn88of2IE59MsyqfYlUn5
NY3yK87rnm/RivPvWcq/uJ7z8VPKx3ib83Ma5Wcs+kL5ejXla5Rz/o6j/I2f
GiifP6Z8jhac33dQfsdR7ZTv7SnfY5gx5f+/KP/jGO4Hb6gf4GLuD1nUH/Db
WeoXw6hf4NES6h+a1D/w23PqJ6epn3zPMdRfllB/wQoJ9ZvH1G/Qpnv/Qfcw
6kfm1I/wOPenV9SfcJ0H9atx1K/wTAD1Lyn1L7TIpX52i/oZDh5P/U1O/Q3V
0qjfbaV+9/2+qP/9Rv0P76dQP9SkfoiZ3B8nUX/EPO6Xs6lfov5n6p9R1D9R
Yyj1Uz3qp3ie+6sB9Ves434rpn6LH7j/9qD+iyncj/dSP8aJT6k/T6P+jKnc
r5OoX6OY+/fXK4r+jQOjqJ/bUz9HrY/U3z2ov2N/7vdp1O9xC/f/hoeK/o8O
zAesiQ+gFvOD3sQPMJP5whtVBV/AWcwfxhN/wN3MJ64Qn8DTzC/MiF9gAPON
sDEKvoF9mX9kf1TwD3zIfCR3joKPIDA/Ub6i4CdYznylvVrBV/B//EVp8aob
hys+zPnf+8J/u/OX3ne785czQPylN3+/kPnLMf59NtrEX07y75czf9nJz7cu
lfiLHj//gRriL3F8Pvr9iL8o8fk52hJ/MebzlTN/mcvnf4b5S91Zup9tu4m/
yJi/qI8m/lLO/OUS8xdfvv+jzF+8eT6UbhB/GcHzM5f5yw2er2PMX4Q8f0OY
vxTwfLYxf/Hh+bVg/uLG/MWe+YsX85e7zF9G8X7YMH8ZxPtjwvxlKe/XGOYv
AN32DxyYv7gyf+mp052/zC+g/Y5l/tLB/OU98xf1/8dfrOpIPwqZvyQyf5nB
/OUy689w5i+GzF8Smb+ImL9YMH9RyyJ928v8pZT1bwTzl+VhpI8Dmb9sHEH6
eYX5i8N10tcU5i+NrL9hzF8WsD7bMH8pY/22Y/4SzvzlAvOXESak/38zf/nK
/mDL/KWY/eMB85db7C/BzF8c2X/8mb84sD9dYf4yj/nLH8xfytnfjjF/Wcz+
d4f5iyf7ow/zF2D/1CD/hAvsrznMX0TsvzrMX3zYn7epEH85zP6dzvylN/OX
i8xfTrD/jzQk/vIz54NoNeIveZwfLN2785e8h8Rfajh/NFH+wP6cT+won2As
5xf948RfjDjfPGL+Usv8JZb5iz3no0OUj9CU85NyKPGXJs5XsZSvMJ3z103m
L685nx1h/tI+i/Lbc+YvKzjfRTB/0eH894r5y/8BC/MmzA==
          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHlczHsXx4cW281yb+J5rBXZS0KWcrLrWgpZbrhIsrZZbovIVrdusiRR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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHlczfn3x7OEGiEjg6QiaxQpTMVJpUi2UFNElrGEKcvMKGWk8B1MQllG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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdmHlczfn3xwtDYdS3QRKyNRJCtCCdsm9lGFnCMDWifIskCjNmKoSUpdQk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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892296659463*^9, 3.878892593601489*^9, 
  3.890981472491473*^9, 3.8909815875580273`*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"64e9d45a-59b1-4866-a674-0bcd69916c24"]
}, Open  ]],

Cell["\<\
Plot points along the paths of orbits at the 9:11 external resonance for \
eccentricities of 0.1, 0.2, 0.3 and 0.4.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878891692634336*^9, 3.878891693759428*^9}, {
  3.8788917923425694`*^9, 3.878891793568647*^9}, {3.878891866139823*^9, 
  3.878891867639566*^9}, {3.878891928844468*^9, 3.8788919327238827`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"effa0b40-7ac3-4def-badb-4bb5dee74763"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pext51d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.1", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext52d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.2", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext53d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.3", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pext54d", " ", "=", " ", 
   RowBox[{"PlotPath", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "9"}], "}"}], ",", " ", "1.0", ",", " ", "0.4", ",", 
     " ", 
     RowBox[{"Pi", "/", "15"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.878891313150784*^9, 3.8788913131565933`*^9}, {
  3.87889152970435*^9, 3.878891555669133*^9}, {3.8788915918501167`*^9, 
  3.87889159673857*^9}, {3.8788916470191727`*^9, 3.878891670613721*^9}, {
  3.878891730374497*^9, 3.878891739510613*^9}, {3.8788917994046373`*^9, 
  3.878891832285042*^9}, {3.8788918775850897`*^9, 3.878891901599208*^9}, {
  3.878891941260139*^9, 3.878891978116588*^9}, {3.878892327646933*^9, 
  3.87889233613489*^9}},
 CellLabel->
  "In[103]:=",ExpressionUUID->"eaf7fb45-5c13-4f5e-b304-ff9d9203745a"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 105, 3, 25811544838480288869, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.878892296890697*^9, 3.878892337442047*^9, 
  3.8788925938412437`*^9, 3.890981472786682*^9, 3.8909815878363037`*^9},
 CellLabel->
  "During evaluation of \
In[103]:=",ExpressionUUID->"ddae698c-2a31-4a8f-afbc-0d6480fc2ed3"],

Cell[BoxData[
 TemplateBox[{
  "FindRoot", "lstol", 
   "\"The line search decreased the step size to within tolerance specified \
by AccuracyGoal and PrecisionGoal but was unable to find a sufficient \
decrease in the merit function. You may need more than \
\\!\\(\\*RowBox[{\\\"MachinePrecision\\\"}]\\) digits of working precision to \
meet these tolerances.\"", 2, 106, 4, 25811544838480288869, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.878892296890697*^9, 3.878892337442047*^9, 
  3.8788925938412437`*^9, 3.890981472786682*^9, 3.890981587936761*^9},
 CellLabel->
  "During evaluation of \
In[103]:=",ExpressionUUID->"d225e69e-a7db-4e49-b111-ce0def7238f0"]
}, Open  ]],

Cell[TextData[{
 "Gather these using ",
 StyleBox["GraphicsGrid", "Input"],
 "."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.811582008273028*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"7696d154-3646-4665-abac-2b19a3e8310d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   StyleBox["GraphicsGrid", "Input"], "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"pext51d", ",", "pext52d", ",", "pext53d", ",", "pext54d"}], 
     "}"}], "}"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.878891581661181*^9, 3.8788916141407623`*^9}, {
  3.8788916753396063`*^9, 3.878891684053443*^9}, {3.878891836709979*^9, 
  3.8788918455142183`*^9}, {3.878891905004848*^9, 3.878891912849112*^9}, {
  3.878891982555327*^9, 3.878891991750113*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"c59c75db-e9d2-4a2a-b5cd-fdd6e9c9c6d6"],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHk81ekXx6W00ESpiaZVRaSGIk0jR7SghWQZlRkz0agkMZNpJ6ppIzMt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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {194.4, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHs81fcfx3WRbPIzVqwLaZmpNHcp9qZYumNq3Uu6ILLlFpVLi6LrRC21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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {583.2, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdmHlczPkfxzvoQMSqVK4lhewKIW15U6mon+un6HDkSopEhZJ11SKtXKWt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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {972., -188.69760000000002}, ImageScaled[{0.5, 0.5}], {360., 359.4240000000001},
     
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
    InsetBox[
     GraphicsBox[{
       LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
        1.5}, {-1.5, -1.5}}], 
       {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
        {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
         AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVmHlczfn3x9vGkoRSKktFGWLSKGTUnLhFomlE01gyGUQIWcKUmjZGKSFZ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          "]]}, {{}, {}}}},
      AspectRatio->Automatic,
      DisplayFunction->Identity,
      ImagePadding->{{0., 0.}, {0., 0.}},
      PlotRange->All], {1360.8000000000002, -188.69760000000002}, 
     ImageScaled[{0.5, 0.5}], {359.9999999999998, 359.4240000000001},
     BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {}},
  ImageSize->{
    UpTo[600], 
    UpTo[360]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892297326107*^9, 3.8788923424927263`*^9, 
  3.878892594218646*^9, 3.890981473015534*^9, 3.8909815880885277`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"a5703810-1d27-456c-9d2d-6e1e871bb5c9"]
}, Open  ]],

Cell[TextData[{
 "Gather several plots using ",
 StyleBox["GraphicsGrid", "Input"],
 ".  This is Fig.8.3d."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.8115808498154507`*^9, 3.811580852596011*^9}, {
  3.878890343454084*^9, 3.8788903604186697`*^9}, {3.878892208754756*^9, 
  3.8788922092798347`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"34f34b46-04ed-43f7-9886-66ac7d71d047"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"GraphicsGrid", "[", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"pext11d", ",", "pext12d", ",", "pext13d"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pext21d", ",", "pext22d", ",", "pext23d"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"pext31d", ",", "pext32d", ",", "pext33d"}], "}"}]}], "}"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8788902515034657`*^9, 3.878890319574437*^9}, {
  3.878892214005972*^9, 3.87889223705945*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"a63cdae0-8707-4098-ba18-57ea78174e47"],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13lQ1GUcx/ElyQsS1JoUMsoQSYOy8ArsMcSDpENNEi0QE9OUkEkTiEOO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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13tQ1WUex3ECRXISE01ZgvSsmrQiumtLG4kP6CTtxA6mlkBBBB5EMUC0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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxt13tQlFUcxnGCiszITJGoLEBJ0coQYonbES9UOmCAIGhMZRE6jqXkJQwt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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -193.1904}, ImageScaled[{0.5, 0.5}], {360., 359.424},
      
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1XtQlWUeB3B0WUSdldQ2JWWScYEJsUILNoT9qVxUNsvDKnC4JIkoJzLa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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1nlQ1OcZB/AFrWgCwYlEZYW0LFkwRTRyGI7Uh9KWqjWKSC7B6BAVQZqQ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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxd1X881fceB3DlR90mlmp1m2XpUveu272p25pfb05UKv1mtkuPVqbW3OVG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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -579.5712000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.42400000000004},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}, {
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxtl3k81XkXxy1JmhEqk6ZVqER7KNSJFm1MUYPyEGVKRiLJpE1RMo1p1Cgt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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {193.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxdl3lczXkXxxvEY2wpRalETE1oRtqmxZlJNe2WGcIYTGMpS3aKGJoJjyKi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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {580.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}], 
     InsetBox[
      GraphicsBox[{
        LineBox[{{-1.5, -1.5}, {1.5, -1.5}, {1.5, 1.5}, {-1.5, 
         1.5}, {-1.5, -1.5}}], 
        {PointSize[0.05], PointBox[{0, 0}]}, {{}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsolutePointSize[2], 
          AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxVl3k41Wkbx6neIiZmSTQpjKSYGpKydVMxZK3E2HrbJJKinRGTZaaIUdZm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           "]]}, {{}, {}}}},
       AspectRatio->Automatic,
       DisplayFunction->Identity,
       ImagePadding->{{0., 0.}, {0., 0.}},
       PlotRange->All], {967.5, -965.9520000000001}, 
      ImageScaled[{0.5, 0.5}], {360., 359.4240000000002},
      BaseStyle->{Graphics3DBoxOptions -> {SphericalRegion -> False}}]}}, {}},
  
  ImageSize->{
    UpTo[600], 
    UpTo[700]},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.878892297971918*^9, 3.8788925947890177`*^9, 
  3.890981473214262*^9, 3.890981588303647*^9},
 CellLabel->
  "Out[108]=",ExpressionUUID->"f950b287-713d-40fe-83e3-f1cc1f2f887b"]
}, Open  ]]
},
WindowToolbars->"MultipurposeBar",
CellGrouping->Manual,
WindowSize->{1053, 662},
WindowMargins->{{83, Automatic}, {Automatic, 27}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowCellLabel->True,
ShowCellTags->False,
FrontEndVersion->"13.2 for Mac OS X x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"f11b9daf-2bfb-40a0-abb1-11e541c5ccba"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 439, 9, 53, "Text",ExpressionUUID->"f0b8aa06-db16-42de-b829-6141169ce309"],
Cell[1000, 31, 179, 3, 67, "Section",ExpressionUUID->"46a2d40f-f18c-413a-a1dd-78688d8cb6ca"],
Cell[1182, 36, 172, 3, 49, "Text",ExpressionUUID->"4d13be8d-b27f-4159-be03-29125211000f"],
Cell[1357, 41, 441, 12, 30, "Input",ExpressionUUID->"0af57122-6bad-4bd6-a32b-206941c664c6"],
Cell[1801, 55, 387, 9, 53, "Text",ExpressionUUID->"65207154-b191-43be-938a-e55009d8aeb0"],
Cell[2191, 66, 551, 14, 30, "Input",ExpressionUUID->"c1aa4f93-5249-4cf2-b3da-53146511bdcf"],
Cell[2745, 82, 369, 13, 53, "Text",ExpressionUUID->"832d9400-db90-4e52-b277-c765597e9a62"],
Cell[3117, 97, 945, 27, 94, "Input",ExpressionUUID->"c1b3cd0e-b61d-4565-9251-5401bfb74f2c"],
Cell[4065, 126, 429, 12, 76, "Text",ExpressionUUID->"47e14c7e-3a9b-4927-9428-8eeb2fbfbaa6"],
Cell[4497, 140, 4894, 135, 325, "Input",ExpressionUUID->"fcb7fd42-0694-4ee8-a452-cf8daf14f5c8"],
Cell[9394, 277, 247, 6, 53, "Text",ExpressionUUID->"7fc55d62-a35a-426f-a5a1-3b9bfb5afac4"],
Cell[9644, 285, 1180, 34, 94, "Input",ExpressionUUID->"0571a41d-07f8-4100-80be-b06dccabf09b"],
Cell[10827, 321, 244, 8, 53, "Text",ExpressionUUID->"59ddf638-53f2-4440-b5dd-66f0d3532882"],
Cell[CellGroupData[{
Cell[11096, 333, 363, 8, 30, "Input",ExpressionUUID->"9a06f594-38e1-4cc3-a699-35b904c683ae"],
Cell[11462, 343, 7024, 133, 170, "Output",ExpressionUUID->"1925b80e-dfcc-413f-b079-38ed1b4f38fb"]
}, Open  ]],
Cell[18501, 479, 248, 6, 53, "Text",ExpressionUUID->"0d4db431-8709-475d-987c-c0aae366cc09"],
Cell[18752, 487, 1181, 34, 94, "Input",ExpressionUUID->"08edaaf6-9468-4e33-8dba-8b4feffc8828"],
Cell[19936, 523, 244, 8, 53, "Text",ExpressionUUID->"256935ff-7d9c-419c-ab4d-b97ae59982ca"],
Cell[CellGroupData[{
Cell[20205, 535, 365, 8, 30, "Input",ExpressionUUID->"b65d6748-3325-4cc8-a753-8753fb86e67f"],
Cell[20573, 545, 10610, 192, 170, "Output",ExpressionUUID->"d29db040-c9ca-496c-af5b-3873d4ed381e"]
}, Open  ]],
Cell[31198, 740, 248, 6, 53, "Text",ExpressionUUID->"96cd15f8-78e6-4890-a330-b11582f1f29a"],
Cell[31449, 748, 1178, 34, 94, "Input",ExpressionUUID->"70172b73-8559-457d-953e-ec6dc47544fb"],
Cell[32630, 784, 246, 8, 53, "Text",ExpressionUUID->"47ee9a23-47db-4786-8edb-fbfdb2568c69"],
Cell[CellGroupData[{
Cell[32901, 796, 368, 8, 30, "Input",ExpressionUUID->"0d654af3-0a6d-450e-a95a-16e2f81a6a2c"],
Cell[33272, 806, 9329, 172, 170, "Output",ExpressionUUID->"6d7672e3-d6d0-4e23-b3d0-d1bcb3b15d96"]
}, Open  ]],
Cell[42616, 981, 248, 6, 53, "Text",ExpressionUUID->"a2081c17-770e-4c20-b598-7281ccca6e66"],
Cell[42867, 989, 1179, 34, 94, "Input",ExpressionUUID->"6b04603b-cb0c-4dac-a519-926848374df5"],
Cell[44049, 1025, 244, 8, 53, "Text",ExpressionUUID->"300e6048-e3fe-416c-8274-96b459045660"],
Cell[CellGroupData[{
Cell[44318, 1037, 366, 8, 30, "Input",ExpressionUUID->"b3d21b17-356f-4c9a-a1bf-014eb12dc1bc"],
Cell[44687, 1047, 15604, 274, 170, "Output",ExpressionUUID->"c5181e14-3649-4700-abdc-124dd7df49f1"]
}, Open  ]],
Cell[60306, 1324, 248, 6, 53, "Text",ExpressionUUID->"9ddce1d6-ff9d-46ad-be0e-92f8406ec25c"],
Cell[60557, 1332, 1181, 34, 94, "Input",ExpressionUUID->"ec7a7997-ea9a-4424-b6d7-8c699c372393"],
Cell[61741, 1368, 246, 8, 53, "Text",ExpressionUUID->"8f4e30d5-92a8-4d82-ab8d-28ca2f803bf7"],
Cell[CellGroupData[{
Cell[62012, 1380, 368, 8, 30, "Input",ExpressionUUID->"ce477813-ab78-4db9-8c38-eac8bf79211e"],
Cell[62383, 1390, 11893, 212, 170, "Output",ExpressionUUID->"d061462f-95c6-405f-82e4-f7515112a407"]
}, Open  ]],
Cell[74291, 1605, 348, 9, 53, "Text",ExpressionUUID->"a75a0581-eff9-469e-a6cf-642bbe1d4f59"],
Cell[CellGroupData[{
Cell[74664, 1618, 730, 17, 94, "Input",ExpressionUUID->"ed370e2c-5c55-4864-a4b9-f5f30e5245ee"],
Cell[75397, 1637, 19754, 364, 616, "Output",ExpressionUUID->"3b3722d9-4529-4a94-9511-b6b7753dee70"]
}, Open  ]],
Cell[95166, 2004, 290, 7, 53, "Text",ExpressionUUID->"cc888054-f7e5-41b7-97c8-2d1c1be626e8"],
Cell[95459, 2013, 1178, 34, 94, "Input",ExpressionUUID->"5b0d420e-1577-4e6b-b206-b03328920e29"],
Cell[96640, 2049, 270, 8, 53, "Text",ExpressionUUID->"4cfaf97a-ef86-4f2f-9973-25f1ac1d86fc"],
Cell[CellGroupData[{
Cell[96935, 2061, 391, 9, 30, "Input",ExpressionUUID->"81467876-6135-43d2-8635-22c074df4440"],
Cell[97329, 2072, 10483, 191, 170, "Output",ExpressionUUID->"aad24e3a-522d-4a3c-bc5c-ad4765f5da43"]
}, Open  ]],
Cell[107827, 2266, 339, 8, 53, "Text",ExpressionUUID->"08344d86-f6b4-4938-a7ce-fc1089c2fce2"],
Cell[108169, 2276, 1280, 36, 94, "Input",ExpressionUUID->"09607696-4097-4c7b-847b-32a4cb1c2fd6"],
Cell[109452, 2314, 270, 8, 53, "Text",ExpressionUUID->"2a127684-36ac-4470-87ae-7e2aa4b2f180"],
Cell[CellGroupData[{
Cell[109747, 2326, 442, 10, 30, "Input",ExpressionUUID->"f27ddb17-7a8c-4348-824e-cff75ccd212f"],
Cell[110192, 2338, 15471, 271, 170, "Output",ExpressionUUID->"e68e092c-81c8-4de3-94e7-f6bab8aa3f72"]
}, Open  ]],
Cell[125678, 2612, 389, 9, 53, "Text",ExpressionUUID->"f505b51f-2069-471b-983b-692bfd0d7033"],
Cell[126070, 2623, 1328, 36, 94, "Input",ExpressionUUID->"0ed723ed-a5b6-4b7a-900c-638928286d10"],
Cell[127401, 2661, 270, 8, 53, "Text",ExpressionUUID->"e9760832-b4d4-4852-898f-1dae1a36b331"],
Cell[CellGroupData[{
Cell[127696, 2673, 491, 11, 30, "Input",ExpressionUUID->"50f27d6d-1be9-4efe-bea1-943178c902a7"],
Cell[128190, 2686, 20535, 355, 170, "Output",ExpressionUUID->"540e98b6-2f31-43a9-b37c-2971c0e5ebd5"]
}, Open  ]],
Cell[148740, 3044, 439, 10, 53, "Text",ExpressionUUID->"b8aa12d3-479b-465d-91e7-bd354be2ea1e"],
Cell[149182, 3056, 1376, 37, 94, "Input",ExpressionUUID->"15b34f33-1641-453c-9ecc-fd44bab3923d"],
Cell[150561, 3095, 270, 8, 53, "Text",ExpressionUUID->"9b8ec011-f393-497a-90cd-6d1a3ec8f4a2"],
Cell[CellGroupData[{
Cell[150856, 3107, 539, 11, 30, "Input",ExpressionUUID->"9825b2bd-65cb-4684-b55e-fa9a61f8c46c"],
Cell[151398, 3120, 25534, 436, 170, "Output",ExpressionUUID->"229b7e06-7f9a-4fa8-9ccf-9022fe760d67"]
}, Open  ]],
Cell[176947, 3559, 486, 10, 53, "Text",ExpressionUUID->"4ee123fa-6479-4836-b9e5-8cc25208182c"],
Cell[CellGroupData[{
Cell[177458, 3573, 1429, 38, 94, "Input",ExpressionUUID->"523ccf1e-9b12-4203-87d8-fd1fc56b99fc"],
Cell[178890, 3613, 667, 13, 48, "Message",ExpressionUUID->"818da656-b621-475e-a857-e845de635115"],
Cell[179560, 3628, 667, 13, 48, "Message",ExpressionUUID->"aaebd0b3-b95e-426b-a6b2-d12661d8ef3f"]
}, Open  ]],
Cell[180242, 3644, 270, 8, 53, "Text",ExpressionUUID->"ea2c84eb-09fe-434c-b93c-53e7b22a1bab"],
Cell[CellGroupData[{
Cell[180537, 3656, 587, 12, 30, "Input",ExpressionUUID->"e6760bbf-f5e8-4591-ac0d-882e594d6835"],
Cell[181127, 3670, 23842, 409, 170, "Output",ExpressionUUID->"828a23f5-b777-46ee-affa-56887faa26cd"]
}, Open  ]],
Cell[204984, 4082, 397, 10, 53, "Text",ExpressionUUID->"4bd0aa88-ab60-4cf0-bc7d-6b2d3ebaef32"],
Cell[CellGroupData[{
Cell[205406, 4096, 679, 16, 94, "Input",ExpressionUUID->"5fdbce17-b012-49b1-8a54-8ceedbbb56ec"],
Cell[206088, 4114, 34424, 605, 616, "Output",ExpressionUUID->"dbe6e934-0cc0-4b5f-b35b-9fecc7eaf9fd"]
}, Open  ]],
Cell[240527, 4722, 248, 6, 53, "Text",ExpressionUUID->"d27380d9-46df-44e7-915f-e0aa8b79ba92"],
Cell[240778, 4730, 1179, 34, 94, "Input",ExpressionUUID->"f062202e-b5ae-4d74-8808-baa37e2627b6"],
Cell[241960, 4766, 246, 8, 53, "Text",ExpressionUUID->"dbb5cb9e-4a4e-483d-ab13-c30626c2aa8a"],
Cell[CellGroupData[{
Cell[242231, 4778, 366, 8, 30, "Input",ExpressionUUID->"6507c61c-f1d4-4dee-a680-4c1adf55086e"],
Cell[242600, 4788, 6874, 132, 170, "Output",ExpressionUUID->"cca45d22-2fb9-4834-bcf6-e8e3bfa44bff"]
}, Open  ]],
Cell[249489, 4923, 248, 6, 53, "Text",ExpressionUUID->"7a8973e6-112a-41c3-8201-d099f4510826"],
Cell[249740, 4931, 1181, 34, 94, "Input",ExpressionUUID->"6f942f8e-0504-4fa3-b582-e0c8b2baf5f2"],
Cell[250924, 4967, 244, 8, 53, "Text",ExpressionUUID->"f20b1f44-7186-483a-b045-d1c629ca69bb"],
Cell[CellGroupData[{
Cell[251193, 4979, 368, 8, 30, "Input",ExpressionUUID->"3a9e4ce6-4384-4a60-b856-4d623c70a969"],
Cell[251564, 4989, 8324, 156, 170, "Output",ExpressionUUID->"1d87e96f-9df2-4992-80f1-dc059e1454d9"]
}, Open  ]],
Cell[259903, 5148, 248, 6, 53, "Text",ExpressionUUID->"001350ac-4a7a-4af2-a2de-f0f3c6e2e5a6"],
Cell[260154, 5156, 1183, 34, 94, "Input",ExpressionUUID->"ebdb5eec-eac3-4130-be45-ef4995d1ab45"],
Cell[261340, 5192, 244, 8, 53, "Text",ExpressionUUID->"84275ba2-c9dd-4831-b793-a8b4af8d5394"],
Cell[CellGroupData[{
Cell[261609, 5204, 366, 8, 30, "Input",ExpressionUUID->"ef48cc20-81cb-4629-953b-c7b299af6b7e"],
Cell[261978, 5214, 11945, 214, 170, "Output",ExpressionUUID->"7e5fd7f1-e85e-457b-8a93-f1fb6cf867b3"]
}, Open  ]],
Cell[273938, 5431, 248, 6, 53, "Text",ExpressionUUID->"5e94720a-2345-42ed-bcf7-7c64c2f16629"],
Cell[274189, 5439, 1179, 34, 94, "Input",ExpressionUUID->"e71a04e5-b85e-462d-9a4a-2e0c61b6f99f"],
Cell[275371, 5475, 268, 8, 53, "Text",ExpressionUUID->"6d835273-85a8-46f1-b372-90e26ef511ac"],
Cell[CellGroupData[{
Cell[275664, 5487, 365, 8, 30, "Input",ExpressionUUID->"ebfdc0e6-6252-4cfd-9b14-276a6214d04a"],
Cell[276032, 5497, 10607, 192, 170, "Output",ExpressionUUID->"a97e5e34-2a31-42d3-8057-02e3ef5848f3"]
}, Open  ]],
Cell[286654, 5692, 248, 6, 53, "Text",ExpressionUUID->"e85d8ac9-d0f1-4e24-9871-ffd0b645fa34"],
Cell[286905, 5700, 1179, 34, 94, "Input",ExpressionUUID->"6699b8cc-62af-43fe-9936-2e78c94b18e9"],
Cell[288087, 5736, 270, 8, 53, "Text",ExpressionUUID->"5ef6384f-0d6d-4073-af87-9cee8840d018"],
Cell[CellGroupData[{
Cell[288382, 5748, 368, 8, 30, "Input",ExpressionUUID->"a36c35e5-add5-4cc2-8b8f-a426b0377e87"],
Cell[288753, 5758, 13641, 241, 170, "Output",ExpressionUUID->"4ae9e3de-19f7-495f-b170-397a87752a3c"]
}, Open  ]],
Cell[302409, 6002, 348, 9, 53, "Text",ExpressionUUID->"67f7e0f5-c547-4a1f-a949-62ddd9253521"],
Cell[CellGroupData[{
Cell[302782, 6015, 630, 15, 94, "Input",ExpressionUUID->"2d3186cf-70d9-4faf-8a01-5df87caff17e"],
Cell[303415, 6032, 19875, 368, 616, "Output",ExpressionUUID->"710f9cdd-9634-4eb7-ae5e-910dcfe770eb"]
}, Open  ]],
Cell[323305, 6403, 248, 6, 53, "Text",ExpressionUUID->"bc8be5a0-9182-49fa-a1e2-7e7163494184"],
Cell[323556, 6411, 1279, 36, 94, "Input",ExpressionUUID->"0d496c42-458f-4c79-959c-1f5d8459b929"],
Cell[324838, 6449, 244, 8, 53, "Text",ExpressionUUID->"a5b420e9-e9ed-4407-866d-fa1f85806296"],
Cell[CellGroupData[{
Cell[325107, 6461, 391, 9, 30, "Input",ExpressionUUID->"4f89bbb6-78dd-48af-9dd0-309fcfea55bc"],
Cell[325501, 6472, 13156, 235, 170, "Output",ExpressionUUID->"3ce6f414-d4ff-4801-86b2-c8848ce3aa18"]
}, Open  ]],
Cell[338672, 6710, 314, 7, 53, "Text",ExpressionUUID->"5c315b46-5b33-403b-b96b-656b364b1562"],
Cell[338989, 6719, 1376, 37, 94, "Input",ExpressionUUID->"92469101-fc59-49bc-b764-8f30eae58316"],
Cell[340368, 6758, 244, 8, 53, "Text",ExpressionUUID->"fc03fbae-da6b-4e1f-bc2e-3ca18d7236c2"],
Cell[CellGroupData[{
Cell[340637, 6770, 442, 10, 30, "Input",ExpressionUUID->"c8a22c6e-b33f-4142-8634-173275000cbf"],
Cell[341082, 6782, 13184, 235, 170, "Output",ExpressionUUID->"ac7cae0a-d154-459a-8bfe-fec357c4ba10"]
}, Open  ]],
Cell[354281, 7020, 365, 8, 53, "Text",ExpressionUUID->"5c4ff47c-c546-4e3a-8803-f1b63f667fe8"],
Cell[354649, 7030, 1427, 38, 94, "Input",ExpressionUUID->"5cc3a98d-5114-46c0-bd0d-3e3a8dd1cc00"],
Cell[356079, 7070, 244, 8, 53, "Text",ExpressionUUID->"20ab887b-c428-4df5-a208-7d9124a72af9"],
Cell[CellGroupData[{
Cell[356348, 7082, 493, 11, 30, "Input",ExpressionUUID->"680786b7-a668-4c0e-8870-17bf4d6cc386"],
Cell[356844, 7095, 18478, 321, 170, "Output",ExpressionUUID->"04c640c6-a92a-43bc-8512-d86a86a354e4"]
}, Open  ]],
Cell[375337, 7419, 414, 9, 53, "Text",ExpressionUUID->"c18d6a53-b68c-464b-9efa-517c3df9ff58"],
Cell[375754, 7430, 1475, 38, 94, "Input",ExpressionUUID->"ae762f78-e6e9-429e-aff0-cd0c35513ed5"],
Cell[377232, 7470, 244, 8, 53, "Text",ExpressionUUID->"749579a0-9988-40dc-b386-5f5be116c6b9"],
Cell[CellGroupData[{
Cell[377501, 7482, 543, 12, 30, "Input",ExpressionUUID->"a9357fba-7ee0-416d-a55a-331b8e9683fd"],
Cell[378047, 7496, 23664, 407, 170, "Output",ExpressionUUID->"64e9d45a-59b1-4866-a674-0bcd69916c24"]
}, Open  ]],
Cell[401726, 7906, 463, 9, 53, "Text",ExpressionUUID->"effa0b40-7ac3-4def-badb-4bb5dee74763"],
Cell[CellGroupData[{
Cell[402214, 7919, 1580, 41, 94, "Input",ExpressionUUID->"eaf7fb45-5c13-4f5e-b304-ff9d9203745a"],
Cell[403797, 7962, 693, 13, 48, "Message",ExpressionUUID->"ddae698c-2a31-4a8f-afbc-0d6480fc2ed3"],
Cell[404493, 7977, 691, 13, 48, "Message",ExpressionUUID->"d225e69e-a7db-4e49-b111-ce0def7238f0"]
}, Open  ]],
Cell[405199, 7993, 244, 8, 53, "Text",ExpressionUUID->"7696d154-3646-4665-abac-2b19a3e8310d"],
Cell[CellGroupData[{
Cell[405468, 8005, 592, 13, 30, "Input",ExpressionUUID->"c59c75db-e9d2-4a2a-b5cd-fdd6e9c9c6d6"],
Cell[406063, 8020, 22403, 386, 170, "Output",ExpressionUUID->"a5703810-1d27-456c-9d2d-6e1e871bb5c9"]
}, Open  ]],
Cell[428481, 8409, 399, 10, 53, "Text",ExpressionUUID->"34f34b46-04ed-43f7-9886-66ac7d71d047"],
Cell[CellGroupData[{
Cell[428905, 8423, 682, 17, 94, "Input",ExpressionUUID->"a63cdae0-8707-4098-ba18-57ea78174e47"],
Cell[429590, 8442, 33188, 586, 616, "Output",ExpressionUUID->"f950b287-713d-40fe-83e3-f1cc1f2f887b"]
}, Open  ]]
}
]
*)

