(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1108026,      19213]
NotebookOptionsPosition[   1103782,      19149]
NotebookOutlinePosition[   1104202,      19166]
CellTagsIndexPosition[   1104159,      19163]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Last checked 20 April, 2023",
 CellFrame->True,
 Background->GrayLevel[0.849989]]], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.851321730299733*^9, 3.851321747924562*^9}, 
   3.8513218075505953`*^9, {3.890897811719871*^9, 3.890897826726935*^9}, {
   3.890973965108789*^9, 3.8909739653874283`*^9}},
 TextAlignment->Left,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"385d7771-3653-4d1c-90b6-959b3abc07fe"],

Cell["Chapter 8, Section 8.2, Animation of Figures 8.1\[Dash]8.2", "Section",
 CellChangeTimes->{{3.878562412934669*^9, 3.878562413354199*^9}, {
  3.87862282971488*^9, 
  3.8786228344765673`*^9}},ExpressionUUID->"4768d13e-5b2d-4fc0-8761-\
b9105674596c"],

Cell[TextData[{
 "We start by defining a function ",
 StyleBox["ksolve", "Input"],
 " that solves Kepler's equation to find the eccentric anomaly for a given \
value of the mean anomaly and eccentricity."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{3.8786458855917883`*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"838c22cc-e00d-4200-9168-ba3021aba8f9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ksolve", "[", 
    RowBox[{"ma_", ",", " ", "e_"}], "]"}], " ", ":=", " ", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"ea", " ", "-", " ", 
       RowBox[{"e", " ", 
        RowBox[{"Sin", "[", "ea", "]"}]}]}], " ", "==", " ", "ma"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"ea", ",", "ma"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.878551288853799*^9, 3.8785512888598747`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"08bcfd53-2348-411e-b5f0-fa32e4290380"],

Cell[TextData[{
 "The function ",
 StyleBox["position", "Input"],
 " calculates the ",
 StyleBox["x",
  FontSlant->"Italic"],
 " and ",
 StyleBox["y",
  FontSlant->"Italic"],
 " coordinates of an object for a particular value of the mean anomaly by \
solving Kepler\[CloseCurlyQuote]s equation."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878645902149838*^9, 3.8786459090335703`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a81f55ff-6b3d-41f6-baa8-b647a7e9022d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"position", "[", 
   RowBox[{"ma_", ",", "a_", ",", "e_"}], "]"}], ":=", "\n", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"eca", "=", 
     RowBox[{"ea", " ", "/.", " ", 
      RowBox[{"ksolve", "[", 
       RowBox[{"ma", ",", "e"}], "]"}]}]}], ";", "\n", 
    RowBox[{"x", "=", 
     RowBox[{"N", "[", 
      RowBox[{"a", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "eca", "]"}], "-", "e"}], ")"}]}], "]"}]}], ";", 
    " ", 
    RowBox[{"y", "=", 
     RowBox[{"N", "[", 
      RowBox[{"a", " ", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], "]"}], " ", 
       RowBox[{"Sin", "[", "eca", "]"}]}], "]"}]}], ";", "\n", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.878551301888957*^9, 3.8785513018971653`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"5ab248a8-9a7d-4da4-a4ad-24420e9f40aa"],

Cell[TextData[{
 "Set the values of the asteroid\[CloseCurlyQuote]s semi-major axis and \
eccentricity.  This is specific for the 2:1 interior resonance but the ",
 StyleBox["Orbit", "Input"],
 " function (defined below) is more general."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562591887006*^9, 3.878562613471806*^9}, {
   3.878801704308281*^9, 3.878801749629154*^9}, 3.878803303684956*^9},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"d210207d-0024-49a6-aae5-c6fb579d722c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"aa", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "2"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"2", "/", "3"}], ")"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ae", "=", "0.5"}], ";"}]}], "Input",
 CellChangeTimes->{{3.878559737940578*^9, 3.8785597663040123`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"77032819-a678-4510-9b2e-c8f20bd90a6c"],

Cell["\<\
Set the colours to be used for the two orbits and associated positions of the \
asteroid and Jupiter.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562591887006*^9, 3.878562613471806*^9}, {
  3.878645977794298*^9, 3.878646003488901*^9}, {3.878646081324325*^9, 
  3.878646113633102*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"962f429b-1548-4ece-a84b-8470eaa08142"],

Cell[BoxData[
 RowBox[{
  RowBox[{"color1", "=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8706884723044577`*^9, 3.8706884767572603`*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"f3fe1c5d-8b51-47a2-b5ee-af23f5afeb73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"color2", "=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.870688484124298*^9, 3.870688503351976*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"ff2bae40-0b92-41eb-bcfd-9044430a3834"],

Cell[TextData[{
 "Define the general function ",
 StyleBox["Orbit", "Input"],
 " that plots an orbit of eccentricity, ",
 StyleBox["e", "Input"],
 ", with semi-major axis specified by the rational made up from the list of \
two numbers given by ",
 StyleBox["pl", "Input"],
 ".  The orbit of the outer planet is taken to be circular with unit \
semi-major axis.  This will also be used in later notebooks to generate plots."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"8cac8ce4-c796-4faf-90dd-88eb54156425"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Orbit", "[", 
   RowBox[{"pl_List", ",", " ", "e_"}], "]"}], " ", ":=", "\n", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"pt", " ", "=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"pl", "[", 
           RowBox[{"[", "1", "]"}], "]"}], " ", ">", " ", 
          RowBox[{"pl", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
         RowBox[{"pl", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
         RowBox[{"pl", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ",", 
      RowBox[{"sun", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PointSize", "[", "0.2", "]"}], ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], "]"}]}], ",", 
      RowBox[{"porb", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Circle", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], "}"}], "]"}]}],
       ",", 
      RowBox[{"a", " ", "=", " ", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"pl", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "/", 
           RowBox[{"pl", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "/", "3"}], ")"}]}], "]"}]}], ",", 
      RowBox[{"circle", " ", "=", " ", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"color2", ",", 
          RowBox[{"Circle", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
        "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", "\n", "  ", 
    RowBox[{
     RowBox[{"ptime", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"N", "[", "t", "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"pt", "*", "2", "*", "Pi"}], ",", 
          RowBox[{"Pi", "/", "40"}]}], "}"}]}], "]"}]}], ";", "\n", "  ", 
     RowBox[{"posvec", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"position", "[", 
          RowBox[{"#", ",", "a", ",", "e"}], "]"}], "&"}], ",", "ptime"}], 
       "]"}]}], ";", "\n", "  ", 
     RowBox[{"f", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"ArcTan", "[", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "]"}], "&"}], ",", 
        "posvec"}], "]"}]}], ";", "\n", "  ", 
     RowBox[{"rad", " ", "=", " ", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"N", "[", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], "+", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], "]"}], "]"}], 
         "&"}], ",", "posvec"}], "]"}]}], ";", "\n", "  ", 
     RowBox[{"orbpts", " ", "=", " ", 
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "*", 
          RowBox[{"Cos", "[", "f", "]"}]}], ",", 
         RowBox[{"rad", "*", 
          RowBox[{"Sin", "[", "f", "]"}]}]}], "}"}], "]"}]}], ";", "\n", "  ", 
     RowBox[{"p3", " ", "=", " ", "\n", "  ", 
      RowBox[{"ListPlot", "[", 
       RowBox[{"orbpts", ",", 
        RowBox[{"PlotStyle", "->", 
         RowBox[{"Directive", "[", "color1", "]"}]}], ",", "\n", 
        "           ", 
        RowBox[{"Joined", "->", "True"}], ",", "\n", "           ", 
        RowBox[{"AspectRatio", "->", "Automatic"}], ",", " ", 
        RowBox[{"Axes", "->", "None"}], ",", "\n", "           ", 
        RowBox[{"PlotRange", "->", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], "]"}]}], 
     ";", "\n", "  ", 
     RowBox[{"Show", "[", 
      RowBox[{"sun", ",", "circle", ",", "p3", ",", "\n", "  ", 
       RowBox[{"AspectRatio", "->", "Automatic"}], ",", 
       RowBox[{"PlotRange", "->", "All"}]}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.878551331804884*^9, 3.878551340055677*^9}, {
   3.8785609574927807`*^9, 3.8785609575798273`*^9}, 3.878561204644804*^9, {
   3.878561253505582*^9, 3.878561284628195*^9}, {3.878562466158894*^9, 
   3.878562477636033*^9}, {3.878647651163328*^9, 3.87864767282902*^9}, {
   3.878802348886018*^9, 3.8788023515254374`*^9}, {3.8788029282939587`*^9, 
   3.8788029380290728`*^9}, {3.8788030582235947`*^9, 3.878803059738882*^9}, {
   3.878803092049589*^9, 3.8788030935635366`*^9}, {3.8788031621301823`*^9, 
   3.878803221184063*^9}, {3.878803521857245*^9, 3.878803536182118*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"fc70e9c9-6301-4bdd-b8ff-a67d80d372a8"],

Cell["\<\
Draw the basic orbits and the Sun for use as a backdrop for the orbital \
positions of the asteroid and Jupiter.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.87864619787433*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"266e0f63-de6d-435f-8734-1abea0eef3e2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"backdrop", "=", 
  RowBox[{"Orbit", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", "0.5"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.878623667307498*^9, 3.878623689106173*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"b030f20a-d7b3-49a7-b7be-f6fc64885ca7"],

Cell[BoxData[
 GraphicsBox[{
   {PointSize[0.2], PointBox[{0, 0}]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], 
    CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
       "]]}}, {{}, {}}}},
  AspectRatio->Automatic,
  PlotRange->All]], "Output",
 CellChangeTimes->{{3.8786236685540247`*^9, 3.8786236913169317`*^9}, {
   3.8786387439316177`*^9, 3.8786387680674067`*^9}, 3.878646598706243*^9, 
   3.8786469020679693`*^9, 3.878647425527606*^9, 3.878803674723425*^9, 
   3.890987389355997*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"98144245-40a3-48d7-b95f-2685d87fc2d8"]
}, Open  ]],

Cell["\<\
Calculate successive positions of Jupiter and the asteroid for the stable \
case of the 2:1 resonance.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646258054105*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f27370c9-a737-4eca-ad1c-07097187ef97"],

Cell[BoxData[
 RowBox[{
  RowBox[{"jpoints1", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EdgeForm", "[", 
          RowBox[{"Thickness", "[", "0.005", "]"}], "]"}], ",", "color2", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{"#", ",", "0.05"}], "]"}]}], "}"}], "]"}], "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"position", "[", 
        RowBox[{
         RowBox[{"meananom", "/", "2"}], ",", "1", ",", "0"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"meananom", ",", "0", ",", 
         RowBox[{"4", "\[Pi]"}], ",", 
         RowBox[{"2", 
          RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.878644534707349*^9, 3.878644567527005*^9}, {
   3.878644660199181*^9, 3.878644690962152*^9}, {3.8786447449198503`*^9, 
   3.878644758478959*^9}, {3.8786451496913137`*^9, 3.878645157323955*^9}, 
   3.878645438320786*^9, {3.878646628300865*^9, 3.878646628690164*^9}, {
   3.8786466758706427`*^9, 3.878646675980278*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"7824053b-39d2-497c-a88b-355fd19d2530"],

Cell[BoxData[
 RowBox[{
  RowBox[{"apoints1", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "0.02", "]"}], ",", "color1", ",", 
         RowBox[{"Point", "[", "#", "]"}]}], "}"}], "]"}], "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"position", "[", 
        RowBox[{"meananom", ",", "aa", ",", "ae"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"meananom", ",", "0", ",", 
         RowBox[{"4", "\[Pi]"}], ",", 
         RowBox[{"2", 
          RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8786447835883303`*^9, 3.8786448337198687`*^9}, {
   3.8786451843892317`*^9, 3.878645185021069*^9}, 3.878645440445937*^9, {
   3.8786466313175097`*^9, 3.878646631420047*^9}, {3.8786466788674097`*^9, 
   3.878646678969735*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"a9d4682c-75af-45a2-9822-5d01023afe7f"],

Cell["Determine the number of pairs of positions to be plotted.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"51bebb08-e96d-468b-ab53-b5517cb6e875"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"npoints", "=", 
  RowBox[{"Length", "[", "jpoints1", "]"}]}]], "Input",
 CellChangeTimes->{{3.87864484178819*^9, 3.878644863079666*^9}, 
   3.878645603080331*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"d2879595-8cb8-4aaf-9772-2f254fa0b6cf"],

Cell[BoxData["201"], "Output",
 CellChangeTimes->{3.878644864388814*^9, 3.878645191320154*^9, 
  3.878645603530542*^9, 3.878646598966247*^9, 3.87864664022793*^9, 
  3.878646684854228*^9, 3.878646902154088*^9, 3.878647425876712*^9, 
  3.878803674812179*^9, 3.890987389959928*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"ef77a7c4-1531-4880-b036-727bf6674f07"]
}, Open  ]],

Cell["\<\
Combine the backdrop of the orbits and Sun with the positions of the asteroid \
and Jupiter at successive times for the stable configuration.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}, {3.878646368052926*^9, 3.87864642837353*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"2083aede-5e23-43d8-9cd5-2f93450b6bef"],

Cell[BoxData[
 RowBox[{
  RowBox[{"stableplots", "=", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"backdrop", ",", 
       RowBox[{"jpoints1", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"apoints1", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "npoints"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.878644875702023*^9, 3.878644943549284*^9}, {
  3.8786449765501842`*^9, 3.8786450501479816`*^9}, {3.878645248294004*^9, 
  3.878645255975646*^9}, {3.878645586540003*^9, 3.87864558893825*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"fa316b84-50a2-43ed-975c-5aa2f2442e17"],

Cell["Animate the stable case.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}, {3.878646368052926*^9, 3.8786464478174677`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"50690528-8dfd-4eb3-b027-7860f08c1822"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stable", "=", 
  RowBox[{"ListAnimate", "[", "stableplots", "]"}]}]], "Input",
 CellChangeTimes->{{3.878645003901153*^9, 3.878645012722374*^9}, {
  3.878646307887398*^9, 3.878646310501663*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"af4e5a7d-0a33-4183-9319-72e1c393c09f"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i11$$ = 43, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {
    "\"min\"" :> {$CellContext`i11$$ = 1}, 
     "\"max\"" :> {$CellContext`i11$$ = 201}}, Typeset`bookmarkMode$$ = 
    "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i11$$], 1, ""}, 1, 201, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    PaneBox[
     PanelBox[GridBox[{
        {
         ItemBox[
          ItemBox[
           TagBox[
            StyleBox[GridBox[{
               {"\<\"\"\>", 
                AnimatorBox[Dynamic[$CellContext`i11$$], {1, 201, 1},
                 AnimationRate->Automatic,
                 AnimationRunTime->3.680138111114502,
                 AnimationTimeIndex->1.0696517412935322`,
                 
                 AppearanceElements->{
                  "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
                   "DirectionButton"},
                 AutoAction->False,
                 DisplayAllSteps->True]}
              },
              AutoDelete->False,
              
              GridBoxAlignment->{
               "Columns" -> {Right, {Left}}, "Rows" -> {{Baseline}}},
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "ListAnimateLabel",
             StripOnInput->False],
            {"ControlArea", Top}],
           Alignment->{Automatic, Inherited},
           StripOnInput->False],
          Background->None,
          StripOnInput->False]},
        {
         ItemBox[
          TagBox[
           StyleBox[
            PaneBox[
             TagBox[
              PaneSelectorBox[{1->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{1., 0.}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3149802624737183, 0.}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 2->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9995065603657316, 0.03141075907812829}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535884`, 0.06819954733524226}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 3->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9980267284282716, 0.06279051952931337}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321734`, 0.13432357556791355`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 4->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.99556196460308, 0.09410831331851431}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.27264603941753995`, 0.19661941470322875`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 5->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9921147013144779, 0.12533323356430426}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.24262915891745948`, 0.25385329843412385`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 6->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9876883405951378, 0.15643446504023087}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980796`, 0.3053397747344624}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 7->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9822872507286887, 0.1873813145857246}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.16743128086083875`, 0.3508518553281648}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 8->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9759167619387474, 0.21814324139654256}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197907`, 0.3904861670159304}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 9->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9685831611286311, 0.2486898871648548}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0806737405369783, 0.4245363702561256}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 10->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9602936856769431, 0.2789911060392293}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.035388686500549056`, 0.4533970632238787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 11->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9510565162951535, 0.3090169943749474}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.010280264298077511`, 0.4774998749506231}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 12->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9408807689542255, 0.33873792024529137}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.05586585891603506, 0.49727506638252733`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 13->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9297764858882515, 0.3681245526846779}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169839`, 0.5131306803051374}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 14->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9177546256839811, 0.3971478906347806}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.1454805449130464, 0.5254427481221686}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 15->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9048270524660195, 0.4257792915650727}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.18906049952988568`, 0.5345520154476682}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 16->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8910065241883679, 0.4539904997395468}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.23162000195848956`, 0.5407642716278159}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 17->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8763066800438636, 0.4817536741017153}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2730590489366069, 0.5443525109115593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 18->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8607420270039436, 0.5090414157503713}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3133067182793022, 0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 19->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8443279255020151, 0.5358267949789967}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3523139097997728, 0.5446029253750275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 20->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8270805742745618, 0.5620833778521306}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3900478949153411, 0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 21->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8090169943749475, 0.5877852522924731}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665314`, 0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 22->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7901550123756904, 0.6129070536529764}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.4616236053612144, 0.5305746834651297}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 23->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7705132427757893, 0.6374239897486896}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.49544962924176134`, 0.52269570783372}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 24->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7501110696304596, 0.6613118653236518}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198191, 0.5134347143846025}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 25->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7289686274214116, 0.6845471059286886}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455198, 0.5029041729238555}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 26->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7071067811865476, 0.7071067811865475}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5890955268533129, 0.4912059788109425}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 27->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6845471059286887, 0.7289686274214116}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424778, 0.4784327561156643}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 28->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6613118653236518, 0.7501110696304596}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498826, 0.46466898570375087`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 29->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6374239897486896, 0.7705132427757893}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320532, 0.44999198273344854`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 30->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6129070536529766, 0.7901550123756903}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763099, 0.4344727450867003}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 31->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5877852522924732, 0.8090169943749473}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138493, 0.4181766913900598}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 32->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5620833778521306, 0.8270805742745618}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435766, 0.40116430465145936`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 33->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5358267949789967, 0.8443279255020151}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264197, 0.3834916952066037}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 34->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5090414157503713, 0.8607420270039436}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631762, 0.36521109464093177`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 35->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4817536741017152, 0.8763066800438636}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074031, 0.3463712906127092}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 36->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4539904997395468, 0.8910065241883679}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8192248032955609, 0.3270180110216626}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 37->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.42577929156507266, 0.9048270524660196}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518694, 0.30719426471396116`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 38->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.39714789063478056, 0.9177546256839811}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576699, 0.2869406448570593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 39->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.3681245526846781, 0.9297764858882513}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479961, 0.26629560022820886`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 40->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.3387379202452915, 0.9408807689542255}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738471, 0.24529567891279405`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 41->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.30901699437494745, 0.9510565162951535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939743, 0.22397574828097455`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 42->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.27899110603922944, 0.960293685676943}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699989, 0.20236919458456765`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 43->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.24868988716485496, 0.9685831611286311}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599705, 0.18050810507478293`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 44->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.21814324139654268, 0.9759167619387473}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.917795560258282, 0.15842343517206775`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 45->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.1873813145857247, 0.9822872507286886}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296826, 0.13614516291076267`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 46->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.15643446504023092, 0.9876883405951378}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9311073641438069, 0.11370243262459062`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 47->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.12533323356430426, 0.9921147013144779}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, 0.0911236896263295}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 48->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.0941083133185145, 0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, 0.06843680746058559}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 49->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.06279051952931351, 0.9980267284282716}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, 0.04566920916711431}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 50->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.031410759078128396, 0.9995065603657316}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, 0.02284798387979817}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 51->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{6.123233995736766*^-17, 1.}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9449407874211548, 6.681205341333952*^-17}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 52->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.03141075907812828, 0.9995065603657316}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, -0.022847983879798035`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 53->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.0627905195293134, 0.9980267284282716}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, -0.04566920916711418}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 54->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.0941083133185144, 0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, -0.06843680746058571}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 55->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.12533323356430437, 0.9921147013144778}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, -0.09112368962632962}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 56->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.15643446504023104, 0.9876883405951377}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.931107364143807, -0.11370243262459051`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 57->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.18738131458572482, 0.9822872507286886}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296826, -0.13614516291076278`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 58->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.21814324139654237, 0.9759167619387474}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.917795560258282, -0.1584234351720674}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 59->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.24868988716485463, 0.9685831611286312}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599707, -0.18050810507478257`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 60->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.27899110603922916, 0.9602936856769431}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699989, -0.2023691945845673}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 61->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.30901699437494734, 0.9510565162951536}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939743, -0.22397574828097447`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 62->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.33873792024529137, 0.9408807689542255}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738471, -0.2452956789127939}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 63->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.368124552684678, 0.9297764858882513}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479962, -0.26629560022820875`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 64->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.39714789063478045, 0.9177546256839813}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576699, -0.28694064485705917`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 65->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.42577929156507277, 0.9048270524660195}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518694, -0.3071942647139613}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 66->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.45399049973954675, 0.8910065241883679}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8192248032955608, -0.3270180110216627}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 67->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.4817536741017154, 0.8763066800438635}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074031, -0.34637129061270927`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 68->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5090414157503713, 0.8607420270039436}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631761, -0.3652110946409319}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 69->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5358267949789968, 0.844327925502015}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264195, -0.3834916952066039}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 70->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5620833778521303, 0.827080574274562}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435768, -0.40116430465145925`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 71->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.587785252292473, 0.8090169943749475}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138496, -0.4181766913900596}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 72->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6129070536529763, 0.7901550123756905}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763104, -0.4344727450867001}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 73->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6374239897486896, 0.7705132427757893}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320533, -0.4499919827334484}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 74->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6613118653236517, 0.7501110696304597}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498828, -0.46466898570375076`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 75->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6845471059286887, 0.7289686274214116}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424781, -0.4784327561156642}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 76->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7071067811865475, 0.7071067811865476}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5890955268533128, -0.4912059788109425}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 77->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7289686274214113, 0.6845471059286888}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455203, -0.5029041729238553}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 78->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7501110696304596, 0.6613118653236518}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198188, -0.5134347143846026}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 79->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7705132427757891, 0.6374239897486899}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.49544962924176367`, -0.5226957078337193}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 80->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7901550123756904, 0.6129070536529764}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121455`, -0.5305746834651296}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 81->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8090169943749473, 0.5877852522924732}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665353`, -0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 82->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8270805742745619, 0.5620833778521305}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3900478949153411, -0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 83->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8443279255020149, 0.535826794978997}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.35231390979977345`, -0.5446029253750274}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 84->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8607420270039435, 0.5090414157503714}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3133067182793024, -0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 85->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8763066800438635, 0.4817536741017156}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.27305904893660743`, -0.5443525109115593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 86->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8910065241883678, 0.45399049973954686}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.23162000195848956`, -0.5407642716278159}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 87->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9048270524660194, 0.4257792915650729}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.18906049952988582`, -0.5345520154476683}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 88->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9177546256839811, 0.3971478906347806}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304654`, -0.5254427481221686}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 89->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9297764858882513, 0.36812455268467814}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169892`, -0.5131306803051376}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 90->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9408807689542255, 0.3387379202452913}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.0558658589160353, -0.4972750663825274}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 91->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9510565162951535, 0.3090169943749475}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807793, -0.4774998749506234}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 92->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9602936856769431, 0.2789911060392291}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.035388686500549264`, -0.45339706322387857`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 93->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9685831611286311, 0.2486898871648548}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0806737405369783, -0.4245363702561256}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 94->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9759167619387474, 0.21814324139654231}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197927`, -0.39048616701593025`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 95->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9822872507286886, 0.187381314585725}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.16743128086083814`, -0.35085185532816543`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 96->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9876883405951377, 0.15643446504023098}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980774`, -0.30533977473446267`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 97->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9921147013144778, 0.12533323356430454}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2426291589174592, -0.25385329843412424`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 98->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.99556196460308, 0.09410831331851435}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.27264603941754, -0.1966194147032286}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 99->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9980267284282716, 0.06279051952931358}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2955876417932173, -0.134323575567914}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 100->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9995065603657316, 0.03141075907812824}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535884`, -0.06819954733524215}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 101->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{-1., 1.2246467991473532*^-16}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3149802624737183, -1.3362410682667903`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 102->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9995065603657316, -0.031410759078127994}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535895`, 0.06819954733524139}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 103->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9980267284282716, -0.06279051952931333}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321745`, 0.13432357556791324`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 104->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.99556196460308, -0.0941083133185141}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2726460394175402, 0.19661941470322838`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 105->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9921147013144779, -0.1253332335643043}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.24262915891745934`, 0.2538532984341241}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 106->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9876883405951378, -0.15643446504023076}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980824`, 0.30533977473446205`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 107->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9822872507286886, -0.18738131458572477}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.1674312808608387, 0.3508518553281649}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 108->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9759167619387474, -0.2181432413965425}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197914`, 0.39048616701593036`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 109->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9685831611286311, -0.24868988716485502}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.08067374053697816, 0.42453637025612573`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 110->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9602936856769431, -0.27899110603922933}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.035388686500549126`, 0.4533970632238786}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 111->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9510565162951535, -0.30901699437494773}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807814, 0.47749987495062346`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 112->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9408807689542255, -0.33873792024529153}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.05586585891603555, 0.4972750663825275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 113->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9297764858882512, -0.36812455268467836}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169915`, 0.5131306803051378}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 114->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9177546256839814, -0.39714789063478}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304568`, 0.5254427481221684}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 115->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9048270524660197, -0.42577929156507227}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.189060499529885, 0.5345520154476681}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 116->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8910065241883681, -0.4539904997395463}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2316200019584887, 0.5407642716278158}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 117->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8763066800438637, -0.481753674101715}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2730590489366066, 0.5443525109115593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 118->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8607420270039439, -0.5090414157503709}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3133067182793015, 0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 119->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8443279255020152, -0.5358267949789964}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.35231390979977256`, 0.5446029253750275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 120->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.827080574274562, -0.5620833778521303}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3900478949153408, 0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 121->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8090169943749475, -0.587785252292473}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665314`, 0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 122->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7901550123756905, -0.6129070536529763}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121416`, 0.5305746834651297}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 123->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7705132427757893, -0.6374239897486896}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.49544962924176167`, 0.5226957078337199}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 124->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7501110696304597, -0.6613118653236517}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198185, 0.5134347143846028}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 125->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7289686274214116, -0.6845471059286887}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455195, 0.5029041729238556}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 126->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7071067811865477, -0.7071067811865474}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5890955268533126, 0.49120597881094263`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 127->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.684547105928689, -0.7289686274214113}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424778, 0.4784327561156644}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 128->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6613118653236519, -0.7501110696304595}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498821, 0.46466898570375115`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 129->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6374239897486896, -0.7705132427757894}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320531, 0.4499919827334486}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 130->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6129070536529765, -0.7901550123756904}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763096, 0.4344727450867006}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 131->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5877852522924732, -0.8090169943749473}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138494, 0.41817669139005975`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 132->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5620833778521309, -0.8270805742745616}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435764, 0.4011643046514597}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 133->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5358267949789963, -0.8443279255020153}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264202, 0.38349169520660337`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 134->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5090414157503712, -0.8607420270039438}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631766, 0.36521109464093154`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 135->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.4817536741017153, -0.8763066800438636}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074031, 0.34637129061270927`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 136->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.4539904997395469, -0.8910065241883678}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.819224803295561, 0.3270180110216625}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 137->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.42577929156507216, -0.9048270524660198}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518694, 0.30719426471396105`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 138->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3971478906347803, -0.9177546256839813}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576703, 0.28694064485705895`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 139->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3681245526846786, -0.9297764858882511}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479959, 0.266295600228209}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 140->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3387379202452922, -0.9408807689542252}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738466, 0.2452956789127948}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 141->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.30901699437494756, -0.9510565162951535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939743, 0.2239757482809745}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 142->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.27899110603922955, -0.960293685676943}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699989, 0.20236919458456734`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 143->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.2486898871648553, -0.968583161128631}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599703, 0.1805081050747833}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 144->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.21814324139654326, -0.9759167619387472}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9177955602582817, 0.15842343517206856`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 145->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.18738131458572463, -0.9822872507286887}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296826, 0.1361451629107626}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 146->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.15643446504023106, -0.9876883405951377}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9311073641438069, 0.11370243262459098`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 147->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.12533323356430462, -0.9921147013144778}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, 0.09112368962632986}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 148->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.09410831331851485, -0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, 0.06843680746058549}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 149->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.0627905195293132, -0.9980267284282716}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, 0.04566920916711444}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 150->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.03141075907812829, -0.9995065603657316}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, 0.0228479838797983}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 151->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{-1.8369701987210297*^-16, -1.}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9449407874211548, 2.0043616024001853`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 152->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.03141075907812794, -0.9995065603657316}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, -0.022847983879797903`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 153->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.06279051952931283, -0.9980267284282716}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, -0.04566920916711405}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 154->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.09410831331851449, -0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, -0.06843680746058606}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 155->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.12533323356430423, -0.9921147013144779}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, -0.09112368962632948}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 156->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.15643446504023067, -0.9876883405951378}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.931107364143807, -0.11370243262459061`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 157->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.18738131458572427, -0.9822872507286887}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296827, -0.13614516291076217`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 158->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.21814324139654287, -0.9759167619387473}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9177955602582817, -0.15842343517206817`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 159->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.24868988716485496, -0.9685831611286311}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599705, -0.1805081050747829}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 160->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.2789911060392293, -0.9602936856769431}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699993, -0.20236919458456695`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 161->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.30901699437494723, -0.9510565162951536}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939746, -0.2239757482809741}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 162->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.33873792024529187, -0.9408807689542253}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738467, -0.24529567891279444`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 163->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.3681245526846783, -0.9297764858882512}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479962, -0.26629560022820864`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 164->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.39714789063477995, -0.9177546256839815}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576704, -0.28694064485705867`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 165->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4257792915650718, -0.9048270524660199}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518696, -0.3071942647139607}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 166->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.45399049973954664, -0.8910065241883679}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8192248032955614, -0.3270180110216622}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 167->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.48175367410171493, -0.8763066800438638}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074034, -0.34637129061270905`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 168->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5090414157503708, -0.860742027003944}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631768, -0.3652110946409312}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 169->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.535826794978996, -0.8443279255020155}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264205, -0.38349169520660314`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 170->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5620833778521306, -0.8270805742745618}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435766, -0.4011643046514593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 171->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5877852522924729, -0.8090169943749476}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138498, -0.4181766913900595}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 172->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6129070536529762, -0.7901550123756906}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763099, -0.4344727450867003}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 173->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6374239897486893, -0.7705132427757896}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320534, -0.44999198273344837`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 174->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6613118653236519, -0.7501110696304595}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498824, -0.4646689857037509}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 175->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6845471059286886, -0.7289686274214116}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424781, -0.47843275611566416`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 176->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7071067811865474, -0.7071067811865477}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.589095526853313, -0.49120597881094247`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 177->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7289686274214113, -0.684547105928689}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455199, -0.5029041729238554}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 178->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7501110696304591, -0.6613118653236523}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198201, -0.5134347143846023}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 179->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7705132427757894, -0.6374239897486896}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.4954496292417632, -0.5226957078337194}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 180->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7901550123756904, -0.6129070536529765}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121466`, -0.5305746834651296}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 181->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8090169943749473, -0.5877852522924732}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665364`, -0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 182->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8270805742745616, -0.5620833778521309}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.39004789491534125`, -0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 183->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8443279255020153, -0.5358267949789963}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3523139097997719, -0.5446029253750275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 184->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8607420270039438, -0.5090414157503712}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.31330671827930195`, -0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 185->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8763066800438636, -0.4817536741017153}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2730590489366065, -0.5443525109115592}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 186->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8910065241883678, -0.45399049973954697}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.23162000195849025`, -0.540764271627816}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 187->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9048270524660198, -0.4257792915650722}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.18906049952988485`, -0.5345520154476681}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 188->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9177546256839813, -0.3971478906347803}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304616`, -0.5254427481221685}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 189->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9297764858882511, -0.36812455268467864}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169961`, -0.5131306803051379}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 190->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9408807689542251, -0.33873792024529226}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.055865858916036494`, -0.4972750663825279}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 191->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9510565162951535, -0.3090169943749476}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807758, -0.47749987495062324`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 192->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.960293685676943, -0.2789911060392296}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0353886865005464, -0.4533970632238802}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 193->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.968583161128631, -0.24868988716485535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.08067374053697732, -0.4245363702561263}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 194->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9759167619387472, -0.2181432413965433}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197801`, -0.3904861670159313}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 195->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9822872507286887, -0.18738131458572468}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.16743128086083875`, -0.3508518553281648}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 196->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9876883405951377, -0.15643446504023112}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980796`, -0.3053397747344624}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 197->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9921147013144778, -0.12533323356430467}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.24262915891745893`, -0.2538532984341248}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 198->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.99556196460308, -0.09410831331851492}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2726460394175394, -0.1966194147032301}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 199->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9980267284282716, -0.06279051952931326}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321734`, -0.13432357556791366`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 200->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9995065603657316, -0.031410759078128354}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535873`, -0.06819954733524276}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 201->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{1., -2.4492935982947064*^-16}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3149802624737183, -2.6724821365335806`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}]}, 
               Dynamic[$CellContext`i11$$],
               Alignment->Automatic,
               BaseStyle->"ListAnimateCore",
               ImageSize->All,
               TransitionDirection->Horizontal,
               TransitionDuration->0.5,
               TransitionEffect->Automatic],
              Identity,
              Editable->True,
              Selectable->True],
             ImageMargins->10],
            Deployed->False,
            StripOnInput->False,
            ScriptLevel->0,
            GraphicsBoxOptions->{PreserveImageOptions->True},
            Graphics3DBoxOptions->{PreserveImageOptions->True}],
           Identity,
           Editable->False,
           Selectable->False],
          Alignment->{Left, Center},
          Background->GrayLevel[1],
          Frame->1,
          FrameStyle->GrayLevel[0, 0.2],
          ItemSize->Automatic,
          StripOnInput->False]}
       },
       AutoDelete->False,
       GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Top}}},
       GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {
           Offset[0.7], {
            Offset[0.5599999999999999]}, 
           Offset[0.7]}, "Rows" -> {
           Offset[0.4], {
            Offset[0.8]}, 
           Offset[0.4]}}],
      DefaultBaseStyle->{},
      FrameMargins->{{5, 5}, {5, 5}}],
     BaselinePosition->Automatic,
     ImageMargins->0],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "ListAnimate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.878645014149555*^9, 3.878645055540079*^9, {3.8786451699549017`*^9, 
   3.878645196240698*^9}, 3.878645259264482*^9, 3.8786456098550158`*^9, 
   3.878646599540316*^9, 3.878646647786351*^9, 3.878646691987714*^9, 
   3.878646902645092*^9, 3.878647426367169*^9, 3.878803675358614*^9, 
   3.890987390698711*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"0ed66c3f-581e-49a1-9ebf-6fe435cd9d33"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Export", "[", 
   RowBox[{"\"\<stable21.mov\>\"", ",", "stable", ",", " ", 
    RowBox[{"\"\<ControlAppearance\>\"", "\[Rule]", "None"}]}], "]"}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.8786467981638813`*^9, 3.878646821364601*^9}, 
   3.878647092857706*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"7f38f813-c224-4ef0-9e88-0c970bfb75a4"],

Cell["\<\
Calculate successive positions of Jupiter and the asteroid for the unstable \
case of the 2:1 resonance.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646258054105*^9}, {3.8786464672512074`*^9, 3.878646467430174*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4d1b10c5-5747-4229-a988-a14b69b8373a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"jpoints2", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"EdgeForm", "[", 
          RowBox[{"Thickness", "[", "0.005", "]"}], "]"}], ",", "color2", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{"#", ",", "0.05"}], "]"}]}], "}"}], "]"}], "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"position", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"meananom", "/", "2"}], "+", "\[Pi]"}], ",", "1", ",", 
         "0"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"meananom", ",", "0", ",", 
         RowBox[{"4", "\[Pi]"}], ",", 
         RowBox[{"2", 
          RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.878644534707349*^9, 3.878644567527005*^9}, {
  3.878644660199181*^9, 3.878644690962152*^9}, {3.8786447449198503`*^9, 
  3.878644758478959*^9}, {3.8786451496913137`*^9, 3.878645157323955*^9}, {
  3.878645438320786*^9, 3.878645466579253*^9}, {3.8786454995966063`*^9, 
  3.878645504320167*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"2840dc16-b893-463e-8c3d-3b6e64bcf3ee"],

Cell[BoxData[
 RowBox[{
  RowBox[{"apoints2", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "0.02", "]"}], ",", "color1", ",", 
         RowBox[{"Point", "[", "#", "]"}]}], "}"}], "]"}], "&"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"position", "[", 
        RowBox[{
         RowBox[{"meananom", "+", "\[Pi]"}], ",", "aa", ",", "ae"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"meananom", ",", "0", ",", 
         RowBox[{"4", "\[Pi]"}], ",", 
         RowBox[{"2", 
          RowBox[{"\[Pi]", "/", "100"}]}]}], "}"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.8786447835883303`*^9, 3.8786448337198687`*^9}, {
  3.8786451843892317`*^9, 3.878645185021069*^9}, {3.878645440445937*^9, 
  3.878645469954423*^9}, {3.878645509749127*^9, 3.8786455110834513`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"3deb5af6-7fd4-4bcd-8fa8-8038ac7b4e93"],

Cell["Determine the number of pairs of positions to be plotted.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a62a4a08-349f-421b-86e9-14f5473c69d1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"npoints", "=", 
  RowBox[{"Length", "[", "jpoints2", "]"}]}]], "Input",
 CellChangeTimes->{{3.87864484178819*^9, 3.878644863079666*^9}, 
   3.878645542344593*^9},
 CellLabel->"In[17]:=",ExpressionUUID->"29154ff2-ef5d-4489-b647-0c881c4df06d"],

Cell[BoxData["201"], "Output",
 CellChangeTimes->{3.878644864388814*^9, 3.878645191320154*^9, 
  3.878645549704773*^9, 3.878646599767742*^9, 3.878646702704483*^9, 
  3.878646942089724*^9, 3.878647426539936*^9, 3.878803676268976*^9, 
  3.890987391021985*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"110f708a-8ab4-4c6f-89bc-119b4ccd188a"]
}, Open  ]],

Cell["\<\
Combine the backdrop of the orbits and Sun with the positions of the asteroid \
and Jupiter at successive times for the unstable configuration.\
\>", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}, {3.878646368052926*^9, 3.87864642837353*^9}, {
  3.8786464869245234`*^9, 3.8786464871056013`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"2c6397c0-289b-475c-9a9d-74dff4d0eab8"],

Cell[BoxData[
 RowBox[{
  RowBox[{"unstableplots", "=", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"backdrop", ",", 
       RowBox[{"jpoints2", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"apoints2", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"PlotRange", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "npoints"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.878644875702023*^9, 3.878644943549284*^9}, {
  3.8786449765501842`*^9, 3.8786450501479816`*^9}, {3.878645248294004*^9, 
  3.878645255975646*^9}, {3.878645553564694*^9, 3.878645581195122*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"41dd16f7-d98e-404e-a896-58980ab5d27f"],

Cell["Animate the stable case.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.878562723826318*^9, 3.878562748545373*^9}, {
  3.878646014560174*^9, 3.8786460463738422`*^9}, {3.878646157239519*^9, 
  3.878646297669169*^9}, {3.878646368052926*^9, 3.8786464478174677`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"fb1913dd-97d5-401b-aa8b-505c38396fa0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"unstable", "=", 
  RowBox[{"ListAnimate", "[", "unstableplots", "]"}]}]], "Input",
 CellChangeTimes->{{3.878645003901153*^9, 3.878645012722374*^9}, {
  3.878645559819111*^9, 3.878645559971675*^9}, {3.8786465275550127`*^9, 
  3.878646530322445*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"4b013aa8-7daa-4143-88c7-6a21e008b3f0"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`i12$$ = 61, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {
    "\"min\"" :> {$CellContext`i12$$ = 1}, 
     "\"max\"" :> {$CellContext`i12$$ = 201}}, Typeset`bookmarkMode$$ = 
    "Menu", Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`i12$$], 1, ""}, 1, 201, 1}}, Typeset`size$$ = 
    Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True}, 
    PaneBox[
     PanelBox[GridBox[{
        {
         ItemBox[
          ItemBox[
           TagBox[
            StyleBox[GridBox[{
               {"\<\"\"\>", 
                AnimatorBox[Dynamic[$CellContext`i12$$], {1, 201, 1},
                 AnimationRate->Automatic,
                 AnimationRunTime->6.911253929138184,
                 AnimationTimeIndex->1.517412935323383,
                 
                 AppearanceElements->{
                  "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
                   "DirectionButton"},
                 AutoAction->False,
                 DisplayAllSteps->True]}
              },
              AutoDelete->False,
              
              GridBoxAlignment->{
               "Columns" -> {Right, {Left}}, "Rows" -> {{Baseline}}},
              
              GridBoxItemSize->{
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
             "ListAnimateLabel",
             StripOnInput->False],
            {"ControlArea", Top}],
           Alignment->{Automatic, Inherited},
           StripOnInput->False],
          Background->None,
          StripOnInput->False]},
        {
         ItemBox[
          TagBox[
           StyleBox[
            PaneBox[
             TagBox[
              PaneSelectorBox[{1->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{-1., 1.2246467991473532*^-16}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9449407874211548, 6.681205341333952*^-17}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 2->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9995065603657316, -0.031410759078127994}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, -0.022847983879798035`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 3->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9980267284282716, -0.06279051952931333}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, -0.04566920916711418}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 4->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.99556196460308, -0.0941083133185141}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, -0.06843680746058571}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 5->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9921147013144779, -0.1253332335643043}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, -0.09112368962632962}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 6->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9876883405951378, -0.15643446504023076}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.931107364143807, -0.11370243262459051`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 7->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9822872507286886, -0.18738131458572477}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296826, -0.13614516291076278`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 8->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9759167619387474, -0.2181432413965425}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.917795560258282, -0.1584234351720674}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 9->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9685831611286311, -0.24868988716485502}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599707, -0.18050810507478257`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 10->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9602936856769431, -0.27899110603922933}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699989, -0.2023691945845673}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 11->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9510565162951535, -0.30901699437494773}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939743, -0.22397574828097447`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 12->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9408807689542255, -0.33873792024529153}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738471, -0.2452956789127939}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 13->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9297764858882512, -0.36812455268467836}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479962, -0.26629560022820875`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 14->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9177546256839814, -0.39714789063478}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576699, -0.28694064485705917`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 15->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.9048270524660197, -0.42577929156507227}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518694, -0.3071942647139613}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 16->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8910065241883681, -0.4539904997395463}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8192248032955608, -0.3270180110216627}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 17->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8763066800438637, -0.481753674101715}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074031, -0.34637129061270927`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 18->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8607420270039439, -0.5090414157503709}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631761, -0.3652110946409319}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 19->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8443279255020152, -0.5358267949789964}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264195, -0.3834916952066039}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 20->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.827080574274562, -0.5620833778521303}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435768, -0.40116430465145925`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 21->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.8090169943749475, -0.587785252292473}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138496, -0.4181766913900596}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 22->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7901550123756905, -0.6129070536529763}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763104, -0.4344727450867001}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 23->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7705132427757893, -0.6374239897486896}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320533, -0.4499919827334484}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 24->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7501110696304597, -0.6613118653236517}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498828, -0.46466898570375076`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 25->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7289686274214116, -0.6845471059286887}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424781, -0.4784327561156642}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 26->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.7071067811865477, -0.7071067811865474}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5890955268533128, -0.4912059788109425}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 27->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.684547105928689, -0.7289686274214113}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455203, -0.5029041729238553}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 28->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6613118653236519, -0.7501110696304595}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198188, -0.5134347143846026}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 29->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6374239897486896, -0.7705132427757894}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.49544962924176367`, -0.5226957078337193}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 30->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.6129070536529765, -0.7901550123756904}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121455`, -0.5305746834651296}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 31->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5877852522924732, -0.8090169943749473}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665353`, -0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 32->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5620833778521309, -0.8270805742745616}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3900478949153411, -0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 33->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5358267949789963, -0.8443279255020153}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.35231390979977345`, -0.5446029253750274}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 34->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.5090414157503712, -0.8607420270039438}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3133067182793024, -0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 35->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.4817536741017153, -0.8763066800438636}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.27305904893660743`, -0.5443525109115593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 36->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.4539904997395469, -0.8910065241883678}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.23162000195848956`, -0.5407642716278159}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 37->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.42577929156507216, -0.9048270524660198}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.18906049952988582`, -0.5345520154476683}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 38->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3971478906347803, -0.9177546256839813}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304654`, -0.5254427481221686}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 39->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3681245526846786, -0.9297764858882511}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169892`, -0.5131306803051376}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 40->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3387379202452922, -0.9408807689542252}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.0558658589160353, -0.4972750663825274}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 41->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.30901699437494756, -0.9510565162951535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807793, -0.4774998749506234}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 42->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.27899110603922955, -0.960293685676943}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.035388686500549264`, -0.45339706322387857`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 43->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.2486898871648553, -0.968583161128631}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0806737405369783, -0.4245363702561256}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 44->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.21814324139654326, -0.9759167619387472}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197927`, -0.39048616701593025`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 45->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.18738131458572463, -0.9822872507286887}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.16743128086083814`, -0.35085185532816543`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 46->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.15643446504023106, -0.9876883405951377}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980774`, -0.30533977473446267`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 47->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.12533323356430462, -0.9921147013144778}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2426291589174592, -0.25385329843412424`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 48->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.09410831331851485, -0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.27264603941754, -0.1966194147032286}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 49->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.0627905195293132, -0.9980267284282716}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2955876417932173, -0.134323575567914}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 50->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.03141075907812829, -0.9995065603657316}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535884`, -0.06819954733524215}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 51->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{-1.8369701987210297*^-16, -1.}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3149802624737183, -1.3362410682667903`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 52->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.03141075907812794, -0.9995065603657316}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535895`, 0.06819954733524139}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 53->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.06279051952931283, -0.9980267284282716}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321745`, 0.13432357556791324`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 54->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.09410831331851449, -0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2726460394175402, 0.19661941470322838`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 55->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.12533323356430423, -0.9921147013144779}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.24262915891745934`, 0.2538532984341241}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 56->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.15643446504023067, -0.9876883405951378}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980824`, 0.30533977473446205`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 57->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.18738131458572427, -0.9822872507286887}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.1674312808608387, 0.3508518553281649}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 58->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.21814324139654287, -0.9759167619387473}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197914`, 0.39048616701593036`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 59->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.24868988716485496, -0.9685831611286311}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.08067374053697816, 0.42453637025612573`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 60->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.2789911060392293, -0.9602936856769431}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.035388686500549126`, 0.4533970632238786}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 61->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.30901699437494723, -0.9510565162951536}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807814, 0.47749987495062346`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 62->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.33873792024529187, -0.9408807689542253}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.05586585891603555, 0.4972750663825275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 63->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.3681245526846783, -0.9297764858882512}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169915`, 0.5131306803051378}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 64->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.39714789063477995, -0.9177546256839815}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304568`, 0.5254427481221684}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 65->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4257792915650718, -0.9048270524660199}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.189060499529885, 0.5345520154476681}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 66->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.45399049973954664, -0.8910065241883679}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2316200019584887, 0.5407642716278158}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 67->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.48175367410171493, -0.8763066800438638}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2730590489366066, 0.5443525109115593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 68->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5090414157503708, -0.860742027003944}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3133067182793015, 0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 69->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.535826794978996, -0.8443279255020155}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.35231390979977256`, 0.5446029253750275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 70->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5620833778521306, -0.8270805742745618}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3900478949153408, 0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 71->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5877852522924729, -0.8090169943749476}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665314`, 0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 72->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6129070536529762, -0.7901550123756906}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121416`, 0.5305746834651297}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 73->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6374239897486893, -0.7705132427757896}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.49544962924176167`, 0.5226957078337199}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 74->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6613118653236519, -0.7501110696304595}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198185, 0.5134347143846028}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 75->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6845471059286886, -0.7289686274214116}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455195, 0.5029041729238556}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 76->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7071067811865474, -0.7071067811865477}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5890955268533126, 0.49120597881094263`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 77->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7289686274214113, -0.684547105928689}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424778, 0.4784327561156644}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 78->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7501110696304591, -0.6613118653236523}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498821, 0.46466898570375115`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 79->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7705132427757894, -0.6374239897486896}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320531, 0.4499919827334486}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 80->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7901550123756904, -0.6129070536529765}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763096, 0.4344727450867006}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 81->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8090169943749473, -0.5877852522924732}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138494, 0.41817669139005975`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 82->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8270805742745616, -0.5620833778521309}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435764, 0.4011643046514597}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 83->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8443279255020153, -0.5358267949789963}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264202, 0.38349169520660337`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 84->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8607420270039438, -0.5090414157503712}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631766, 0.36521109464093154`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 85->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8763066800438636, -0.4817536741017153}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074031, 0.34637129061270927`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 86->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8910065241883678, -0.45399049973954697}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.819224803295561, 0.3270180110216625}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 87->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9048270524660198, -0.4257792915650722}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518694, 0.30719426471396105`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 88->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9177546256839813, -0.3971478906347803}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576703, 0.28694064485705895`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 89->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9297764858882511, -0.36812455268467864}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479959, 0.266295600228209}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 90->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9408807689542251, -0.33873792024529226}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738466, 0.2452956789127948}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 91->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9510565162951535, -0.3090169943749476}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939743, 0.2239757482809745}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 92->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.960293685676943, -0.2789911060392296}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699989, 0.20236919458456734`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 93->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.968583161128631, -0.24868988716485535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599703, 0.1805081050747833}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 94->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9759167619387472, -0.2181432413965433}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9177955602582817, 0.15842343517206856`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 95->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9822872507286887, -0.18738131458572468}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296826, 0.1361451629107626}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 96->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9876883405951377, -0.15643446504023112}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9311073641438069, 0.11370243262459098`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 97->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9921147013144778, -0.12533323356430467}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, 0.09112368962632986}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 98->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.99556196460308, -0.09410831331851492}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, 0.06843680746058549}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 99->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9980267284282716, -0.06279051952931326}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, 0.04566920916711444}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 100->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9995065603657316, -0.031410759078128354}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, 0.0228479838797983}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 101->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{1., -2.4492935982947064*^-16}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9449407874211548, 2.0043616024001853`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 102->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9995065603657316, 0.03141075907812699}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9443880972694263, -0.022847983879797903`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 103->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9980267284282716, 0.06279051952931276}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9427297035493626, -0.04566920916711405}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 104->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9955619646030801, 0.09410831331851353}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9399646362822588, -0.06843680746058606}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 105->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9921147013144779, 0.12533323356430418}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9360912782434938, -0.09112368962632948}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 106->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9876883405951379, 0.15643446504022973}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.931107364143807, -0.11370243262459061`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 107->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9822872507286887, 0.1873813145857242}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9250099796296827, -0.13614516291076217`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 108->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9759167619387475, 0.21814324139654195}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9177955602582817, -0.15842343517206817`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 109->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9685831611286311, 0.2486898871648549}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.9094598906599705, -0.1805081050747829}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 110->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9602936856769433, 0.27899110603922833}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8999981041699993, -0.20236919458456695`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 111->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9510565162951536, 0.3090169943749472}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8894046832939746, -0.2239757482809741}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 112->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9408807689542256, 0.338737920245291}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8776734614738467, -0.24529567891279444`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 113->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9297764858882513, 0.36812455268467825}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8647976267479962, -0.26629560022820864`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 114->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9177546256839815, 0.3971478906347799}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8507697280576704, -0.28694064485705867`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 115->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.9048270524660196, 0.4257792915650726}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8355816851518696, -0.3071942647139607}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 116->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.891006524188368, 0.4539904997395466}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8192248032955614, -0.3270180110216622}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 117->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8763066800438634, 0.4817536741017157}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.8016897943074034, -0.34637129061270905`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 118->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.860742027003944, 0.5090414157503708}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7829668058631768, -0.3652110946409312}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 119->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.844327925502015, 0.5358267949789967}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7630454615264205, -0.38349169520660314`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 120->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.8270805742745618, 0.5620833778521306}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7419149146435766, -0.4011643046514593}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 121->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.809016994374947, 0.5877852522924737}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.7195639201138498, -0.4181766913900595}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 122->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7901550123756906, 0.6129070536529762}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6959809291763099, -0.4344727450867003}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 123->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.770513242775789, 0.63742398974869}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6711542138320534, -0.44999198273344837`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 124->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7501110696304595, 0.6613118653236519}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6450720294498824, -0.4646689857037509}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 125->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.728968627421411, 0.6845471059286893}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.6177228266424781, -0.47843275611566416`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 126->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.7071067811865477, 0.7071067811865472}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.589095526853313, -0.49120597881094247`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 127->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6845471059286897, 0.7289686274214106}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5591798805455199, -0.5029041729238554}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 128->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6613118653236524, 0.7501110696304591}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.5279669328198201, -0.5134347143846023}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 129->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6374239897486903, 0.7705132427757887}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.4954496292417632, -0.5226957078337194}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 130->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.6129070536529766, 0.7901550123756903}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.46162360536121466`, -0.5305746834651296}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 131->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5877852522924741, 0.8090169943749467}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.42648821786665364`, -0.5369470915808212}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 132->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.562083377852131, 0.8270805742745615}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.39004789491534125`, -0.5416745657345787}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 133->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5358267949789972, 0.8443279255020147}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.3523139097997719, -0.5446029253750275}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 134->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.5090414157503713, 0.8607420270039436}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.31330671827930195`, -0.5455598928453314}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 135->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.48175367410171616, 0.8763066800438631}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.2730590489366065, -0.5443525109115592}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 136->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4539904997395471, 0.8910065241883677}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.23162000195849025`, -0.540764271627816}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 137->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.4257792915650731, 0.9048270524660194}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.18906049952988485`, -0.5345520154476681}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 138->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.3971478906347804, 0.9177546256839813}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.14548054491304616`, -0.5254427481221685}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 139->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.36812455268467875, 0.9297764858882511}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.10101888847169961`, -0.5131306803051379}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 140->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.33873792024529153, 0.9408807689542255}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.055865858916036494`, -0.4972750663825279}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 141->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.30901699437494773, 0.9510565162951535}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807758, -0.47749987495062324`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 142->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.2789911060392289, 0.9602936856769432}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0353886865005464, -0.4533970632238802}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 143->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.24868988716485543, 0.968583161128631}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.08067374053697732, -0.4245363702561263}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 144->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.2181432413965425, 0.9759167619387474}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633197801`, -0.3904861670159313}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 145->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.18738131458572474, 0.9822872507286886}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.16743128086083875`, -0.3508518553281648}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 146->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.15643446504023029, 0.9876883405951378}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980796`, -0.3053397747344624}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 147->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.12533323356430473, 0.9921147013144778}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.24262915891745893`, -0.2538532984341248}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 148->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.09410831331851409, 0.99556196460308}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2726460394175394, -0.1966194147032301}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 149->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.06279051952931332, 0.9980267284282716}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321734`, -0.13432357556791366`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 150->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{0.031410759078127536, 0.9995065603657316}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.31003869082535873`, -0.06819954733524276}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 151->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], DiskBox[{3.061616997868383*^-16, 1.}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3149802624737183, -2.6724821365335806`*^-16}]}},
                
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 152->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.031410759078126925, 0.9995065603657316}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.3100386908253593, 0.06819954733523934}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 153->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.06279051952931271, 0.9980267284282716}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.29558764179321717`, 0.13432357556791405`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 154->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.09410831331851348, 0.9955619646030801}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2726460394175408, 0.19661941470322686`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 155->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.12533323356430412, 0.9921147013144779}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.2426291589174597, 0.25385329843412346`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 156->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.15643446504022968, 0.9876883405951379}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.20707378224980957`, 0.30533977473446033`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 157->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.18738131458572502, 0.9822872507286886}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.1674312808608391, 0.35085185532816443`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 158->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.21814324139654104, 0.9759167619387478}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.12495647633198004`, 0.39048616701592964`}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 159->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.2486898871648548, 0.9685831611286311}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0806737405369778, 0.4245363702561259}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 160->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.2789911060392291, 0.9602936856769431}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{0.0353886865005478, 0.4533970632238794}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 161->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.3090169943749471, 0.9510565162951536}, 0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.01028026429807702, 0.4774998749506229}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 162->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]], 
                  DiskBox[{-0.33873792024529087, 0.9408807689542257}, 
                   0.05]}, 
                 {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.02], 
                  PointBox[{-0.05586585891603492, 0.4972750663825273}]}},
                AspectRatio->Automatic,
                PlotRange->{{-1.1, 1.1}, {-1.1, 1.1}}], 163->
               GraphicsBox[{{
                  {PointSize[0.2], PointBox[{0, 0}]}, 
                  {RGBColor[0.880722, 0.611041, 0.142051], 
                   CircleBox[{0, 0}, 1]}, {{}, {{}, {}, 
                    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
                    0.009166666666666668], AbsoluteThickness[1.6], 
                    LineBox[CompressedData["
1:eJyN1ntQVGUYBvCFTETHDMELgoFjXnInKy8YBr6gKCIwlJWXAXQw8JKpCMqQ
IkwCVt7AFBCnBgEhRdEEjPu8LKKmcltA0GWBXRFdwUWUq5MO1XwPf3CSGZnZ
4Y8ze8533vd5frNTNuxY6Wcok8kS//389/9QwJEXSTNrSIa/vO1bd8WlVVOE
19Kq5OIrNKc84bQBVRFN7VFWOFyjuO5Dsy6MqqTs8LuVwXnlZPKrx03fH25R
R/G52ksHq+l2mHXpZfMSanEKjT5hVUe278VtdvHOIxdVw9EcKxWtXJUs1zz7
nY5a/qiriVHTrOtJ2crRkdwZ8EeSZ1QjmextqN867zKH7HFrHjFaQyrXnNrq
48zFL6en70zUUNeSj7otlNd5k8N4zz9Haql3m2JjbkoZux6/1NThrqU+kzPO
kdZV7OObsC16h5a894b2rPa4w9Fy6+itgVqyepp/vMf7Lmf/ZLa2xktLa4J6
7WJc67kksyjt/GwtmS2M6imb0MgPzZv9A9o01Dbm20wHHw0XW3wcsiZGQ8pe
07WaFC3HGRhOdJmtoRCFQt147z47tqfMbdvRRAsn7G9b/6qZXatmbinY1Egt
ywMfHHm3hbP9D1/MWNZAc778viPW9CH/NSz2wtwxalp8dkRr2vBHbGKyTr75
qooMuV314vEjbnFbcdXJ7x4FrM1+mFGoY33g5PnHeuqo5mR/+Fv7H3OavXtq
e3AtfUrOT8cvaGVNQlKnWl9DFx0v3BjX0MoHLIYv4VXVVNv04a1pu9r4xLln
3U1ZSnKLNU/e8rKNOdpo4i7jSuobtrtCFvSED/j8XWR3vpS6SfmzkfYJZ77y
zmied5OiCq051l7PuinjgnSXr5H/d0bGJYf0fH+zzSSH94vJrV9xPvG2npNm
xC89ZVFIG8/axy56pWfnhLnTrmuu0Jb41d+kWrdzsPJB+fQF6RShC/fUzm/n
uv6AYINFv1Gl/KugLrt2Nv/snHxD+mk7yXWWfJ8l9+eB50eI5/NOnK9anI+P
4fz14vzci/dLFe/HkvdnyXx4YH6Hxfw4HfONFPNlG8z/kZg/38F+UsR+WLI/
Hob9Non98lLs/x2xf5bkg3XIT6bID9sgX+4iX7wH+XMS+eMq5POkyCdL8suT
ke9mkW9eh/xfE/nnSehHjugHe6E/UaI/3Dm4XyzpH7ein36inyzpL09Fv/eJ
fvMD9L9X9J87vxY+xAgf2BJ+eAg/OBu+6IUvPAr+dAt/OBY+ZQmf+BP45ST8
4lz4FiZ84wH/JlC+gdoxuSAf113gny2+bwn/Bu5fCP+s8PzWIfz7AudfBv+S
4N8B+Lf+hnj/PvhnLPHvBuangH8qzNcX/tVh/iuG8G+1xD9T7Dd3CP9GSfzr
QH6K4F8F8nUK/kny9z//6pHfIvhnh3wXwr8lyP9Y+Pc2+qGBf/7oz/Mh/LNF
/7TwT9JPqkJ/E97Qv074oJD4dw/+DfjyfAj/fOGTr8S/rDf0LxzXP5cFvtY/
P9x/Gfxzx/MjJf41w79fcP5S+CfxnV/i/UPgnzvmkwP/ajC/ePh3CfMNg392
mL8a/g3s58wQ/hlhvyr4txz7N4Z/tsiHAv7dR35y4Z898uUM//Yhf4vhXzXy
GQ//upBfhn8y5FsH/zYg/8Xwz0Li3+7B/eGRYwf7Z7Zd9M8N/vUP/n3CZm6i
vyXwT45+h8I/Ofzrgn8fwIco+Cf5/cQZ8KUD/kl+f/FB+NQK/2zg1wz4lwXf
yl7rX2bBPyLjoq8=
                    "]]}}, {{}, {}}}}, 
                 {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[Thickness[
                  0.005]],