(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     18893,        469]
NotebookOptionsPosition[     17394,        442]
NotebookOutlinePosition[     17814,        459]
CellTagsIndexPosition[     17771,        456]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Last checked 20 April, 2023",
 CellFrame->True,
 Background->GrayLevel[0.849989]]], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.851321730299733*^9, 3.851321747924562*^9}, 
   3.8513218075505953`*^9, {3.890897811719871*^9, 3.890897826726935*^9}, {
   3.890973965108789*^9, 3.8909739653874283`*^9}},
 TextAlignment->Left,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"88ba0939-a8c3-43e5-aef1-352da244f4b4"],

Cell["Chapter 8, Section 8.5, Table 8.5", "Section",ExpressionUUID->"567f9698-15cd-4c81-ab81-689dfc74ded0"],

Cell[TextData[{
 "Use the definition of ",
 StyleBox["LaplaceCoefficient", "Input"],
 " from the ",
 StyleBox["DisturbingFunction", "Input"],
 " package."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"558e2beb-4336-43a2-9c0b-31de039a82ff"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceCoefficient", "[", 
   RowBox[{"s_", ",", "jj_Integer", ",", "a_", ",", "n_Integer"}], "]"}], ":=",
   "\n", "  ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"outside", ",", 
      RowBox[{"j", "=", 
       RowBox[{"Abs", "[", "jj", "]"}]}], ",", "cterm", ",", "cbterm", ",", 
      "csum", ",", "i", ",", "k"}], "}"}], ",", "\n", "    ", 
    RowBox[{
     RowBox[{"outside", "=", 
      RowBox[{"2", "*", 
       RowBox[{
        RowBox[{"Product", "[", 
         RowBox[{
          RowBox[{"s", "+", "k"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "0", ",", 
            RowBox[{"j", "-", "1"}]}], "}"}]}], "]"}], "/", 
        RowBox[{"j", "!"}]}], "*", 
       RowBox[{"a", "^", 
        RowBox[{"(", 
         RowBox[{"j", "-", "n"}], ")"}]}]}]}], ";", "\n", "    ", 
     RowBox[{"cterm", "=", "1"}], ";", "\n", "    ", 
     RowBox[{"cbterm", "=", 
      RowBox[{"cterm", "*", 
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"j", "-", "k"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}]}], ";", "\n", "    ", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"i", "=", "1"}], ";", " ", 
        RowBox[{"csum", "=", "cbterm"}]}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"cbterm", ">", "$MachineEpsilon"}], ")"}], "||", 
        RowBox[{"(", 
         RowBox[{"cbterm", "\[Equal]", "0"}], ")"}]}], ",", 
       RowBox[{"i", "++"}], ",", "\n", "      ", 
       RowBox[{
        RowBox[{"cterm", "=", 
         RowBox[{"cterm", "*", 
          RowBox[{"(", 
           RowBox[{"s", "+", "i", "-", "1"}], ")"}], "*", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"s", "+", "j", "+", "i", "-", "1"}], ")"}], "/", "i"}], 
           "/", 
           RowBox[{"(", 
            RowBox[{"j", "+", "i"}], ")"}]}], "*", 
          RowBox[{"a", "^", "2"}]}]}], ";", "\n", "      ", 
        RowBox[{"cbterm", "=", 
         RowBox[{"cterm", "*", 
          RowBox[{"Product", "[", 
           RowBox[{
            RowBox[{"j", "+", 
             RowBox[{"2", "*", "i"}], "-", "k"}], ",", 
            RowBox[{"{", 
             RowBox[{"k", ",", "0", ",", 
              RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}]}], ";", "\n", 
        "      ", 
        RowBox[{"csum", "=", 
         RowBox[{"csum", "+", "cbterm"}]}]}]}], "]"}], ";", "\n", "    ", 
     RowBox[{"Expand", "[", 
      RowBox[{"outside", "*", "csum"}], "]"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.879072710482382*^9, 3.8790727104917793`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"68585f33-c496-44e7-aa64-8e7c96e42fdc"],

Cell[TextData[{
 "Define a function, ",
 StyleBox["AlphaValues", "Input"],
 ", to return \[Alpha], \[Alpha]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", "1"], "(", "\[Alpha]", ")"}], TraditionalForm]],
  ExpressionUUID->"003fc2fc-71b1-463d-93e7-d78053428a3b"],
 " and \[Alpha]",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["f", 
     StyleBox["d",
      FontSlant->"Plain"]], "(", "\[Alpha]", ")"}], TraditionalForm]],
  ExpressionUUID->"4650c6ea-5d9b-4307-a85c-055634414f0e"],
 " for each resonance specified by ",
 StyleBox["p",
  FontSlant->"Italic"],
 "+",
 StyleBox["q",
  FontSlant->"Italic"],
 " and ",
 StyleBox["p",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"328d3989-dd5d-42cd-bbcb-bb055c1e790c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"AlphaValues", "[", 
   RowBox[{"{", 
    RowBox[{"ppq_", ",", " ", "p_"}], "}"}], "]"}], " ", ":=", "\n", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j", "=", "ppq"}], ",", " ", 
      RowBox[{"\[Alpha]", " ", "=", " ", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "/", 
           RowBox[{"(", "ppq", ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "/", "3"}], ")"}]}], "]"}]}]}], "}"}], ",", "\n", 
    RowBox[{
     RowBox[{"f1", " ", "=", " ", "\n", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "8"}], ")"}], "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "*", "\[Alpha]", "*", 
          RowBox[{"LaplaceCoefficient", "[", 
           RowBox[{
            RowBox[{"1", "/", "2"}], ",", " ", "0", ",", " ", "\[Alpha]", ",",
             " ", "1"}], "]"}]}], " ", "+", "\n", "        ", 
         RowBox[{
          RowBox[{"\[Alpha]", "^", "2"}], "*", 
          RowBox[{"LaplaceCoefficient", "[", 
           RowBox[{
            RowBox[{"1", "/", "2"}], ",", " ", "0", ",", " ", "\[Alpha]", ",",
             " ", "2"}], "]"}]}]}], ")"}]}]}], ";", "\n", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ppq", "-", "p"}], " ", "==", " ", "1"}], ",", " ", "\n", 
       RowBox[{"fd", " ", "=", "\n", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], "*", "j", "*", 
            RowBox[{"LaplaceCoefficient", "[", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", "j", ",", " ", "\[Alpha]", 
              ",", " ", "0"}], "]"}]}], " ", "+", "\n", "        ", 
           RowBox[{
            RowBox[{"-", "\[Alpha]"}], "*", 
            RowBox[{"LaplaceCoefficient", "[", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", "j", ",", " ", "\[Alpha]", 
              ",", " ", "1"}], "]"}]}]}], ")"}]}]}]}], "]"}], ";", "\n", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"ppq", "-", "p"}], " ", "==", " ", "2"}], ",", "\n", 
       RowBox[{"fd", " ", "=", "\n", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "8"}], ")"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], "*", "j"}], " ", "+", " ", 
              RowBox[{"4", "*", 
               RowBox[{"j", "^", "2"}]}]}], ")"}], "*", 
            RowBox[{"LaplaceCoefficient", "[", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", "j", ",", " ", "\[Alpha]", 
              ",", " ", "0"}], "]"}]}], " ", "+", "\n", "        ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], "*", "\[Alpha]"}], " ", "+", " ", 
              RowBox[{"4", "*", "j", "*", "\[Alpha]"}]}], ")"}], "*", 
            RowBox[{"LaplaceCoefficient", "[", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", "j", ",", " ", "\[Alpha]", 
              ",", " ", "1"}], "]"}]}], " ", "+", "\n", "         ", 
           RowBox[{
            RowBox[{"\[Alpha]", "^", "2"}], "*", 
            RowBox[{"LaplaceCoefficient", "[", 
             RowBox[{
              RowBox[{"1", "/", "2"}], ",", " ", "j", ",", " ", "\[Alpha]", 
              ",", " ", "2"}], "]"}]}]}], ")"}]}]}]}], "]"}], ";", "\n", 
     RowBox[{"{", 
      RowBox[{"ppq", ",", " ", "p", ",", " ", "\[Alpha]", ",", " ", 
       RowBox[{"\[Alpha]", "*", "f1"}], ",", " ", 
       RowBox[{"\[Alpha]", "*", "fd"}]}], "}"}]}]}], "\n", "]"}]}]], "Input",
 CellChangeTimes->{{3.879072728949695*^9, 3.879072728955452*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"9f5d7861-1c01-4217-9830-34b192c6d97b"],

Cell["Select the resonances for the table.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"6e745e35-8243-4a41-86c4-4e5e11430ff2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"resonances", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"6", ",", "5"}], "}"}], ",", "\n", "              ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"7", ",", "5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"9", ",", "7"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"11", ",", "9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.879072743362542*^9, 3.879072743371122*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"1ffc598a-35f8-41ec-a224-9bb6822addb9"],

Cell["Generate the values for the table.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"7121454e-ed17-47cf-ace5-9d38b23069d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{"table", " ", "=", " ", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AlphaValues", "[", "#", "]"}], "&"}], ",", " ", "resonances"}],
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8790727550050707`*^9, 3.879072755010755*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"b6bfdb20-bd62-4376-80d1-c9a81bd8310b"],

Cell["Display the results.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"3cb1a0f9-04c9-409a-b59a-15bbd8190ee3"],

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"table", ",", 
   RowBox[{"TableHeadings", "->", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
RowBox[{
StyleBox[\"p\", \"TI\"], \"+\", 
StyleBox[\"q\", \"TI\"]}], TraditionalForm], \"errors\" -> {}, \"input\" -> \
\"p+q\", \"state\" -> \"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\"", ",", 
        "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
StyleBox[\"p\", \"TI\"], TraditionalForm], \"errors\" -> {}, \"input\" -> \"p\
\", \"state\" -> \"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\"", ",", 
        "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[\"\[Alpha]\", \
TraditionalForm], \"errors\" -> {}, \"input\" -> \"\\\\alpha\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\"", ",", 
        "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
RowBox[{\"\[Alpha] \", 
SubscriptBox[
StyleBox[\"f\", \"TI\"], 
RowBox[{\"s\", \",\", \"1\"}]], 
RowBox[{\"(\", \"\[Alpha]\", \")\"}]}], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"\\\\alpha\\\\,f_{\\\\rm{s,1}}(\\\\alpha)\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\"", ",", 
        "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
RowBox[{\"\[Alpha] \", 
SubscriptBox[
StyleBox[\"f\", \"TI\"], \"d\"], 
RowBox[{\"(\", \"\[Alpha]\", \")\"}]}], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"\\\\alpha\\\\,f_{\\\\rm{d}}(\\\\alpha)\", \"state\" -> \"Boxes\
\"|>,\"TeXAssistantTemplate\"]\)\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.879072769356983*^9, 3.879072827083391*^9}, {
  3.8790728848857603`*^9, 3.879072935118709*^9}, {3.879072968330552*^9, 
  3.87907319835172*^9}},
 CellLabel->"In[5]:=",ExpressionUUID->"e48c3967-0ba9-4b05-9658-211fab19bcf7"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      TagBox["\<\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[RowBox[{StyleBox[\\\"p\\\", \\\"TI\\\"], \\\"+\\\", \
StyleBox[\\\"q\\\", \\\"TI\\\"]}], TraditionalForm], \\\"errors\\\" -> {}, \\\
\"input\\\" -> \\\"p+q\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> FormBox[StyleBox[\\\
\"p\\\", \\\"TI\\\"], TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\" \
-> \\\"p\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[\\\"\[Alpha]\\\", TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\
\" -> \\\"\\\\\\\\alpha\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[RowBox[{\\\"\[Alpha] \\\", SubscriptBox[StyleBox[\\\"f\\\", \
\\\"TI\\\"], RowBox[{\\\"s\\\", \\\",\\\", \\\"1\\\"}]], RowBox[{\\\"(\\\", \
\\\"\[Alpha]\\\", \\\")\\\"}]}], TraditionalForm], \\\"errors\\\" -> {}, \
\\\"input\\\" -> \\\"\\\\\\\\alpha\\\\\\\\,f_{\\\\\\\\rm{s,1}}(\\\\\\\\alpha)\
\\\", \\\"state\\\" -> \\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"\>",
       HoldForm], 
      TagBox["\<\"\\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[RowBox[{\\\"\[Alpha] \\\", SubscriptBox[StyleBox[\\\"f\\\", \
\\\"TI\\\"], \\\"d\\\"], RowBox[{\\\"(\\\", \\\"\[Alpha]\\\", \\\")\\\"}]}], \
TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\" -> \
\\\"\\\\\\\\alpha\\\\\\\\,f_{\\\\\\\\rm{d}}(\\\\\\\\alpha)\\\", \\\"state\\\" \
-> \\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"\>",
       HoldForm]},
     {"2", "1", "0.6299605249474366`", "0.2441899723065255`", 
      RowBox[{"-", "0.7499640348438882`"}]},
     {"3", "2", "0.7631428283688879`", "0.8797508999209263`", 
      RowBox[{"-", "1.5455341716765858`"}]},
     {"4", "3", "0.8254818122236567`", "1.8814737654897`", 
      RowBox[{"-", "2.344724836584575`"}]},
     {"5", "4", "0.8617738760127535`", "3.244939511355182`", 
      RowBox[{"-", "3.145145660198443`"}]},
     {"6", "5", "0.8855488076521759`", "4.968568034621297`", 
      RowBox[{"-", "3.9461319300367697`"}]},
     {"3", "1", "0.4807498567691362`", "0.06838124369988761`", 
      "0.2878524933796507`"},
     {"5", "3", "0.7113786608980126`", "0.5156566652853578`", 
      "2.3289164094706996`"},
     {"7", "5", "0.7990635300581406`", "1.3352319976637008`", 
      "6.289030419953237`"},
     {"9", "7", "0.8457402901133606`", "2.5181175536768183`", 
      "12.167331157250084`"},
     {"11", "9", "0.8747820899988616`", "4.061790895759118`", 
      "19.96391205509065`"}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxDividers->{
     "Columns" -> {{False}}, "Rows" -> {False, True, {False}, False}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[2.0999999999999996`]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   {None, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[
   BoxForm`e$, 
    TableHeadings -> {
     None, {"\!\(\*TemplateBox[<|\"boxes\" -> FormBox[RowBox[{StyleBox[\"p\", \
\"TI\"], \"+\", StyleBox[\"q\", \"TI\"]}], TraditionalForm], \"errors\" -> \
{}, \"input\" -> \"p+q\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)", 
       "\!\(\*TemplateBox[<|\"boxes\" -> FormBox[StyleBox[\"p\", \"TI\"], \
TraditionalForm], \"errors\" -> {}, \"input\" -> \"p\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)", 
       "\!\(\*TemplateBox[<|\"boxes\" -> FormBox[\"\[Alpha]\", \
TraditionalForm], \"errors\" -> {}, \"input\" -> \"\\\\alpha\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)", 
       "\!\(\*TemplateBox[<|\"boxes\" -> FormBox[RowBox[{\"\[Alpha] \", \
SubscriptBox[StyleBox[\"f\", \"TI\"], RowBox[{\"s\", \",\", \"1\"}]], \
RowBox[{\"(\", \"\[Alpha]\", \")\"}]}], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"\\\\alpha\\\\,f_{\\\\rm{s,1}}(\\\\alpha)\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)", 
       "\!\(\*TemplateBox[<|\"boxes\" -> FormBox[RowBox[{\"\[Alpha] \", \
SubscriptBox[StyleBox[\"f\", \"TI\"], \"d\"], RowBox[{\"(\", \"\[Alpha]\", \
\")\"}]}], TraditionalForm], \"errors\" -> {}, \"input\" -> \
\"\\\\alpha\\\\,f_{\\\\rm{d}}(\\\\alpha)\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)"}}]]]], "Output",
 CellChangeTimes->{
  3.879072937506147*^9, {3.879073120671657*^9, 3.8790732021627417`*^9}, 
   3.879073350265585*^9, {3.890987163522585*^9, 3.8909871904412622`*^9}},
 CellLabel->
  "Out[5]//TableForm=",ExpressionUUID->"94e165ee-074a-48ee-a68a-fd0593119eb1"]
},
CellGrouping->Manual,
WindowSize->{1052, 670},
WindowMargins->{{84, Automatic}, {Automatic, 20}},
FrontEndVersion->"13.2 for Mac OS X x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"202eb61c-febb-4288-8f4b-ef17b5724b2a"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 439, 9, 53, "Text",ExpressionUUID->"88ba0939-a8c3-43e5-aef1-352da244f4b4"],
Cell[1000, 31, 107, 0, 67, "Section",ExpressionUUID->"567f9698-15cd-4c81-ab81-689dfc74ded0"],
Cell[1110, 33, 276, 9, 49, "Text",ExpressionUUID->"558e2beb-4336-43a2-9c0b-31de039a82ff"],
Cell[1389, 44, 2765, 74, 220, "Input",ExpressionUUID->"68585f33-c496-44e7-aa64-8e7c96e42fdc"],
Cell[4157, 120, 803, 30, 53, "Text",ExpressionUUID->"328d3989-dd5d-42cd-bbcb-bb055c1e790c"],
Cell[4963, 152, 3978, 100, 346, "Input",ExpressionUUID->"9f5d7861-1c01-4217-9830-34b192c6d97b"],
Cell[8944, 254, 162, 3, 53, "Text",ExpressionUUID->"6e745e35-8243-4a41-86c4-4e5e11430ff2"],
Cell[9109, 259, 954, 26, 52, "Input",ExpressionUUID->"1ffc598a-35f8-41ec-a224-9bb6822addb9"],
Cell[10066, 287, 160, 3, 53, "Text",ExpressionUUID->"7121454e-ed17-47cf-ace5-9d38b23069d6"],
Cell[10229, 292, 365, 9, 30, "Input",ExpressionUUID->"b6bfdb20-bd62-4376-80d1-c9a81bd8310b"],
Cell[10597, 303, 146, 3, 53, "Text",ExpressionUUID->"3cb1a0f9-04c9-409a-b59a-15bbd8190ee3"],
Cell[10746, 308, 1787, 36, 34, "Input",ExpressionUUID->"e48c3967-0ba9-4b05-9658-211fab19bcf7"],
Cell[12536, 346, 4854, 94, 223, "Output",ExpressionUUID->"94e165ee-074a-48ee-a68a-fd0593119eb1"]
}
]
*)

