(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     94982,       2103]
NotebookOptionsPosition[     90386,       2027]
NotebookOutlinePosition[     90939,       2047]
CellTagsIndexPosition[     90896,       2044]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["Last checked 19 April, 2023",
 CellFrame->True,
 Background->GrayLevel[0.849989]]], "Text",
 CellFrame->True,
 CellChangeTimes->{{3.851321730299733*^9, 3.851321747924562*^9}, 
   3.8513218075505953`*^9, {3.890897811719871*^9, 3.890897826726935*^9}},
 TextAlignment->Left,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"1715f356-d7df-435e-9589-4e6e1357031f"],

Cell["Chapter 4, Section 4.6", "Section",ExpressionUUID->"49d7e63d-8a29-4b0e-a205-7f32cf3640b5"],

Cell["This section is concerned with the Darwin-Radau relation.", "Text",
 CellFrame->True,
 CellChangeTimes->{{3.863943369714531*^9, 3.8639434092392*^9}, {
  3.863945055689994*^9, 3.8639450765851727`*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"35a39124-29e6-4169-9f79-37aa7d706bb0"],

Cell[TextData[{
 "Equation (4.115) is rewritten to express \[Sigma]/\[LeftAngleBracket]\[Rho]\
\[RightAngleBracket] as a function of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "ea53223d-26e4-461c-b98d-37712ac5569c"],
 " and ",
 StyleBox["r", "Input"],
 " = ",
 StyleBox["A/B",
  FontSlant->"Italic"],
 ".  We do this by defining a function ",
 StyleBox["\[Sigma]\[Rho]", "Input"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"d82097fa-fc7d-4ed3-868d-f9b0b86b685a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]\[Rho]", "[", 
   RowBox[{"C_", ",", "r_"}], "]"}], ":=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"r", "^", "3"}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "/", "2"}], ")"}], "*", "C"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"r", "^", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"5", "/", "2"}], ")"}], "*", "C"}]}], ")"}]}]}]}], 
    ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",ExpressionUUID->"8b5b11dd-035f-4c02-b6bd-d3f76a7dca0f"],

Cell[TextData[{
 "Define ",
 StyleBox["\[Delta]", "Input"],
 " to be a function of ",
 StyleBox["r", "Input"],
 " = ",
 StyleBox["A/B",
  FontSlant->"Italic"],
 " and ",
 StyleBox["sr", "Input"],
 " = ",
 StyleBox["\[Sigma]/\[Rho]", "Input"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"360f3066-8782-477d-8c29-756f6d76f1f0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Delta]", "[", 
   RowBox[{"r_", ",", "sr_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"r", "^", "3"}], "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", "sr"}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",ExpressionUUID->"e87b9739-ba24-4449-9799-d45b1464c14a"],

Cell[TextData[{
 "Then define ",
 StyleBox["\[Gamma]", "Input"],
 " to be a function of ",
 StyleBox["sr", "Input"],
 " = ",
 StyleBox["\[Sigma]/\[Rho]", "Input"],
 ". "
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"e0c1e586-9aba-4fb6-8159-b51a0943575c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Gamma]", "[", "sr_", "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "/", "5"}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "/", "5"}], ")"}], "*", "sr"}]}]}]], "Input",
 CellLabel->"In[3]:=",ExpressionUUID->"363b3167-b526-4d8c-86d0-dd816c8e0f9b"],

Cell[TextData[{
 "Now we are in a position to define the function ",
 StyleBox["J2f", "Input"],
 " that returns the value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "2"], TraditionalForm]],ExpressionUUID->
  "6d9f30bd-db1c-43e7-ba74-2d31f9e45e11"],
 "/",
 StyleBox["f",
  FontSlant->"Italic"],
 "  for specified values of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "642a439d-da7c-44fc-ada2-e87dbd153619"],
 " and ",
 StyleBox["r", "Input"],
 " = ",
 StyleBox["A/B",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"33d4bcf3-3bf0-499b-83b0-af522c604ec1"],

Cell[BoxData[
 RowBox[{
  RowBox[{"J2f", "[", 
   RowBox[{"C_", ",", "r_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "/", "3"}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"C", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "/", "5"}], ")"}], "*", 
       RowBox[{"r", "^", "2"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"r", "^", "2"}]}], ")"}]}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"2", "/", "3"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"3", "/", "5"}], ")"}], "*", 
       RowBox[{
        RowBox[{"\[Delta]", "[", 
         RowBox[{"r", ",", 
          RowBox[{"\[Sigma]\[Rho]", "[", 
           RowBox[{"C", ",", "r"}], "]"}]}], "]"}], "/", 
        RowBox[{"\[Gamma]", "[", 
         RowBox[{"\[Sigma]\[Rho]", "[", 
          RowBox[{"C", ",", "r"}], "]"}], "]"}]}], "*", 
       RowBox[{"r", "^", "2"}]}]}], ")"}]}]}]}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"2c039e76-9716-49e7-a226-6f5adb8681a5"],

Cell[TextData[{
 "The Darwin-Radau relation is an approximation to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "2"], TraditionalForm]],ExpressionUUID->
  "0a6c8ee3-253a-46db-bb40-acd013cc9628"],
 "/",
 StyleBox["f",
  FontSlant->"Italic"],
 "  that is valid in the limit as ",
 StyleBox["r", "Input"],
 " \[RightArrow] 1.  We can show this by starting with an expression for ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["J", "2"], TraditionalForm]],ExpressionUUID->
  "ef4d283a-26b6-46f0-9bde-dac862881d8e"],
 "/",
 StyleBox["f",
  FontSlant->"Italic"],
 "  for general values of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "c0b72beb-b6e4-4360-9d79-a76c7f36a687"],
 " and ",
 StyleBox["A/B",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"0ff52de2-06ee-40ad-b9fb-98c9da03b691"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"temp", "=", 
  RowBox[{"J2f", "[", 
   RowBox[{"C", ",", "r"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"dbed093f-b562-496b-905b-6b96de7cdd01"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], "+", 
  FractionBox[
   RowBox[{"C", "-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["r", "2"]}], "5"]}], 
   RowBox[{"1", "-", 
    SuperscriptBox["r", "2"]}]], "-", 
  FractionBox["2", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["r", "5"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          FractionBox["1", 
           RowBox[{"1", "-", 
            FractionBox[
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"5", " ", "C"}], "2"]}], 
             RowBox[{
              SuperscriptBox["r", "3"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 FractionBox[
                  RowBox[{"5", " ", "C"}], "2"]}], "+", 
                SuperscriptBox["r", "2"]}], ")"}]}]]}]]}], ")"}]}], 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["2", "5"], "+", 
          FractionBox["3", 
           RowBox[{"5", " ", 
            RowBox[{"(", 
             RowBox[{"1", "-", 
              FractionBox[
               RowBox[{"1", "-", 
                FractionBox[
                 RowBox[{"5", " ", "C"}], "2"]}], 
               RowBox[{
                SuperscriptBox["r", "3"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"5", " ", "C"}], "2"]}], "+", 
                  SuperscriptBox["r", "2"]}], ")"}]}]]}], ")"}]}]]}], 
         ")"}]}]]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.811315733980402*^9, {3.811315827815534*^9, 3.811315844930237*^9}, 
   3.863930922888962*^9, 3.863935245102268*^9, 3.863945096143713*^9, {
   3.890915520938272*^9, 3.890915542083159*^9}},
 CellLabel->"Out[5]=",ExpressionUUID->"4f187d81-0fbd-412a-9206-071c909fa5a0"]
}, Open  ]],

Cell["This can be simplified somewhat.", "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"1dfda4db-3f2f-4b10-af32-3f9323ef83f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stemp", "=", 
  RowBox[{"Simplify", "[", "temp", "]"}]}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"08fa9c44-d27f-45dc-be57-5f2c9e577797"],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"5", " ", "C"}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["r", "2"]}]}], 
   RowBox[{"5", "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["r", "2"]}]}]], "+", 
  FractionBox[
   RowBox[{"8", "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["r", "5"]}], "+", 
    RowBox[{"10", " ", "C", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["r", "3"]}]}], ")"}]}]}], 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["r", "5"]}], ")"}]}], "+", 
      RowBox[{"5", " ", "C", " ", 
       RowBox[{"(", 
        RowBox[{"2", "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["r", "3"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["r", "5"]}]}], ")"}]}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{
  3.811315734022171*^9, {3.811315827855891*^9, 3.811315844961488*^9}, 
   3.8639309229361687`*^9, 3.863935245143897*^9, 3.86394509618723*^9, {
   3.890915520987237*^9, 3.890915542133424*^9}},
 CellLabel->"Out[6]=",ExpressionUUID->"927b2fb6-385b-46ad-905c-9ea728eeee2f"]
}, Open  ]],

Cell[TextData[{
 "Now take the limit of this expression as ",
 StyleBox["r", "Input"],
 " \[RightArrow] 1.  This gives the same expression as Eq.(4.114)."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"cf4b0458-ecd8-4e95-ae2e-c2c6048bba7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"stemp", ",", 
   RowBox[{"r", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"7f81f67b-ab45-4a1c-aa96-d0ad3ef8fa96"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", "10"]}], "+", 
  FractionBox[
   RowBox[{"5", " ", "C"}], "2"], "-", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["C", "2"]}], "8"]}]], "Output",
 CellChangeTimes->{
  3.81131573406992*^9, {3.811315827886043*^9, 3.8113158449942427`*^9}, 
   3.863930922978909*^9, 3.8639352452106733`*^9, 3.863945096252297*^9, {
   3.890915521052885*^9, 3.8909155421960087`*^9}},
 CellLabel->"Out[7]=",ExpressionUUID->"9787b85f-e1a4-4bd4-bc6d-01282da90f99"]
}, Open  ]],

Cell[TextData[{
 "Use this to define a function ",
 StyleBox["DarwinRadau", "Input"],
 "."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"a88e4fc5-cfc2-422d-8f48-8f6cf039f01d"],

Cell["DarwinRadau[C_]:=N[(-3/10)+(5/2)C-(15/8)C^2]", "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"6dedcfa2-2b61-4365-bc0d-2eb4c7c25cfb"],

Cell[TextData[{
 "Plot the straight line for the point-core model where ",
 StyleBox["r", "Input"],
 " \[RightArrow] 0."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"515b6f10-2d57-471a-84d7-4f12a7620985"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pcm", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cval", ",", "cval"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cval", ",", "0", ",", "0.4", ",", "0.001"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Joined", "->", "True"}], ",", 
    RowBox[{"PlotStyle", "->", "Dotted"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8113158322132587`*^9, 3.8113158330966663`*^9}, {
  3.863934858254821*^9, 3.863934865243183*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"c40698c1-4ff1-4254-b75e-8d9b293d9208"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], Dashing[{0, Small}], LineBox[CompressedData["
1:eJxd2Husz3Ucx/HTmZmZtZKkUymSNGtmrVlXlW7SxaWZNTOzlK4k1UlSknQv
1yTkODhIKpUk9/vdcdDJzMxaF5UkqSSt7+fz3N7P1e+fx2bH93y/38/n83q9
f6dZn/5d+5aWlJSMOqmkJPn/z9+zD9fc1qdz+//aO/xr6P2LB43pF/LvA8Kn
Gs27af/gQSE/Vx4+eaBl23pzh4T8v2fDK/fd8dpbDz8Xcp3nw0UdG5S2HvlC
yHVfDC//ZP3jS999OeT3vBoubDrixy4LXw/5vW+Gk1af9+HAfqNC7mN0uOdY
/kUh9zU2PKvN3hZ1h40Luc/x4V13X5GuFHLfE8KJb+dPyHNMDHdv/aPb1zPe
CXmuSeGZdbqffPH8ySHPOSXscVm+UMhzTw1vbffStb2/Ud5DRfhTl3Ql5b1M
C1958Lvjsw8r76kybD2ycXHrynubHm6quGHBkRPKe5wRPlC8pSZ1Zoa8V61f
WzngqvpVIe9Z56THPGVWyHvXW9JlGs8OWQf9Ib3ms+eErIumt1bd/L2QddKL
er6x8miruSHrphuKq5S1eT9kHfW+UQeHtL90Xsi6anFTxaN+ELLOemexaYql
DFl3nV68tdpKZR/obyd2lh9o+VHIvtDr88Ir+0THNskPErJvlNtS9pFekj8f
h+wrHb58Y7FzlH2mO4pVL95FyL7T8/OFlH2oj/ZLL/7TkH2pq462KlZW2acL
wtO4sZB9q/mu1iv7+LNw/uRDVWs7KftaS/ODKvt8YdiVjRKy73Vaesydyjn4
PPw1XaaHci70urTt9yjnZFE4Om3bXsq50f2D00Io5+iLsG3e2Mq50mHjOhRb
RTlni8PtzfPChpw7bZZS/6ByDpeEj6RjMUA5l7oireoR5ZwuDU/lIIYsg+bX
dkw5x8vCfFtDlMsoLb485JzrrLWdipOsnHvtXJzChsOVHNA/U+usVnJBp5al
g7AiJCf05rywSm7oL1XpxpQc0QnprjYquaLXFJuqY4OVITmj3x9PD6rkjqZd
UmyVkBzS/JjVSi5pvkzDVSE5pTmGuim5pYwNSkxojoFaJdf0mXSMm6wOyTm9
MB8cJfd0Wx4rlBzUJ9Ix2Kvkop6btnHTNSE5qevStuut5Kb2T8taoeSonpEP
upKra8Nl6bZaKDmr996TPkruahqaimQNyWFNqVh+QMnldWGvfCElp7VuDiYl
tzWtQqN5So5rnuoOKbm+PvwnHbO2Ss7rzLSNByq5r7fzoCE9oL+nZTiq9MKG
cEp6zHZKT+iN+cUpvaE/51pQekTHp1g/rvTKxvDqvBBKz+i3KVaHKr2jxJ7S
Q5pjpXRTSC9pPrYdlJ7SfCxGKL2lbDulx3RXWtZ6m0N6TZ/Od6b0nF6QN57S
e7plc/6E9KA+NiYF6ZaQXtRz8kZWelLX5K9VSm/qQylGa5Qe1dPzwdga0qu6
JMVAd6VntW/+2qX0rjbgoIX0sOZtUrYtpJc1L0NPpaeVr2VKb2u+zD6lx6tD
zrnS68q5V3peyQGl95VcUOYAJSeUuUDJDWVOUHJEmRuUXFHmiO0hOaPMFUru
KHOGkkPK3KHkkjKHKDmlzCVKbilzipJjytyi5Joyx9SE5Jwy1yi5p8w5Sg4q
c4/mbT5UmYOUPxsoc5GSm8qyKjmqzE1Kru4ImaOUnFXmKiV3lTlLyWFl7lJy
WZnDlJxW5jIlt5U5TclxZW5Tcn1nyByn5Lwy1ym5r8x5Sg8oc5/SC8ocqPSE
MhcqvaHMiUqPKHOj0iu7QuZIpWeUuVLpHWXOVHpImTuVXlLmUKWnlLlU6S1l
TlV6TJlbvwzpNWWOVXpOmWuV3lPmXKUHlblX+bOkMgcrPamMiUpvKnOy0qPK
3Fwb0qvKHK30rDJXK72rzNlKDytzt9LLyhyu9LQyJii9rczpSo9/FdLjSo8r
Pa70uNLjSo8rPa70uNLjSo8rPa70uNLjSo8rPa70+O6QHld6XOlxpceVHld6
XOlxpceVHtd/ARvSha4=
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.4}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.811315734214161*^9, {3.811315828002586*^9, 3.8113158451105537`*^9}, 
   3.863930923311211*^9, 3.863934866446093*^9, 3.863935245636949*^9, 
   3.863945096662156*^9, {3.890915521600091*^9, 3.890915542675241*^9}},
 CellLabel->"Out[9]=",ExpressionUUID->"5b52fb4a-6486-49c9-8fff-e0389d5bfa21"]
}, Open  ]],

Cell[TextData[{
 "Plot ",
 StyleBox["J2f", "Input"],
 " as a function of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "da537ac9-73ac-430a-a7df-0e65395b939a"],
 " for a model with ",
 StyleBox["r", "Input"],
 " = 0.5."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"4ab0cd92-658c-40ef-8e1c-5dc79e15df34"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r05", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cval", ",", 
        RowBox[{"J2f", "[", 
         RowBox[{"cval", ",", "0.5"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cval", ",", "0.0001", ",", "0.4", ",", "0.001"}], "}"}]}], 
     "]"}], ",", 
    RowBox[{"Joined", "->", "True"}], ",", 
    RowBox[{"PlotStyle", "->", "Dashed"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.811315813913196*^9, 3.8113158146913853`*^9}, {
  3.8639348272493477`*^9, 3.863934839398601*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"8b0f80c0-83e6-45f6-a2a7-7c4cc2f5efa7"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], Dashing[{Small, Small}], LineBox[CompressedData["

1:eJwtWHlcjekXv1FEKHsoLhmlQpok6zd7IrIUhZElZFKhSJPEL0pioqRSadOu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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.3991}, {-0.1009438869463164, 0.399097899806365}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8113157342668257`*^9, {3.811315828043*^9, 3.8113158451617527`*^9}, 
   3.863930923353451*^9, 3.863934840787904*^9, 3.863935245688045*^9, 
   3.8639450967072563`*^9, {3.8909155220556717`*^9, 3.890915543106029*^9}},
 CellLabel->"Out[10]=",ExpressionUUID->"49c3cf44-5b06-4396-8ce1-71630edcd6ab"]
}, Open  ]],

Cell[TextData[{
 "Plot ",
 StyleBox["J2f", "Input"],
 " as a function of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "c29e1402-e972-4bf8-ba1b-1a5130750a84"],
 " for a model with ",
 StyleBox["r=0.99", "Input"],
 ".  This should be close to the Darwin-Radau relation."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"12d282ad-426d-449d-b1e4-ca2da86614af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r99", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cval", ",", 
        RowBox[{"J2f", "[", 
         RowBox[{"cval", ",", "0.99"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cval", ",", "0", ",", "0.4", ",", "0.001"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Joined", "->", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.811315706770542*^9, 3.81131570760026*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"aea14487-38b7-4513-a6dd-4367291af742"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9mHlcTekfx4+9aRpTMk2W0YJCRlG2YXzLvjRkHYOSLGXJFoOES5hkK2uS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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.4}, {-0.29648255417474445`, 0.40000000000000047`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.811315734314262*^9, {3.811315828092815*^9, 3.811315845198678*^9}, 
   3.863930923393918*^9, 3.863935245736239*^9, 3.8639450967503138`*^9, {
   3.89091552212216*^9, 3.8909155431577597`*^9}},
 CellLabel->"Out[11]=",ExpressionUUID->"3ae12250-8295-4373-8d91-1fd880b4474d"]
}, Open  ]],

Cell[TextData[{
 "Plot ",
 StyleBox["J2f", "Input"],
 " as a function of ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["C", "_"], TraditionalForm]],ExpressionUUID->
  "a93551ec-f7cc-4b37-88e9-1dae977c3660"],
 " for the Darwin-Radau model."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"f13f606c-cba2-4b0a-8f13-44bacc800603"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dr", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cval", ",", 
        RowBox[{"DarwinRadau", "[", "cval", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"cval", ",", "0", ",", "0.4", ",", "0.001"}], "}"}]}], "]"}], 
    ",", 
    RowBox[{"Joined", "->", "True"}], ",", 
    RowBox[{"PlotStyle", "->", "Automatic"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.811315701833547*^9, 3.811315702792794*^9}, {
  3.8639347772701797`*^9, 3.863934800533287*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"1f8f3604-9722-48af-8507-7ccad0c892bc"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9WWdYFFcXtiRGE2OiiYjGFkvsERU1sb0klqDYE0sUCRYUsSsqoBGVqCiI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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.4}, {-0.3, 0.3999999999999999}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8113157343643227`*^9, {3.81131582812971*^9, 3.811315845227387*^9}, 
   3.863930923431089*^9, {3.863934787727247*^9, 3.8639348014591007`*^9}, 
   3.8639352457801857`*^9, 3.863945096784812*^9, {3.890915522188293*^9, 
   3.890915543204897*^9}},
 CellLabel->"Out[12]=",ExpressionUUID->"fb84e120-d171-41d9-ba79-2e7bec220285"]
}, Open  ]],

Cell[TextData[{
 "Compare the ",
 StyleBox["r=0.99", "Input"],
 " plot with the Darwin-Radau model plot.  They are almost identical."
}], "Text",
 CellFrame->True,
 Background->GrayLevel[
  0.849989],ExpressionUUID->"61c24cf4-5cd9-4fd3-a434-abdcf1b45703"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"r99", ",", "dr", ",", " ", 
   RowBox[{"Frame", "->", "True"}], ",", " ", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0.4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0.4"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",ExpressionUUID->"982a857d-d1e5-4fcf-be95-1122e43e6580"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9mHlcTekfx4+9aRpTMk2W0YJCRlG2YXzLvjRkHYOSLGXJFoOES5hkK2uS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       "]]}}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9WWdYFFcXtiRGE2OiiYjGFkvsERU1sb0klqDYE0sUCRYUsSsqoBGVqCiI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       "]]}}, {{}, {}}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.4}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.8113157343883123`*^9, {3.811315828136961*^9, 3.811315845234207*^9}, 
   3.863930923445406*^9, 3.863935245793455*^9, 3.863945096798325*^9, {
   3.890915522207591*^9, 3.8909155432246103`*^9}},
 CellLabel->"Out[13]=",ExpressionUUID->"4867d208-0876-4d38-ac77-5b2988753708"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"xlabel", "=", 
   RowBox[{
   "\"\<Moment of inertia factor, \>\"", "<>", 
    "\"\<\!\(\*TemplateBox[<|\"boxes\" -> FormBox[
OverscriptBox[
StyleBox[\"C\", \"TI\"], \"_\"], TraditionalForm], \"errors\" -> {}, \
\"input\" -> \"{\\\\bar{\\\\cal C}}\", \"state\" -> \
\"Boxes\"|>,\"TeXAssistantTemplate\"]\)\>\""}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ylabel", "=", 
   TemplateBox[<|"boxes" -> FormBox[
       RowBox[{
         SubscriptBox[
          StyleBox["J", "TI"], "2"], "/", 
         StyleBox["f", "TI"]}], TraditionalForm], "errors" -> {}, "input" -> 
     "J_2/f", "state" -> "Boxes"|>,
    "TeXAssistantTemplate"]}], ";"}]}], "Input",
 CellChangeTimes->{{3.855640306242826*^9, 3.855640313202561*^9}, {
  3.855640391802243*^9, 3.855640398897621*^9}, {3.85564053863629*^9, 
  3.8556406145515633`*^9}, {3.856874675072912*^9, 3.856874721538768*^9}, {
  3.857297938861788*^9, 3.857297947501027*^9}, {3.8583280156988163`*^9, 
  3.858328059304631*^9}, {3.858328163091331*^9, 3.8583281708873568`*^9}, {
  3.858328338054955*^9, 3.858328395173381*^9}, {3.863931273097649*^9, 
  3.863931283867725*^9}, {3.8639313339684687`*^9, 3.8639314226492023`*^9}, {
  3.8639314956380463`*^9, 3.8639315197727337`*^9}, {3.8639316164347553`*^9, 
  3.863931620572627*^9}, {3.863931655030054*^9, 3.863931677455222*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"d41a36ca-f357-400e-80a0-1898727b1cd8"],

Cell[TextData[{
 "Plot the Darwin-Radau approximation together with the ",
 StyleBox["r=0.5", "Input"],
 " planet and the point-core model for comparison.  This is Fig.4.9."
}], "Text",
 CellFrame->True,
 CellChangeTimes->{
  3.811315749142481*^9, {3.863935038491857*^9, 3.863935039122238*^9}, {
   3.863935079669169*^9, 3.86393508682204*^9}},
 Background->GrayLevel[
  0.849989],ExpressionUUID->"77ad593e-8a57-4d7a-9bdb-85d80a1263a2"],

Cell[CellGroupData[{

Cell["\<\
Show[dr,r05,pcm,Frame->True, 
PlotRange->{{0,0.4},{0,0.4}},AspectRatio->1,FrameLabel->{xlabel,ylabel},
RotateLabel->False,
PlotRangePadding->None,FrameStyle->Thickness[0.004],
LabelStyle\[Rule]Directive[FontFamily\[Rule]\"Times\",FontSize\[Rule]16]]\
\>", "Input",
 CellChangeTimes->{{3.811315796722403*^9, 3.811315797322301*^9}, {
  3.863931168488468*^9, 3.863931218916546*^9}, {3.863934518354766*^9, 
  3.863934558903863*^9}, {3.8639348784289*^9, 3.8639349030790367`*^9}, {
  3.86393499161705*^9, 3.8639350020867023`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"46a030bb-8170-4fb4-b720-0f378d1389f4"],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw9WWdYFFcXtiRGE2OiiYjGFkvsERU1sb0klqDYE0sUCRYUsSsqoBGVqCiI
2NGAIiCIItI7zLKwhWUXthc7sWssWNAo6jd37vGbP/Ow694595y33fHbBaum
+zRq0KDB/oYNGrD7h2uQdJmE+uRa46QFU/HH/TuTxn764W9vDFF367qkxii8
3uJX5H/QF3naexlReUb6fjVuvBzy1rHPKGz6OvWXmiB/FIxv3qjPkg//PgDD
5UtLw0YZhcB73w1omrIZS+ZPGV7f+sPvt2Jkj+JVmx8ahBHXpuw9unI7Sr7K
9GquMNB6f0H6WbRBkNbdtROC99Dlc/0NtH4o3EoVe9pNNAjDstQbSk7ugZ/7
5YX3uhroeeH4qS7opeqNXsjruOPBtLwIlGpOjc0x6en5kXigmDo565xeiC7v
nLbWdz9K7+xqKQ/RUz0H4Obyy75rc/XCpf+kB2LZyQhVc1c91XcIGOwllqYX
vul/pVuTbYex5cay6r4V1VTvERiT+5y8FVgtzFk0nK2ITcVvbhT3rqb6oxDY
8XJM9qUq4fgx6YKWXeFVtJ/jWK/WrW48qkpwVL389cbpv7G25bXdvz/W0f6i
oUhq4FwdqxPafjSzRb+MGKwIG/jNouk62u8JsKc4f6QTZv8oLYiiYaqt/2Zr
af+xWNik941rS7TCxKG7f/K+FYs/OsUUPG2rpX6cQtqOzp9011YK/05jK57C
LLbOlkrqTxymD5v9/o5LpRC2/M6b5No4JIQ2PxdwQ0P9iseEbobKnkc0Qp9d
TuIW4jH288T5r9w11L8EHB7NflkhVIpjefY2Aay8F6kV1M/TcI3aWdN1QYWw
TNpHIv7KifZY07qC+puIXl3Kel9Vq4VPbfGrR36ahK7swZvV1O8krK1xc3dy
UQtn2Xa/PIPWg8UFb6io/2fQwvr+R+1RlTCBLeeUDM/yjQusHiqaRzI4S1TC
fdbu9mfxKjSq1fgsJc3nLMb+8dPxdF+lwLqn73IOd7e/PvJjByXN6xyuPStr
WmNQCL0898lf9ExB34yYx0k7FTS/FFQV7/KIGK4QKsTV2vU/D4XT9vaHnpTT
PM+jZXH4gvzT5cLS/Q83Y3AqMtKSOrybU07zTQXfV7kgFidu+QJeBLd4dktR
RvO+gCNz53y+e1OZ8JsIHnGkCGcNHFBG80+D9XWXU/3uyIUEsXu2+DRIZcTI
CQ9pENHcbOqvcuH5W3PAve/Skd1PszyymZzwkY4Zjo1jnwilwhgJAOkYbxx8
cNWGUsJLOg44s42UCoekewYGpPyzV3tDRvjJQPe9hmFnj8sEXl4GVhXqPZOm
yQhPGWg+9LrYQZnAdSoT79kVLBC+MhHZ17tR7qMSIUTGiJ0JzbPrj1LmlRDe
MnFhxnZFjbZYMIldEnuCUdPH7Jwxopjwl4WN0hyKBAk3RVmY+01v5X/fFBEe
s3BXlMPe4YXCOl82gGx0nnIg9Vh9AeEzG42nvWzovqJAKHvRU5xwNvaxMV3N
J7zmQCnK5/wp+cJXvEAk1d0L0MryCL85GLLQ4L9hYJ4gVafOwTI/x5w/EnIJ
z7nguMwVGGyUHrkwu3vcehiaQ/jORdPO2bsPvskWGkkbzsWd/XAOWJlNeM/D
qhP3I/+uyRKmc8Agjm3rtyzCfx6Cd8W5nVRnCtLn5jw0WXRhY/CITOJDPn64
dDnqRFqG8JQtNzsfXz3snVDfLYP4kQ8uW+nCzwz+l/JRcb1n4PoW6cSXAiTI
7T9HhqQJB1hfvAowdcv0h6baC8SfAqSmuPb6+EqqUBPEBlIAL6kP54lPhVic
XNShJitFGCABvBAykZ5hp84RvwqxetP4hVkRZ4VtkpAUwj9rTfmczcnEtyJo
u7DBnhEM0r0Igcodjb/9PYn4V4Sgk2tEhUgUvmXq/7AI+vMnDl4depr4WIyg
2ubtXvdIENYweqwuRqAkqPHEz2Jonc/Hn20WJ0i+8qwY/vVXE/Emlvhaguti
uxIunhRackJiq6r5b0ohhvhbAtJ1QWrffyXQuvnUvwk/RnwWsKTDjElfrj8q
SOVtFpCySDWus9dh4reAY05Fd/u4HxS4TsngIvFkP/Fdhuv+v09cPipCOKP0
EBktQ9rsaSFLnfcQ/2XQt5z8mdfzHcJUkY2tQmQYFzvl5njjNtIDGZylQjYJ
r1iV5TJMDZK3+qLnOtIHGdy+V8zwueYjxLZjhCiF7PmCnj0ujiW9KIVbcYM3
d80z4C4NuBSdu4suOXoZuH6UwsVjROxyzXo8SWIFit87Hlzp9PhPcD0Rf39V
PeLpJyGIYtVpShElyus8p13g+lKKWAknYXCTfFiO3zK7uU3qtw9cb+S43ONp
t3vH9+PuG7ZhORaFTWnocuIguP7IMeav3oM3xR4GQ4sIGaxmjzl1FFyP5Hg3
+Pf4jnHHIG1XL8fNRylXNpz6G1yf5Og8cssq08kYSMu1KkNWZ91s15iT4HpV
hmrJ0GMhydGvZXhiqo3apjkFrl9lKDpticxTxYHHhzK4/hwgIjgeXC7KMCvZ
0fi8LAGSHNjK8J30w9Pg+laGUzZ797O5iQiWcFkO5YkNr5ZlJIHrXTmiXEx1
F1LOoIdEoHK03vuo84bEZHD9K8co8rFqCYblaCXac2jUOe6jReU4ILqPJTIF
GxkdrpSj+F71loTQ8+D6WI5Dw0+HvAhORScG544KOEnAvACulwrEdRrXdN+Q
NKgY/LwViHg1WRuUngaunwoYhwxN7NE3Haukvivgd/Hd4cOJ6eB6qsAsaRAZ
aCMRRYHoaX1zs45ngOurEq7dD9z1+ToTAiuvmxLdvGz97XszwfVWCT+RTZ99
koUli9mlxEeMJluzeE7dpcQj3xuh2a+ywMKTqLD4gZWzJhtcj5XQS4EyG0wd
A+4poWysSfScnwOuzyp8KglvDrykBVVI8Vn25/6pueB6rcLx78N261S5aCIJ
lAp3Pfec04zKA9dvFUKesALywKbxdaoKm5gu9c0H13MVSn8pP+Qelw8p3T1W
YfFnP7WY4FxAvq+GCLaY5hEFeMfoNkCNJKa3jQvB9V4NSdYDCpHI4LxWDbcv
HlVdfFgIrv9qiMVln1pQhMl8w+hfuzWjl62I+4RZjW5BbRVrPYpRx8bxQo0N
kgwVky9VQJKfQSU4wbY7tAJfr++01ZxYAu4XFfA+OPj+t+0EjJPqqECzNn38
XPYK4P5RgQ+69Uiyhwr07nFxhvuPMnA/qUB9g4Qha9bKcITnRGzeOy8u6JwM
3F80iNc2ObbopgyjpIFoEMhw2qEU3G80qGNyNKMUt5m8btGgS0FsiU9EKbj/
aPCcxTNlKbj8abB2q3dEx/el4H6kQay0LzmP+Y0qef5eJQf3p0o8v/Wx/Zck
OST6jq5ExxXt052uycH9qhJ1iV1aK53KINFjRyUYamdOLiPdr0TcwHd/KneU
gcOvEhv/Mm1vU1wG7meVeM3y5vMyWNh4m2rRXVS3uX3Kwf1Ni3eSjpfjT6lC
LbYwfztWDu53Wpw/3EwwV5dDkt0wLULa/Pnx0iYKcP/TounE69YrIxTQSTql
hSuTrXUKcD/UooVufbulyQqsZ3W30CGy7Znw4GsKcH/UQeas2b2htRIdJEDr
cFRzqeVkDyW4X+rQQeK5EgrpeKXDhHFV8hM5SnD/1OG7Ly88aPOvEiuYnBp1
SA4PPrnmWxU/pz3T4WIhrp6bqUJriSBVnFdhKnB/rcKwgfvqS2UqFEuNrYIv
O1C9UIH7bRXGrYsZN6e3Gj7S8asKmk7NR7z0UoP7b9X/edCcEw52UY2NKjW4
H1fBc0bdvJb1akhwaVeNcG3XYBeXCnB/roZfnVsfl0UVkMbhWY3nDPdRFeB+
XY1uC9gJqAL8eFaN9/EinN9XgPt3Nfaw8Q7UQFruWjVK2HYXa4gXeuKJhviu
R+fEMa2KtRpwf9djps+11qXvNcR/PYbaliacHlgJ7vd6lIjHTT+fStIDPZ5I
9VWC+78eRs+k/Uc0laQPengde+Lxtr4SPA/oERnaa/+Y/lrqkx4re0+fv3y+
Fjwf6PFG+lxL+qHHoJ1r4+YptOB5QY8v3fy+6vFSS3oi7idl2heGnjrw/CA+
Xzwdzp2jI33RI1uarw48TxiALmzDOtIbA6Q480gHni8MmD36n44enapIfwy4
fW2J5w9TqyhvGNBewl8V6ZEBb11Eg02vovxhQPitIzNH/1NF+mSAcuIlIaNV
NeURAxIXf5HVaHQ1zcHAfX1dNeUTA1ZmjBs5Jr6a9MuAX8X0NNhUTXnFgNWL
Ov4X0lBPemZA87R9k+e11VN+MeA9zY3rmwHuJkfFdXc95Rkjbp7NeLzHW096
Z4RlbuO53QP0lG+M6Hi78rO0fXrSPyOKmA0l6SnvGJG6s3zkkRI96aERL6Kf
l9Ra9JR/jDgUHr1j5EM9JLhvMWLnjKL9gR8ZKA8ZeS74xgD++sCI5esWBskH
GigfGeGtvj+zeryB9NOIM+x8422gvGSE+zvv6/kbDaSnRgxjz40wUH4yYsex
nGCf0wbSVxO69Duc27XIQHnKBOfjD1yNRgPprQniai9X36M5DDIRT4ykvyY8
f1U8KdjJSHnLBFSKB8K+RtJjE8Twlj95tJHylwmmN0rbid+NpM8mSDRcZaQ8
ZkLx/sCbX+w0kl6bkB7XxOQSbaR8ZkK9mC5+zjCSfpsQPTV062i1kfKaiff9
qpH03AQxTIxu89xI+c2ELZm6vfeamUjfzVh7uVeHlE4mynNmlFx9W+s12ER6
b+Y5w8NE+c6MGas+X37Y20T6b0bsW/eWbTeYKO+Z8TM7ToSZyA/MYPGmNtZE
+c/8/31wfzCja9Ytzz2VJsqDZnTYFjBPuG4ivzDDt0dI/M0XJsqHZjRL+rj/
60/N5B9mfj7vZKa8aMbkgWud6lzN5CdmPBnpufayWCfPj2bc7sLe+JnJXywY
WHP0deA6M+VJC2ysL6Fm8hsLqu5lRNmjzZQvLWjn+nzK6nQz+Y8FRbPOT3yl
MFPetCDnt6sRqy+ayY8saMwa/8hM+dOCxItJNwY0tpA/WRC90K0uqI2F8qgF
j9j7wT4W8isLIhuKBxTxuTyfWghnFvIvC8wfTXvZ0NdCedWCzexAt8lCfmaB
/4ozznf2WSi/WiFj7xvjLeRvVvBjvYXyrBXevqkm90oL+Z0VqStFBl+1UL61
YvrkrHORTy3kf1ZM+OTB+/ZNrJR3rYhmstXWSn5ohdvHsoAm/ayUf60YMsEr
ZqEbPfeoFaG+/p+k/2qlPGyF9HpFXIf7pRWSDAVZKR9b4X9px+1he63kn1Z0
+GPT4vGxVsrLVp4PM63kp1YsfqobMlRppfxso/xsJX+1oalY/u0HVsrTNswW
x3n6nZX81oZ6Ed4zW9ooX9tQJ9K9rquN/NcGD1bIEBvlbRueDPq+fdPxNvJj
G+67GqcHzrVR/rZhOMvDK2zkzzbclG+L7LvVRnncxnXogI382gaXnC9vxibY
KJ/bYHnx2YayHBv5t/h3i+BJVrWN8roN3zX083NctJFO2fn73X9t5Od2qNck
+ae9s5Gf29HhyX/z/xI/535uRxnL/13s5Od2iNP7/O0gO/m5HS0lHNjJz+0o
ZA2eZSc/tyOva7RTka+d/NyOZgXFCQOC7OTndqT3mhVwNMxOfm5HButTtJ38
3I7Gh2sfD0q1k5/bIYLtoJ9gJz8X62LnHb2d/Fys+yvPlDM1dvJzquOpnfzc
gfj6hItJjR3k5w7Usf8++NpBfi5+P0HX0be7g/zcgdihrZNdhjjIzx2QYDXO
QX7uQLR4+jkwy0F+7kAMA5x4537uQC07Xol37ucOHD+0fWV/dpf83IEouv8P
TH3cqQ==
       "]]}}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], Dashing[{Small, Small}], 
      LineBox[CompressedData["
1:eJwtWHlcjekXv1FEKHsoLhmlQpok6zd7IrIUhZElZFKhSJPEL0pioqRSadOu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       "]]}}, {{}, {}}}, {{}, {{}, {}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.007333333333333334],
       AbsoluteThickness[1.6], Dashing[{0, Small}], LineBox[CompressedData["
1:eJxd2Husz3Ucx/HTmZmZtZKkUymSNGtmrVlXlW7SxaWZNTOzlK4k1UlSknQv
1yTkODhIKpUk9/vdcdDJzMxaF5UkqSSt7+fz3N7P1e+fx2bH93y/38/n83q9
f6dZn/5d+5aWlJSMOqmkJPn/z9+zD9fc1qdz+//aO/xr6P2LB43pF/LvA8Kn
Gs27af/gQSE/Vx4+eaBl23pzh4T8v2fDK/fd8dpbDz8Xcp3nw0UdG5S2HvlC
yHVfDC//ZP3jS999OeT3vBoubDrixy4LXw/5vW+Gk1af9+HAfqNC7mN0uOdY
/kUh9zU2PKvN3hZ1h40Luc/x4V13X5GuFHLfE8KJb+dPyHNMDHdv/aPb1zPe
CXmuSeGZdbqffPH8ySHPOSXscVm+UMhzTw1vbffStb2/Ud5DRfhTl3Ql5b1M
C1958Lvjsw8r76kybD2ycXHrynubHm6quGHBkRPKe5wRPlC8pSZ1Zoa8V61f
WzngqvpVIe9Z56THPGVWyHvXW9JlGs8OWQf9Ib3ms+eErIumt1bd/L2QddKL
er6x8miruSHrphuKq5S1eT9kHfW+UQeHtL90Xsi6anFTxaN+ELLOemexaYql
DFl3nV68tdpKZR/obyd2lh9o+VHIvtDr88Ir+0THNskPErJvlNtS9pFekj8f
h+wrHb58Y7FzlH2mO4pVL95FyL7T8/OFlH2oj/ZLL/7TkH2pq462KlZW2acL
wtO4sZB9q/mu1iv7+LNw/uRDVWs7KftaS/ODKvt8YdiVjRKy73Vaesydyjn4
PPw1XaaHci70urTt9yjnZFE4Om3bXsq50f2D00Io5+iLsG3e2Mq50mHjOhRb
RTlni8PtzfPChpw7bZZS/6ByDpeEj6RjMUA5l7oireoR5ZwuDU/lIIYsg+bX
dkw5x8vCfFtDlMsoLb485JzrrLWdipOsnHvtXJzChsOVHNA/U+usVnJBp5al
g7AiJCf05rywSm7oL1XpxpQc0QnprjYquaLXFJuqY4OVITmj3x9PD6rkjqZd
UmyVkBzS/JjVSi5pvkzDVSE5pTmGuim5pYwNSkxojoFaJdf0mXSMm6wOyTm9
MB8cJfd0Wx4rlBzUJ9Ix2Kvkop6btnHTNSE5qevStuut5Kb2T8taoeSonpEP
upKra8Nl6bZaKDmr996TPkruahqaimQNyWFNqVh+QMnldWGvfCElp7VuDiYl
tzWtQqN5So5rnuoOKbm+PvwnHbO2Ss7rzLSNByq5r7fzoCE9oL+nZTiq9MKG
cEp6zHZKT+iN+cUpvaE/51pQekTHp1g/rvTKxvDqvBBKz+i3KVaHKr2jxJ7S
Q5pjpXRTSC9pPrYdlJ7SfCxGKL2lbDulx3RXWtZ6m0N6TZ/Od6b0nF6QN57S
e7plc/6E9KA+NiYF6ZaQXtRz8kZWelLX5K9VSm/qQylGa5Qe1dPzwdga0qu6
JMVAd6VntW/+2qX0rjbgoIX0sOZtUrYtpJc1L0NPpaeVr2VKb2u+zD6lx6tD
zrnS68q5V3peyQGl95VcUOYAJSeUuUDJDWVOUHJEmRuUXFHmiO0hOaPMFUru
KHOGkkPK3KHkkjKHKDmlzCVKbilzipJjytyi5Joyx9SE5Jwy1yi5p8w5Sg4q
c4/mbT5UmYOUPxsoc5GSm8qyKjmqzE1Kru4ImaOUnFXmKiV3lTlLyWFl7lJy
WZnDlJxW5jIlt5U5TclxZW5Tcn1nyByn5Lwy1ym5r8x5Sg8oc5/SC8ocqPSE
MhcqvaHMiUqPKHOj0iu7QuZIpWeUuVLpHWXOVHpImTuVXlLmUKWnlLlU6S1l
TlV6TJlbvwzpNWWOVXpOmWuV3lPmXKUHlblX+bOkMgcrPamMiUpvKnOy0qPK
3Fwb0qvKHK30rDJXK72rzNlKDytzt9LLyhyu9LQyJii9rczpSo9/FdLjSo8r
Pa70uNLjSo8rPa70uNLjSo8rPa70uNLjSo8rPa70+O6QHld6XOlxpceVHld6
XOlxpceVHtd/ARvSha4=
       "]]}}, {{}, {}}}},
  AspectRatio->1,
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->True,
  FrameLabel->{
    FormBox[
    "\"Moment of inertia factor, \\!\\(\\*TemplateBox[<|\\\"boxes\\\" -> \
FormBox[OverscriptBox[StyleBox[\\\"C\\\", \\\"TI\\\"], \\\"_\\\"], \
TraditionalForm], \\\"errors\\\" -> {}, \\\"input\\\" -> \
\\\"{\\\\\\\\bar{\\\\\\\\cal C}}\\\", \\\"state\\\" -> \
\\\"Boxes\\\"|>,\\\"TeXAssistantTemplate\\\"]\\)\"", TraditionalForm], 
    FormBox[
     FractionBox[
      SubscriptBox["J", "2"], "f"], TraditionalForm]},
  FrameStyle->Thickness[0.004],
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->Directive[FontFamily -> "Times", FontSize -> 16],
  Method->{
   "AxisPadding" -> Scaled[0.02], "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "DefaultPlotStyle" -> {
      Directive[
       RGBColor[0.368417, 0.506779, 0.709798], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.880722, 0.611041, 0.142051], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.560181, 0.691569, 0.194885], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.922526, 0.385626, 0.209179], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.528488, 0.470624, 0.701351], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.772079, 0.431554, 0.102387], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.363898, 0.618501, 0.782349], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[1, 0.75, 0], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.647624, 0.37816, 0.614037], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.571589, 0.586483, 0.], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.915, 0.3325, 0.2125], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.9728288904374106, 0.621644452187053, 0.07336199581899142], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.736782672705901, 0.358, 0.5030266573755369], 
       AbsoluteThickness[1.6]], 
      Directive[
       RGBColor[0.28026441037696703`, 0.715, 0.4292089322474965], 
       AbsoluteThickness[1.6]]}, "DomainPadding" -> Scaled[0.02], 
    "PointSizeFunction" -> "SmallPointSize", "RangePadding" -> Scaled[0.05], 
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 0.4}, {0, 0.4}},
  PlotRangeClipping->True,
  PlotRangePadding->None,
  RotateLabel->False,
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.863931188761025*^9, 3.8639314587692204`*^9, 3.863931525876876*^9, 
   3.8639315913186083`*^9, {3.8639316720818453`*^9, 3.863931682075842*^9}, 
   3.863934559931244*^9, {3.863934879737707*^9, 3.8639349053271437`*^9}, 
   3.863935003552752*^9, 3.863935245823189*^9, 3.8639450968220463`*^9, {
   3.890915522254561*^9, 3.8909155432548656`*^9}},
 CellLabel->"Out[16]=",ExpressionUUID->"1fe49465-1201-4797-aded-c250aebae5b4"]
}, Open  ]]
},
CellGrouping->Manual,
WindowSize->{984, 647},
WindowMargins->{{171, Automatic}, {Automatic, 316}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"13.2 for Mac OS X x86 (64-bit) (November 18, 2022)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"0ce66da6-1f8e-4e0a-9514-c00858741bf5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 387, 8, 53, "Text",ExpressionUUID->"1715f356-d7df-435e-9589-4e6e1357031f"],
Cell[948, 30, 96, 0, 67, "Section",ExpressionUUID->"49d7e63d-8a29-4b0e-a205-7f32cf3640b5"],
Cell[1047, 32, 298, 5, 49, "Text",ExpressionUUID->"35a39124-29e6-4169-9f79-37aa7d706bb0"],
Cell[1348, 39, 558, 18, 53, "Text",ExpressionUUID->"d82097fa-fc7d-4ed3-868d-f9b0b86b685a"],
Cell[1909, 59, 739, 24, 30, "Input",ExpressionUUID->"8b5b11dd-035f-4c02-b6bd-d3f76a7dca0f"],
Cell[2651, 85, 369, 16, 53, "Text",ExpressionUUID->"360f3066-8782-477d-8c29-756f6d76f1f0"],
Cell[3023, 103, 297, 8, 30, "Input",ExpressionUUID->"e87b9739-ba24-4449-9799-d45b1464c14a"],
Cell[3323, 113, 291, 11, 53, "Text",ExpressionUUID->"e0c1e586-9aba-4fb6-8159-b51a0943575c"],
Cell[3617, 126, 318, 9, 30, "Input",ExpressionUUID->"363b3167-b526-4d8c-86d0-dd816c8e0f9b"],
Cell[3938, 137, 677, 25, 53, "Text",ExpressionUUID->"33d4bcf3-3bf0-499b-83b0-af522c604ec1"],
Cell[4618, 164, 1079, 34, 30, "Input",ExpressionUUID->"2c039e76-9716-49e7-a226-6f5adb8681a5"],
Cell[5700, 200, 898, 31, 76, "Text",ExpressionUUID->"0ff52de2-06ee-40ad-b9fb-98c9da03b691"],
Cell[CellGroupData[{
Cell[6623, 235, 184, 4, 30, "Input",ExpressionUUID->"dbed093f-b562-496b-905b-6b96de7cdd01"],
Cell[6810, 241, 1969, 58, 213, "Output",ExpressionUUID->"4f187d81-0fbd-412a-9206-071c909fa5a0"]
}, Open  ]],
Cell[8794, 302, 158, 3, 53, "Text",ExpressionUUID->"1dfda4db-3f2f-4b10-af32-3f9323ef83f8"],
Cell[CellGroupData[{
Cell[8977, 309, 169, 3, 30, "Input",ExpressionUUID->"08fa9c44-d27f-45dc-be57-5f2c9e577797"],
Cell[9149, 314, 1290, 40, 61, "Output",ExpressionUUID->"927b2fb6-385b-46ad-905c-9ea728eeee2f"]
}, Open  ]],
Cell[10454, 357, 276, 7, 53, "Text",ExpressionUUID->"cf4b0458-ecd8-4e95-ae2e-c2c6048bba7d"],
Cell[CellGroupData[{
Cell[10755, 368, 188, 4, 30, "Input",ExpressionUUID->"7f81f67b-ab45-4a1c-aa96-d0ad3ef8fa96"],
Cell[10946, 374, 512, 13, 53, "Output",ExpressionUUID->"9787b85f-e1a4-4bd4-bc6d-01282da90f99"]
}, Open  ]],
Cell[11473, 390, 212, 7, 53, "Text",ExpressionUUID->"a88e4fc5-cfc2-422d-8f48-8f6cf039f01d"],
Cell[11688, 399, 139, 1, 30, "Input",ExpressionUUID->"6dedcfa2-2b61-4365-bc0d-2eb4c7c25cfb"],
Cell[11830, 402, 242, 7, 53, "Text",ExpressionUUID->"515b6f10-2d57-471a-84d7-4f12a7620985"],
Cell[CellGroupData[{
Cell[12097, 413, 600, 15, 30, "Input",ExpressionUUID->"c40698c1-4ff1-4254-b75e-8d9b293d9208"],
Cell[12700, 430, 5610, 128, 246, "Output",ExpressionUUID->"5b52fb4a-6486-49c9-8fff-e0389d5bfa21"]
}, Open  ]],
Cell[18325, 561, 388, 14, 53, "Text",ExpressionUUID->"4ab0cd92-658c-40ef-8e1c-5dc79e15df34"],
Cell[CellGroupData[{
Cell[18738, 579, 675, 17, 30, "Input",ExpressionUUID->"8b0f80c0-83e6-45f6-a2a7-7c4cc2f5efa7"],
Cell[19416, 598, 10827, 214, 230, "Output",ExpressionUUID->"49c3cf44-5b06-4396-8ce1-71630edcd6ab"]
}, Open  ]],
Cell[30258, 815, 439, 14, 53, "Text",ExpressionUUID->"12d282ad-426d-449d-b1e4-ca2da86614af"],
Cell[CellGroupData[{
Cell[30722, 833, 567, 15, 30, "Input",ExpressionUUID->"aea14487-38b7-4513-a6dd-4367291af742"],
Cell[31292, 850, 9782, 196, 231, "Output",ExpressionUUID->"3ae12250-8295-4373-8d91-1fd880b4474d"]
}, Open  ]],
Cell[41089, 1049, 361, 12, 53, "Text",ExpressionUUID->"f13f606c-cba2-4b0a-8f13-44bacc800603"],
Cell[CellGroupData[{
Cell[41475, 1065, 645, 16, 30, "Input",ExpressionUUID->"1f8f3604-9722-48af-8507-7ccad0c892bc"],
Cell[42123, 1083, 9531, 193, 231, "Output",ExpressionUUID->"fb84e120-d171-41d9-ba79-2e7bec220285"]
}, Open  ]],
Cell[51669, 1279, 255, 7, 53, "Text",ExpressionUUID->"61c24cf4-5cd9-4fd3-a434-abdcf1b45703"],
Cell[CellGroupData[{
Cell[51949, 1290, 467, 12, 30, "Input",ExpressionUUID->"982a857d-d1e5-4fcf-be95-1122e43e6580"],
Cell[52419, 1304, 15783, 297, 376, "Output",ExpressionUUID->"4867d208-0876-4d38-ac77-5b2988753708"]
}, Open  ]],
Cell[68217, 1604, 1439, 29, 54, "Input",ExpressionUUID->"d41a36ca-f357-400e-80a0-1898727b1cd8"],
Cell[69659, 1635, 435, 10, 53, "Text",ExpressionUUID->"77ad593e-8a57-4d7a-9bdb-85d80a1263a2"],
Cell[CellGroupData[{
Cell[70119, 1649, 613, 11, 102, "Input",ExpressionUUID->"46a030bb-8170-4fb4-b720-0f378d1389f4"],
Cell[70735, 1662, 19635, 362, 394, "Output",ExpressionUUID->"1fe49465-1201-4797-aded-c250aebae5b4"]
}, Open  ]]
}
]
*)

